/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.dom;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContainerable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.dom.DomSerializer;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.prism.util.PrismUtil;
import com.evolveum.midpoint.prism.xml.PrismJaxbProcessor;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.JAXBUtil;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrismDomProcessor {
    private static final String JAVA_PROPERTY_OID = "oid";
    private static final String JAVA_PROPERTY_TYPE = "type";
    private static final String JAVA_PROPERTY_DESCRIPTION = "description";
    private static final String JAVA_PROPERTY_FILTER = "filter";
    private static final String JAVA_JAXB_PROPERTY_ANY = "any";
    private SchemaRegistry schemaRegistry;
    private PrismContext prismContext;

    public PrismDomProcessor(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    private PrismJaxbProcessor getJaxbProcessor() {
        return this.getPrismContext().getPrismJaxbProcessor();
    }

    public <T extends Objectable> PrismObject<T> parseObject(File file, Class<T> type) throws SchemaException {
        PrismObject<T> object = this.parseObject(file);
        if (!object.canRepresent(type)) {
            throw new SchemaException("Requested object of type " + type + ", but parsed type " + object.getCompileTimeClass());
        }
        return object;
    }

    public <T extends Objectable> PrismObject<T> parseObject(File file) throws SchemaException {
        Document parsedDocument = DOMUtil.parseFile((File)file);
        Element element = DOMUtil.getFirstChildElement((Node)parsedDocument);
        if (element == null) {
            return null;
        }
        try {
            return this.parseObject(element);
        }
        catch (SchemaException e) {
            throw new SchemaException(String.valueOf(e.getMessage()) + " while parsing file " + file, (Throwable)e);
        }
    }

    public List<PrismObject<? extends Objectable>> parseObjects(File file) throws SchemaException {
        Document parsedDocument = DOMUtil.parseFile((File)file);
        Element listElement = DOMUtil.getFirstChildElement((Node)parsedDocument);
        if (listElement == null) {
            return null;
        }
        NodeList childNodes = listElement.getChildNodes();
        int count = 0;
        ArrayList<PrismObject<? extends Objectable>> list = new ArrayList<PrismObject<? extends Objectable>>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node instanceof Element) {
                ++count;
                try {
                    PrismObject object = this.parseObject((Element)node);
                    list.add(object);
                }
                catch (SchemaException e) {
                    throw new SchemaException(String.valueOf(e.getMessage()) + " while parsing object #" + count + " from file " + file, (Throwable)e);
                }
            }
            ++i;
        }
        return list;
    }

    public <T extends Objectable> PrismObject<T> parseObject(String objectString, Class<T> type) throws SchemaException {
        PrismObject<T> object = this.parseObject(objectString);
        if (!object.canRepresent(type)) {
            throw new SchemaException("Requested object of type " + type + ", but parsed type " + object.getCompileTimeClass());
        }
        return object;
    }

    public <T extends Objectable> PrismObject<T> parseObject(String objectString) throws SchemaException {
        Document parsedDocument = DOMUtil.parseDocument((String)objectString);
        Element element = DOMUtil.getFirstChildElement((Node)parsedDocument);
        if (element == null) {
            return null;
        }
        return this.parseObject(element);
    }

    public <T extends Objectable> PrismObject<T> parseObject(Node domNode) throws SchemaException {
        if (domNode instanceof Element) {
            return this.parseObject((Element)domNode);
        }
        return this.parseObject(DOMUtil.getFirstChildElement((Node)domNode));
    }

    public <T extends Objectable> PrismObject<T> parseObject(Element objectElement) throws SchemaException {
        QName elementName = DOMUtil.getQName((Node)objectElement);
        PrismSchema schema = this.schemaRegistry.findSchemaByNamespace(elementName.getNamespaceURI());
        if (schema == null) {
            throw new SchemaException("No schema for namespace " + elementName.getNamespaceURI());
        }
        PrismObjectDefinition objectDefinition = null;
        QName xsiType = DOMUtil.resolveXsiType((Element)objectElement);
        if (xsiType != null) {
            objectDefinition = schema.findObjectDefinitionByType(xsiType);
            if (objectDefinition == null) {
                throw new SchemaException("No definition found for type " + xsiType + " (as defined by xsi:type)");
            }
        } else {
            objectDefinition = schema.findObjectDefinitionByElementName(elementName);
            if (objectDefinition == null) {
                throw new SchemaException("No object definition for element " + elementName + " in schema " + schema);
            }
        }
        return this.parseObject(objectElement, objectDefinition);
    }

    private <T extends Objectable> PrismObject<T> parseObject(Element objectElement, PrismObjectDefinition<T> objectDefinition) throws SchemaException {
        PrismObject object = (PrismObject)this.parsePrismContainer(objectElement, objectDefinition);
        String oid = this.getOid(objectElement);
        object.setOid(oid);
        String version = objectElement.getAttribute("version");
        object.setVersion(version);
        return object;
    }

    public <T extends Containerable> PrismContainer<T> parsePrismContainer(Element domElement) throws SchemaException {
        QName elementName = DOMUtil.getQName((Node)domElement);
        PrismSchema schema = this.schemaRegistry.findSchemaByNamespace(elementName.getNamespaceURI());
        if (schema == null) {
            throw new SchemaException("No schema definition for namespace '" + elementName.getNamespaceURI() + "'");
        }
        PrismContainerDefinition propertyContainerDefinition = schema.findItemDefinition(elementName, PrismContainerDefinition.class);
        if (propertyContainerDefinition == null) {
            throw new SchemaException("No definition for element " + elementName);
        }
        return this.parsePrismContainer(domElement, propertyContainerDefinition);
    }

    public <T extends Containerable> PrismContainer<T> parsePrismContainer(Element domElement, PrismContainerDefinition<T> propertyContainerDefinition) throws SchemaException {
        ArrayList<Element> valueElements = new ArrayList<Element>(1);
        valueElements.add(domElement);
        return this.parsePrismContainer(valueElements, DOMUtil.getQName((Node)domElement), propertyContainerDefinition);
    }

    private <T extends Containerable> PrismContainer<T> parsePrismContainer(List<? extends Object> valueElements, QName itemName, PrismContainerDefinition<T> containerDefinition) throws SchemaException {
        Item container = containerDefinition.instantiate(itemName);
        for (Object object : valueElements) {
            if (object instanceof Element) {
                Element element = (Element)object;
                String id = this.getContainerId(element);
                PrismContainerValue pval = new PrismContainerValue(null, null, (PrismContainerable)((Object)container), id);
                List childElements = DOMUtil.listChildElements((Node)element);
                Collection<Item> newContainerItems = this.parsePrismContainerItems(childElements, containerDefinition);
                this.addValuesToContainerValue(pval, newContainerItems);
                ((PrismContainer)container).add(pval);
                continue;
            }
            if (object instanceof JAXBElement) {
                this.parsePrismContainerFromValueObject(((JAXBElement)object).getValue(), (PrismContainerDefinition)((PrismContainer)container).getDefinition(), (PrismContainer<T>)container);
                continue;
            }
            this.parsePrismContainerFromValueObject(object, (PrismContainerDefinition)((PrismContainer)container).getDefinition(), (PrismContainer<T>)container);
        }
        return container;
    }

    private <T extends Containerable> void addValuesToContainerValue(PrismContainerValue<T> containerValue, Collection<? extends Item> newContainerItems) throws SchemaException {
        for (Item item : newContainerItems) {
            Item<?> existingItem = containerValue.findItem(item.getName());
            if (existingItem == null) {
                containerValue.add(item);
                continue;
            }
            for (PrismValue newPVal : item.getValues()) {
                existingItem.add(newPVal);
            }
        }
    }

    private <T extends Containerable> PrismContainerValue<T> parsePrismContainerFromValueObject(Object value, PrismContainerDefinition def, PrismContainer<T> parent) throws SchemaException {
        if (value instanceof Containerable) {
            PrismContainerValue containerValue = ((Containerable)value).asPrismContainerValue();
            containerValue.revive(parent.getPrismContext());
            parent.add(containerValue);
            containerValue.applyDefinition(def);
            return containerValue;
        }
        throw new SchemaException("Cannot process value of class " + value.getClass() + " as a container " + def);
    }

    private String getOid(Element element) {
        String oid = element.getAttribute(JAVA_PROPERTY_OID);
        if (StringUtils.isBlank((String)oid)) {
            return null;
        }
        return oid;
    }

    private String getContainerId(Element element) {
        String id = element.getAttribute("id");
        if (StringUtils.isNotBlank((String)id)) {
            return id;
        }
        id = element.getAttributeNS(element.getNamespaceURI(), "id");
        if (StringUtils.isNotBlank((String)id)) {
            return id;
        }
        id = element.getAttributeNS(DOMUtil.XML_ID_ATTRIBUTE.getNamespaceURI(), DOMUtil.XML_ID_ATTRIBUTE.getLocalPart());
        if (StringUtils.isNotBlank((String)id)) {
            return id;
        }
        return null;
    }

    private <T extends Containerable> Collection<? extends Item> parsePrismContainerItems(List<Element> childElements, PrismContainerDefinition<T> containerDefinition) throws SchemaException {
        return this.parsePrismContainerItems(childElements, containerDefinition, null);
    }

    protected <T extends Containerable> Collection<? extends Item<?>> parsePrismContainerItems(List<Element> elements, PrismContainerDefinition<T> containerDefinition, Collection<? extends ItemDefinition> selection) throws SchemaException {
        HashSet props = new HashSet();
        int i = 0;
        while (i < elements.size()) {
            block8: {
                ItemDefinition def;
                ArrayList<Element> valueElements;
                QName elementQName;
                block7: {
                    Element propElement = elements.get(i);
                    elementQName = DOMUtil.getQName((Node)propElement);
                    valueElements = new ArrayList<Element>();
                    valueElements.add(propElement);
                    while (i + 1 < elements.size() && elementQName.equals(DOMUtil.getQName((Node)elements.get(i + 1)))) {
                        valueElements.add(elements.get(++i));
                    }
                    if (selection == null) break block7;
                    boolean selected = false;
                    for (ItemDefinition itemDefinition : selection) {
                        if (!itemDefinition.getNameOrDefaultName().equals(elementQName)) continue;
                        selected = true;
                    }
                    if (!selected) break block8;
                }
                if ((def = this.locateItemDefinition(containerDefinition, elementQName, valueElements)) == null && !containerDefinition.isRuntimeSchema()) {
                    throw new SchemaException("Item " + elementQName + " has no definition", elementQName);
                }
                Item<?> item = this.parseItem(valueElements, elementQName, def);
                props.add(item);
            }
            ++i;
        }
        return props;
    }

    private ItemDefinition resolveDynamicItemDefinition(ItemDefinition parentDefinition, List<Element> valueElements, PrismContext prismContext) throws SchemaException {
        QName typeName = null;
        QName elementName = null;
        int maxOccurs = -1;
        for (Element element : valueElements) {
            Element domElement;
            if (elementName == null) {
                elementName = JAXBUtil.getElementQName((Object)element);
            }
            if (!(element instanceof Element) || !DOMUtil.hasXsiType((Element)(domElement = element)) || (typeName = DOMUtil.resolveXsiType((Element)domElement)) == null) continue;
            String maxOccursString = domElement.getAttributeNS(PrismConstants.A_MAX_OCCURS.getNamespaceURI(), PrismConstants.A_MAX_OCCURS.getLocalPart());
            if (StringUtils.isBlank((String)maxOccursString)) break;
            maxOccurs = this.parseMultiplicity(maxOccursString, elementName);
            break;
        }
        if (typeName == null) {
            return null;
        }
        PrismPropertyDefinition propDef = new PrismPropertyDefinition(elementName, elementName, typeName, prismContext);
        propDef.setMaxOccurs(maxOccurs);
        propDef.setDynamic(true);
        return propDef;
    }

    private int parseMultiplicity(String maxOccursString, QName elementName) throws SchemaException {
        if ("unbounded".equals(maxOccursString)) {
            return -1;
        }
        if (maxOccursString.startsWith("-")) {
            return -1;
        }
        if (StringUtils.isNumeric((String)maxOccursString)) {
            return Integer.valueOf(maxOccursString);
        }
        throw new SchemaException("Expecetd numeric value for " + PrismConstants.A_MAX_OCCURS.getLocalPart() + " attribute on " + elementName + " but got " + maxOccursString);
    }

    private <T> PrismProperty<T> parsePrismPropertyRaw(List<? extends Object> valueElements, QName itemName) throws SchemaException {
        Object firstElement = valueElements.get(0);
        QName propertyName = JAXBUtil.getElementQName((Object)firstElement);
        PrismProperty<PrismPropertyValue<Object>> property = new PrismProperty<PrismPropertyValue<Object>>(propertyName);
        for (Object object : valueElements) {
            PrismPropertyValue<Object> pval = new PrismPropertyValue<Object>(null);
            pval.setRawElement(object);
            property.add(pval);
        }
        return property;
    }

    public <T> PrismProperty<T> parsePrismProperty(List<? extends Object> valueElements, QName propName, PrismPropertyDefinition propertyDefinition) throws SchemaException {
        if (valueElements == null || valueElements.isEmpty()) {
            return null;
        }
        PrismProperty prop = propertyDefinition.instantiate(propName);
        if (!propertyDefinition.isMultiValue() && valueElements.size() > 1) {
            throw new SchemaException("Attempt to store multiple values in single-valued property " + propName);
        }
        for (Object object : valueElements) {
            T realValue = this.parsePrismPropertyRealValue(object, propertyDefinition);
            prop.add(new PrismPropertyValue<T>(realValue));
        }
        return prop;
    }

    public <T> T parsePrismPropertyRealValue(Object valueElement, PrismPropertyDefinition propertyDefinition) throws SchemaException {
        QName typeName = propertyDefinition.getTypeName();
        PrismJaxbProcessor jaxbProcessor = this.getJaxbProcessor();
        Object realValue = null;
        if (valueElement instanceof Element) {
            Element element = (Element)valueElement;
            if (propertyDefinition.getTypeName().equals(DOMUtil.XSD_ANY)) {
                PrismUtil.unfortifyNamespaceDeclarations(element);
                realValue = element;
            } else if (XmlTypeConverter.canConvert(typeName)) {
                realValue = XmlTypeConverter.toJavaValue(element, typeName);
            } else if (jaxbProcessor.canConvert(typeName)) {
                try {
                    realValue = jaxbProcessor.toJavaValue(element, typeName);
                }
                catch (JAXBException e) {
                    throw new SchemaException("Attempt to unmarshal value of property " + propertyDefinition.getName() + " failed: " + e.getMessage(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new SchemaException(String.valueOf(e.getMessage()) + " in property " + propertyDefinition.getName(), (Throwable)e);
                }
            } else {
                DOMUtil.fixNamespaceDeclarations((Element)element);
                realValue = element;
            }
        } else if (valueElement instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)valueElement;
            realValue = jaxbElement.getValue();
        } else {
            realValue = valueElement;
        }
        this.postProcessPropertyRealValue(realValue);
        return (T)realValue;
    }

    private <T> void postProcessPropertyRealValue(T realValue) {
        PolyString polyString;
        if (realValue == null) {
            return;
        }
        if (realValue instanceof PolyString && !(polyString = (PolyString)realValue).isComputed()) {
            polyString.recompute(this.getPrismContext().getDefaultPolyStringNormalizer());
        }
    }

    public <T> PrismProperty<T> parsePropertyFromValueElement(Element valueElement, PrismPropertyDefinition propertyDefinition) throws SchemaException {
        PrismProperty prop = propertyDefinition.instantiate();
        if (propertyDefinition.isSingleValue()) {
            Object realValue = XmlTypeConverter.convertValueElementAsScalar(valueElement, propertyDefinition.getTypeName());
            this.postProcessPropertyRealValue(realValue);
            prop.addValue(new PrismPropertyValue<Object>(realValue));
        } else {
            List<?> list = XmlTypeConverter.convertValueElementAsList(valueElement, propertyDefinition.getTypeName());
            for (Object realValue : list) {
                this.postProcessPropertyRealValue(realValue);
                prop.add(new PrismPropertyValue(realValue));
            }
        }
        return prop;
    }

    public <T extends Containerable> Collection<? extends Item<?>> parseContainerItems(PrismContainerDefinition<T> containingPcd, List<Object> valueElements) throws SchemaException {
        ArrayList items = new ArrayList(valueElements.size());
        int i = 0;
        while (i < valueElements.size()) {
            Object valueElement = valueElements.get(i);
            QName elementQName = JAXBUtil.getElementQName((Object)valueElement);
            if (elementQName == null) {
                throw new SchemaException("Cannot determine name of element " + valueElement + " in " + containingPcd);
            }
            ArrayList<Object> itemValueElements = new ArrayList<Object>();
            itemValueElements.add(valueElement);
            while (i + 1 < valueElements.size() && elementQName.equals(JAXBUtil.getElementQName((Object)valueElements.get(i + 1)))) {
                itemValueElements.add(valueElements.get(++i));
            }
            ItemDefinition itemDefinition = this.locateItemDefinition(containingPcd, elementQName, itemValueElements);
            if (itemDefinition == null && !containingPcd.isRuntimeSchema()) {
                throw new SchemaException("Definition of item " + elementQName + " cannot be found in " + containingPcd);
            }
            Item<?> item = this.parseItem(itemValueElements, elementQName, itemDefinition);
            items.add(item);
            ++i;
        }
        return items;
    }

    private <T extends Containerable> ItemDefinition locateItemDefinition(PrismContainerDefinition<T> containerDefinition, QName elementQName, List<? extends Object> valueElements) throws SchemaException {
        ItemDefinition def = containerDefinition.findItemDefinition(elementQName);
        if (def != null) {
            return def;
        }
        if (!valueElements.isEmpty() && valueElements.get(0) instanceof Element) {
            def = this.resolveDynamicItemDefinition(containerDefinition, valueElements, this.prismContext);
        }
        if (def != null) {
            return def;
        }
        if (containerDefinition.isRuntimeSchema()) {
            def = this.resolveGlobalItemDefinition(containerDefinition, valueElements);
        }
        return def;
    }

    private <T extends Containerable> ItemDefinition resolveGlobalItemDefinition(PrismContainerDefinition<T> containerDefinition, List<? extends Object> valueElements) throws SchemaException {
        Object firstElement = valueElements.get(0);
        QName elementQName = JAXBUtil.getElementQName((Object)firstElement);
        return this.getPrismContext().getSchemaRegistry().resolveGlobalItemDefinition(elementQName);
    }

    public PrismReference parsePrismReference(List<? extends Object> valueElements, QName propName, PrismReferenceDefinition referenceDefinition) throws SchemaException {
        if (valueElements == null || valueElements.isEmpty()) {
            return null;
        }
        PrismReference ref = referenceDefinition.instantiate();
        if (!referenceDefinition.isMultiValue() && valueElements.size() > 1) {
            throw new SchemaException("Attempt to store multiple values in single-valued property " + propName);
        }
        for (Object object : valueElements) {
            if (propName.equals(referenceDefinition.getName())) {
                if (object instanceof Element) {
                    ref.add(this.parseReferenceValue((Element)object));
                    continue;
                }
                if (object instanceof JAXBElement) {
                    ref.add(this.parseReferenceValueFromObject(((JAXBElement)object).getValue()));
                    continue;
                }
                ref.add(this.parseReferenceValueFromObject(object));
                continue;
            }
            ref.add(this.parseReferenceAsCompositeObject(object, referenceDefinition));
        }
        return ref;
    }

    private PrismReferenceValue parseReferenceAsCompositeObject(Object valueElement, PrismReferenceDefinition referenceDefinition) throws SchemaException {
        QName targetTypeName = referenceDefinition.getTargetTypeName();
        PrismObjectDefinition schemaObjectDefinition = null;
        if (targetTypeName != null) {
            schemaObjectDefinition = this.getPrismContext().getSchemaRegistry().findObjectDefinitionByType(targetTypeName);
        }
        PrismObject compositeObject = null;
        try {
            if (valueElement instanceof Element) {
                Element valueDomElement = (Element)valueElement;
                compositeObject = schemaObjectDefinition == null ? this.parseObject(valueDomElement) : this.parseObject(valueDomElement, schemaObjectDefinition);
            } else if (valueElement instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)valueElement;
                Objectable objectable = (Objectable)jaxbElement.getValue();
                compositeObject = objectable.asPrismObject();
                if (schemaObjectDefinition == null) {
                    this.getPrismContext().adopt(objectable);
                } else {
                    compositeObject.revive(this.getPrismContext());
                    compositeObject.applyDefinition(schemaObjectDefinition);
                }
            }
        }
        catch (SchemaException e) {
            throw new SchemaException(String.valueOf(e.getMessage()) + " while parsing composite object in reference element " + referenceDefinition.getCompositeObjectElementName(), (Throwable)e);
        }
        PrismReferenceValue refVal = new PrismReferenceValue();
        refVal.setObject(compositeObject);
        return refVal;
    }

    public PrismReferenceValue parseReferenceValue(Element element) {
        Element filterElement;
        String oid = this.getOid(element);
        QName type = DOMUtil.getQNameAttribute((Element)element, (String)JAVA_PROPERTY_TYPE);
        if (type != null) {
            DOMUtil.validateNonEmptyQName((QName)type, (String)(" in reference type in " + DOMUtil.getQName((Node)element)));
        }
        PrismReferenceValue refVal = new PrismReferenceValue(oid);
        refVal.setTargetType(type);
        Element descriptionElement = DOMUtil.getChildElement((Element)element, (String)JAVA_PROPERTY_DESCRIPTION);
        if (descriptionElement != null) {
            refVal.setDescription(descriptionElement.getTextContent());
        }
        if ((filterElement = DOMUtil.getChildElement((Element)element, (String)JAVA_PROPERTY_FILTER)) != null) {
            refVal.setFilter(DOMUtil.getFirstChildElement((Node)filterElement));
        }
        return refVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PrismReferenceValue parseReferenceValueFromObject(Object referenceObject) throws SchemaException {
        String oid = (String)MiscUtil.getJavaProperty((Object)referenceObject, (String)JAVA_PROPERTY_OID, String.class);
        QName type = (QName)MiscUtil.getJavaProperty((Object)referenceObject, (String)JAVA_PROPERTY_TYPE, QName.class);
        PrismReferenceValue refVal = new PrismReferenceValue(oid);
        refVal.setTargetType(type);
        String description = (String)MiscUtil.getJavaProperty((Object)referenceObject, (String)JAVA_PROPERTY_DESCRIPTION, String.class);
        refVal.setDescription(description);
        Object filterType = MiscUtil.getJavaProperty((Object)referenceObject, (String)JAVA_PROPERTY_FILTER, Object.class);
        if (filterType == null) return refVal;
        if (MiscUtil.hasJavaProperty((Object)filterType, (String)JAVA_JAXB_PROPERTY_ANY)) {
            List filterElementList = (List)MiscUtil.getJavaProperty((Object)filterType, (String)JAVA_JAXB_PROPERTY_ANY, List.class);
            if (filterElementList == null) return refVal;
            Object firstElement = filterElementList.get(0);
            if (!(firstElement instanceof Element)) throw new SchemaException("Unknown type of filter element " + firstElement.getClass());
            refVal.setFilter((Element)firstElement);
            return refVal;
        } else {
            if (!MiscUtil.hasJavaProperty((Object)filterType, (String)JAVA_PROPERTY_FILTER)) throw new SchemaException("JAXB bean of type " + referenceObject.getClass().getName() + " representing prism reference" + " does not contain '" + JAVA_JAXB_PROPERTY_ANY + "' property nor '" + JAVA_PROPERTY_FILTER + "' property");
            Element filterElement = (Element)MiscUtil.getJavaProperty((Object)filterType, (String)JAVA_PROPERTY_FILTER, Element.class);
            refVal.setFilter(filterElement);
        }
        return refVal;
    }

    public Item<?> parseItem(List<? extends Object> valueElements, QName itemName, ItemDefinition def) throws SchemaException {
        if (def == null) {
            return this.parsePrismPropertyRaw(valueElements, itemName);
        }
        if (def instanceof PrismContainerDefinition) {
            return this.parsePrismContainer(valueElements, itemName, (PrismContainerDefinition)def);
        }
        if (def instanceof PrismPropertyDefinition) {
            return this.parsePrismProperty(valueElements, itemName, (PrismPropertyDefinition)def);
        }
        if (def instanceof PrismReferenceDefinition) {
            return this.parsePrismReference(valueElements, itemName, (PrismReferenceDefinition)def);
        }
        throw new IllegalArgumentException("Attempt to parse unknown definition type " + def.getClass().getName());
    }

    public <T extends Containerable> boolean addItemValue(Item item, Object element, PrismContainer<T> container) throws SchemaException {
        ItemDefinition itemDefinition = item.getDefinition();
        ArrayList<Object> itemValueElements = new ArrayList<Object>();
        itemValueElements.add(element);
        if (itemDefinition == null) {
            itemDefinition = this.locateItemDefinition((PrismContainerDefinition<T>)container.getDefinition(), item.getName(), (List<? extends Object>)itemValueElements);
        }
        if (!(itemDefinition != null || container.getDefinition() != null && ((PrismContainerDefinition)container.getDefinition()).isRuntimeSchema())) {
            throw new SchemaException("Definition of item " + item + " in " + container + " cannot be determined");
        }
        Item<?> fauxItem = this.parseItem(itemValueElements, item.getName(), itemDefinition);
        PrismValue itemValue = (PrismValue)fauxItem.getValues().get(0);
        return item.add(itemValue);
    }

    public <T extends Containerable> boolean deleteItemValue(Item item, Object element, PrismContainer<T> container) throws SchemaException {
        ItemDefinition itemDefinition = item.getDefinition();
        ArrayList<Object> itemValueElements = new ArrayList<Object>();
        itemValueElements.add(element);
        if (itemDefinition == null) {
            itemDefinition = this.locateItemDefinition((PrismContainerDefinition<T>)container.getDefinition(), item.getName(), (List<? extends Object>)itemValueElements);
        }
        if (!(itemDefinition != null || container.getDefinition() != null && ((PrismContainerDefinition)container.getDefinition()).isRuntimeSchema())) {
            throw new SchemaException("Definition of item " + item + " in " + container + " cannot be determined");
        }
        Item<?> fauxItem = this.parseItem(itemValueElements, item.getName(), itemDefinition);
        PrismValue itemValue = (PrismValue)fauxItem.getValues().get(0);
        return item.remove(itemValue);
    }

    public Element serializeToDom(PrismObject<?> object) throws SchemaException {
        return this.serializeToDom(object, false);
    }

    public Element serializeToDom(PrismObject<?> object, boolean serializeCompositeObjects) throws SchemaException {
        DomSerializer domSerializer = new DomSerializer(this.getPrismContext());
        domSerializer.setSerializeCompositeObjects(serializeCompositeObjects);
        return domSerializer.serialize(object);
    }

    public <T extends Containerable> Element serializeToDom(PrismContainerValue<T> object, Element parentElement) throws SchemaException {
        DomSerializer domSerializer = new DomSerializer(this.getPrismContext());
        return domSerializer.serializeContainerValue(object, parentElement);
    }

    public <T extends Objectable> String serializeObjectToString(PrismObject<T> object) throws SchemaException {
        return this.serializeObjectToString(object, false);
    }

    public <T extends Objectable> String serializeObjectToString(PrismObject<T> object, boolean serializeCompositeObjects) throws SchemaException {
        Element element = this.serializeToDom(object, serializeCompositeObjects);
        return DOMUtil.serializeDOMToString((Node)element);
    }

    public <T extends Containerable> String serializeObjectToString(PrismContainerValue<T> object, Element parentElement) throws SchemaException {
        Element element = this.serializeToDom(object, parentElement);
        return DOMUtil.serializeDOMToString((Node)element);
    }

    public Element serializeValueToDom(PrismValue pval, QName elementName) throws SchemaException {
        return this.serializeValueToDom(pval, elementName, DOMUtil.getDocument());
    }

    public Element serializeValueToDom(PrismValue pval, QName elementName, Document document) throws SchemaException {
        Element fakeElement = document.createElementNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        this.serializeValueToDom(pval, fakeElement);
        return DOMUtil.getFirstChildElement((Node)fakeElement);
    }

    public void serializeValueToDom(PrismValue pval, Element parentElement) throws SchemaException {
        DomSerializer domSerializer = new DomSerializer(this.getPrismContext());
        domSerializer.serialize(pval, parentElement);
    }

    public List<Element> serializeItemToDom(Item<?> item) throws SchemaException {
        return this.serializeItemToDom(item, DOMUtil.getDocument());
    }

    public List<Element> serializeItemToDom(Item<?> item, Document document) throws SchemaException {
        QName elementName = item.getName();
        Element fakeElement = document.createElementNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        this.serializeItemToDom(item, fakeElement);
        return DOMUtil.listChildElements((Node)fakeElement);
    }

    public void serializeItemToDom(Item<?> item, Element parentElement) throws SchemaException {
        DomSerializer domSerializer = new DomSerializer(this.getPrismContext());
        domSerializer.serialize(item, parentElement);
    }

    public String determineElementNamespace(Itemable parent, String elementDescriptionLocalName) {
        ItemDefinition definition = parent.getDefinition();
        if (definition == null) {
            return parent.getName().getNamespaceURI();
        }
        return definition.getTypeName().getNamespaceURI();
    }
}

