/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.dom;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.dom.AttributeNamedNodeMapImpl;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public abstract class ElementPrismAbstractImpl
implements Element {
    private PrismValue value;

    ElementPrismAbstractImpl(PrismValue value) {
        this.value = value;
    }

    protected PrismValue getValue() {
        return this.value;
    }

    protected Item getItem() {
        return (Item)this.value.getParent();
    }

    protected PrismContext getPrismContext() {
        return this.getItem().getPrismContext();
    }

    protected QName getElementName() {
        return this.getItem().getName();
    }

    @Override
    public String getNodeName() {
        return this.getElementName().getLocalPart();
    }

    @Override
    public String getNamespaceURI() {
        return this.getElementName().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.getElementName().getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLocalName() {
        return this.getElementName().getLocalPart();
    }

    @Override
    public String getTagName() {
        return this.getElementName().getLocalPart();
    }

    protected abstract NodeList getValueNodeList();

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public abstract String getTextContent() throws DOMException;

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException("The DOM element for " + this.getItem() + " is not writable");
    }

    @Override
    public NodeList getChildNodes() {
        return this.getValueNodeList();
    }

    @Override
    public Node getFirstChild() {
        NodeList valueNodeList = this.getValueNodeList();
        if (valueNodeList.getLength() == 0) {
            return null;
        }
        return valueNodeList.item(0);
    }

    @Override
    public Node getLastChild() {
        NodeList valueNodeList = this.getValueNodeList();
        if (valueNodeList.getLength() == 0) {
            return null;
        }
        return valueNodeList.item(valueNodeList.getLength() - 1);
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public Node getParentNode() {
        PrismValue parentValue = this.getItem().getParent();
        if (parentValue == null) {
            return null;
        }
        return parentValue.asDomElement();
    }

    @Override
    public Node getPreviousSibling() {
        PrismValue parentValue;
        Item item = this.getItem();
        PrismValue previousPVal = item.getPreviousValue(this.value);
        if (previousPVal == null && (parentValue = this.getItem().getParent()) instanceof PrismContainerValue) {
            PrismContainerValue parentContainerValue = (PrismContainerValue)parentValue;
            Item<?> prevItem = parentContainerValue.getPreviousItem(this.getItem());
            if (prevItem == null || prevItem.isEmpty()) {
                return null;
            }
            previousPVal = prevItem.getValue(-1);
        }
        if (previousPVal == null) {
            return null;
        }
        return previousPVal.asDomElement();
    }

    @Override
    public Node getNextSibling() {
        PrismValue parentValue;
        this.getItem();
        PrismValue nextPVal = this.getItem().getNextValue(this.value);
        if (nextPVal == null && (parentValue = this.getItem().getParent()) instanceof PrismContainerValue) {
            PrismContainerValue parentContainerValue = (PrismContainerValue)parentValue;
            Item<?> nextItem = parentContainerValue.getNextItem(this.getItem());
            if (nextItem == null || nextItem.isEmpty()) {
                return null;
            }
            nextPVal = nextItem.getValue(0);
        }
        if (nextPVal == null) {
            return null;
        }
        return nextPVal.asDomElement();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new AttributeNamedNodeMapImpl(this.getAttributeMap(), this.getNamespaceURI(), this);
    }

    @Override
    public Document getOwnerDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract Node insertBefore(Node var1, Node var2) throws DOMException;

    @Override
    public abstract Node replaceChild(Node var1, Node var2) throws DOMException;

    @Override
    public abstract Node removeChild(Node var1) throws DOMException;

    @Override
    public abstract Node appendChild(Node var1) throws DOMException;

    @Override
    public abstract boolean hasChildNodes();

    @Override
    public abstract Node cloneNode(boolean var1);

    @Override
    public abstract NodeList getElementsByTagName(String var1);

    @Override
    public abstract NodeList getElementsByTagNameNS(String var1, String var2) throws DOMException;

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    @Override
    public boolean isSameNode(Node other) {
        return false;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.equals(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException();
    }

    protected Map<String, String> getAttributeMap() {
        return null;
    }

    @Override
    public String getAttribute(String name) {
        return this.getAttributeMap().get(name);
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Attr getAttributeNode(String name) {
        return (Attr)this.getAttributes().getNamedItem(name);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttributeNodeNS(namespaceURI, localName).getValue();
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return (Attr)this.getAttributes().getNamedItemNS(namespaceURI, localName);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributes().getLength() != 0;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Element/Prism(" + this.value + ")";
    }
}

