/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.delta;

import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.Visitable;
import com.evolveum.midpoint.prism.Visitor;
import com.evolveum.midpoint.prism.delta.DeltaSetTriple;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import java.util.Collection;

public class PrismValueDeltaSetTriple<V extends PrismValue>
extends DeltaSetTriple<V>
implements Dumpable,
DebugDumpable,
Visitable {
    public PrismValueDeltaSetTriple() {
    }

    public PrismValueDeltaSetTriple(Collection<V> zeroSet, Collection<V> plusSet, Collection<V> minusSet) {
        super(zeroSet, plusSet, minusSet);
    }

    public static <V extends PrismValue> PrismValueDeltaSetTriple<V> diff(Collection<V> valuesOld, Collection<V> valuesNew) {
        PrismValueDeltaSetTriple<V> triple = new PrismValueDeltaSetTriple<V>();
        PrismValueDeltaSetTriple.diff(valuesOld, valuesNew, triple);
        return triple;
    }

    public <O extends PrismValue> void distributeAs(V myMember, PrismValueDeltaSetTriple<O> otherTriple, O otherMember) {
        if (otherTriple.getZeroSet() != null && PrismValue.containsRealValue(otherTriple.getZeroSet(), otherMember)) {
            this.zeroSet.add(myMember);
        }
        if (otherTriple.getPlusSet() != null && PrismValue.containsRealValue(otherTriple.getPlusSet(), otherMember)) {
            this.plusSet.add(myMember);
        }
        if (otherTriple.getMinusSet() != null && PrismValue.containsRealValue(otherTriple.getMinusSet(), otherMember)) {
            this.minusSet.add(myMember);
        }
    }

    public Class<V> getValueClass() {
        V anyValue = this.getAnyValue();
        if (anyValue == null) {
            return null;
        }
        return anyValue.getClass();
    }

    public Class<?> getRealValueClass() {
        V anyValue = this.getAnyValue();
        if (anyValue == null) {
            return null;
        }
        if (anyValue instanceof PrismPropertyValue) {
            PrismPropertyValue pval = (PrismPropertyValue)anyValue;
            Object realValue = pval.getValue();
            if (realValue == null) {
                return null;
            }
            return realValue.getClass();
        }
        return null;
    }

    private V getAnyValue() {
        if (this.zeroSet != null && !this.zeroSet.isEmpty()) {
            return (V)((PrismValue)this.zeroSet.iterator().next());
        }
        if (this.plusSet != null && !this.plusSet.isEmpty()) {
            return (V)((PrismValue)this.plusSet.iterator().next());
        }
        if (this.minusSet != null && !this.minusSet.isEmpty()) {
            return (V)((PrismValue)this.minusSet.iterator().next());
        }
        return null;
    }

    public PrismValueDeltaSetTriple<V> clone() {
        PrismValueDeltaSetTriple<V> clone = new PrismValueDeltaSetTriple<V>();
        clone.zeroSet = this.cloneSet(this.zeroSet);
        clone.plusSet = this.cloneSet(this.plusSet);
        clone.minusSet = this.cloneSet(this.minusSet);
        return clone;
    }

    private Collection<V> cloneSet(Collection<V> origSet) {
        if (origSet == null) {
            return null;
        }
        Collection clonedSet = this.createSet();
        for (PrismValue origVal : origSet) {
            clonedSet.add(origVal.clone());
        }
        return clonedSet;
    }

    @Override
    public void accept(Visitor visitor) {
        this.acceptSet(this.zeroSet, visitor);
        this.acceptSet(this.plusSet, visitor);
        this.acceptSet(this.minusSet, visitor);
    }

    private void acceptSet(Collection<V> set, Visitor visitor) {
        if (set == null) {
            return;
        }
        for (PrismValue val : set) {
            val.accept(visitor);
        }
    }

    @Override
    protected String debugName() {
        return "PVDeltaSetTriple";
    }
}

