/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.delta;

import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;

public class DeltaSetTriple<T>
implements Dumpable,
DebugDumpable {
    protected Collection<T> zeroSet;
    protected Collection<T> plusSet;
    protected Collection<T> minusSet;

    public DeltaSetTriple() {
        this.zeroSet = this.createSet();
        this.plusSet = this.createSet();
        this.minusSet = this.createSet();
    }

    public DeltaSetTriple(Collection<T> zeroSet, Collection<T> plusSet, Collection<T> minusSet) {
        this.zeroSet = zeroSet;
        this.plusSet = plusSet;
        this.minusSet = minusSet;
    }

    public static <T> DeltaSetTriple<T> diff(Collection<T> valuesOld, Collection<T> valuesNew) {
        DeltaSetTriple<T> triple = new DeltaSetTriple<T>();
        DeltaSetTriple.diff(valuesOld, valuesNew, triple);
        return triple;
    }

    protected static <T> void diff(Collection<T> valuesOld, Collection<T> valuesNew, DeltaSetTriple<T> triple) {
        if (valuesOld == null && valuesNew == null) {
            return;
        }
        if (valuesOld == null) {
            triple.getPlusSet().addAll(valuesNew);
            return;
        }
        if (valuesNew == null) {
            triple.getMinusSet().addAll(valuesOld);
            return;
        }
        for (T val : valuesOld) {
            if (valuesNew.contains(val)) {
                triple.getZeroSet().add(val);
                continue;
            }
            triple.getMinusSet().add(val);
        }
        for (T val : valuesNew) {
            if (valuesOld.contains(val)) continue;
            triple.getPlusSet().add(val);
        }
    }

    protected Collection<T> createSet() {
        return new ArrayList();
    }

    public Collection<T> getZeroSet() {
        return this.zeroSet;
    }

    public Collection<T> getPlusSet() {
        return this.plusSet;
    }

    public Collection<T> getMinusSet() {
        return this.minusSet;
    }

    public boolean hasPlusSet() {
        return this.plusSet != null && !this.plusSet.isEmpty();
    }

    public boolean hasZeroSet() {
        return this.zeroSet != null && !this.zeroSet.isEmpty();
    }

    public boolean hasMinusSet() {
        return this.minusSet != null && !this.minusSet.isEmpty();
    }

    public void addToPlusSet(T item) {
        if (this.plusSet == null) {
            this.plusSet = this.createSet();
        }
        this.plusSet.add(item);
    }

    public void addToMinusSet(T item) {
        if (this.minusSet == null) {
            this.minusSet = this.createSet();
        }
        this.minusSet.add(item);
    }

    public void addToZeroSet(T item) {
        if (this.zeroSet == null) {
            this.zeroSet = this.createSet();
        }
        this.zeroSet.add(item);
    }

    public void addAllToPlusSet(Collection<T> items) {
        if (this.plusSet == null) {
            this.plusSet = this.createSet();
        }
        this.plusSet.addAll(items);
    }

    public void addAllToMinusSet(Collection<T> items) {
        if (this.minusSet == null) {
            this.minusSet = this.createSet();
        }
        this.minusSet.addAll(items);
    }

    public void addAllToZeroSet(Collection<T> items) {
        if (this.zeroSet == null) {
            this.zeroSet = this.createSet();
        }
        this.zeroSet.addAll(items);
    }

    public Collection<T> union() {
        return MiscUtil.union((Collection[])new Collection[]{this.zeroSet, this.plusSet, this.minusSet});
    }

    public Collection<T> getNonNegativeValues() {
        return MiscUtil.union((Collection[])new Collection[]{this.zeroSet, this.plusSet});
    }

    public void merge(DeltaSetTriple<T> triple) {
        this.zeroSet.addAll(triple.zeroSet);
        this.plusSet.addAll(triple.plusSet);
        this.minusSet.addAll(triple.minusSet);
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.debugName()).append("(");
        this.dumpSet(sb, "zero", this.zeroSet);
        this.dumpSet(sb, "plus", this.plusSet);
        this.dumpSet(sb, "minus", this.minusSet);
        sb.append(")");
        return sb.toString();
    }

    protected String debugName() {
        return "DeltaSetTriple";
    }

    private void dumpSet(StringBuilder sb, String label, Collection<T> set) {
        sb.append(label).append(": ").append(set).append("; ");
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        DebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append("DeltaSetTriple:\n");
        this.debugDumpSet(sb, "zero", this.zeroSet, indent + 1);
        sb.append("\n");
        this.debugDumpSet(sb, "plus", this.plusSet, indent + 1);
        sb.append("\n");
        this.debugDumpSet(sb, "minus", this.minusSet, indent + 1);
        return sb.toString();
    }

    private void debugDumpSet(StringBuilder sb, String label, Collection<T> set, int indent) {
        DebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append(label).append(":");
        if (set == null) {
            sb.append(" null");
        } else {
            for (T val : set) {
                sb.append("\n");
                sb.append(DebugUtil.debugDump(val, (int)(indent + 1)));
            }
        }
    }
}

