/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import javax.xml.namespace.QName;

public class PrismObjectDefinition<T extends Objectable>
extends PrismContainerDefinition<T> {
    private static final long serialVersionUID = -8298581031956931008L;

    public PrismObjectDefinition(QName name, ComplexTypeDefinition complexTypeDefinition, PrismContext prismContext, Class<T> compileTimeClass) {
        super(name, complexTypeDefinition, prismContext, compileTimeClass);
        if (name != null) {
            this.defaultName = name;
        }
    }

    @Override
    public PrismObject<T> instantiate() {
        PrismObject midPointObject = new PrismObject(this.getNameOrDefaultName(), this, this.prismContext);
        return midPointObject;
    }

    @Override
    public PrismObject<T> instantiate(QName name) {
        PrismObject midPointObject = new PrismObject(name, this, this.prismContext);
        return midPointObject;
    }

    @Override
    public PrismObjectDefinition<T> clone() {
        PrismObjectDefinition<T> clone = new PrismObjectDefinition<T>(this.name, this.complexTypeDefinition, this.prismContext, this.compileTimeClass);
        this.copyDefinitionData(clone);
        return clone;
    }

    @Override
    public PrismObjectDefinition<T> cloneWithReplacedDefinition(QName itemName, ItemDefinition newDefinition) {
        return (PrismObjectDefinition)super.cloneWithReplacedDefinition(itemName, newDefinition);
    }

    public void setExtensionDefinition(ComplexTypeDefinition extensionComplexTypeDefinition) {
        QName extensionQName = this.getExtensionQName();
        PrismContainerDefinition oldExtensionDef = this.findContainerDefinition(extensionQName);
        PrismContainerDefinition newExtensionDef = new PrismContainerDefinition(extensionQName, extensionComplexTypeDefinition, this.prismContext);
        newExtensionDef.setRuntimeSchema(true);
        if (oldExtensionDef != null) {
            if (newExtensionDef.getDisplayName() == null) {
                newExtensionDef.setDisplayName(oldExtensionDef.getDisplayName());
            }
            if (newExtensionDef.getDisplayOrder() == null) {
                newExtensionDef.setDisplayOrder(oldExtensionDef.getDisplayOrder());
            }
            if (newExtensionDef.getHelp() == null) {
                newExtensionDef.setHelp(oldExtensionDef.getHelp());
            }
        }
        ComplexTypeDefinition newCtd = this.complexTypeDefinition.clone();
        newCtd.replaceDefinition(extensionQName, newExtensionDef);
        if (newCtd.getDisplayName() == null) {
            newCtd.setDisplayName(this.complexTypeDefinition.getDisplayName());
        }
        if (newCtd.getDisplayOrder() == null) {
            newCtd.setDisplayOrder(this.complexTypeDefinition.getDisplayOrder());
        }
        if (newCtd.getHelp() == null) {
            newCtd.setHelp(this.complexTypeDefinition.getHelp());
        }
        this.complexTypeDefinition = newCtd;
    }

    private QName getExtensionQName() {
        String namespace = this.getName().getNamespaceURI();
        return new QName(namespace, "extension");
    }

    @Override
    protected String getDebugDumpClassName() {
        return "POD";
    }
}

