/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContainerable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.delta.ContainerDelta;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class PrismContainer<V extends Containerable>
extends Item<PrismContainerValue<V>>
implements PrismContainerable<V> {
    private static final long serialVersionUID = 5206821250098051028L;
    protected Class<V> compileTimeClass;

    public PrismContainer(QName name) {
        super(name);
    }

    public PrismContainer(QName name, Class<V> compileTimeClass) {
        super(name);
        if (Modifier.isAbstract(compileTimeClass.getModifiers())) {
            throw new IllegalArgumentException("Can't use class '" + compileTimeClass.getSimpleName() + "' as compile-time class for " + name + "; the class is abstract.");
        }
        this.compileTimeClass = compileTimeClass;
    }

    protected PrismContainer(QName name, PrismContainerDefinition<V> definition, PrismContext prismContext) {
        super(name, definition, prismContext);
    }

    @Override
    public Class<V> getCompileTimeClass() {
        if (this.compileTimeClass != null) {
            return this.compileTimeClass;
        }
        if (this.getDefinition() != null) {
            return ((PrismContainerDefinition)this.getDefinition()).getCompileTimeClass();
        }
        return null;
    }

    public boolean canRepresent(Class<?> compileTimeClass) {
        return compileTimeClass.isAssignableFrom(this.getCompileTimeClass());
    }

    @Override
    public List<PrismContainerValue<V>> getValues() {
        return super.getValues();
    }

    public PrismContainerValue<V> getValue() {
        if (this.getValues().size() == 1) {
            return this.getValues().get(0);
        }
        if (this.getValues().size() > 1) {
            throw new IllegalStateException("Attempt to get single value from a multivalued container " + this.getName());
        }
        if (this.getDefinition() != null && !this.getDefinition().isDynamic()) {
            if (this.getDefinition().isSingleValue()) {
                PrismContainerValue pValue = new PrismContainerValue(null, null, this, null);
                try {
                    this.add(pValue);
                }
                catch (SchemaException e) {
                    throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
                }
                return pValue;
            }
            throw new IllegalStateException("Attempt to get single value from a multivalued container " + this.getName());
        }
        PrismContainerValue pValue = new PrismContainerValue(null, null, this, null);
        try {
            this.add(pValue);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
        return pValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(PrismContainerValue<V> value) throws SchemaException {
        if (this.getDefinition() != null) {
            if (!this.getDefinition().isSingleValue()) throw new IllegalStateException("Attempt to set single value to a multivalued container " + this.getName());
            this.clear();
            this.add(value);
            return;
        } else {
            this.clear();
            this.add(value);
        }
    }

    @Override
    public PrismContainerValue<V> getPreviousValue(PrismValue value) {
        return (PrismContainerValue)super.getPreviousValue(value);
    }

    @Override
    public PrismContainerValue<V> getNextValue(PrismValue value) {
        return (PrismContainerValue)super.getNextValue(value);
    }

    private boolean canAssumeSingleValue() {
        if (this.getDefinition() != null) {
            return this.getDefinition().isSingleValue();
        }
        return this.getValues().size() <= 1;
    }

    public PrismContainerValue<V> getValue(String id) {
        for (PrismContainerValue<V> pval : this.getValues()) {
            if ((id != null || pval.getId() != null) && !id.equals(pval.getId())) continue;
            return pval;
        }
        return null;
    }

    public void setPropertyRealValue(QName propertyName, Object realValue) throws SchemaException {
        PrismProperty property = this.findOrCreateProperty(propertyName);
        property.setRealValue(realValue);
    }

    public <T> T getPropertyRealValue(QName propertyName, Class<T> type) {
        PrismProperty<T> property = this.findProperty(propertyName);
        if (property == null) {
            return null;
        }
        return property.getRealValue(type);
    }

    @Override
    public boolean add(PrismContainerValue<V> pValue) throws SchemaException {
        pValue.setParent(this);
        if (this.getDefinition() != null) {
            pValue.applyDefinition((PrismContainerDefinition)this.getDefinition(), false);
        }
        return this.getValues().add(pValue);
    }

    public void add(Item<?> item) throws SchemaException {
        this.getValue().add(item);
    }

    public void remove(Item<?> item) {
        this.getValue().remove(item);
    }

    public PrismContainerValue<V> createNewValue() {
        PrismContainerValue pValue = new PrismContainerValue();
        try {
            this.add(pValue);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
        return pValue;
    }

    public void mergeValues(PrismContainer<V> other) throws SchemaException {
        this.mergeValues(other.getValues());
    }

    public void mergeValues(Collection<PrismContainerValue<V>> otherValues) throws SchemaException {
        for (PrismContainerValue<V> otherValue : otherValues) {
            this.mergeValue(otherValue);
        }
    }

    public void mergeValue(PrismContainerValue<V> otherValue) throws SchemaException {
        Iterator<PrismContainerValue<V>> iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            PrismContainerValue<V> thisValue = iterator.next();
            if (thisValue.equals(otherValue)) {
                return;
            }
            if (thisValue.getId() == null || !thisValue.getId().equals(otherValue.getId())) continue;
            iterator.remove();
        }
        otherValue.setParent(this);
        if (this.getDefinition() != null) {
            otherValue.applyDefinition(this.getDefinition());
        }
        this.add(otherValue);
    }

    public void trim() {
        Iterator<PrismContainerValue<V>> iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            PrismContainerValue<V> pval = iterator.next();
            if (!pval.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Override
    public PrismContainerDefinition<V> getDefinition() {
        return (PrismContainerDefinition)this.definition;
    }

    public void setDefinition(PrismContainerDefinition<V> definition) {
        this.definition = definition;
    }

    @Override
    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        if (definition == null) {
            return;
        }
        if (!(definition instanceof PrismContainerDefinition)) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to container " + this);
        }
        this.compileTimeClass = ((PrismContainerDefinition)definition).getCompileTimeClass();
        super.applyDefinition(definition);
    }

    public <I extends Item<?>> I findItem(QName itemQName, Class<I> type) {
        try {
            return this.findCreateItem(itemQName, type, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Item<?> findItem(QName itemQName) {
        try {
            return this.findCreateItem(itemQName, Item.class, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    <I extends Item<?>> I findCreateItem(QName itemQName, Class<I> type, boolean create) throws SchemaException {
        return this.getValue().findCreateItem(itemQName, type, null, create);
    }

    public <I extends Item<?>> I findItem(PropertyPath propPath, Class<I> type) {
        try {
            return this.findCreateItem(propPath, type, null, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Item<?> findItem(PropertyPath propPath) {
        try {
            return this.findCreateItem(propPath, Item.class, null, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    <I extends Item<?>> I findCreateItem(PropertyPath propPath, Class<I> type, ItemDefinition itemDefinition, boolean create) throws SchemaException {
        if (propPath == null || propPath.isEmpty()) {
            throw new IllegalArgumentException("Empty path specified");
        }
        PropertyPathSegment first = propPath.first();
        if (!first.getName().equals(this.getName())) {
            throw new IllegalArgumentException("Expected path with first segment name " + this.getName() + ", but got " + first);
        }
        PropertyPath rest = propPath.rest();
        if (rest.isEmpty()) {
            if (type.isAssignableFrom(this.getClass())) {
                return (I)this;
            }
            if (create) {
                throw new IllegalStateException("The " + type.getSimpleName() + " " + this.getName() + " cannot be created because " + this.getClass().getSimpleName() + " with the same name exists");
            }
            return null;
        }
        if (first.getId() == null) {
            if (this.canAssumeSingleValue()) {
                return this.getValue().findCreateItem(rest, type, itemDefinition, create);
            }
            throw new IllegalArgumentException("Attempt to get segment " + first + " without an ID from a multi-valued container " + this.getName());
        }
        for (PrismContainerValue<V> pval : this.getValues()) {
            if (!first.getId().equals(pval.getId())) continue;
            return pval.findCreateItem(rest, type, itemDefinition, create);
        }
        return null;
    }

    public <T extends Containerable> PrismContainer<T> findContainer(PropertyPath path) {
        return this.findItem(path, PrismContainer.class);
    }

    public <T extends Containerable> PrismContainer<T> findContainer(QName containerName) {
        return this.findItem(containerName, PrismContainer.class);
    }

    public <T> PrismProperty<T> findProperty(PropertyPath path) {
        return this.findItem(path, PrismProperty.class);
    }

    public <T> PrismProperty<T> findProperty(QName propertyQName) {
        return this.findItem(propertyQName, PrismProperty.class);
    }

    public PrismReference findReference(PropertyPath path) {
        return this.findItem(path, PrismReference.class);
    }

    public PrismReference findReference(QName referenceQName) {
        return this.findItem(referenceQName, PrismReference.class);
    }

    public PrismReference findReferenceByCompositeObjectElementName(QName elementName) {
        return this.getValue().findReferenceByCompositeObjectElementName(elementName);
    }

    public <T extends Item<?>> T findOrCreateItem(PropertyPath containerPath, Class<T> type) throws SchemaException {
        return this.findCreateItem(containerPath, type, null, true);
    }

    public <T extends Item<?>> T findOrCreateItem(PropertyPath containerPath, Class<T> type, ItemDefinition definition) throws SchemaException {
        if (PrismObject.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("It makes no sense to find object in a container (class)");
        }
        if (definition instanceof PrismObjectDefinition) {
            throw new IllegalArgumentException("It makes no sense to find object in a container (definition)");
        }
        return this.findCreateItem(containerPath, type, definition, true);
    }

    public <T extends Containerable> PrismContainer<T> findOrCreateContainer(PropertyPath containerPath) throws SchemaException {
        return this.findCreateItem(containerPath, PrismContainer.class, null, true);
    }

    public <T extends Containerable> PrismContainer<T> findOrCreateContainer(QName containerName) throws SchemaException {
        return this.findCreateItem(containerName, PrismContainer.class, true);
    }

    public <T> PrismProperty<T> findOrCreateProperty(PropertyPath propertyPath) throws SchemaException {
        return this.findCreateItem(propertyPath, PrismProperty.class, null, true);
    }

    public <T> PrismProperty<T> findOrCreateProperty(QName propertyName) throws SchemaException {
        return this.findCreateItem(propertyName, PrismProperty.class, true);
    }

    public PrismReference findOrCreateReference(PropertyPath propertyPath) throws SchemaException {
        return this.findCreateItem(propertyPath, PrismReference.class, null, true);
    }

    public PrismReference findOrCreateReference(QName propertyName) throws SchemaException {
        return this.findCreateItem(propertyName, PrismReference.class, true);
    }

    void addItemPathsToList(PropertyPath basePath, Collection<PropertyPath> list) {
        boolean addIds = true;
        if (this.getDefinition() != null && this.getDefinition().isSingleValue()) {
            addIds = false;
        }
        for (PrismContainerValue<V> pval : this.getValues()) {
            PropertyPathSegment segment = null;
            segment = addIds ? new PropertyPathSegment(this.getName(), pval.getId()) : new PropertyPathSegment(this.getName());
            pval.addItemPathsToList(basePath.subPath(segment), list);
        }
    }

    @Override
    public ContainerDelta<V> createDelta(PropertyPath path) {
        return new ContainerDelta(path, (PrismContainerDefinition)this.getDefinition());
    }

    public Collection<? extends ItemDelta> diff(PrismContainer<V> other, PropertyPath pathPrefix) {
        return this.diff(other, pathPrefix, true);
    }

    public Collection<? extends ItemDelta> diff(PrismContainer<V> other, PropertyPath pathPrefix, boolean ignoreMetadata) {
        ArrayList deltas = new ArrayList();
        this.diffInternal(other, pathPrefix, deltas, ignoreMetadata);
        return deltas;
    }

    @Override
    public void revive(PrismContext prismContext) {
        if (this.prismContext != null) {
            return;
        }
        super.revive(prismContext);
        for (PrismContainerValue<V> pval : this.getValues()) {
            pval.revive(prismContext);
        }
    }

    @Override
    public boolean isEmpty() {
        for (PrismContainerValue<V> pval : this.getValues()) {
            if (pval.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void checkDefinition(ItemDefinition def) {
        if (!(def instanceof PrismContainerDefinition)) {
            throw new IllegalArgumentException("Definition " + def + " cannot be applied to container " + this);
        }
    }

    @Override
    public void assertDefinitions(boolean tolarateRaw, String sourceDescription) throws SchemaException {
        super.assertDefinitions(tolarateRaw, sourceDescription);
        for (PrismContainerValue<V> val : this.getValues()) {
            val.assertDefinitions(tolarateRaw, String.valueOf(this.toString()) + " in " + sourceDescription);
        }
    }

    @Override
    public PrismContainer<V> clone() {
        PrismContainer<V> clone = new PrismContainer<V>(this.getName(), this.getDefinition(), this.prismContext);
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(PrismContainer<V> clone) {
        super.copyValues(clone);
        for (PrismContainerValue<V> pval : this.getValues()) {
            try {
                clone.add((PrismContainerValue<V>)pval.clone());
            }
            catch (SchemaException e) {
                throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public boolean equivalent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrismContainer other = (PrismContainer)obj;
        return this.equals(other);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getDebugDumpClassName()) + "(" + this.getName() + "):" + this.getValues();
    }

    @Override
    public String dump() {
        return this.debugDump();
    }

    @Override
    public String debugDump(int indent) {
        Iterator<PrismContainerValue<V>> i;
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i2;
        }
        sb.append(this.getDebugDumpClassName()).append(": ").append(DebugUtil.prettyPrint((QName)this.getName()));
        sb.append(this.additionalDumpDescription());
        ItemDefinition def = this.getDefinition();
        if (def != null) {
            sb.append(" def(");
            sb.append(DebugUtil.prettyPrint((QName)def.getTypeName()));
            if (((PrismContainerDefinition)def).isRuntimeSchema()) {
                sb.append(",runtime");
            }
            if (def.isDynamic()) {
                sb.append(",dyn");
            }
            sb.append(")");
        }
        if ((i = this.getValues().iterator()).hasNext()) {
            sb.append("\n");
        }
        while (i.hasNext()) {
            PrismContainerValue<V> pval = i.next();
            sb.append(pval.debugDump(indent + 1));
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String additionalDumpDescription() {
        return "";
    }

    @Override
    protected String getDebugDumpClassName() {
        return "PC";
    }
}

