/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.Visitable;
import com.evolveum.midpoint.prism.Visitor;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class Item<V extends PrismValue>
implements Itemable,
Dumpable,
DebugDumpable,
Visitable,
Serializable {
    protected QName name;
    protected PrismValue parent;
    protected ItemDefinition definition;
    private List<V> values = new ArrayList<V>();
    private transient Map<String, Object> userData;
    protected transient PrismContext prismContext;

    Item(QName name) {
        this.name = name;
        this.userData = new HashMap<String, Object>();
    }

    Item(QName name, ItemDefinition definition, PrismContext prismContext) {
        this.name = name;
        this.definition = definition;
        this.prismContext = prismContext;
        this.userData = new HashMap<String, Object>();
    }

    @Override
    public ItemDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public void setDefinition(ItemDefinition definition) {
        this.checkDefinition(definition);
        this.definition = definition;
    }

    public String getDisplayName() {
        return this.getDefinition() == null ? null : this.getDefinition().getDisplayName();
    }

    public String getHelp() {
        return this.getDefinition() == null ? null : this.getDefinition().getHelp();
    }

    @Override
    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public PrismValue getParent() {
        return this.parent;
    }

    public void setParent(PrismValue parentValue) {
        this.parent = parentValue;
    }

    @Override
    public PropertyPath getPath(PropertyPath pathPrefix) {
        if (pathPrefix == null) {
            return new PropertyPath(this.getName());
        }
        return pathPrefix.subPath(this.getName());
    }

    public Map<String, Object> getUserData() {
        return this.userData;
    }

    public Object getUserData(String key) {
        return this.userData.get(key);
    }

    public void setUserData(String key, Object value) {
        this.userData.put(key, value);
    }

    public List<V> getValues() {
        return this.values;
    }

    public V getValue(int index) {
        if (index < 0) {
            index = this.values.size() + index;
        }
        return (V)((PrismValue)this.values.get(index));
    }

    public boolean hasValue(PrismValue value, boolean ignoreMetadata) {
        return this.findValue(value, ignoreMetadata) != null;
    }

    public boolean hasValue(PrismValue value) {
        return this.hasValue(value, false);
    }

    public boolean hasRealValue(PrismValue value) {
        return this.hasValue(value, true);
    }

    public PrismValue findValue(PrismValue value, boolean ignoreMetadata) {
        for (PrismValue myVal : this.getValues()) {
            if (!myVal.equals(value, ignoreMetadata)) continue;
            return myVal;
        }
        return null;
    }

    public PrismValue getPreviousValue(PrismValue value) {
        PrismValue previousValue = null;
        for (PrismValue myVal : this.getValues()) {
            if (myVal == value) {
                return previousValue;
            }
            previousValue = myVal;
        }
        throw new IllegalStateException("The value " + value + " is not any of " + this + " values, therefore cannot determine previous value");
    }

    public PrismValue getNextValue(PrismValue value) {
        Iterator<V> iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            PrismValue myVal = (PrismValue)iterator.next();
            if (myVal != value) continue;
            if (iterator.hasNext()) {
                return (PrismValue)iterator.next();
            }
            return null;
        }
        throw new IllegalStateException("The value " + value + " is not any of " + this + " values, therefore cannot determine next value");
    }

    public Collection<V> getClonedValues() {
        ArrayList<PrismValue> clonedValues = new ArrayList<PrismValue>(this.getValues().size());
        for (PrismValue val : this.getValues()) {
            clonedValues.add(val.clone());
        }
        return clonedValues;
    }

    public boolean contains(V value) {
        return this.getValues().contains(value);
    }

    public boolean containsRealValue(V value) {
        for (PrismValue myValue : this.getValues()) {
            if (!myValue.equalsRealValue((PrismValue)value)) continue;
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<V> newValues) throws SchemaException {
        boolean changed = false;
        for (PrismValue val : newValues) {
            if (!this.add(val)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean add(V newValue) throws SchemaException {
        ((PrismValue)newValue).setParent(this);
        return this.values.add(newValue);
    }

    public boolean removeAll(Collection<V> newValues) {
        boolean changed = false;
        for (PrismValue val : newValues) {
            if (!this.remove(val)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean remove(V newValue) {
        boolean changed = false;
        Iterator<V> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            PrismValue val = (PrismValue)iterator.next();
            if (!val.equalsRealValue((PrismValue)newValue)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public V remove(int index) {
        return (V)((PrismValue)this.values.remove(index));
    }

    public void replaceAll(Collection<V> newValues) throws SchemaException {
        this.values.clear();
        this.addAll(newValues);
    }

    public void replace(V newValue) {
        this.values.clear();
        this.values.add(newValue);
    }

    public void clear() {
        this.values.clear();
    }

    public List<Element> asDomElements() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (PrismValue pval : this.getValues()) {
            elements.add(pval.asDomElement());
        }
        return elements;
    }

    protected void diffInternal(Item<V> other, PropertyPath pathPrefix, Collection<? extends ItemDelta> deltas, boolean ignoreMetadata) {
        PropertyPath deltaPath = this.getPath(pathPrefix);
        ItemDelta delta = null;
        if (deltaPath != null && !deltaPath.isEmpty()) {
            delta = this.createDelta(deltaPath);
        }
        if (other == null) {
            for (PrismValue value : this.getValues()) {
                PrismValue valueClone = value.clone();
                delta.addValueToDelete(valueClone);
            }
        } else {
            ArrayList<V> outstandingOtheValues = new ArrayList<V>(other.getValues().size());
            outstandingOtheValues.addAll(other.getValues());
            for (PrismValue thisValue : this.getValues()) {
                Iterator iterator = outstandingOtheValues.iterator();
                boolean found = false;
                while (iterator.hasNext()) {
                    PrismValue otherValue = (PrismValue)iterator.next();
                    if (thisValue.representsSameValue(otherValue) || delta == null) {
                        found = true;
                        thisValue.diffMatchingRepresentation(otherValue, thisValue.getPath(pathPrefix), deltas, ignoreMetadata);
                        iterator.remove();
                        break;
                    }
                    if (!thisValue.equals(otherValue, ignoreMetadata)) continue;
                    found = true;
                    iterator.remove();
                    break;
                }
                if (found) continue;
                delta.addValueToDelete(thisValue.clone());
            }
            for (PrismValue outstandingOtherValue : outstandingOtheValues) {
                delta.addValueToAdd(outstandingOtherValue.clone());
            }
            delta = this.fixupDelta(delta, other, pathPrefix, ignoreMetadata);
        }
        if (delta != null && !delta.isEmpty()) {
            deltas.add(delta);
        }
    }

    protected ItemDelta fixupDelta(ItemDelta delta, Item<V> other, PropertyPath pathPrefix, boolean ignoreMetadata) {
        return delta;
    }

    public abstract ItemDelta<V> createDelta(PropertyPath var1);

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        for (PrismValue value : this.getValues()) {
            value.accept(visitor);
        }
    }

    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        this.applyDefinition(definition, true);
    }

    public void applyDefinition(ItemDefinition definition, boolean force) throws SchemaException {
        if (definition != null) {
            this.checkDefinition(definition);
        }
        if (this.prismContext == null) {
            this.prismContext = definition.getPrismContext();
        }
        this.definition = definition;
        for (PrismValue pval : this.getValues()) {
            pval.applyDefinition(definition, force);
        }
    }

    public void revive(PrismContext prismContext) {
        if (this.prismContext != null) {
            return;
        }
        this.prismContext = prismContext;
        if (this.definition != null) {
            this.definition.revive(prismContext);
        }
    }

    public abstract Item clone();

    protected void copyValues(Item clone) {
        clone.name = this.name;
        clone.definition = this.definition;
        clone.prismContext = this.prismContext;
    }

    public static <T extends Item> T createNewDefinitionlessItem(QName name, Class<T> type) {
        Item item = null;
        try {
            Constructor<T> constructor = type.getConstructor(QName.class);
            item = (Item)constructor.newInstance(name);
        }
        catch (Exception e) {
            throw new SystemException("Error creating new definitionless " + type.getSimpleName() + ": " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
        }
        return (T)item;
    }

    public void checkConsistence() {
        this.checkConsistenceInternal(this, PropertyPath.EMPTY_PATH);
    }

    public void checkConsistenceInternal(Itemable rootItem, PropertyPath path) {
        if (this.name == null) {
            throw new IllegalStateException("Item " + this + " has no name (" + path + " in " + rootItem + ")");
        }
        if (this.definition != null) {
            this.checkDefinition(this.definition);
        }
        if (this.values != null) {
            for (PrismValue val : this.values) {
                if (val == null) {
                    throw new IllegalStateException("Null value in item " + this + " (" + path + " in " + rootItem + ")");
                }
                if (val.getParent() == null) {
                    throw new IllegalStateException("Null parent for value " + val + " in item " + this + " (" + path + " in " + rootItem + ")");
                }
                if (val.getParent() != this) {
                    throw new IllegalStateException("Wrong parent for value " + val + " in item " + this + " (" + path + " in " + rootItem + "), " + "bad parent: " + val.getParent());
                }
                val.checkConsistenceInternal(rootItem, path);
            }
        }
    }

    protected abstract void checkDefinition(ItemDefinition var1);

    public void assertDefinitions() throws SchemaException {
        this.assertDefinitions("");
    }

    public void assertDefinitions(String sourceDescription) throws SchemaException {
        this.assertDefinitions(false, sourceDescription);
    }

    public void assertDefinitions(boolean tolarateRawValues, String sourceDescription) throws SchemaException {
        if (tolarateRawValues && this.isRaw()) {
            return;
        }
        if (this.definition == null) {
            throw new SchemaException("No definition in " + this + " in " + sourceDescription);
        }
    }

    public boolean isRaw() {
        for (PrismValue val : this.getValues()) {
            if (val.isRaw()) continue;
            return false;
        }
        return true;
    }

    public boolean hasRaw() {
        for (PrismValue val : this.getValues()) {
            if (!val.isRaw()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.getValues() == null || this.getValues().isEmpty();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.values == null ? 0 : MiscUtil.unorderedCollectionHashcode(this.values));
        return result;
    }

    public boolean equalsRealValue(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.equalsRealValues(this.values, other.values));
    }

    private boolean equalsRealValues(List<V> thisValue, List<?> otherValues) {
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof PrismValue && o2 instanceof PrismValue) {
                    PrismValue v1 = (PrismValue)o1;
                    PrismValue v2 = (PrismValue)o2;
                    return v1.equalsRealValue(v2) ? 0 : 1;
                }
                return -1;
            }
        };
        return MiscUtil.unorderedCollectionEquals(thisValue, otherValues, (Comparator)comparator);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !MiscUtil.unorderedCollectionEquals(this.values, (Collection)other.values));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getName() + ")";
    }

    public String dump() {
        return this.toString();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.getDebugDumpClassName()).append(": ").append(DebugUtil.prettyPrint((QName)this.getName()));
        return sb.toString();
    }

    protected String getDebugDumpClassName() {
        return "Item";
    }
}

