/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.core;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jaxrx.core.JaxRxException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SchemaChecker {
    private final String xslSchema;

    public SchemaChecker(String schema) {
        this.xslSchema = "/" + schema + ".xsd";
    }

    public Document check(InputStream input) {
        Document document;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = docBuilder.parse(input);
            InputStream is = this.getClass().getResourceAsStream(this.xslSchema);
            SAXSource source = new SAXSource(new InputSource(is));
            this.checkIsValid(document, source);
        }
        catch (SAXException exce) {
            throw new JaxRxException(400, exce.getMessage());
        }
        catch (ParserConfigurationException exce) {
            throw new JaxRxException(exce);
        }
        catch (IOException exce) {
            throw new JaxRxException(exce);
        }
        return document;
    }

    private void checkIsValid(Document document, Source source) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(source);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }
}

