/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.valueconstruction;

import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;

public class ObjectDeltaObject<T extends ObjectType>
implements Dumpable,
DebugDumpable {
    private PrismObject<T> oldObject;
    private ObjectDelta<T> delta;
    private PrismObject<T> newObject;

    public ObjectDeltaObject(PrismObject<T> oldObject, ObjectDelta<T> delta, PrismObject<T> newObject) {
        this.oldObject = oldObject;
        this.delta = delta;
        this.newObject = newObject;
    }

    public PrismObject<T> getOldObject() {
        return this.oldObject;
    }

    public ObjectDelta<T> getDelta() {
        return this.delta;
    }

    public PrismObject<T> getNewObject() {
        return this.newObject;
    }

    public static <T extends ObjectType> ObjectDeltaObject<T> create(PrismObject<T> oldObject, ObjectDelta<T> delta) throws SchemaException {
        PrismObject newObject = oldObject.clone();
        delta.applyTo(newObject);
        return new ObjectDeltaObject<T>(oldObject, delta, newObject);
    }

    public static <T extends ObjectType> ObjectDeltaObject<T> create(PrismObject<T> oldObject, ItemDelta<?> ... itemDeltas) throws SchemaException {
        ObjectDelta objectDelta = oldObject.createDelta(ChangeType.MODIFY);
        objectDelta.addModifications(itemDeltas);
        return ObjectDeltaObject.create(oldObject, objectDelta);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.delta == null ? 0 : this.delta.hashCode());
        result = 31 * result + (this.newObject == null ? 0 : this.newObject.hashCode());
        result = 31 * result + (this.oldObject == null ? 0 : this.oldObject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectDeltaObject other = (ObjectDeltaObject)obj;
        if (this.delta == null ? other.delta != null : !this.delta.equals(other.delta)) {
            return false;
        }
        if (this.newObject == null ? other.newObject != null : !this.newObject.equals(other.newObject)) {
            return false;
        }
        return !(this.oldObject == null ? other.oldObject != null : !this.oldObject.equals(other.oldObject));
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        DebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append("ObjectDeltaObject():");
        this.dumpObject(sb, this.oldObject, "old", indent + 1);
        if (this.delta != null) {
            sb.append("\n");
            DebugUtil.indentDebugDump((StringBuilder)sb, (int)(indent + 1));
            sb.append("delta:");
            if (this.delta == null) {
                sb.append(" null");
            } else {
                sb.append("\n");
                sb.append(this.delta.debugDump(indent + 2));
            }
        }
        this.dumpObject(sb, this.newObject, "new", indent + 1);
        return sb.toString();
    }

    private void dumpObject(StringBuilder sb, PrismObject<T> object, String label, int indent) {
        sb.append("\n");
        DebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append(label).append(":");
        if (object == null) {
            sb.append(" null");
        } else {
            sb.append("\n");
            sb.append(object.debugDump(indent + 1));
        }
    }

    public String dump() {
        return this.debugDump();
    }

    public String toString() {
        return "ObjectDeltaObject(" + this.oldObject + " + " + this.delta + " = " + this.newObject + ")";
    }
}

