/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.valueconstruction;

import com.evolveum.midpoint.common.valueconstruction.ValueConstructor;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LiteralValueConstructor
implements ValueConstructor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <V extends PrismValue> PrismValueDeltaSetTriple<V> construct(JAXBElement<?> constructorElement, ItemDefinition outputDefinition, Item<V> input, ItemDelta<V> inputDelta, Map<QName, Object> variables, boolean conditionResultOld, boolean conditionResultNew, String contextDescription, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        if (!constructorElement.getName().equals(SchemaConstants.C_VALUE)) {
            throw new IllegalArgumentException("Literal value constructor cannot handle elements " + constructorElement.getName());
        }
        Object constructorTypeObject = constructorElement.getValue();
        if (!(constructorTypeObject instanceof Element)) {
            throw new IllegalArgumentException("Literal value constructor can only handle DOM elements, but got " + constructorTypeObject.getClass().getName());
        }
        PrismContext prismContext = outputDefinition.getPrismContext();
        if (prismContext == null) {
            throw new IllegalStateException("No prism context in " + outputDefinition);
        }
        Element valueElement = (Element)constructorTypeObject;
        Item output = null;
        List valueSubelements = DOMUtil.listChildElements((Node)valueElement);
        if (valueSubelements == null || valueSubelements.isEmpty()) {
            if (StringUtils.isBlank((String)valueElement.getTextContent())) {
                output = outputDefinition.instantiate();
                return ItemDelta.toDeltaSetTriple((Item)output, null, (boolean)conditionResultOld, (boolean)conditionResultNew);
            } else {
                if (!(outputDefinition instanceof PrismPropertyDefinition)) throw new ExpressionEvaluationException("Tense expression forms can only be used to evalueate properties, not " + output.getClass().getSimpleName() + ", try to enclose the value with proper elements");
                output = (Item)prismContext.getPrismDomProcessor().parsePropertyFromValueElement(valueElement, (PrismPropertyDefinition)outputDefinition);
            }
            return ItemDelta.toDeltaSetTriple((Item)output, null, (boolean)conditionResultOld, (boolean)conditionResultNew);
        } else {
            output = prismContext.getPrismDomProcessor().parseItem(valueSubelements, outputDefinition.getName(), outputDefinition);
        }
        return ItemDelta.toDeltaSetTriple((Item)output, null, (boolean)conditionResultOld, (boolean)conditionResultNew);
    }
}

