/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.valueconstruction;

import com.evolveum.midpoint.common.expression.Expression;
import com.evolveum.midpoint.common.expression.ExpressionFactory;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructor;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.delta.DeltaSetTriple;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.prism.xml.XsdTypeMapper;
import com.evolveum.midpoint.schema.constants.ExpressionConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExpressionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public class ExpressionValueConstructor
implements ValueConstructor {
    private ExpressionFactory factory;

    ExpressionValueConstructor(ExpressionFactory factory) {
        this.factory = factory;
    }

    @Override
    public <V extends PrismValue> PrismValueDeltaSetTriple<V> construct(JAXBElement<?> constructorElement, ItemDefinition outputDefinition, Item<V> input, ItemDelta<V> inputDelta, Map<QName, Object> variables, boolean conditionResultOld, boolean conditionResultNew, String contextDescription, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        Object constructorTypeObject = constructorElement.getValue();
        if (!(constructorTypeObject instanceof ExpressionType)) {
            throw new IllegalArgumentException("Expression value constructor cannot handle elements of type " + constructorTypeObject.getClass().getName());
        }
        ExpressionType constructorType = (ExpressionType)constructorTypeObject;
        PrismValueDeltaSetTriple inputTriple = ItemDelta.toDeltaSetTriple(input, inputDelta, (boolean)conditionResultOld, (boolean)conditionResultNew);
        PrismValueDeltaSetTriple outputTriple = new PrismValueDeltaSetTriple();
        Collection inputZeroValues = null;
        if (inputTriple != null) {
            Collection<V> outputValues;
            Collection inputValues;
            if (inputTriple.hasPlusSet()) {
                inputValues = inputTriple.getPlusSet();
                outputValues = this.evaluateExpression(constructorType, outputDefinition, inputValues, variables, false, contextDescription, result);
                outputTriple.addAllToPlusSet(outputValues);
            }
            if (inputTriple.hasMinusSet()) {
                inputValues = inputTriple.getMinusSet();
                outputValues = this.evaluateExpression(constructorType, outputDefinition, inputValues, variables, true, contextDescription, result);
                outputTriple.addAllToMinusSet(outputValues);
            }
            if (inputTriple.hasZeroSet()) {
                inputZeroValues = inputTriple.getZeroSet();
            }
        }
        Collection<V> outputZeroValuesOld = null;
        if (conditionResultOld) {
            outputZeroValuesOld = this.evaluateExpressionAtLeastOnce(constructorType, outputDefinition, inputZeroValues, variables, true, contextDescription, result);
        }
        Collection<V> outputZeroValuesNew = null;
        if (conditionResultNew) {
            outputZeroValuesNew = this.evaluateExpressionAtLeastOnce(constructorType, outputDefinition, inputZeroValues, variables, false, contextDescription, result);
        }
        PrismValueDeltaSetTriple outputZeroDeltaTriple = PrismValueDeltaSetTriple.diff(outputZeroValuesOld, outputZeroValuesNew);
        outputTriple.merge((DeltaSetTriple)outputZeroDeltaTriple);
        return outputTriple;
    }

    private <V extends PrismValue> Collection<V> evaluateExpression(ExpressionType constructorType, ItemDefinition outputDefinition, Collection<V> inputValues, Map<QName, Object> variables, boolean oldVars, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        ArrayList<PrismValue> outputValues = new ArrayList<PrismValue>();
        if (inputValues == null) {
            return outputValues;
        }
        for (PrismValue inputValue : inputValues) {
            Collection<PrismValue> expressionOutputs = this.evaluateExpressionForValue(constructorType, outputDefinition, inputValue, variables, oldVars, contextDescription, result);
            outputValues.addAll(expressionOutputs);
        }
        return outputValues;
    }

    private <V extends PrismValue> Collection<V> evaluateExpressionAtLeastOnce(ExpressionType constructorType, ItemDefinition outputDefinition, Collection<V> inputValues, Map<QName, Object> variables, boolean oldVars, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        ArrayList<PrismValue> outputValues = new ArrayList<PrismValue>();
        if (inputValues == null) {
            return this.evaluateExpressionForValue(constructorType, outputDefinition, null, variables, oldVars, contextDescription, result);
        }
        for (PrismValue inputValue : inputValues) {
            Collection<PrismValue> expressionOutputs = this.evaluateExpressionForValue(constructorType, outputDefinition, inputValue, variables, oldVars, contextDescription, result);
            outputValues.addAll(expressionOutputs);
        }
        return outputValues;
    }

    private <V extends PrismValue> Collection<V> evaluateExpressionForValue(ExpressionType constructorType, ItemDefinition outputDefinition, V inputValue, Map<QName, Object> variables, boolean oldVars, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Expression expression = this.factory.createExpression(constructorType, contextDescription);
        if (oldVars) {
            expression.addVariableDefinitionsOld(variables);
        } else {
            expression.addVariableDefinitionsNew(variables);
        }
        if (!expression.hasVariableDefinition(ExpressionConstants.VAR_INPUT)) {
            expression.addVariableDefinition(ExpressionConstants.VAR_INPUT, inputValue);
        }
        QName typeName = outputDefinition.getTypeName();
        Class type = XsdTypeMapper.toJavaType((QName)typeName);
        Item output = outputDefinition.instantiate();
        if (!(output instanceof PrismProperty)) {
            throw new UnsupportedOperationException("Expression can only result in a property, not " + output.getClass());
        }
        ArrayList outputValues = new ArrayList();
        if (outputDefinition.isMultiValue()) {
            List resultValues = expression.evaluateList(type, result);
            outputValues.addAll(resultValues);
        } else {
            PrismPropertyValue resultValue = expression.evaluateScalar(type, result);
            if (resultValue != null) {
                outputValues.add(resultValue);
            }
        }
        return outputValues;
    }
}

