/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.refinery;

public class ResourceAccountType {
    private String resourceOid;
    private String accountType;

    public ResourceAccountType(String resourceOid, String accountType) {
        this.resourceOid = resourceOid;
        this.setAccountType(accountType);
    }

    public String getResourceOid() {
        return this.resourceOid;
    }

    public void setResourceOid(String resourceOid) {
        this.resourceOid = resourceOid;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType == null ? "user" : accountType;
    }

    public String toString() {
        return "RAT(" + this.resourceOid + ": " + this.accountType + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.accountType == null ? 0 : this.accountType.hashCode());
        result = 31 * result + (this.resourceOid == null ? 0 : this.resourceOid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceAccountType other = (ResourceAccountType)obj;
        if (this.accountType == null ? other.accountType != null : !this.accountType.equals(other.accountType)) {
            return false;
        }
        return !(this.resourceOid == null ? other.resourceOid != null : !this.resourceOid.equals(other.resourceOid));
    }

    public boolean equivalent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceAccountType other = (ResourceAccountType)obj;
        if (this.accountType == null ? other.accountType != null : !ResourceAccountType.equalsAccountType(this.accountType, other.accountType)) {
            return false;
        }
        return !(this.resourceOid == null ? other.resourceOid != null : !this.resourceOid.equals(other.resourceOid));
    }

    public static boolean equalsAccountType(String a, String b) {
        if (ResourceAccountType.isDefaultAccountType(a) && ResourceAccountType.isDefaultAccountType(b)) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean isDefaultAccountType(String accountType) {
        if (accountType == null) {
            return true;
        }
        return "user".equals(accountType);
    }
}

