/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.refinery;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccessType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAttributeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueAssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import java.util.List;
import javax.xml.namespace.QName;

public class RefinedAttributeDefinition
extends ResourceAttributeDefinition
implements Dumpable,
DebugDumpable {
    private String displayName;
    private String description;
    private boolean tolerant = true;
    private boolean create = true;
    private boolean read = true;
    private boolean update = true;
    private ResourceAttributeDefinition attributeDefinition;
    private ValueConstructionType outboundValueConstructionType;
    private List<ValueAssignmentType> inboundAssignmentTypes;

    private RefinedAttributeDefinition(ResourceAttributeDefinition attrDef, PrismContext prismContext) {
        super(attrDef.getName(), attrDef.getDefaultName(), attrDef.getTypeName(), prismContext);
        this.attributeDefinition = attrDef;
    }

    public void setNativeAttributeName(String nativeAttributeName) {
        throw new UnsupportedOperationException("Parts of refined attribute are immutable");
    }

    public boolean isTolerant() {
        return this.tolerant;
    }

    public void setTolerant(boolean tolerant) {
        this.tolerant = tolerant;
    }

    public boolean canRead() {
        return this.read;
    }

    public boolean canUpdate() {
        return this.update;
    }

    public void setReadOnly() {
        throw new UnsupportedOperationException("Parts of refined attribute are immutable");
    }

    public QName getValueType() {
        return this.attributeDefinition.getValueType();
    }

    public void setMinOccurs(int minOccurs) {
        this.attributeDefinition.setMinOccurs(minOccurs);
    }

    public void setMaxOccurs(int maxOccurs) {
        this.attributeDefinition.setMaxOccurs(maxOccurs);
    }

    public void setRead(boolean read) {
        throw new UnsupportedOperationException("Parts of refined attribute are immutable");
    }

    public void setUpdate(boolean update) {
        throw new UnsupportedOperationException("Parts of refined attribute are immutable");
    }

    public void setCreate(boolean create) {
        throw new UnsupportedOperationException("Parts of refined attribute are immutable");
    }

    public boolean canCreate() {
        return this.create;
    }

    public QName getDefaultName() {
        return this.attributeDefinition.getDefaultName();
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        throw new UnsupportedOperationException("Parts of refined attribute are immutable");
    }

    public void setHelp(String help) {
        throw new UnsupportedOperationException("Parts of refined attribute are immutable");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceAttributeDefinition getAttributeDefinition() {
        return this.attributeDefinition;
    }

    public void setAttributeDefinition(ResourceAttributeDefinition attributeDefinition) {
        this.attributeDefinition = attributeDefinition;
    }

    public ValueConstructionType getOutboundValueConstructionType() {
        return this.outboundValueConstructionType;
    }

    public void setOutboundValueConstructionType(ValueConstructionType outboundValueConstructionType) {
        this.outboundValueConstructionType = outboundValueConstructionType;
    }

    public boolean hasOutboundExpression() {
        return this.outboundValueConstructionType != null;
    }

    public List<ValueAssignmentType> getInboundAssignmentTypes() {
        return this.inboundAssignmentTypes;
    }

    public void setInboundAssignmentTypes(List<ValueAssignmentType> inboundAssignmentTypes) {
        this.inboundAssignmentTypes = inboundAssignmentTypes;
    }

    public QName getName() {
        return this.attributeDefinition.getName();
    }

    public QName getTypeName() {
        return this.attributeDefinition.getTypeName();
    }

    public String getNativeAttributeName() {
        return this.attributeDefinition.getNativeAttributeName();
    }

    public Object[] getAllowedValues() {
        return this.attributeDefinition.getAllowedValues();
    }

    public int getMaxOccurs() {
        return this.attributeDefinition.getMaxOccurs();
    }

    public int getMinOccurs() {
        return this.attributeDefinition.getMinOccurs();
    }

    public boolean isMandatory() {
        return this.attributeDefinition.isMandatory();
    }

    public boolean isMultiValue() {
        return this.attributeDefinition.isMultiValue();
    }

    public boolean isOptional() {
        return this.attributeDefinition.isOptional();
    }

    public boolean isSingleValue() {
        return this.attributeDefinition.isSingleValue();
    }

    public String getHelp() {
        return this.attributeDefinition.getHelp();
    }

    static RefinedAttributeDefinition parse(ResourceAttributeDefinition attrDef, ResourceAttributeDefinitionType attrDefType, ObjectClassComplexTypeDefinition objectClassDef, PrismContext prismContext, String contextDescription) throws SchemaException {
        RefinedAttributeDefinition rAttrDef = new RefinedAttributeDefinition(attrDef, prismContext);
        if (attrDefType != null && attrDefType.getDisplayName() != null) {
            rAttrDef.setDisplayName(attrDefType.getDisplayName());
        } else if (attrDef.getDisplayName() != null) {
            rAttrDef.setDisplayName(attrDef.getDisplayName());
        }
        if (attrDefType != null && attrDefType.getDescription() != null) {
            rAttrDef.setDescription(attrDefType.getDescription());
        }
        if (attrDefType != null) {
            rAttrDef.tolerant = attrDefType.isTolerant() == null ? true : attrDefType.isTolerant();
            if (attrDefType.getOutbound() != null) {
                rAttrDef.setOutboundValueConstructionType(attrDefType.getOutbound());
            }
            if (attrDefType.getInbound() != null) {
                rAttrDef.setInboundAssignmentTypes(attrDefType.getInbound());
            }
        }
        rAttrDef.ignored = attrDef.isIgnored();
        rAttrDef.create = RefinedAttributeDefinition.parseAccess(attrDefType, AccessType.CREATE, attrDef.canCreate());
        rAttrDef.update = RefinedAttributeDefinition.parseAccess(attrDefType, AccessType.UPDATE, attrDef.canUpdate());
        rAttrDef.read = RefinedAttributeDefinition.parseAccess(attrDefType, AccessType.READ, attrDef.canRead());
        return rAttrDef;
    }

    private static boolean parseAccess(ResourceAttributeDefinitionType attrDefType, AccessType access, boolean defaultValue) {
        if (attrDefType == null) {
            return defaultValue;
        }
        List accessList = attrDefType.getAccess();
        if (accessList == null || accessList.isEmpty()) {
            return defaultValue;
        }
        for (AccessType acccessEntry : accessList) {
            if (acccessEntry != access) continue;
            return true;
        }
        return false;
    }

    public static boolean isIgnored(ResourceAttributeDefinitionType attrDefType) {
        if (attrDefType.isIgnore() == null) {
            return false;
        }
        return attrDefType.isIgnore();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.getDisplayName() != null) {
            sb.append(",Disp");
        }
        if (this.getDescription() != null) {
            sb.append(",Desc");
        }
        if (this.getOutboundValueConstructionType() != null) {
            sb.append(",OUT");
        }
        return sb.toString();
    }

    protected String getDebugDumpClassName() {
        return "RRAD";
    }
}

