/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.refinery;

import com.evolveum.midpoint.common.ResourceObjectPattern;
import com.evolveum.midpoint.common.refinery.RefinedAttributeDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainer;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAccountTypeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceActivationDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceActivationEnableDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAttributeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceCredentialsDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectPatternType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourcePasswordDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueAssignmentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

public class RefinedAccountDefinition
extends ResourceAttributeContainerDefinition
implements Dumpable,
DebugDumpable {
    private String accountType;
    private String displayName;
    private String description;
    private boolean isDefault;
    private ObjectClassComplexTypeDefinition objectClassDefinition;
    private ResourceType resourceType;
    private Collection<ResourceAttributeDefinition> identifiers;
    private Collection<ResourceAttributeDefinition> secondaryIdentifiers;
    private Collection<ResourceObjectPattern> protectedAccounts;
    PrismObjectDefinition<AccountShadowType> objectDefinition = null;
    private Collection<RefinedAttributeDefinition> attributeDefinitions = new HashSet<RefinedAttributeDefinition>();

    private RefinedAccountDefinition(PrismContext prismContext, ResourceType resourceType) {
        super(SchemaConstants.I_ATTRIBUTES, null, prismContext);
        this.resourceType = resourceType;
    }

    private RefinedAccountDefinition(PrismContext prismContext, ResourceType resourceType, ObjectClassComplexTypeDefinition objectClassDefinition) {
        super(SchemaConstants.I_ATTRIBUTES, null, prismContext);
        this.resourceType = resourceType;
        this.objectClassDefinition = objectClassDefinition;
    }

    public ResourceAttributeDefinition getDescriptionAttribute() {
        return this.objectClassDefinition.getDescriptionAttribute();
    }

    public void setDescriptionAttribute(ResourceAttributeDefinition descriptionAttribute) {
        throw new UnsupportedOperationException("Parts of refined account are immutable");
    }

    public ResourceAttributeDefinition getNamingAttribute() {
        return this.objectClassDefinition.getNamingAttribute();
    }

    public String getNativeObjectClass() {
        return this.objectClassDefinition.getNativeObjectClass();
    }

    public void setAccountType(boolean accountType) {
        throw new UnsupportedOperationException("Parts of refined account are immutable");
    }

    public boolean isDefaultAccountType() {
        return this.isDefault;
    }

    public void setDefaultAccountType(boolean defaultAccountType) {
        this.isDefault = defaultAccountType;
    }

    public String getAccountTypeName() {
        return this.accountType;
    }

    public void setAccountTypeName(String accountTypeName) {
        this.accountType = accountTypeName;
    }

    public ResourceAttributeDefinition getDisplayNameAttribute() {
        return this.objectClassDefinition.getDisplayNameAttribute();
    }

    public void setDisplayNameAttribute(QName displayName) {
        throw new UnsupportedOperationException("Parts of refined account are immutable");
    }

    public Collection<ResourceAttributeDefinition> getIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = this.createIdentifiersCollection();
        }
        return this.identifiers;
    }

    public Collection<ResourceAttributeDefinition> getSecondaryIdentifiers() {
        if (this.secondaryIdentifiers == null) {
            this.secondaryIdentifiers = this.createIdentifiersCollection();
        }
        return this.secondaryIdentifiers;
    }

    private Collection<ResourceAttributeDefinition> createIdentifiersCollection() {
        return new ArrayList<ResourceAttributeDefinition>();
    }

    public Collection<ResourceObjectPattern> getProtectedAccounts() {
        if (this.protectedAccounts == null) {
            this.protectedAccounts = new ArrayList<ResourceObjectPattern>();
        }
        return this.protectedAccounts;
    }

    public PrismContext getPrismContext() {
        return this.resourceType.asPrismObject().getPrismContext();
    }

    public ObjectClassComplexTypeDefinition getComplexTypeDefinition() {
        return this.objectClassDefinition;
    }

    public ResourceAttributeContainer instantiate() {
        return new ResourceAttributeContainer(this.getNameOrDefaultName(), (ResourceAttributeContainerDefinition)this, this.getPrismContext());
    }

    public ResourceAttributeContainer instantiate(QName name) {
        return new ResourceAttributeContainer(name, (ResourceAttributeContainerDefinition)this, this.getPrismContext());
    }

    public RefinedAccountDefinition clone() {
        RefinedAccountDefinition clone = new RefinedAccountDefinition(this.getPrismContext(), this.resourceType, this.objectClassDefinition);
        this.copyDefinitionData(clone);
        return clone;
    }

    protected void copyDefinitionData(RefinedAccountDefinition clone) {
        super.copyDefinitionData((ResourceAttributeContainerDefinition)clone);
        clone.accountType = this.accountType;
        clone.attributeDefinitions = this.attributeDefinitions;
        clone.description = this.description;
        clone.displayName = this.displayName;
        clone.isDefault = this.isDefault;
        clone.objectClassDefinition = this.objectClassDefinition;
        clone.objectDefinition = this.objectDefinition;
        clone.resourceType = this.resourceType;
    }

    public RefinedAttributeDefinition findAttributeDefinition(QName elementQName) {
        return (RefinedAttributeDefinition)this.findItemDefinition(elementQName, RefinedAttributeDefinition.class);
    }

    public RefinedAttributeDefinition findAttributeDefinition(String elementLocalname) {
        QName elementQName = new QName(this.getNamespace(), elementLocalname);
        return this.findAttributeDefinition(elementQName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isRuntimeSchema() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNamespace() {
        return ResourceTypeUtil.getResourceNamespace((ResourceType)this.resourceType);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ObjectClassComplexTypeDefinition getObjectClassDefinition() {
        return this.objectClassDefinition;
    }

    public void setObjectClassDefinition(ObjectClassComplexTypeDefinition objectClassDefinition) {
        this.objectClassDefinition = objectClassDefinition;
    }

    public boolean isAccountType() {
        return true;
    }

    public Collection<RefinedAttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public Set<PrismPropertyDefinition> getPropertyDefinitions() {
        return (Set)this.attributeDefinitions;
    }

    public Collection<ItemDefinition> getDefinitions() {
        return this.attributeDefinitions;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public PrismObjectDefinition<AccountShadowType> getObjectDefinition() {
        if (this.objectDefinition == null) {
            this.constructObjectDefinition();
        }
        return this.objectDefinition;
    }

    private void constructObjectDefinition() {
        PrismObjectDefinition refinedObjectDef;
        PrismObjectDefinition originalObjectDefinition = this.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(AccountShadowType.class);
        this.objectDefinition = refinedObjectDef = originalObjectDefinition.cloneWithReplacedDefinition(AccountShadowType.F_ATTRIBUTES, (ItemDefinition)this);
    }

    public RefinedAttributeDefinition getAttributeDefinition(QName attributeName) {
        for (RefinedAttributeDefinition attrDef : this.attributeDefinitions) {
            if (!attrDef.getName().equals(attributeName)) continue;
            return attrDef;
        }
        return null;
    }

    public void add(RefinedAttributeDefinition refinedAttributeDefinition) {
        this.attributeDefinitions.add(refinedAttributeDefinition);
    }

    public boolean containsAttributeDefinition(QName attributeName) {
        for (RefinedAttributeDefinition rAttributeDef : this.attributeDefinitions) {
            if (!rAttributeDef.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    static RefinedAccountDefinition parse(ResourceAccountTypeDefinitionType accountTypeDefType, ResourceType resourceType, RefinedResourceSchema rSchema, PrismContext prismContext, String contextDescription) throws SchemaException {
        RefinedAccountDefinition rAccountDef = new RefinedAccountDefinition(prismContext, resourceType);
        if (accountTypeDefType.getName() == null) {
            throw new SchemaException("Account type definition does not have a name, in " + contextDescription);
        }
        rAccountDef.setAccountTypeName(accountTypeDefType.getName());
        ObjectClassComplexTypeDefinition objectClassDef = null;
        if (accountTypeDefType.getObjectClass() != null) {
            QName objectClass = accountTypeDefType.getObjectClass();
            objectClassDef = rSchema.getOriginalResourceSchema().findObjectClassDefinition(objectClass);
            if (objectClassDef == null) {
                throw new SchemaException("Object class " + objectClass + " as specified in account type " + accountTypeDefType.getName() + " was not found in the resource schema of " + contextDescription);
            }
        } else {
            throw new SchemaException("Definition of account type " + accountTypeDefType.getName() + " does not have objectclass, in " + contextDescription);
        }
        rAccountDef.setObjectClassDefinition(objectClassDef);
        if (accountTypeDefType.getDisplayName() != null) {
            rAccountDef.setDisplayName(accountTypeDefType.getDisplayName());
        } else if (objectClassDef.getDisplayName() != null) {
            rAccountDef.setDisplayName(objectClassDef.getDisplayName());
        }
        if (accountTypeDefType.getDescription() != null) {
            rAccountDef.setDescription(accountTypeDefType.getDescription());
        }
        if (accountTypeDefType.isDefault() != null) {
            rAccountDef.setDefault(accountTypeDefType.isDefault());
        } else {
            rAccountDef.setDefault(objectClassDef.isDefaultAccountType());
        }
        for (ResourceAttributeDefinition road : objectClassDef.getAttributeDefinitions()) {
            String attrContextDescription = road.getName() + ", in " + contextDescription;
            ResourceAttributeDefinitionType attrDefType = RefinedAccountDefinition.findAttributeDefinitionType(road.getName(), accountTypeDefType, attrContextDescription);
            if (attrDefType != null && RefinedAttributeDefinition.isIgnored(attrDefType)) continue;
            RefinedAttributeDefinition rAttrDef = RefinedAttributeDefinition.parse(road, attrDefType, objectClassDef, prismContext, "in account type " + accountTypeDefType.getName() + ", in " + contextDescription);
            rAccountDef.processIdentifiers(rAttrDef, objectClassDef);
            if (rAccountDef.containsAttributeDefinition(rAttrDef.getName())) {
                throw new SchemaException("Duplicate definition of attribute " + rAttrDef.getName() + " in account type " + accountTypeDefType.getName() + ", in " + contextDescription);
            }
            rAccountDef.add(rAttrDef);
        }
        for (ResourceAttributeDefinitionType attrDefType : accountTypeDefType.getAttribute()) {
            if (rAccountDef.containsAttributeDefinition(attrDefType.getRef()) || RefinedAttributeDefinition.isIgnored(attrDefType)) continue;
            throw new SchemaException("Definition of attribute " + attrDefType.getRef() + " not found in object class " + objectClassDef.getTypeName() + " as defined in " + contextDescription);
        }
        RefinedAccountDefinition.parseProtectedAccounts(rAccountDef, accountTypeDefType);
        return rAccountDef;
    }

    private static void parseProtectedAccounts(RefinedAccountDefinition rAccountDef, ResourceAccountTypeDefinitionType accountTypeDefType) throws SchemaException {
        for (ResourceObjectPatternType protectedType : accountTypeDefType.getProtected()) {
            ResourceObjectPattern protectedPattern = RefinedAccountDefinition.convertToPatten(protectedType, rAccountDef);
            rAccountDef.getProtectedAccounts().add(protectedPattern);
        }
    }

    private static ResourceObjectPattern convertToPatten(ResourceObjectPatternType protectedType, RefinedAccountDefinition rAccountDef) throws SchemaException {
        ResourceObjectPattern resourceObjectPattern = new ResourceObjectPattern();
        Collection items = rAccountDef.getPrismContext().getPrismDomProcessor().parseContainerItems((PrismContainerDefinition)rAccountDef, protectedType.getAny());
        for (Item item : items) {
            if (item instanceof ResourceAttribute) {
                resourceObjectPattern.addIdentifier((ResourceAttribute)item);
                continue;
            }
            throw new SchemaException("Unexpected item in pattern for " + (Object)((Object)rAccountDef) + ": " + item);
        }
        return resourceObjectPattern;
    }

    static RefinedAccountDefinition parse(ObjectClassComplexTypeDefinition objectClassDef, ResourceType resourceType, RefinedResourceSchema rSchema, PrismContext prismContext, String contextDescription) throws SchemaException {
        RefinedAccountDefinition rAccountDef = new RefinedAccountDefinition(prismContext, resourceType, objectClassDef);
        String accountTypeName = null;
        if (objectClassDef.getAccountTypeName() != null) {
            accountTypeName = objectClassDef.getAccountTypeName();
            rAccountDef.setAccountTypeName(accountTypeName);
        } else if (objectClassDef.isDefaultAccountType()) {
            rAccountDef.setAccountTypeName("user");
        } else {
            throw new SchemaException("Account type definition does not have a name, in " + contextDescription);
        }
        if (objectClassDef.getDisplayName() != null) {
            rAccountDef.setDisplayName(objectClassDef.getDisplayName());
        }
        rAccountDef.setDefault(objectClassDef.isDefaultAccountType());
        for (ResourceAttributeDefinition attrDef : objectClassDef.getAttributeDefinitions()) {
            String attrContextDescription = String.valueOf(accountTypeName) + ", in " + contextDescription;
            RefinedAttributeDefinition rAttrDef = RefinedAttributeDefinition.parse(attrDef, null, objectClassDef, prismContext, attrContextDescription);
            rAccountDef.processIdentifiers(rAttrDef, objectClassDef);
            if (rAccountDef.containsAttributeDefinition(rAttrDef.getName())) {
                throw new SchemaException("Duplicate definition of attribute " + rAttrDef.getName() + " in " + attrContextDescription);
            }
            rAccountDef.add(rAttrDef);
        }
        return rAccountDef;
    }

    private void processIdentifiers(RefinedAttributeDefinition rAttrDef, ObjectClassComplexTypeDefinition objectClassDef) {
        QName attrName = rAttrDef.getName();
        if (objectClassDef.isIdentifier(attrName)) {
            this.getIdentifiers().add(rAttrDef);
        }
        if (objectClassDef.isSecondaryIdentifier(attrName)) {
            this.getSecondaryIdentifiers().add(rAttrDef);
        }
    }

    private static ResourceAttributeDefinitionType findAttributeDefinitionType(QName attrName, ResourceAccountTypeDefinitionType accountTypeDefType, String contextDescription) throws SchemaException {
        ResourceAttributeDefinitionType foundAttrDefType = null;
        for (ResourceAttributeDefinitionType attrDefType : accountTypeDefType.getAttribute()) {
            if (attrDefType.getRef() != null) {
                if (!attrDefType.getRef().equals(attrName)) continue;
                if (foundAttrDefType == null) {
                    foundAttrDefType = attrDefType;
                    continue;
                }
                throw new SchemaException("Duplicate definition of attribute " + attrDefType.getRef() + " in account type " + accountTypeDefType.getName() + ", in " + contextDescription);
            }
            throw new SchemaException("Missing reference to the attribute schema definition in definition " + SchemaDebugUtil.prettyPrint((Object)attrDefType) + " during processing of " + contextDescription);
        }
        return foundAttrDefType;
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append("RAccountDef(");
        sb.append(SchemaDebugUtil.prettyPrint((QName)this.getName()));
        if (this.isDefault()) {
            sb.append(",default");
        }
        sb.append(",");
        sb.append(SchemaDebugUtil.prettyPrint((QName)this.getObjectClassDefinition().getTypeName()));
        sb.append(")\n");
        Iterator<ItemDefinition> i2 = this.getDefinitions().iterator();
        while (i2.hasNext()) {
            ItemDefinition def = i2.next();
            sb.append(def.debugDump(indent + 1));
            if (!i2.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String dump() {
        return this.debugDump(0);
    }

    public PrismObject<AccountShadowType> createBlankShadow() {
        PrismObject accountShadow;
        try {
            accountShadow = this.prismContext.getSchemaRegistry().instantiate(AccountShadowType.class);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal error instantiating account shadow: " + e.getMessage(), (Throwable)e);
        }
        AccountShadowType accountShadowType = (AccountShadowType)accountShadow.asObjectable();
        accountShadowType.setAccountType(this.getAccountTypeName());
        accountShadowType.setObjectClass(this.objectClassDefinition.getTypeName());
        accountShadowType.setResourceRef(ObjectTypeUtil.createObjectRef((ObjectType)this.resourceType));
        PrismObjectDefinition newDefinition = accountShadow.getDefinition().cloneWithReplacedDefinition(AccountShadowType.F_ATTRIBUTES, (ItemDefinition)this);
        accountShadow.setDefinition((PrismContainerDefinition)newDefinition);
        return accountShadow;
    }

    public ResourceAccountType getResourceAccountType() {
        return new ResourceAccountType(this.resourceType.getOid(), this.getAccountTypeName());
    }

    public Collection<? extends QName> getNamesOfAttributesWithOutboundExpressions() {
        HashSet<QName> attrNames = new HashSet<QName>();
        for (RefinedAttributeDefinition attrDef : this.getAttributeDefinitions()) {
            if (attrDef.getOutboundValueConstructionType() == null) continue;
            attrNames.add(attrDef.getName());
        }
        return attrNames;
    }

    public Collection<? extends QName> getNamesOfAttributesWithInboundExpressions() {
        HashSet<QName> attrNames = new HashSet<QName>();
        for (RefinedAttributeDefinition attrDef : this.getAttributeDefinitions()) {
            List<ValueAssignmentType> inbounds = attrDef.getInboundAssignmentTypes();
            if (inbounds == null || inbounds.isEmpty()) continue;
            attrNames.add(attrDef.getName());
        }
        return attrNames;
    }

    private ResourceAccountTypeDefinitionType getAccountSchemaHandlingDefinition() {
        if (this.resourceType.getSchemaHandling() == null) {
            return null;
        }
        List types = this.resourceType.getSchemaHandling().getAccountType();
        ResourceAccountTypeDefinitionType definition = null;
        for (ResourceAccountTypeDefinitionType account : types) {
            if (this.accountType == null && account.isDefault().booleanValue()) {
                definition = account;
                break;
            }
            if (!this.accountType.equals(account.getName())) continue;
            definition = account;
            break;
        }
        return definition;
    }

    public ValueAssignmentType getCredentialsInbound() {
        ResourceAccountTypeDefinitionType definition = this.getAccountSchemaHandlingDefinition();
        if (definition == null) {
            return null;
        }
        ResourceCredentialsDefinitionType credentials = definition.getCredentials();
        if (credentials == null) {
            return null;
        }
        ResourcePasswordDefinitionType password = credentials.getPassword();
        if (password == null || password.getInbound() == null) {
            return null;
        }
        return password.getInbound();
    }

    public ValueAssignmentType getActivationInbound() {
        ResourceAccountTypeDefinitionType definition = this.getAccountSchemaHandlingDefinition();
        if (definition == null) {
            return null;
        }
        ResourceActivationDefinitionType activation = definition.getActivation();
        if (activation == null) {
            return null;
        }
        ResourceActivationEnableDefinitionType enabled = activation.getEnabled();
        if (enabled == null || enabled.getInbound() == null) {
            return null;
        }
        return enabled.getInbound();
    }
}

