/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.expression;

import com.evolveum.midpoint.common.expression.ExpressionEvaluator;
import com.evolveum.midpoint.common.expression.MidPointFunctions;
import com.evolveum.midpoint.common.valueconstruction.ObjectDeltaObject;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExpressionReturnTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExpressionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.VariableDefinitionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Expression {
    private Element code;
    private Map<QName, Object> variables;
    private String shortDesc;
    private ExpressionEvaluator evaluator;
    private ObjectResolver objectResolver;
    private ExpressionReturnTypeType returnType;
    private MidPointFunctions functionLibrary;
    private static final Trace LOGGER = TraceManager.getTrace(Expression.class);

    Expression(ExpressionEvaluator evaluator, ExpressionType expressionType, String shortDesc) {
        this.code = expressionType.getCode();
        this.shortDesc = shortDesc;
        this.evaluator = evaluator;
        this.variables = new HashMap<QName, Object>();
        if (expressionType.getVariable() != null) {
            for (VariableDefinitionType varDef : expressionType.getVariable()) {
                this.addVariableDefinition(varDef);
            }
        }
        this.returnType = null;
    }

    public ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public void setObjectResolver(ObjectResolver objectResolver) {
        this.objectResolver = objectResolver;
    }

    public ExpressionReturnTypeType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ExpressionReturnTypeType returnType) {
        this.returnType = returnType;
    }

    public MidPointFunctions getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(MidPointFunctions functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public void addVariableDefinition(VariableDefinitionType varDef) {
        if (varDef.getName() == null) {
            throw new IllegalArgumentException("Null variable name in " + this.shortDesc);
        }
        if (varDef.getObjectRef() != null) {
            this.addVariableDefinition(varDef.getName(), varDef.getObjectRef());
        } else if (varDef.getValue() != null) {
            this.addVariableDefinition(varDef.getName(), varDef.getValue());
        } else {
            LOGGER.warn("Empty definition of variable {} in expression {}, ignoring it", (Object)varDef.getName(), (Object)this.shortDesc);
        }
    }

    public void addVariableDefinition(QName name, ObjectReferenceType objectRef) {
        this.addVariableDefinition(name, (Object)objectRef);
    }

    public void addVariableDefinition(QName name, String value) {
        this.addVariableDefinition(name, (Object)value);
    }

    public void addVariableDefinition(QName name, PrismValue value) {
        this.addVariableDefinition(name, (Object)value);
    }

    public void addVariableDefinitions(Map<QName, Object> extraVariables) {
        for (Map.Entry<QName, Object> entry : extraVariables.entrySet()) {
            PrismObject value = entry.getValue();
            if (value instanceof ObjectDeltaObject) {
                ObjectDeltaObject odo = (ObjectDeltaObject)value;
                if (odo.getDelta() != null) {
                    throw new IllegalArgumentException("Cannot use variables with deltas in addVariableDefinitions, use addVariableDefinitionsOld or addVariableDefinitionsNew");
                }
                value = odo.getOldObject();
            }
            this.variables.put(entry.getKey(), value);
        }
    }

    public void addVariableDefinitionsOld(Map<QName, Object> extraVariables) {
        for (Map.Entry<QName, Object> entry : extraVariables.entrySet()) {
            PrismObject value = entry.getValue();
            if (value instanceof ObjectDeltaObject) {
                ObjectDeltaObject odo = (ObjectDeltaObject)value;
                value = odo.getOldObject();
            }
            this.variables.put(entry.getKey(), value);
        }
    }

    public void addVariableDefinitionsNew(Map<QName, Object> extraVariables) {
        for (Map.Entry<QName, Object> entry : extraVariables.entrySet()) {
            PrismObject value = entry.getValue();
            if (value instanceof ObjectDeltaObject) {
                ObjectDeltaObject odo = (ObjectDeltaObject)value;
                value = odo.getNewObject();
            }
            this.variables.put(entry.getKey(), value);
        }
    }

    public void setRootNode(ObjectReferenceType objectRef) {
        this.addVariableDefinition(null, (Object)objectRef);
    }

    private void addVariableDefinition(QName name, Object value) {
        if (this.variables.containsKey(name)) {
            LOGGER.warn("Duplicate definition of variable {} in expression {}, ignoring it", (Object)name, (Object)this.shortDesc);
            return;
        }
        this.variables.put(name, value);
    }

    public boolean hasVariableDefinition(QName name) {
        return this.variables.containsKey(name);
    }

    public <T> PrismPropertyValue<T> evaluateScalar(Class<T> type, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        if (this.code == null) {
            throw new ExpressionEvaluationException("No expression code in " + this.shortDesc);
        }
        if (this.returnType == ExpressionReturnTypeType.LIST) {
            List<PrismPropertyValue<T>> retList = this.evaluateList(type, result);
            if (retList.isEmpty()) {
                return null;
            }
            if (retList.size() > 1) {
                String msg = "Expression produced list of " + retList.size() + " entries, but it was requested to be evaluated in scalar context. Cannot reduce list to scalar.";
                ExpressionEvaluationException ex = new ExpressionEvaluationException(msg);
                LOGGER.error(msg, (Throwable)ex);
                throw ex;
            }
            return retList.get(0);
        }
        try {
            PrismPropertyValue<T> ret = this.evaluator.evaluateScalar(type, this.code, this.variables, this.objectResolver, this.functionLibrary, this.shortDesc, result);
            this.traceExpressionSuccess("scalar", type, ret);
            return ret;
        }
        catch (ExpressionEvaluationException ex) {
            this.traceExpressionFailure("scalar", type, (Exception)((Object)ex));
            throw ex;
        }
        catch (ObjectNotFoundException ex) {
            this.traceExpressionFailure("scalar", type, (Exception)((Object)ex));
            throw ex;
        }
        catch (SchemaException ex) {
            this.traceExpressionFailure("scalar", type, (Exception)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            this.traceExpressionFailure("scalar", type, ex);
            throw ex;
        }
    }

    public <T> List<PrismPropertyValue<T>> evaluateList(Class<T> type, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        if (this.code == null) {
            throw new ExpressionEvaluationException("No expression code in " + this.shortDesc);
        }
        if (this.returnType == ExpressionReturnTypeType.SCALAR) {
            PrismPropertyValue<T> ret = this.evaluateScalar(type, result);
            ArrayList<PrismPropertyValue<T>> retList = new ArrayList<PrismPropertyValue<T>>(1);
            if (ret != null) {
                retList.add(ret);
            }
            return retList;
        }
        try {
            List<PrismPropertyValue<T>> ret = this.evaluator.evaluateList(type, this.code, this.variables, this.objectResolver, this.functionLibrary, this.shortDesc, result);
            this.traceExpressionSuccess("list", type, ret);
            return ret;
        }
        catch (ExpressionEvaluationException ex) {
            this.traceExpressionFailure("list", type, (Exception)((Object)ex));
            throw ex;
        }
        catch (ObjectNotFoundException ex) {
            this.traceExpressionFailure("list", type, (Exception)((Object)ex));
            throw ex;
        }
        catch (SchemaException ex) {
            this.traceExpressionFailure("list", type, (Exception)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            this.traceExpressionFailure("list", type, ex);
            throw ex;
        }
    }

    private void traceExpressionSuccess(String returnContext, Class<?> returnType, Object returnValue) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Expression trace:\n---[ EXPRESSION {}]---------------------------\nLanguage: {}\nReturn type: {} ({})\nVariables:\n{}\nCode:\n{}\nResult: {}", new Object[]{this.shortDesc, this.evaluator.getLanguageName(), returnType, returnContext, this.formatVariables(), this.formatCode(), SchemaDebugUtil.prettyPrint((Object)returnValue)});
        }
    }

    private void traceExpressionFailure(String returnContext, Class<?> returnType, Exception exception) {
        LOGGER.error("Expression error: {}", (Object)exception.getMessage(), (Object)exception);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Expression trace:\n---[ EXPRESSION {}]---------------------------\nLanguage: {}\nReturn type: {} ({})\nVariables:\n{}\nCode:\n{}\nError: {}", new Object[]{this.shortDesc, this.evaluator.getLanguageName(), returnType, returnContext, this.formatVariables(), this.formatCode(), SchemaDebugUtil.prettyPrint((Object)exception)});
        }
    }

    private String formatVariables() {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<QName, Object>> i = this.variables.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<QName, Object> entry = i.next();
            SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)1);
            sb.append(SchemaDebugUtil.prettyPrint((QName)entry.getKey())).append(": ");
            Object value = entry.getValue();
            if (value instanceof DebugDumpable) {
                sb.append("\n");
                sb.append(((DebugDumpable)value).debugDump(2));
            } else if (value instanceof Element) {
                sb.append("\n");
                sb.append(DOMUtil.serializeDOMToString((Node)((Element)value)));
            } else {
                sb.append(SchemaDebugUtil.prettyPrint((Object)value));
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private String formatCode() {
        return DOMUtil.serializeDOMToString((Node)this.code);
    }
}

