/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AppenderConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AuditingConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ClassLoggerConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.FileAppenderConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LoggingConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SubSystemLoggerConfigurationType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;

public class LoggingConfigurationManager {
    public static final String AUDIT_LOGGER_NAME = "com.evolveum.midpoint.audit.log";
    static final Trace LOGGER = TraceManager.getTrace(LoggingConfigurationManager.class);
    private static String currentlyUsedVersion = null;

    public static void configure(LoggingConfigurationType config, String version, OperationResult result) {
        OperationResult res = result.createSubresult("Logging reconfiguration configuration");
        LOGGER.info("Changing logging configuration (current config version: {}, new version {})", (Object)currentlyUsedVersion, (Object)version);
        currentlyUsedVersion = version;
        LoggerContext lc = (LoggerContext)TraceManager.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        String configXml = LoggingConfigurationManager.prepareConfiguration(config);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("New logging configuration:");
            LOGGER.trace(configXml);
        }
        ByteArrayInputStream cis = new ByteArrayInputStream(configXml.getBytes());
        LOGGER.info("Resetting current logging configuration");
        lc.getStatusManager().clear();
        for (Logger l : lc.getLoggerList()) {
            LOGGER.trace("Disable logger: {}", (Object)l);
            l.setLevel(Level.ERROR);
        }
        lc.reset();
        lc.setName("MidPoint");
        try {
            configurator.doConfigure((InputStream)cis);
            LOGGER.info("New logging configuration applied");
        }
        catch (JoranException e) {
            System.out.println("Error during applying logging configuration: " + e.getMessage());
            LOGGER.error("Error during applying logging configuration: " + e.getMessage(), (Throwable)e);
            result.createSubresult("Applying logging configuration.").recordFatalError(e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            System.out.println("Error during applying logging configuration: " + e.getMessage());
            LOGGER.error("Error during applying logging configuration: " + e.getMessage(), (Throwable)e);
            result.createSubresult("Applying logging configuration.").recordFatalError(e.getMessage(), (Throwable)e);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StatusPrinter.setPrintStream((PrintStream)new PrintStream(baos));
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
        String internalLog = null;
        try {
            internalLog = baos.toString("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (!StringUtils.isEmpty((String)internalLog)) {
            res.recordSuccess();
            String[] internalLogLines = internalLog.split("\n");
            int i = 0;
            while (i < internalLogLines.length) {
                if (internalLogLines[i].contains("|-ERROR")) {
                    res.recordPartialError(internalLogLines[i]);
                }
                res.appendDetail(internalLogLines[i]);
                ++i;
            }
            System.out.println(internalLog);
        } else {
            res.recordSuccess();
        }
    }

    private static String prepareConfiguration(LoggingConfigurationType config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration can't be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<configuration scan=\"false\" debug=\"true\">\n");
        for (SubSystemLoggerConfigurationType ss : config.getSubSystemLogger()) {
            if (!"ALL".contentEquals(ss.getComponent().name())) continue;
            LoggingConfigurationManager.defineTurbo(sb, ss);
        }
        for (SubSystemLoggerConfigurationType ss : config.getSubSystemLogger()) {
            if (ss.getComponent() == null || ss.getLevel() == null) {
                LOGGER.error("Subsystem ({}) or level ({})is null", (Object)ss.getComponent(), (Object)ss.getLevel());
                continue;
            }
            if ("OFF".equals(ss.getLevel().name()) || "ALL".contentEquals(ss.getComponent().name())) continue;
            LoggingConfigurationManager.defineTurbo(sb, ss);
        }
        for (AppenderConfigurationType appender : config.getAppender()) {
            if (appender instanceof FileAppenderConfigurationType) {
                FileAppenderConfigurationType a = (FileAppenderConfigurationType)appender;
                String fileName = a.getFileName();
                String filePattern = a.getFilePattern();
                boolean isRolling = false;
                String appenderClass = "ch.qos.logback.core.FileAppender";
                if (filePattern != null || a.getMaxHistory() > 0 || !StringUtils.isEmpty((String)a.getMaxFileSize())) {
                    isRolling = true;
                    appenderClass = "ch.qos.logback.core.rolling.RollingFileAppender";
                }
                sb.append("\t<appender name=\"");
                sb.append(a.getName());
                sb.append("\" class=\"" + appenderClass + "\">\n");
                sb.append("\t\t<file>");
                sb.append(fileName);
                sb.append("</file>\n");
                sb.append("\t\t<append>");
                sb.append(a.isAppend());
                sb.append("</append>\n");
                if (isRolling) {
                    sb.append("\t\t<rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">\n");
                    sb.append("\t\t\t<fileNamePattern>");
                    sb.append(filePattern);
                    sb.append("</fileNamePattern>\n");
                    if (a.getMaxHistory() > 0) {
                        sb.append("\t\t\t<maxHistory>");
                        sb.append(a.getMaxHistory());
                        sb.append("</maxHistory>\n");
                    }
                    if (!StringUtils.isEmpty((String)a.getMaxFileSize())) {
                        sb.append("\t\t\t<timeBasedFileNamingAndTriggeringPolicy class=\"ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP\">\n");
                        sb.append("\t\t\t\t<maxFileSize>");
                        sb.append(a.getMaxFileSize());
                        sb.append("</maxFileSize>\n");
                        sb.append("\t\t\t</timeBasedFileNamingAndTriggeringPolicy>\n");
                    }
                    sb.append("\t\t</rollingPolicy>\n");
                }
                sb.append("\t\t<encoder>\n");
                sb.append("\t\t\t<pattern>");
                sb.append(a.getPattern());
                sb.append("</pattern>\n");
                sb.append("\t\t</encoder>\n");
                sb.append("\t</appender>\n");
            }
            if (StringUtils.isEmpty((String)config.getRootLoggerAppender())) continue;
            sb.append("\t<root level=\"");
            sb.append(config.getRootLoggerLevel());
            sb.append("\">\n");
            sb.append("\t\t<appender-ref ref=\"");
            sb.append(config.getRootLoggerAppender());
            sb.append("\" />\n");
            sb.append("\t</root>\n");
        }
        for (ClassLoggerConfigurationType logger : config.getClassLogger()) {
            sb.append("\t<logger name=\"");
            sb.append(logger.getPackage());
            sb.append("\" level=\"");
            sb.append(logger.getLevel());
            sb.append("\"");
            if (logger.getAppender() != null && !logger.getAppender().isEmpty()) {
                sb.append(">\n");
                for (String appenderName : logger.getAppender()) {
                    sb.append("\t\t<appender-ref ref=\"");
                    sb.append(appenderName);
                    sb.append("\"/>");
                }
                sb.append("\t</logger>\n");
                continue;
            }
            sb.append("/>\n");
        }
        LoggingConfigurationManager.generateAuditingLogConfig(config.getAuditing(), sb);
        if (config.getAdvanced() != null) {
            for (Object item : config.getAdvanced().getContent()) {
                sb.append(item.toString());
                sb.append("\n");
            }
        }
        sb.append("</configuration>");
        return sb.toString();
    }

    private static void generateAuditingLogConfig(AuditingConfigurationType auditing, StringBuilder sb) {
        sb.append("\t<logger name=\"");
        sb.append(AUDIT_LOGGER_NAME);
        sb.append("\" level=\"");
        if (auditing == null || auditing.isEnabled() == null || auditing.isEnabled().booleanValue()) {
            if (auditing != null && auditing.isDetails() != null && auditing.isDetails().booleanValue()) {
                sb.append("DEBUG");
            } else {
                sb.append("INFO");
            }
        } else {
            sb.append("OFF");
        }
        sb.append("\"");
        if (auditing != null && auditing.getAppender() != null && !auditing.getAppender().isEmpty()) {
            sb.append(">\n");
            for (String appenderName : auditing.getAppender()) {
                sb.append("\t\t<appender-ref ref=\"");
                sb.append(appenderName);
                sb.append("\"/>");
            }
            sb.append("\t</logger>\n");
        } else {
            sb.append("/>\n");
        }
    }

    private static void defineTurbo(StringBuilder sb, SubSystemLoggerConfigurationType ss) {
        sb.append("\t<turboFilter class=\"com.evolveum.midpoint.util.logging.MDCLevelTurboFilter\">\n");
        sb.append("\t\t<MDCKey>subsystem</MDCKey>\n");
        sb.append("\t\t<MDCValue>");
        sb.append(ss.getComponent().name());
        sb.append("</MDCValue>\n");
        sb.append("\t\t<level>");
        sb.append(ss.getLevel().name());
        sb.append("</level>\n");
        sb.append("\t\t<OnMatch>ACCEPT</OnMatch>\n");
        sb.append("\t</turboFilter>\n");
    }

    public static String getCurrentlyUsedVersion() {
        return currentlyUsedVersion;
    }

    public static void resetCurrentlyUsedVersion() {
        currentlyUsedVersion = null;
    }
}

