/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.api;

import java.util.List;
import javax.net.ssl.TrustManager;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.security.GuardedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteFrameworkConnectionInfo {
    private final String _host;
    private final int _port;
    private final GuardedString _key;
    private final boolean _useSSL;
    private final List<TrustManager> _trustManagers;
    private final int _timeout;

    public RemoteFrameworkConnectionInfo(String host, int port, GuardedString key) {
        this(host, port, key, false, null, 60000);
    }

    public RemoteFrameworkConnectionInfo(String host, int port, GuardedString key, boolean useSSL, List<TrustManager> trustManagers, int timeout) {
        Assertions.nullCheck(host, "host");
        Assertions.nullCheck(key, "key");
        this._host = host;
        this._port = port;
        this._key = key;
        this._useSSL = useSSL;
        this._trustManagers = CollectionUtil.newReadOnlyList(trustManagers);
        this._timeout = timeout;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public GuardedString getKey() {
        return this._key;
    }

    public boolean getUseSSL() {
        return this._useSSL;
    }

    public List<TrustManager> getTrustManagers() {
        return this._trustManagers;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteFrameworkConnectionInfo) {
            RemoteFrameworkConnectionInfo other = (RemoteFrameworkConnectionInfo)o;
            if (!this.getHost().equals(other.getHost())) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getUseSSL() != other.getUseSSL()) {
                return false;
            }
            if (!((Object)this.getTrustManagers()).equals(other.getTrustManagers())) {
                return false;
            }
            if (!this.getKey().equals(other.getKey())) {
                return false;
            }
            return this.getTimeout() == other.getTimeout();
        }
        return false;
    }

    public int hashCode() {
        return this._host.hashCode() ^ this._port;
    }

    public String toString() {
        return "{host=" + this._host + ", port=" + this._port + "}";
    }
}

