/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.ucf.impl;

import com.evolveum.midpoint.common.crypto.EncryptionException;
import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.prism.xml.XsdTypeMapper;
import com.evolveum.midpoint.provisioning.ucf.api.Change;
import com.evolveum.midpoint.provisioning.ucf.api.ConnectorInstance;
import com.evolveum.midpoint.provisioning.ucf.api.ExecuteScriptArgument;
import com.evolveum.midpoint.provisioning.ucf.api.ExecuteScriptOperation;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.provisioning.ucf.api.Operation;
import com.evolveum.midpoint.provisioning.ucf.api.PasswordChangeOperation;
import com.evolveum.midpoint.provisioning.ucf.api.PropertyModificationOperation;
import com.evolveum.midpoint.provisioning.ucf.api.ResultHandler;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorFactoryIcfImpl;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure1;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure11;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure13;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure15;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure17;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure19;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure21;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure23;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure25;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure27;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure3;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure5;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure7;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl$AjcClosure9;
import com.evolveum.midpoint.provisioning.ucf.impl.IcfUtil;
import com.evolveum.midpoint.provisioning.ucf.impl.IntermediateException;
import com.evolveum.midpoint.schema.SchemaConstantsGenerated;
import com.evolveum.midpoint.schema.constants.ConnectorTestOperation;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.holder.XPathSegment;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainer;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceSchema;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptHostType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptOrderType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.ActivationCapabilityType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.CredentialsCapabilityType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.LiveSyncCapabilityType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.PasswordCapabilityType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.ScriptCapabilityType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.TestConnectionCapabilityType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import com.evolveum.prism.xml.ns._public.types_2.PolyStringType;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.ScriptContext;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConnectorInstanceIcfImpl
implements ConnectorInstance {
    private static final String CUSTOM_OBJECTCLASS_PREFIX = "Custom";
    private static final String CUSTOM_OBJECTCLASS_SUFFIX = "ObjectClass";
    private static final ObjectFactory capabilityObjectFactory;
    private static final Trace LOGGER;
    ConnectorInfo cinfo;
    ConnectorType connectorType;
    ConnectorFacade icfConnectorFacade;
    String resourceSchemaNamespace;
    Protector protector;
    PrismContext prismContext;
    private ResourceSchema resourceSchema = null;
    private PrismSchema connectorSchema;
    Set<Object> capabilities = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        ConnectorInstanceIcfImpl.ajc$preClinit();
        capabilityObjectFactory = new ObjectFactory();
        LOGGER = TraceManager.getTrace(ConnectorInstanceIcfImpl.class);
    }

    public ConnectorInstanceIcfImpl(ConnectorInfo connectorInfo, ConnectorType connectorType, String schemaNamespace, PrismSchema connectorSchema, Protector protector, PrismContext prismContext) {
        this.cinfo = connectorInfo;
        this.connectorType = connectorType;
        this.resourceSchemaNamespace = schemaNamespace;
        this.connectorSchema = connectorSchema;
        this.protector = protector;
        this.prismContext = prismContext;
    }

    public String getSchemaNamespace() {
        return this.resourceSchemaNamespace;
    }

    @Override
    public void configure(PrismContainerValue configuration, OperationResult parentResult) throws CommunicationException, GenericFrameworkException, SchemaException, ConfigurationException {
        PrismContainerValue prismContainerValue = configuration;
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)prismContainerValue, (Object)operationResult);
        Object[] objectArray = new Object[]{this, prismContainerValue, operationResult, joinPoint};
        MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private PrismContainerDefinition getConfigurationContainerDefinition() throws SchemaException {
        QName configContainerQName;
        PrismContainerDefinition configContainerDef;
        if (this.connectorSchema == null) {
            this.generateConnectorSchema();
        }
        if ((configContainerDef = this.connectorSchema.findContainerDefinitionByElementName(configContainerQName = new QName(this.connectorType.getNamespace(), ResourceType.F_CONFIGURATION.getLocalPart()))) == null) {
            throw new SchemaException("No definition of container " + configContainerQName + " in configuration schema for connector " + this);
        }
        return configContainerDef;
    }

    @Override
    public PrismSchema generateConnectorSchema() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (PrismSchema)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private QName icfTypeToXsdType(Class<?> type) {
        if (this.isMultivaluedType(type)) {
            type = type.getComponentType();
        }
        QName propXsdType = null;
        propXsdType = GuardedString.class.equals(type) ? SchemaConstants.R_PROTECTED_STRING_TYPE : (GuardedByteArray.class.equals(type) ? SchemaConstants.R_PROTECTED_BYTE_ARRAY_TYPE : XsdTypeMapper.toXsdType(type));
        return propXsdType;
    }

    private boolean isMultivaluedType(Class<?> type) {
        return type.isArray() && !type.equals(byte[].class) && !type.equals(char[].class);
    }

    @Override
    public void initialize(OperationResult parentResult) throws CommunicationException, GenericFrameworkException, ConfigurationException {
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)operationResult);
        Object[] objectArray = new Object[]{this, operationResult, joinPoint};
        MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public ResourceSchema getResourceSchema(OperationResult parentResult) throws CommunicationException, GenericFrameworkException, ConfigurationException {
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)operationResult);
        Object[] objectArray = new Object[]{this, operationResult, joinPoint};
        return (ResourceSchema)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void parseResourceSchema(Schema icfSchema) {
        Set supportedOperations;
        boolean capPassword = false;
        boolean capEnable = false;
        this.resourceSchema = new ResourceSchema(this.getSchemaNamespace(), this.prismContext);
        Set objectClassInfoSet = icfSchema.getObjectClassInfo();
        for (ObjectClassInfo objectClassInfo : objectClassInfoSet) {
            QName objectClassXsdName = this.objectClassToQname(objectClassInfo.getType());
            ObjectClassComplexTypeDefinition roDefinition = this.resourceSchema.createObjectClassDefinition(objectClassXsdName);
            if (ObjectClass.ACCOUNT_NAME.equals(objectClassInfo.getType())) {
                roDefinition.setAccountType(true);
                roDefinition.setDefaultAccountType(true);
            }
            ResourceAttributeDefinition uidDefinition = roDefinition.createAttributeDefinition(ConnectorFactoryIcfImpl.ICFS_UID, DOMUtil.XSD_STRING);
            uidDefinition.setMinOccurs(0);
            uidDefinition.setMaxOccurs(1);
            uidDefinition.setReadOnly();
            uidDefinition.setDisplayName("ICF UID");
            roDefinition.getIdentifiers().add(uidDefinition);
            Set attributeInfoSet = objectClassInfo.getAttributeInfo();
            for (AttributeInfo attributeInfo : attributeInfoSet) {
                if (OperationalAttributes.PASSWORD_NAME.equals(attributeInfo.getName())) {
                    capPassword = true;
                    continue;
                }
                if (OperationalAttributes.ENABLE_NAME.equals(attributeInfo.getName())) {
                    capEnable = true;
                    continue;
                }
                QName attrXsdName = this.convertAttributeNameToQName(attributeInfo.getName());
                QName attrXsdType = this.icfTypeToXsdType(attributeInfo.getType());
                ResourceAttributeDefinition roaDefinition = roDefinition.createAttributeDefinition(attrXsdName, attrXsdType);
                if (attrXsdName.equals(ConnectorFactoryIcfImpl.ICFS_NAME)) {
                    roaDefinition.setDisplayName("ICF NAME");
                    roDefinition.getSecondaryIdentifiers().add(roaDefinition);
                }
                Set flagsSet = attributeInfo.getFlags();
                roaDefinition.setMinOccurs(0);
                roaDefinition.setMaxOccurs(1);
                boolean canCreate = true;
                boolean canUpdate = true;
                boolean canRead = true;
                for (AttributeInfo.Flags flags : flagsSet) {
                    if (flags == AttributeInfo.Flags.REQUIRED) {
                        roaDefinition.setMinOccurs(1);
                    }
                    if (flags == AttributeInfo.Flags.MULTIVALUED) {
                        roaDefinition.setMaxOccurs(-1);
                    }
                    if (flags == AttributeInfo.Flags.NOT_CREATABLE) {
                        canCreate = false;
                    }
                    if (flags == AttributeInfo.Flags.NOT_READABLE) {
                        canRead = false;
                    }
                    if (flags != AttributeInfo.Flags.NOT_UPDATEABLE) continue;
                    canUpdate = false;
                }
                roaDefinition.setCreate(canCreate);
                roaDefinition.setUpdate(canUpdate);
                roaDefinition.setRead(canRead);
            }
            roDefinition.setNativeObjectClass(objectClassInfo.getType());
            roDefinition.setDisplayNameAttribute(ConnectorFactoryIcfImpl.ICFS_NAME);
            roDefinition.setNamingAttribute(ConnectorFactoryIcfImpl.ICFS_NAME);
        }
        this.capabilities = new HashSet<Object>();
        if (capEnable) {
            ActivationCapabilityType capAct = new ActivationCapabilityType();
            ActivationCapabilityType.EnableDisable capEnableDisable = new ActivationCapabilityType.EnableDisable();
            capAct.setEnableDisable(capEnableDisable);
            this.capabilities.add(capabilityObjectFactory.createActivation(capAct));
        }
        if (capPassword) {
            CredentialsCapabilityType capCred = new CredentialsCapabilityType();
            PasswordCapabilityType capPass = new PasswordCapabilityType();
            capCred.setPassword(capPass);
            this.capabilities.add(capabilityObjectFactory.createCredentials(capCred));
        }
        if ((supportedOperations = this.icfConnectorFacade.getSupportedOperations()).contains(SyncApiOp.class)) {
            LiveSyncCapabilityType capSync = new LiveSyncCapabilityType();
            this.capabilities.add(capabilityObjectFactory.createLiveSync(capSync));
        }
        if (supportedOperations.contains(TestApiOp.class)) {
            TestConnectionCapabilityType capTest = new TestConnectionCapabilityType();
            this.capabilities.add(capabilityObjectFactory.createTestConnection(capTest));
        }
        if (supportedOperations.contains(ScriptOnResourceApiOp.class) || supportedOperations.contains(ScriptOnConnectorApiOp.class)) {
            ScriptCapabilityType.Host host;
            ScriptCapabilityType capScript = new ScriptCapabilityType();
            if (supportedOperations.contains(ScriptOnResourceApiOp.class)) {
                host = new ScriptCapabilityType.Host();
                host.setType(ScriptHostType.RESOURCE);
                capScript.getHost().add(host);
            }
            if (supportedOperations.contains(ScriptOnConnectorApiOp.class)) {
                host = new ScriptCapabilityType.Host();
                host.setType(ScriptHostType.CONNECTOR);
                capScript.getHost().add(host);
            }
            this.capabilities.add(capabilityObjectFactory.createScript(capScript));
        }
    }

    public Set<Object> getCapabilities(OperationResult parentResult) throws CommunicationException, GenericFrameworkException, ConfigurationException {
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)operationResult);
        Object[] objectArray = new Object[]{this, operationResult, joinPoint};
        return (Set)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public <T extends ResourceObjectShadowType> PrismObject<T> fetchObject(Class<T> type, ObjectClassComplexTypeDefinition objectClassDefinition, Collection<? extends ResourceAttribute> identifiers, boolean returnDefaultAttributes, Collection<? extends ResourceAttributeDefinition> attributesToReturn, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, GenericFrameworkException, SchemaException {
        Class<T> clazz = type;
        ObjectClassComplexTypeDefinition objectClassComplexTypeDefinition = objectClassDefinition;
        Collection<? extends ResourceAttribute> collection = identifiers;
        boolean bl = returnDefaultAttributes;
        Collection<? extends ResourceAttributeDefinition> collection2 = attributesToReturn;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, objectClassComplexTypeDefinition, collection, Conversions.booleanObject((boolean)bl), collection2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, objectClassComplexTypeDefinition, collection, Conversions.booleanObject((boolean)bl), collection2, operationResult, joinPoint};
        return (PrismObject)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private <T extends ResourceObjectShadowType> PrismObjectDefinition<T> toShadowDefinition(ObjectClassComplexTypeDefinition objectClassDefinition) {
        ResourceAttributeContainerDefinition resourceAttributeContainerDefinition = objectClassDefinition.toResourceAttributeContainerDefinition(ResourceObjectShadowType.F_ATTRIBUTES);
        return resourceAttributeContainerDefinition.toShadowDefinition();
    }

    private ConnectorObject fetchConnectorObject(ObjectClass icfObjectClass, Uid uid, boolean returnDefaultAttributes, Collection<? extends ResourceAttributeDefinition> attributesToReturn, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, GenericFrameworkException {
        OperationResult icfResult = parentResult.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".getObject");
        icfResult.addParam("objectClass", (Object)icfObjectClass.toString());
        icfResult.addParam("uid", (Object)uid.getUidValue());
        icfResult.addContext("connector", this.icfConnectorFacade.getClass());
        ConnectorObject co = null;
        try {
            OperationOptionsBuilder optionsBuilder = new OperationOptionsBuilder();
            co = this.icfConnectorFacade.getObject(icfObjectClass, uid, optionsBuilder.build());
            icfResult.recordSuccess();
        }
        catch (Exception ex) {
            Exception midpointEx = IcfUtil.processIcfException(ex, icfResult);
            icfResult.computeStatus("Add object failed");
            if (midpointEx instanceof CommunicationException) {
                throw (CommunicationException)((Object)midpointEx);
            }
            if (midpointEx instanceof GenericFrameworkException) {
                throw (GenericFrameworkException)midpointEx;
            }
            if (midpointEx instanceof RuntimeException) {
                throw (RuntimeException)midpointEx;
            }
            throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
        }
        return co;
    }

    @Override
    public Collection<ResourceAttribute<?>> addObject(PrismObject<? extends ResourceObjectShadowType> object, Set<Operation> additionalOperations, OperationResult parentResult) throws CommunicationException, GenericFrameworkException, SchemaException, ObjectAlreadyExistsException {
        PrismObject<? extends ResourceObjectShadowType> prismObject = object;
        Set<Operation> set = additionalOperations;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{prismObject, set, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, prismObject, set, operationResult, joinPoint};
        return (Collection)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private void validateShadow(PrismObject<? extends ResourceObjectShadowType> shadow, String operation, boolean requireUid) {
        Collection identifiers;
        if (shadow == null) {
            throw new IllegalArgumentException("Cannot " + operation + " null " + shadow);
        }
        PrismContainer attributesContainer = shadow.findContainer(ResourceObjectShadowType.F_ATTRIBUTES);
        if (attributesContainer == null) {
            throw new IllegalArgumentException("Cannot " + operation + " shadow without attributes container");
        }
        ResourceAttributeContainer resourceAttributesContainer = ResourceObjectShadowUtil.getAttributesContainer(shadow);
        if (resourceAttributesContainer == null) {
            throw new IllegalArgumentException("Cannot " + operation + " shadow without attributes container of type ResourceAttributeContainer, got " + attributesContainer.getClass());
        }
        if (requireUid && ((identifiers = resourceAttributesContainer.getIdentifiers()) == null || identifiers.isEmpty())) {
            throw new IllegalArgumentException("Cannot " + operation + " shadow without identifiers");
        }
    }

    @Override
    public Set<PropertyModificationOperation> modifyObject(ObjectClassComplexTypeDefinition objectClass, Collection<? extends ResourceAttribute> identifiers, Set<Operation> changes, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, GenericFrameworkException, SchemaException {
        ObjectClassComplexTypeDefinition objectClassComplexTypeDefinition = objectClass;
        Collection<? extends ResourceAttribute> collection = identifiers;
        Set<Operation> set = changes;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{objectClassComplexTypeDefinition, collection, set, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, objectClassComplexTypeDefinition, collection, set, operationResult, joinPoint};
        return (Set)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private PropertyDelta createUidDelta(Uid uid, ResourceAttributeDefinition uidDefinition) {
        PropertyDelta uidDelta = new PropertyDelta(new PropertyPath(new QName[]{ResourceObjectShadowType.F_ATTRIBUTES}), (PrismPropertyDefinition)uidDefinition);
        uidDelta.setValueToReplace((PrismValue)new PrismPropertyValue((Object)uid.getUidValue()));
        return uidDelta;
    }

    private String dumpAttributes(Set<Attribute> attributes) {
        if (attributes == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Attribute attr : attributes) {
            for (Object value : attr.getValue()) {
                sb.append(attr.getName());
                sb.append(" = ");
                sb.append(value);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void deleteObject(ObjectClassComplexTypeDefinition objectClass, Set<Operation> additionalOperations, Collection<? extends ResourceAttribute> identifiers, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, GenericFrameworkException {
        ObjectClassComplexTypeDefinition objectClassComplexTypeDefinition = objectClass;
        Set<Operation> set = additionalOperations;
        Collection<? extends ResourceAttribute> collection = identifiers;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{objectClassComplexTypeDefinition, set, collection, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, objectClassComplexTypeDefinition, set, collection, operationResult, joinPoint};
        MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure17(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public PrismProperty deserializeToken(Object serializedToken) {
        Object object = serializedToken;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)object);
        Object[] objectArray = new Object[]{this, object, joinPoint};
        return (PrismProperty)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
    }

    public PrismProperty fetchCurrentToken(ObjectClassComplexTypeDefinition objectClass, OperationResult parentResult) throws CommunicationException, GenericFrameworkException {
        ObjectClassComplexTypeDefinition objectClassComplexTypeDefinition = objectClass;
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)objectClassComplexTypeDefinition, (Object)operationResult);
        Object[] objectArray = new Object[]{this, objectClassComplexTypeDefinition, operationResult, joinPoint};
        return (PrismProperty)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public List<Change> fetchChanges(ObjectClassComplexTypeDefinition objectClass, PrismProperty lastToken, OperationResult parentResult) throws CommunicationException, GenericFrameworkException, SchemaException, ConfigurationException {
        ObjectClassComplexTypeDefinition objectClassComplexTypeDefinition = objectClass;
        PrismProperty prismProperty = lastToken;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{objectClassComplexTypeDefinition, prismProperty, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, objectClassComplexTypeDefinition, prismProperty, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure23(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    public void test(OperationResult parentResult) {
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)operationResult);
        Object[] objectArray = new Object[]{this, operationResult, joinPoint};
        MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public <T extends ResourceObjectShadowType> void search(Class<T> type, ObjectClassComplexTypeDefinition objectClassDefinition, QueryType query, ResultHandler<T> handler, OperationResult parentResult) throws CommunicationException, GenericFrameworkException, SchemaException {
        Class<T> clazz = type;
        ObjectClassComplexTypeDefinition objectClassComplexTypeDefinition = objectClassDefinition;
        QueryType queryType = query;
        ResultHandler<T> resultHandler = handler;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, objectClassComplexTypeDefinition, queryType, resultHandler, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, objectClassComplexTypeDefinition, queryType, resultHandler, operationResult, joinPoint};
        MidpointAspect.aspectOf().processUcfNdc(new ConnectorInstanceIcfImpl$AjcClosure27(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private QName convertAttributeNameToQName(String icfAttrName) {
        LOGGER.trace("icf attribute: {}", (Object)icfAttrName);
        QName attrXsdName = new QName(this.getSchemaNamespace(), icfAttrName, "ri");
        if (Name.NAME.equals(icfAttrName)) {
            attrXsdName = ConnectorFactoryIcfImpl.ICFS_NAME;
        }
        LOGGER.trace("attr xsd name: {}", (Object)attrXsdName);
        return attrXsdName;
    }

    private String convertAttributeNameToIcf(QName attrQName, OperationResult parentResult) throws SchemaException {
        if (attrQName.getNamespaceURI().equals(this.getSchemaNamespace())) {
            return attrQName.getLocalPart();
        }
        if (ConnectorFactoryIcfImpl.ICFS_NAME.equals(attrQName)) {
            return Name.NAME;
        }
        if (ConnectorFactoryIcfImpl.ICFS_UID.equals(attrQName)) {
            return Uid.NAME;
        }
        throw new SchemaException("No mapping from QName " + attrQName + " to an ICF attribute name");
    }

    private QName objectClassToQname(String icfObjectClassString) {
        if (ObjectClass.ACCOUNT_NAME.equals(icfObjectClassString)) {
            return new QName(this.getSchemaNamespace(), "AccountObjectClass", "icfs");
        }
        if (ObjectClass.GROUP_NAME.equals(icfObjectClassString)) {
            return new QName(this.getSchemaNamespace(), "GroupObjectClass", "icfs");
        }
        return new QName(this.getSchemaNamespace(), CUSTOM_OBJECTCLASS_PREFIX + icfObjectClassString + CUSTOM_OBJECTCLASS_SUFFIX, "ri");
    }

    private ObjectClass objectClassToIcf(PrismObject<? extends ResourceObjectShadowType> object) {
        ResourceObjectShadowType shadowType = (ResourceObjectShadowType)object.asObjectable();
        QName qnameObjectClass = shadowType.getObjectClass();
        if (qnameObjectClass == null) {
            ResourceAttributeContainer attrContainer = ResourceObjectShadowUtil.getAttributesContainer((ResourceObjectShadowType)shadowType);
            if (attrContainer == null) {
                return null;
            }
            ResourceAttributeContainerDefinition objectClassDefinition = attrContainer.getDefinition();
            qnameObjectClass = objectClassDefinition.getTypeName();
        }
        return this.objectClassToIcf(qnameObjectClass);
    }

    private ObjectClass objectClassToIcf(ObjectClassComplexTypeDefinition objectClassDefinition) {
        QName qnameObjectClass = objectClassDefinition.getTypeName();
        return this.objectClassToIcf(qnameObjectClass);
    }

    private ObjectClass objectClassToIcf(QName qnameObjectClass) {
        if (!this.getSchemaNamespace().equals(qnameObjectClass.getNamespaceURI())) {
            throw new IllegalArgumentException("ObjectClass QName " + qnameObjectClass + " is not in the appropriate namespace for " + ObjectTypeUtil.toShortString((ObjectType)this.connectorType) + ", expected: " + this.getSchemaNamespace());
        }
        String lname = qnameObjectClass.getLocalPart();
        if ("AccountObjectClass".equals(lname)) {
            return ObjectClass.ACCOUNT;
        }
        if ("GroupObjectClass".equals(lname)) {
            return ObjectClass.GROUP;
        }
        if (lname.startsWith(CUSTOM_OBJECTCLASS_PREFIX) && lname.endsWith(CUSTOM_OBJECTCLASS_SUFFIX)) {
            String icfObjectClassName = lname.substring(CUSTOM_OBJECTCLASS_PREFIX.length(), lname.length() - CUSTOM_OBJECTCLASS_SUFFIX.length());
            return new ObjectClass(icfObjectClassName);
        }
        throw new IllegalArgumentException("Cannot recognize objectclass QName " + qnameObjectClass + " for " + ObjectTypeUtil.toShortString((ObjectType)this.connectorType) + ", expected: " + this.getSchemaNamespace());
    }

    private Uid getUid(Collection<? extends ResourceAttribute> identifiers) {
        for (ResourceAttribute resourceAttribute : identifiers) {
            if (!resourceAttribute.getName().equals(ConnectorFactoryIcfImpl.ICFS_UID)) continue;
            return new Uid((String)resourceAttribute.getValue().getValue());
        }
        return null;
    }

    private ResourceAttributeDefinition getUidDefinition(ResourceAttributeContainerDefinition def) {
        return def.findAttributeDefinition(ConnectorFactoryIcfImpl.ICFS_UID);
    }

    private ResourceAttributeDefinition getUidDefinition(Collection<? extends ResourceAttribute> identifiers) {
        for (ResourceAttribute resourceAttribute : identifiers) {
            if (!resourceAttribute.getName().equals(ConnectorFactoryIcfImpl.ICFS_UID)) continue;
            return resourceAttribute.getDefinition();
        }
        return null;
    }

    private ResourceAttribute createUidAttribute(Uid uid, ResourceAttributeDefinition uidDefinition) {
        ResourceAttribute uidRoa = uidDefinition.instantiate();
        uidRoa.setValue(new PrismPropertyValue((Object)uid.getUidValue()));
        return uidRoa;
    }

    private <T extends ResourceObjectShadowType> PrismObject<T> convertToResourceObject(ConnectorObject co, PrismObjectDefinition<T> objectDefinition, boolean full) throws SchemaException {
        PrismObject shadowPrism = null;
        if (objectDefinition == null) {
            throw new SchemaException("No definition");
        }
        shadowPrism = objectDefinition.instantiate();
        ResourceObjectShadowType shadow = (ResourceObjectShadowType)shadowPrism.asObjectable();
        ResourceAttributeContainer attributesContainer = (ResourceAttributeContainer)shadowPrism.findOrCreateContainer(ResourceObjectShadowType.F_ATTRIBUTES);
        ResourceAttributeContainerDefinition attributesDefinition = attributesContainer.getDefinition();
        shadow.setObjectClass(attributesDefinition.getTypeName());
        LOGGER.trace("Resource attribute container definition {}.", (Object)attributesDefinition.dump());
        Uid uid = co.getUid();
        ResourceAttribute uidRoa = this.createUidAttribute(uid, this.getUidDefinition(attributesDefinition));
        attributesContainer.getValue().add((Item)uidRoa);
        for (Attribute icfAttr : co.getAttributes()) {
            Object value;
            AccountShadowType accountShadowType;
            if (icfAttr.getName().equals(Uid.NAME)) continue;
            if (icfAttr.getName().equals(OperationalAttributes.PASSWORD_NAME)) {
                if (shadow instanceof AccountShadowType) {
                    accountShadowType = (AccountShadowType)shadow;
                    ProtectedStringType password = this.getSingleValue(icfAttr, ProtectedStringType.class);
                    ResourceObjectShadowUtil.setPassword((AccountShadowType)accountShadowType, (ProtectedStringType)password);
                    continue;
                }
                throw new SchemaException("Attempt to set password for non-account object type " + objectDefinition);
            }
            if (icfAttr.getName().equals(OperationalAttributes.ENABLE_NAME)) {
                if (shadow instanceof AccountShadowType) {
                    accountShadowType = (AccountShadowType)shadow;
                    Boolean enabled = this.getSingleValue(icfAttr, Boolean.class);
                    ActivationType activationType = ResourceObjectShadowUtil.getOrCreateActivation((ResourceObjectShadowType)accountShadowType);
                    activationType.setEnabled(enabled);
                    continue;
                }
                throw new SchemaException("Attempt to set activation/enabled for non-account object type " + objectDefinition);
            }
            QName qname = this.convertAttributeNameToQName(icfAttr.getName());
            ResourceAttributeDefinition attributeDefinition = attributesDefinition.findAttributeDefinition(qname);
            if (attributeDefinition == null) {
                throw new SchemaException("Unknown attribute {}. Cannot create definition.", qname);
            }
            ResourceAttribute resourceAttribute = attributeDefinition.instantiate(qname);
            LOGGER.trace("attribute name: " + qname);
            LOGGER.trace("attribute value: " + icfAttr.getValue());
            if (full) {
                if (icfAttr.getValue() != null) {
                    for (Object icfValue : icfAttr.getValue()) {
                        value = this.convertValueFromIcf(icfValue, qname);
                        resourceAttribute.add((PrismValue)new PrismPropertyValue(value));
                    }
                }
                attributesContainer.getValue().add((Item)resourceAttribute);
                continue;
            }
            if (icfAttr.getValue() == null || icfAttr.getValue().isEmpty()) continue;
            for (Object icfValue : icfAttr.getValue()) {
                value = this.convertValueFromIcf(icfValue, qname);
                resourceAttribute.add((PrismValue)new PrismPropertyValue(value));
            }
            attributesContainer.getValue().add((Item)resourceAttribute);
        }
        return shadowPrism;
    }

    private <T> T getSingleValue(Attribute icfAttr, Class<T> type) throws SchemaException {
        List values = icfAttr.getValue();
        if (values != null && !values.isEmpty()) {
            if (values.size() > 1) {
                throw new SchemaException("Expected single value for " + icfAttr.getName());
            }
            Object val = this.convertValueFromIcf(values.get(0), null);
            if (type.isAssignableFrom(val.getClass())) {
                return (T)val;
            }
            throw new SchemaException("Expected type " + type.getName() + " for " + icfAttr.getName() + " but got " + val.getClass().getName());
        }
        throw new SchemaException("Empty value for " + icfAttr.getName());
    }

    private Set<Attribute> convertFromResourceObject(ResourceAttributeContainer attributesPrism, OperationResult parentResult) throws SchemaException {
        Collection resourceAttributes = attributesPrism.getAttributes();
        return this.convertFromResourceObject(resourceAttributes, parentResult);
    }

    private Set<Attribute> convertFromResourceObject(Collection<ResourceAttribute<?>> resourceAttributes, OperationResult parentResult) throws SchemaException {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        if (resourceAttributes == null) {
            return attributes;
        }
        for (ResourceAttribute<?> attribute : resourceAttributes) {
            String attrName = this.convertAttributeNameToIcf(attribute.getName(), parentResult);
            HashSet<Object> convertedAttributeValues = new HashSet<Object>();
            for (PrismPropertyValue value : attribute.getValues()) {
                convertedAttributeValues.add(this.convertValueToIcf(value, attribute.getName()));
            }
            Attribute connectorAttribute = AttributeBuilder.build((String)attrName, convertedAttributeValues);
            attributes.add(connectorAttribute);
        }
        return attributes;
    }

    private Object convertValueToIcf(Object value, QName propName) throws SchemaException {
        if (value == null) {
            return null;
        }
        if (value instanceof PrismPropertyValue) {
            return this.convertValueToIcf(((PrismPropertyValue)value).getValue(), propName);
        }
        if (value instanceof ProtectedStringType) {
            ProtectedStringType ps = (ProtectedStringType)value;
            return this.toGuardedString(ps, propName.toString());
        }
        return value;
    }

    private Object convertValueFromIcf(Object icfValue, QName propName) {
        if (icfValue == null) {
            return null;
        }
        if (icfValue instanceof GuardedString) {
            return this.fromGuardedString((GuardedString)icfValue);
        }
        return icfValue;
    }

    private void convertFromActivation(Set<Attribute> updateAttributes, Collection<PropertyDelta> activationDeltas) throws SchemaException {
        for (PropertyDelta propDelta : activationDeltas) {
            if (propDelta.getName().equals(ActivationType.F_ENABLED)) {
                updateAttributes.add(AttributeBuilder.build((String)OperationalAttributes.ENABLE_NAME, (Object[])new Object[]{propDelta.getPropertyNew().getValue(Boolean.class).getValue()}));
                continue;
            }
            throw new SchemaException("Got unknown activation attribute delta " + propDelta.getName());
        }
    }

    private void convertFromPassword(Set<Attribute> attributes, PropertyDelta passwordDelta) {
        if (passwordDelta == null) {
            throw new IllegalArgumentException("No password was provided");
        }
        if (passwordDelta.getName().equals(PasswordType.F_PROTECTED_STRING)) {
            GuardedString guardedPassword = this.toGuardedString((ProtectedStringType)passwordDelta.getPropertyNew().getValue().getValue(), "new password");
            attributes.add(AttributeBuilder.build((String)OperationalAttributes.PASSWORD_NAME, (Object[])new Object[]{guardedPassword}));
        }
    }

    private List<Change> getChangesFromSyncDeltas(ObjectClass objClass, Collection<SyncDelta> icfDeltas, PrismSchema schema, OperationResult parentResult) throws SchemaException, GenericFrameworkException {
        ArrayList<Change> changeList = new ArrayList<Change>();
        Validate.notNull(icfDeltas, (String)"Sync result must not be null.");
        for (SyncDelta icfDelta : icfDeltas) {
            Change change;
            ArrayList<ResourceAttribute<?>> identifiers;
            if (icfDelta.getObject() != null) {
                objClass = icfDelta.getObject().getObjectClass();
            }
            QName objectClass = this.objectClassToQname(objClass.getObjectClassValue());
            ObjectClassComplexTypeDefinition objClassDefinition = (ObjectClassComplexTypeDefinition)schema.findComplexTypeDefinition(objectClass);
            if (SyncDeltaType.DELETE.equals((Object)icfDelta.getDeltaType())) {
                LOGGER.debug("START creating delta of type DELETE");
                ObjectDelta objectDelta = new ObjectDelta(ResourceObjectShadowType.class, ChangeType.DELETE);
                ResourceAttribute uidAttribute = this.createUidAttribute(icfDelta.getUid(), this.getUidDefinition(objClassDefinition.toResourceAttributeContainerDefinition(ResourceObjectShadowType.F_ATTRIBUTES)));
                identifiers = new ArrayList<ResourceAttribute>(1);
                identifiers.add(uidAttribute);
                change = new Change(identifiers, (ObjectDelta<? extends ResourceObjectShadowType>)objectDelta, this.getToken(icfDelta.getToken()));
                change.setObjectClassDefinition(objClassDefinition);
                changeList.add(change);
                LOGGER.debug("END creating delta of type DELETE");
                continue;
            }
            if (SyncDeltaType.CREATE_OR_UPDATE.equals((Object)icfDelta.getDeltaType())) {
                PrismObjectDefinition objectDefinition = this.toShadowDefinition(objClassDefinition);
                LOGGER.trace("Object definition: {}", objectDefinition);
                LOGGER.debug("START creating delta of type CREATE_OR_UPDATE");
                PrismObject currentShadow = this.convertToResourceObject(icfDelta.getObject(), objectDefinition, false);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Got current shadow: {}", (Object)currentShadow.dump());
                }
                identifiers = ResourceObjectShadowUtil.getIdentifiers(currentShadow);
                change = new Change(identifiers, currentShadow, this.getToken(icfDelta.getToken()));
                change.setObjectClassDefinition(objClassDefinition);
                changeList.add(change);
                LOGGER.debug("END creating delta of type CREATE_OR_UPDATE");
                continue;
            }
            throw new GenericFrameworkException("Unexpected sync delta type " + icfDelta.getDeltaType());
        }
        return changeList;
    }

    private Element getModificationPath(Document doc) {
        ArrayList<XPathSegment> segments = new ArrayList<XPathSegment>();
        XPathSegment attrSegment = new XPathSegment(SchemaConstants.I_ATTRIBUTES);
        segments.add(attrSegment);
        XPathHolder t = new XPathHolder(segments);
        Element xpathElement = t.toElement(SchemaConstants.I_PROPERTY_CONTAINER_REFERENCE_PATH, doc);
        return xpathElement;
    }

    private SyncToken getSyncToken(PrismProperty tokenProperty) throws SchemaException {
        if (tokenProperty.getValue() == null) {
            throw new IllegalArgumentException("Attempt to get token from a null property");
        }
        Object tokenValue = tokenProperty.getValue().getValue();
        if (tokenValue == null) {
            throw new IllegalArgumentException("Attempt to get token from a null-valued property");
        }
        SyncToken syncToken = new SyncToken(tokenValue);
        return syncToken;
    }

    private PrismProperty<?> getToken(SyncToken syncToken) {
        Object object = syncToken.getValue();
        return this.createTokenProperty(object);
    }

    private <T> PrismProperty<T> createTokenProperty(T object) {
        QName type = XsdTypeMapper.toXsdType(object.getClass());
        HashSet<PrismPropertyValue> syncTokenValues = new HashSet<PrismPropertyValue>();
        syncTokenValues.add(new PrismPropertyValue(object));
        PrismPropertyDefinition propDef = new PrismPropertyDefinition(SchemaConstants.SYNC_TOKEN, SchemaConstants.SYNC_TOKEN, type, this.prismContext);
        propDef.setDynamic(true);
        PrismProperty property = propDef.instantiate();
        property.addValues(syncTokenValues);
        return property;
    }

    private void checkAndExecuteAdditionalOperation(Set<Operation> additionalOperations, ScriptOrderType order) {
        if (additionalOperations == null) {
            return;
        }
        for (Operation op : additionalOperations) {
            if (!(op instanceof ExecuteScriptOperation)) continue;
            ExecuteScriptOperation executeOp = (ExecuteScriptOperation)op;
            LOGGER.trace("Find execute script operation: {}", (Object)SchemaDebugUtil.prettyPrint((Object)executeOp));
            if (!order.equals((Object)executeOp.getScriptOrder())) continue;
            this.executeScript(executeOp);
        }
    }

    private void executeScript(ExecuteScriptOperation executeOp) {
        ScriptContext scriptContext = this.convertToScriptContext(executeOp);
        if (executeOp.isConnectorHost()) {
            LOGGER.debug("Start running script on connector.");
            this.icfConnectorFacade.runScriptOnConnector(scriptContext, new OperationOptionsBuilder().build());
            LOGGER.debug("Finish running script on connector.");
        }
        if (executeOp.isResourceHost()) {
            LOGGER.debug("Start running script on resource.");
            this.icfConnectorFacade.runScriptOnResource(scriptContext, new OperationOptionsBuilder().build());
            LOGGER.debug("Finish running script on resource.");
        }
    }

    private ScriptContext convertToScriptContext(ExecuteScriptOperation executeOp) {
        HashMap<String, List<Object>> scriptArguments = new HashMap<String, List<Object>>();
        for (ExecuteScriptArgument argument : executeOp.getArgument()) {
            scriptArguments.put(argument.getArgumentName(), argument.getArgumentValue());
        }
        ScriptContext scriptContext = new ScriptContext(executeOp.getLanguage(), executeOp.getTextCode(), scriptArguments);
        return scriptContext;
    }

    private void transformConnectorConfiguration(APIConfiguration apiConfig, PrismContainerValue configuration) throws SchemaException, ConfigurationException {
        ConfigurationProperties configProps = apiConfig.getConfigurationProperties();
        String connectorConfNs = this.connectorType.getNamespace();
        PrismContainer configurationPropertiesContainer = configuration.findContainer(ConnectorFactoryIcfImpl.CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_ELEMENT_QNAME);
        if (configurationPropertiesContainer == null) {
            configurationPropertiesContainer = configuration.findContainer(new QName(connectorConfNs, "configurationProperties"));
        }
        int numConfingProperties = this.transformConnectorConfiguration(configProps, configurationPropertiesContainer, connectorConfNs);
        PrismContainer connectorPoolContainer = configuration.findContainer(new QName("http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/connector-schema-2", "connectorPoolConfiguration"));
        ObjectPoolConfiguration connectorPoolConfiguration = apiConfig.getConnectorPoolConfiguration();
        this.transformConnectorPoolConfiguration(connectorPoolConfiguration, connectorPoolContainer);
        PrismProperty producerBufferSizeProperty = configuration.findProperty(new QName("http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/connector-schema-2", "producerBufferSize"));
        if (producerBufferSizeProperty != null) {
            apiConfig.setProducerBufferSize(this.parseInt(producerBufferSizeProperty));
        }
        PrismContainer connectorTimeoutsContainer = configuration.findContainer(new QName("http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/connector-schema-2", "timeouts"));
        this.transformConnectorTimeoutsConfiguration(apiConfig, connectorTimeoutsContainer);
        if (numConfingProperties == 0) {
            throw new SchemaException("No configuration properties found. Wrong namespace? (expected: " + connectorConfNs + ")");
        }
    }

    private int transformConnectorConfiguration(ConfigurationProperties configProps, PrismContainer<?> configurationPropertiesContainer, String connectorConfNs) throws ConfigurationException {
        int numConfingProperties = 0;
        if (configurationPropertiesContainer == null || configurationPropertiesContainer.getValue() == null) {
            LOGGER.warn("No configuration properties in connectorType.getOid()");
            return numConfingProperties;
        }
        for (PrismProperty prismProperty : configurationPropertiesContainer.getValue().getProperties()) {
            QName propertyQName = prismProperty.getName();
            if (propertyQName.getNamespaceURI() == null || !propertyQName.getNamespaceURI().equals(connectorConfNs)) {
                LOGGER.warn("Found element with a wrong namespace ({}) in connector OID={}", (Object)propertyQName.getNamespaceURI(), (Object)this.connectorType.getOid());
                continue;
            }
            ++numConfingProperties;
            String propertyName = propertyQName.getLocalPart();
            ConfigurationProperty property = configProps.getProperty(propertyName);
            Class type = property.getType();
            if (type.isArray()) {
                property.setValue((Object)this.convertToIcfArray(prismProperty, type.getComponentType()));
                continue;
            }
            property.setValue(this.convertToIcfSingle(prismProperty, type));
        }
        return numConfingProperties;
    }

    private void transformConnectorPoolConfiguration(ObjectPoolConfiguration connectorPoolConfiguration, PrismContainer<?> connectorPoolContainer) throws SchemaException {
        if (connectorPoolContainer == null || connectorPoolContainer.getValue() == null) {
            return;
        }
        for (PrismProperty prismProperty : connectorPoolContainer.getValue().getProperties()) {
            QName propertyQName = prismProperty.getName();
            if (propertyQName.getNamespaceURI().equals("http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/connector-schema-2")) {
                String subelementName = propertyQName.getLocalPart();
                if ("minEvictableIdleTimeMillis".equals(subelementName)) {
                    connectorPoolConfiguration.setMinEvictableIdleTimeMillis(this.parseLong(prismProperty));
                    continue;
                }
                if ("minIdle".equals(subelementName)) {
                    connectorPoolConfiguration.setMinIdle(this.parseInt(prismProperty));
                    continue;
                }
                if ("maxIdle".equals(subelementName)) {
                    connectorPoolConfiguration.setMaxIdle(this.parseInt(prismProperty));
                    continue;
                }
                if ("maxObjects".equals(subelementName)) {
                    connectorPoolConfiguration.setMaxObjects(this.parseInt(prismProperty));
                    continue;
                }
                if ("maxWait".equals(subelementName)) {
                    connectorPoolConfiguration.setMaxWait(this.parseLong(prismProperty));
                    continue;
                }
                throw new SchemaException("Unexpected element " + propertyQName + " in " + "connectorPoolConfiguration");
            }
            throw new SchemaException("Unexpected element " + propertyQName + " in " + "connectorPoolConfiguration");
        }
    }

    private void transformConnectorTimeoutsConfiguration(APIConfiguration apiConfig, PrismContainer<?> connectorTimeoutsContainer) throws SchemaException {
        if (connectorTimeoutsContainer == null || connectorTimeoutsContainer.getValue() == null) {
            return;
        }
        for (PrismProperty prismProperty : connectorTimeoutsContainer.getValue().getProperties()) {
            QName propertQName = prismProperty.getName();
            if (!"http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/connector-schema-2".equals(propertQName.getNamespaceURI())) continue;
            String opName = propertQName.getLocalPart();
            Class<? extends APIOperation> apiOpClass = ConnectorFactoryIcfImpl.resolveApiOpClass(opName);
            if (apiOpClass != null) {
                apiConfig.setTimeout(apiOpClass, this.parseInt(prismProperty));
                continue;
            }
            throw new SchemaException("Unknown operation name " + opName + " in " + "timeouts");
        }
    }

    private int parseInt(PrismProperty<?> prop) {
        return (Integer)prop.getRealValue(Integer.class);
    }

    private long parseLong(PrismProperty<?> prop) {
        Object realValue = prop.getRealValue();
        if (realValue instanceof Long) {
            return (Long)realValue;
        }
        if (realValue instanceof Integer) {
            return ((Integer)realValue).intValue();
        }
        throw new IllegalArgumentException("Cannot convert " + realValue.getClass() + " to long");
    }

    private Object convertToIcfSingle(PrismProperty<?> configProperty, Class<?> expectedType) throws ConfigurationException {
        if (configProperty == null) {
            return null;
        }
        PrismPropertyValue pval = configProperty.getValue();
        return this.convertToIcf(pval, expectedType);
    }

    private Object[] convertToIcfArray(PrismProperty prismProperty, Class<?> componentType) throws ConfigurationException {
        List values = prismProperty.getValues();
        Object valuesArrary = Array.newInstance(componentType, values.size());
        int j = 0;
        while (j < values.size()) {
            Object icfValue = this.convertToIcf((PrismPropertyValue)values.get(j), componentType);
            Array.set(valuesArrary, j, icfValue);
            ++j;
        }
        return (Object[])valuesArrary;
    }

    private Object convertToIcf(PrismPropertyValue<?> pval, Class<?> expectedType) throws ConfigurationException {
        Object midPointRealValue = pval.getValue();
        if (expectedType.equals(GuardedString.class)) {
            if (midPointRealValue instanceof ProtectedStringType) {
                ProtectedStringType ps = (ProtectedStringType)pval.getValue();
                return this.toGuardedString(ps, pval.getParent().getName().getLocalPart());
            }
            throw new ConfigurationException("Expected protected string as value of configuration property " + pval.getParent().getName().getLocalPart() + " but got " + midPointRealValue.getClass());
        }
        if (expectedType.equals(GuardedByteArray.class)) {
            return new GuardedByteArray(Base64.decodeBase64((String)((String)pval.getValue())));
        }
        if (midPointRealValue instanceof PolyString) {
            return ((PolyString)midPointRealValue).getOrig();
        }
        if (midPointRealValue instanceof PolyStringType) {
            return ((PolyStringType)midPointRealValue).getOrig();
        }
        if (expectedType.equals(File.class) && midPointRealValue instanceof String) {
            return new File((String)midPointRealValue);
        }
        return midPointRealValue;
    }

    private GuardedString toGuardedString(ProtectedStringType ps, String propertyName) {
        if (ps == null) {
            return null;
        }
        if (!this.protector.isEncrypted(ps)) {
            if (ps.getClearValue() == null) {
                return null;
            }
            LOGGER.warn("Using cleartext value for {}", (Object)propertyName);
            return new GuardedString(ps.getClearValue().toCharArray());
        }
        try {
            return new GuardedString(this.protector.decryptString(ps).toCharArray());
        }
        catch (EncryptionException e) {
            LOGGER.error("Unable to decrypt value of element {}: {}", new Object[]{propertyName, e.getMessage(), e});
            throw new SystemException("Unable to dectypt value of element " + propertyName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private ProtectedStringType fromGuardedString(GuardedString icfValue) {
        final ProtectedStringType ps = new ProtectedStringType();
        icfValue.access(new GuardedString.Accessor(){

            public void access(char[] passwordChars) {
                try {
                    ps.setClearValue(new String(passwordChars));
                    ConnectorInstanceIcfImpl.this.protector.encrypt(ps);
                }
                catch (EncryptionException encryptionException) {
                    throw new IllegalStateException("Protector failed to encrypt password");
                }
            }
        });
        return ps;
    }

    public String toString() {
        return "ConnectorInstanceIcfImpl(" + ObjectTypeUtil.toShortString((ObjectType)this.connectorType) + ")";
    }

    static final /* synthetic */ void configure_aroundBody0(ConnectorInstanceIcfImpl ajc$this, PrismContainerValue configuration, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".configure");
        result.addParam("configuration", (Object)configuration);
        try {
            configuration.applyDefinition((ItemDefinition)ajc$this.getConfigurationContainerDefinition());
            APIConfiguration apiConfig = ajc$this.cinfo.createDefaultAPIConfiguration();
            try {
                ajc$this.transformConnectorConfiguration(apiConfig, configuration);
            }
            catch (SchemaException e) {
                result.recordFatalError(e.getMessage(), (Throwable)e);
                throw e;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Configuring connector {}", (Object)ajc$this.connectorType);
                for (String propName : apiConfig.getConfigurationProperties().getPropertyNames()) {
                    LOGGER.trace("P: {} = {}", (Object)propName, apiConfig.getConfigurationProperties().getProperty(propName).getValue());
                }
            }
            ajc$this.icfConnectorFacade = ConnectorFacadeFactory.getInstance().newInstance(apiConfig);
            result.recordSuccess();
        }
        catch (Exception ex) {
            Exception midpointEx = IcfUtil.processIcfException(ex, result);
            result.computeStatus("Removing attribute values failed");
            if (midpointEx instanceof CommunicationException) {
                throw (CommunicationException)((Object)midpointEx);
            }
            if (midpointEx instanceof GenericFrameworkException) {
                throw (GenericFrameworkException)midpointEx;
            }
            if (midpointEx instanceof SchemaException) {
                throw (SchemaException)((Object)midpointEx);
            }
            if (midpointEx instanceof ConfigurationException) {
                throw (ConfigurationException)((Object)midpointEx);
            }
            if (midpointEx instanceof RuntimeException) {
                throw (RuntimeException)midpointEx;
            }
            throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
        }
    }

    static final /* synthetic */ PrismSchema generateConnectorSchema_aroundBody2(ConnectorInstanceIcfImpl ajc$this, JoinPoint joinPoint) {
        LOGGER.trace("Generating configuration schema for {}", (Object)ajc$this);
        APIConfiguration defaultAPIConfiguration = ajc$this.cinfo.createDefaultAPIConfiguration();
        ConfigurationProperties icfConfigurationProperties = defaultAPIConfiguration.getConfigurationProperties();
        if (icfConfigurationProperties == null || icfConfigurationProperties.getPropertyNames() == null || icfConfigurationProperties.getPropertyNames().isEmpty()) {
            LOGGER.debug("No configuration schema for {}", (Object)ajc$this);
            return null;
        }
        PrismSchema mpSchema = new PrismSchema(ajc$this.connectorType.getNamespace(), ajc$this.prismContext);
        PrismContainerDefinition configurationContainerDef = mpSchema.createPropertyContainerDefinition(ResourceType.F_CONFIGURATION.getLocalPart(), "ConfigurationType");
        ComplexTypeDefinition configPropertiesTypeDef = mpSchema.createComplexTypeDefinition(new QName(ajc$this.connectorType.getNamespace(), "ConfigurationPropertiesType"));
        for (String icfPropertyName : icfConfigurationProperties.getPropertyNames()) {
            ConfigurationProperty icfProperty = icfConfigurationProperties.getProperty(icfPropertyName);
            QName propXsdType = ajc$this.icfTypeToXsdType(icfProperty.getType());
            LOGGER.trace("{}: Mapping ICF config schema property {} from {} to {}", new Object[]{ajc$this, icfPropertyName, icfProperty.getType(), propXsdType});
            PrismPropertyDefinition propertyDefinifion = configPropertiesTypeDef.createPropertyDefinition(icfPropertyName, propXsdType);
            propertyDefinifion.setDisplayName(icfProperty.getDisplayName(null));
            propertyDefinifion.setHelp(icfProperty.getHelpMessage(null));
            if (ajc$this.isMultivaluedType(icfProperty.getType())) {
                propertyDefinifion.setMaxOccurs(-1);
            } else {
                propertyDefinifion.setMaxOccurs(1);
            }
            if (icfProperty.isRequired()) {
                propertyDefinifion.setMinOccurs(1);
                continue;
            }
            propertyDefinifion.setMinOccurs(0);
        }
        configurationContainerDef.createContainerDefinition(ConnectorFactoryIcfImpl.CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_ELEMENT, ConnectorFactoryIcfImpl.CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_TYPE, 0, 1);
        configurationContainerDef.createPropertyDefinition(ConnectorFactoryIcfImpl.CONNECTOR_SCHEMA_PRODUCER_BUFFER_SIZE_ELEMENT, ConnectorFactoryIcfImpl.CONNECTOR_SCHEMA_PRODUCER_BUFFER_SIZE_TYPE, 0, 1);
        configurationContainerDef.createContainerDefinition(ConnectorFactoryIcfImpl.CONNECTOR_SCHEMA_TIMEOUTS_ELEMENT, ConnectorFactoryIcfImpl.CONNECTOR_SCHEMA_TIMEOUTS_TYPE, 0, 1);
        configurationContainerDef.createContainerDefinition(ConnectorFactoryIcfImpl.CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_ELEMENT_QNAME, configPropertiesTypeDef, 1, 1);
        LOGGER.debug("Generated configuration schema for {}: {} definitions", (Object)ajc$this, (Object)mpSchema.getDefinitions().size());
        ajc$this.connectorSchema = mpSchema;
        return mpSchema;
    }

    static final /* synthetic */ void initialize_aroundBody4(ConnectorInstanceIcfImpl ajc$this, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".initialize");
        result.addContext("connector", (Object)ajc$this.connectorType);
        result.addContext("implementationClass", ConnectorFactoryIcfImpl.class);
        if (ajc$this.icfConnectorFacade == null) {
            result.recordFatalError("Attempt to use unconfigured connector");
            throw new IllegalStateException("Attempt to use unconfigured connector " + ObjectTypeUtil.toShortString((ObjectType)ajc$this.connectorType));
        }
        OperationResult icfResult = result.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".schema");
        icfResult.addContext("connector", ajc$this.icfConnectorFacade.getClass());
        Schema icfSchema = null;
        try {
            icfSchema = ajc$this.icfConnectorFacade.schema();
            icfResult.recordSuccess();
        }
        catch (Exception ex) {
            Exception midpointEx = IcfUtil.processIcfException(ex, icfResult);
            if (midpointEx instanceof CommunicationException) {
                result.recordFatalError("ICF communication error: " + midpointEx.getMessage(), (Throwable)midpointEx);
                throw (CommunicationException)((Object)midpointEx);
            }
            if (midpointEx instanceof ConfigurationException) {
                result.recordFatalError("ICF configuration error: " + midpointEx.getMessage(), (Throwable)midpointEx);
                throw (ConfigurationException)((Object)midpointEx);
            }
            if (midpointEx instanceof GenericFrameworkException) {
                result.recordFatalError("ICF error: " + midpointEx.getMessage(), (Throwable)midpointEx);
                throw (GenericFrameworkException)midpointEx;
            }
            if (midpointEx instanceof RuntimeException) {
                result.recordFatalError("ICF error: " + midpointEx.getMessage(), (Throwable)midpointEx);
                throw (RuntimeException)midpointEx;
            }
            result.recordFatalError("Internal error: " + midpointEx.getMessage(), (Throwable)midpointEx);
            throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
        }
        ajc$this.parseResourceSchema(icfSchema);
        result.recordSuccess();
    }

    static final /* synthetic */ ResourceSchema getResourceSchema_aroundBody6(ConnectorInstanceIcfImpl ajc$this, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".getResourceSchema");
        result.addContext("connector", (Object)ajc$this.connectorType);
        if (ajc$this.resourceSchema == null) {
            try {
                ajc$this.initialize(result);
            }
            catch (CommunicationException ex) {
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
            catch (ConfigurationException ex) {
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
            catch (GenericFrameworkException ex) {
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
        }
        result.recordSuccess();
        return ajc$this.resourceSchema;
    }

    static final /* synthetic */ Set getCapabilities_aroundBody8(ConnectorInstanceIcfImpl ajc$this, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".getCapabilities");
        result.addContext("connector", (Object)ajc$this.connectorType);
        if (ajc$this.capabilities == null) {
            try {
                ajc$this.initialize(result);
            }
            catch (CommunicationException ex) {
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
            catch (ConfigurationException ex) {
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
            catch (GenericFrameworkException ex) {
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
        }
        result.recordSuccess();
        return ajc$this.capabilities;
    }

    static final /* synthetic */ PrismObject fetchObject_aroundBody10(ConnectorInstanceIcfImpl ajc$this, Class type, ObjectClassComplexTypeDefinition objectClassDefinition, Collection identifiers, boolean returnDefaultAttributes, Collection attributesToReturn, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".fetchObject");
        result.addParam("resourceObjectDefinition", (Object)objectClassDefinition);
        result.addParam("identifiers", (Object)identifiers);
        result.addContext("connector", (Object)ajc$this.connectorType);
        if (ajc$this.icfConnectorFacade == null) {
            result.recordFatalError("Attempt to use unconfigured connector");
            throw new IllegalStateException("Attempt to use unconfigured connector " + ObjectTypeUtil.toShortString((ObjectType)ajc$this.connectorType));
        }
        Uid uid = ajc$this.getUid(identifiers);
        if (uid == null) {
            result.recordFatalError("Required attribute UID not found in identification set while attempting to fetch object identified by " + identifiers + " from " + ObjectTypeUtil.toShortString((ObjectType)ajc$this.connectorType));
            throw new IllegalArgumentException("Required attribute UID not found in identification set while attempting to fetch object identified by " + identifiers + " from " + ObjectTypeUtil.toShortString((ObjectType)ajc$this.connectorType));
        }
        ObjectClass icfObjectClass = ajc$this.objectClassToIcf(objectClassDefinition);
        if (icfObjectClass == null) {
            result.recordFatalError("Unable to detemine object class from QName " + objectClassDefinition.getTypeName() + " while attempting to fetch object identified by " + identifiers + " from " + ObjectTypeUtil.toShortString((ObjectType)ajc$this.connectorType));
            throw new IllegalArgumentException("Unable to detemine object class from QName " + objectClassDefinition.getTypeName() + " while attempting to fetch object identified by " + identifiers + " from " + ObjectTypeUtil.toShortString((ObjectType)ajc$this.connectorType));
        }
        ConnectorObject co = null;
        try {
            co = ajc$this.fetchConnectorObject(icfObjectClass, uid, returnDefaultAttributes, attributesToReturn, result);
        }
        catch (CommunicationException ex) {
            result.recordFatalError("ICF invocation failed due to communication problem");
            throw ex;
        }
        catch (GenericFrameworkException ex) {
            result.recordFatalError("ICF invocation failed due to a generic ICF framework problem");
            throw ex;
        }
        if (co == null) {
            result.recordFatalError("Object not found");
            throw new ObjectNotFoundException("Object identified by " + identifiers + " was not found by " + ObjectTypeUtil.toShortString((ObjectType)ajc$this.connectorType));
        }
        PrismObjectDefinition shadowDefinition = ajc$this.toShadowDefinition(objectClassDefinition);
        PrismObject shadow = ajc$this.convertToResourceObject(co, shadowDefinition, true);
        result.recordSuccess();
        return shadow;
    }

    static final /* synthetic */ Collection addObject_aroundBody12(ConnectorInstanceIcfImpl ajc$this, PrismObject object, Set additionalOperations, OperationResult parentResult, JoinPoint joinPoint) {
        ajc$this.validateShadow((PrismObject<? extends ResourceObjectShadowType>)object, "add", false);
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer((PrismObject)object);
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".addObject");
        result.addParam("resourceObject", (Object)object);
        result.addParam("additionalOperations", (Object)additionalOperations);
        ObjectClass objectClass = ajc$this.objectClassToIcf((PrismObject<? extends ResourceObjectShadowType>)object);
        if (objectClass == null) {
            result.recordFatalError("Couldn't get icf object class from " + object);
            throw new IllegalArgumentException("Couldn't get icf object class from " + object);
        }
        Set<Attribute> attributes = null;
        try {
            AccountShadowType account;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("midPoint object before conversion:\n{}", (Object)attributesContainer.dump());
            }
            attributes = ajc$this.convertFromResourceObject(attributesContainer, result);
            if (object.asObjectable() instanceof AccountShadowType && (account = (AccountShadowType)object.asObjectable()).getCredentials() != null && account.getCredentials().getPassword() != null) {
                PasswordType password = account.getCredentials().getPassword();
                ProtectedStringType protectedString = password.getProtectedString();
                GuardedString guardedPassword = ajc$this.toGuardedString(protectedString, "new password");
                attributes.add(AttributeBuilder.build((String)OperationalAttributes.PASSWORD_NAME, (Object[])new Object[]{guardedPassword}));
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("ICF attributes after conversion:\n{}", (Object)IcfUtil.dump(attributes));
            }
        }
        catch (SchemaException ex) {
            result.recordFatalError("Error while converting resource object attributes. Reason: " + ex.getMessage(), (Throwable)ex);
            throw new SchemaException("Error while converting resource object attributes. Reason: " + ex.getMessage(), (Throwable)ex);
        }
        if (attributes == null) {
            result.recordFatalError("Couldn't set attributes for icf.");
            throw new IllegalStateException("Couldn't set attributes for icf.");
        }
        OperationResult icfResult = result.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".create");
        icfResult.addParam("objectClass", (Object)objectClass);
        icfResult.addParam("attributes", attributes);
        icfResult.addParam("options", null);
        icfResult.addContext("connector", (Object)ajc$this.icfConnectorFacade);
        Uid uid = null;
        try {
            ajc$this.checkAndExecuteAdditionalOperation(additionalOperations, ScriptOrderType.BEFORE);
            uid = ajc$this.icfConnectorFacade.create(objectClass, attributes, new OperationOptionsBuilder().build());
            ajc$this.checkAndExecuteAdditionalOperation(additionalOperations, ScriptOrderType.AFTER);
        }
        catch (Exception ex) {
            Exception midpointEx = IcfUtil.processIcfException(ex, icfResult);
            result.computeStatus("Add object failed");
            if (midpointEx instanceof ObjectAlreadyExistsException) {
                throw (ObjectAlreadyExistsException)((Object)midpointEx);
            }
            if (midpointEx instanceof CommunicationException) {
                throw (CommunicationException)((Object)midpointEx);
            }
            if (midpointEx instanceof GenericFrameworkException) {
                throw (GenericFrameworkException)midpointEx;
            }
            if (midpointEx instanceof SchemaException) {
                throw (SchemaException)((Object)midpointEx);
            }
            if (midpointEx instanceof RuntimeException) {
                throw (RuntimeException)midpointEx;
            }
            throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
        }
        if (uid == null || uid.getUidValue() == null || uid.getUidValue().isEmpty()) {
            icfResult.recordFatalError("ICF did not returned UID after create");
            result.computeStatus("Add object failed");
            throw new GenericFrameworkException("ICF did not returned UID after create");
        }
        ResourceAttributeDefinition uidDefinition = ajc$this.getUidDefinition(attributesContainer.getDefinition());
        if (uidDefinition == null) {
            throw new IllegalArgumentException("No definition for ICF UID attribute found in definition " + attributesContainer.getDefinition());
        }
        ResourceAttribute attribute = ajc$this.createUidAttribute(uid, uidDefinition);
        attributesContainer.getValue().addReplaceExisting((Item)attribute);
        icfResult.recordSuccess();
        result.recordSuccess();
        return attributesContainer.getAttributes();
    }

    static final /* synthetic */ Set modifyObject_aroundBody14(ConnectorInstanceIcfImpl ajc$this, ObjectClassComplexTypeDefinition objectClass, Collection identifiers, Set changes, OperationResult parentResult, JoinPoint joinPoint) {
        HashSet<Operation> additionalOperations;
        String originalUid;
        Uid uid;
        OperationResult result;
        block45: {
            Exception midpointEx;
            OperationOptions options;
            Set<Attribute> attributes;
            OperationResult icfResult;
            PropertyDelta passwordDelta;
            HashSet<PropertyDelta> activationDeltas;
            HashSet valuesToRemove;
            HashSet updateValues;
            ObjectClass objClass;
            block44: {
                result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".modifyObject");
                result.addParam("objectClass", (Object)objectClass);
                result.addParam("identifiers", (Object)identifiers);
                result.addParam("changes", (Object)changes);
                objClass = ajc$this.objectClassToIcf(objectClass);
                uid = ajc$this.getUid(identifiers);
                originalUid = uid.getUidValue();
                HashSet addValues = new HashSet();
                updateValues = new HashSet();
                valuesToRemove = new HashSet();
                additionalOperations = new HashSet<Operation>();
                activationDeltas = new HashSet<PropertyDelta>();
                passwordDelta = null;
                for (Operation operation : changes) {
                    if (operation instanceof PropertyModificationOperation) {
                        PropertyModificationOperation change = (PropertyModificationOperation)operation;
                        PropertyDelta delta = change.getPropertyDelta();
                        if (delta.getParentPath().equals((Object)new PropertyPath(new QName[]{ResourceObjectShadowType.F_ATTRIBUTES}))) {
                            if (delta.getDefinition() == null || !(delta.getDefinition() instanceof ResourceAttributeDefinition)) {
                                ResourceAttributeDefinition def = objectClass.findAttributeDefinition(delta.getName());
                                delta.applyDefinition((ItemDefinition)def);
                            }
                            if (delta.isAdd()) {
                                ResourceAttribute addAttribute = (ResourceAttribute)delta.instantiateEmptyProperty();
                                addAttribute.addValues(delta.getValuesToAdd());
                                addValues.add(addAttribute);
                            }
                            if (delta.isDelete()) {
                                ResourceAttribute deleteAttribute = (ResourceAttribute)delta.instantiateEmptyProperty();
                                deleteAttribute.addValues(delta.getValuesToDelete());
                                valuesToRemove.add(deleteAttribute);
                            }
                            if (!delta.isReplace()) continue;
                            ResourceAttribute updateAttribute = (ResourceAttribute)delta.instantiateEmptyProperty();
                            updateAttribute.addValues(delta.getValuesToReplace());
                            updateValues.add(updateAttribute);
                            continue;
                        }
                        if (delta.getParentPath().equals((Object)new PropertyPath(new QName[]{AccountShadowType.F_ACTIVATION}))) {
                            activationDeltas.add(delta);
                            continue;
                        }
                        if (delta.getParentPath().equals((Object)new PropertyPath(new PropertyPath(new QName[]{AccountShadowType.F_CREDENTIALS}), CredentialsType.F_PASSWORD))) {
                            passwordDelta = delta;
                            continue;
                        }
                        throw new SchemaException("Change of unknown attribute " + delta.getName());
                    }
                    if (operation instanceof PasswordChangeOperation) {
                        PasswordChangeOperation cfr_ignored_0 = (PasswordChangeOperation)operation;
                        continue;
                    }
                    if (operation instanceof ExecuteScriptOperation) {
                        ExecuteScriptOperation scriptOperation = (ExecuteScriptOperation)operation;
                        additionalOperations.add(scriptOperation);
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown operation type " + operation.getClass().getName() + ": " + operation);
                }
                ajc$this.checkAndExecuteAdditionalOperation(additionalOperations, ScriptOrderType.BEFORE);
                icfResult = null;
                try {
                    if (addValues == null || addValues.isEmpty()) break block44;
                    attributes = null;
                    try {
                        attributes = ajc$this.convertFromResourceObject(addValues, result);
                    }
                    catch (SchemaException ex) {
                        result.recordFatalError("Error while converting resource object attributes. Reason: " + ex.getMessage(), (Throwable)ex);
                        throw new SchemaException("Error while converting resource object attributes. Reason: " + ex.getMessage(), (Throwable)ex);
                    }
                    options = new OperationOptionsBuilder().build();
                    icfResult = result.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".addAttributeValues");
                    icfResult.addParam("objectClass", (Object)objectClass);
                    icfResult.addParam("uid", (Object)uid.getUidValue());
                    icfResult.addParam("attributes", attributes);
                    icfResult.addParam("options", (Object)options);
                    icfResult.addContext("connector", (Object)ajc$this.icfConnectorFacade);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Invoking ICF addAttributeValues(), objectclass={}, uid={}, attributes=\n{}", new Object[]{objClass, uid, ajc$this.dumpAttributes(attributes)});
                    }
                    uid = ajc$this.icfConnectorFacade.addAttributeValues(objClass, uid, attributes, options);
                    icfResult.recordSuccess();
                }
                catch (Exception ex) {
                    midpointEx = IcfUtil.processIcfException(ex, icfResult);
                    result.computeStatus("Adding attribute values failed");
                    if (midpointEx instanceof ObjectNotFoundException) {
                        throw (ObjectNotFoundException)((Object)midpointEx);
                    }
                    if (midpointEx instanceof CommunicationException) {
                        throw (CommunicationException)((Object)midpointEx);
                    }
                    if (midpointEx instanceof GenericFrameworkException) {
                        throw (GenericFrameworkException)midpointEx;
                    }
                    if (midpointEx instanceof SchemaException) {
                        throw (SchemaException)((Object)midpointEx);
                    }
                    if (midpointEx instanceof RuntimeException) {
                        throw (RuntimeException)midpointEx;
                    }
                    throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
                }
            }
            if (updateValues != null && !updateValues.isEmpty() || activationDeltas != null || passwordDelta != null) {
                Set<Attribute> updateAttributes = null;
                try {
                    updateAttributes = ajc$this.convertFromResourceObject(updateValues, result);
                }
                catch (SchemaException ex) {
                    result.recordFatalError("Error while converting resource object attributes. Reason: " + ex.getMessage(), (Throwable)ex);
                    throw new SchemaException("Error while converting resource object attributes. Reason: " + ex.getMessage(), (Throwable)ex);
                }
                if (activationDeltas != null) {
                    ajc$this.convertFromActivation(updateAttributes, activationDeltas);
                }
                if (passwordDelta != null) {
                    ajc$this.convertFromPassword(updateAttributes, passwordDelta);
                }
                options = new OperationOptionsBuilder().build();
                icfResult = result.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".update");
                icfResult.addParam("objectClass", (Object)objectClass);
                icfResult.addParam("uid", (Object)uid.getUidValue());
                icfResult.addParam("attributes", updateAttributes);
                icfResult.addParam("options", (Object)options);
                icfResult.addContext("connector", (Object)ajc$this.icfConnectorFacade);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Invoking ICF update(), objectclass={}, uid={}, attributes=\n{}", new Object[]{objClass, uid, ajc$this.dumpAttributes(updateAttributes)});
                }
                try {
                    uid = ajc$this.icfConnectorFacade.update(objClass, uid, updateAttributes, options);
                    icfResult.recordSuccess();
                }
                catch (Exception ex) {
                    Exception midpointEx2 = IcfUtil.processIcfException(ex, icfResult);
                    result.computeStatus("Update failed");
                    if (midpointEx2 instanceof ObjectNotFoundException) {
                        throw (ObjectNotFoundException)((Object)midpointEx2);
                    }
                    if (midpointEx2 instanceof CommunicationException) {
                        throw (CommunicationException)((Object)midpointEx2);
                    }
                    if (midpointEx2 instanceof GenericFrameworkException) {
                        throw (GenericFrameworkException)midpointEx2;
                    }
                    if (midpointEx2 instanceof SchemaException) {
                        throw (SchemaException)((Object)midpointEx2);
                    }
                    if (midpointEx2 instanceof RuntimeException) {
                        throw (RuntimeException)midpointEx2;
                    }
                    throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
                }
            }
            try {
                if (valuesToRemove == null || valuesToRemove.isEmpty()) break block45;
                attributes = null;
                try {
                    attributes = ajc$this.convertFromResourceObject(valuesToRemove, result);
                }
                catch (SchemaException ex) {
                    result.recordFatalError("Error while converting resource object attributes. Reason: " + ex.getMessage(), (Throwable)ex);
                    throw new SchemaException("Error while converting resource object attributes. Reason: " + ex.getMessage(), (Throwable)ex);
                }
                options = new OperationOptionsBuilder().build();
                icfResult = result.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".update");
                icfResult.addParam("objectClass", (Object)objectClass);
                icfResult.addParam("uid", (Object)uid.getUidValue());
                icfResult.addParam("attributes", attributes);
                icfResult.addParam("options", (Object)options);
                icfResult.addContext("connector", (Object)ajc$this.icfConnectorFacade);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Invoking ICF removeAttributeValues(), objectclass={}, uid={}, attributes=\n{}", new Object[]{objClass, uid, ajc$this.dumpAttributes(attributes)});
                }
                uid = ajc$this.icfConnectorFacade.removeAttributeValues(objClass, uid, attributes, options);
                icfResult.recordSuccess();
            }
            catch (Exception ex) {
                midpointEx = IcfUtil.processIcfException(ex, icfResult);
                result.computeStatus("Removing attribute values failed");
                if (midpointEx instanceof ObjectNotFoundException) {
                    throw (ObjectNotFoundException)((Object)midpointEx);
                }
                if (midpointEx instanceof CommunicationException) {
                    throw (CommunicationException)((Object)midpointEx);
                }
                if (midpointEx instanceof GenericFrameworkException) {
                    throw (GenericFrameworkException)midpointEx;
                }
                if (midpointEx instanceof SchemaException) {
                    throw (SchemaException)((Object)midpointEx);
                }
                if (midpointEx instanceof RuntimeException) {
                    throw (RuntimeException)midpointEx;
                }
                throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
            }
        }
        ajc$this.checkAndExecuteAdditionalOperation(additionalOperations, ScriptOrderType.AFTER);
        result.recordSuccess();
        HashSet<PropertyModificationOperation> sideEffectChanges = new HashSet<PropertyModificationOperation>();
        if (!originalUid.equals(uid.getUidValue())) {
            PropertyDelta uidDelta = ajc$this.createUidDelta(uid, ajc$this.getUidDefinition(identifiers));
            PropertyModificationOperation uidMod = new PropertyModificationOperation(uidDelta);
            sideEffectChanges.add(uidMod);
        }
        return sideEffectChanges;
    }

    static final /* synthetic */ void deleteObject_aroundBody16(ConnectorInstanceIcfImpl ajc$this, ObjectClassComplexTypeDefinition objectClass, Set additionalOperations, Collection identifiers, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".deleteObject");
        result.addParam("identifiers", (Object)identifiers);
        ObjectClass objClass = ajc$this.objectClassToIcf(objectClass);
        Uid uid = ajc$this.getUid(identifiers);
        OperationResult icfResult = result.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".delete");
        icfResult.addParam("uid", (Object)uid);
        icfResult.addParam("objectClass", (Object)objClass);
        icfResult.addContext("connector", (Object)ajc$this.icfConnectorFacade);
        try {
            ajc$this.checkAndExecuteAdditionalOperation(additionalOperations, ScriptOrderType.BEFORE);
            ajc$this.icfConnectorFacade.delete(objClass, uid, new OperationOptionsBuilder().build());
            ajc$this.checkAndExecuteAdditionalOperation(additionalOperations, ScriptOrderType.AFTER);
            icfResult.recordSuccess();
        }
        catch (Exception ex) {
            Exception midpointEx = IcfUtil.processIcfException(ex, icfResult);
            result.computeStatus("Removing attribute values failed");
            if (midpointEx instanceof ObjectNotFoundException) {
                throw (ObjectNotFoundException)((Object)midpointEx);
            }
            if (midpointEx instanceof CommunicationException) {
                throw (CommunicationException)((Object)midpointEx);
            }
            if (midpointEx instanceof GenericFrameworkException) {
                throw (GenericFrameworkException)midpointEx;
            }
            if (midpointEx instanceof SchemaException) {
                throw new IllegalArgumentException(midpointEx.getMessage(), midpointEx);
            }
            if (midpointEx instanceof RuntimeException) {
                throw (RuntimeException)midpointEx;
            }
            throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
        }
        result.recordSuccess();
    }

    static final /* synthetic */ PrismProperty deserializeToken_aroundBody18(ConnectorInstanceIcfImpl ajc$this, Object serializedToken, JoinPoint joinPoint) {
        return ajc$this.createTokenProperty(serializedToken);
    }

    static final /* synthetic */ PrismProperty fetchCurrentToken_aroundBody20(ConnectorInstanceIcfImpl ajc$this, ObjectClassComplexTypeDefinition objectClass, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".deleteObject");
        result.addParam("objectClass", (Object)objectClass);
        ObjectClass objClass = ajc$this.objectClassToIcf(objectClass);
        SyncToken syncToken = ajc$this.icfConnectorFacade.getLatestSyncToken(objClass);
        if (syncToken == null) {
            result.recordFatalError("No token found");
            throw new IllegalArgumentException("No token found.");
        }
        PrismProperty<?> property = ajc$this.getToken(syncToken);
        result.recordSuccess();
        return property;
    }

    static final /* synthetic */ List fetchChanges_aroundBody22(ConnectorInstanceIcfImpl ajc$this, ObjectClassComplexTypeDefinition objectClass, PrismProperty lastToken, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult subresult = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".fetchChanges");
        subresult.addContext("objectClass", (Object)objectClass);
        subresult.addParam("lastToken", (Object)lastToken);
        SyncToken syncToken = null;
        try {
            syncToken = ajc$this.getSyncToken(lastToken);
            LOGGER.trace("Sync token created from the property last token: {}", syncToken.getValue());
        }
        catch (SchemaException ex) {
            subresult.recordFatalError(ex.getMessage(), (Throwable)ex);
            throw new SchemaException(ex.getMessage(), (Throwable)ex);
        }
        final ArrayList<SyncDelta> syncDeltas = new ArrayList<SyncDelta>();
        ObjectClass icfObjectClass = ajc$this.objectClassToIcf(objectClass);
        SyncResultsHandler syncHandler = new SyncResultsHandler(){

            public boolean handle(SyncDelta delta) {
                LOGGER.trace("Detected sync delta: {}", (Object)delta);
                return syncDeltas.add(delta);
            }
        };
        OperationResult icfResult = subresult.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".sync");
        icfResult.addContext("connector", (Object)ajc$this.icfConnectorFacade);
        icfResult.addParam("icfObjectClass", (Object)icfObjectClass);
        icfResult.addParam("syncToken", (Object)syncToken);
        icfResult.addParam("syncHandler", (Object)syncHandler);
        try {
            ajc$this.icfConnectorFacade.sync(icfObjectClass, syncToken, syncHandler, new OperationOptionsBuilder().build());
            icfResult.recordSuccess();
            icfResult.addReturn("count", (Object)syncDeltas.size());
        }
        catch (Exception ex) {
            Exception midpointEx = IcfUtil.processIcfException(ex, icfResult);
            subresult.computeStatus();
            if (midpointEx instanceof CommunicationException) {
                throw (CommunicationException)((Object)midpointEx);
            }
            if (midpointEx instanceof GenericFrameworkException) {
                throw (GenericFrameworkException)midpointEx;
            }
            if (midpointEx instanceof SchemaException) {
                throw (SchemaException)((Object)midpointEx);
            }
            if (midpointEx instanceof RuntimeException) {
                throw (RuntimeException)midpointEx;
            }
            throw new SystemException("Got unexpected exception: " + ex.getClass().getName(), (Throwable)ex);
        }
        List<Change> changeList = null;
        try {
            ResourceSchema schema = ajc$this.getResourceSchema(subresult);
            changeList = ajc$this.getChangesFromSyncDeltas(icfObjectClass, syncDeltas, (PrismSchema)schema, subresult);
        }
        catch (SchemaException ex) {
            subresult.recordFatalError(ex.getMessage(), (Throwable)ex);
            throw new SchemaException(ex.getMessage(), (Throwable)ex);
        }
        subresult.recordSuccess();
        subresult.addReturn("count", (Object)(changeList == null ? 0 : changeList.size()));
        return changeList;
    }

    static final /* synthetic */ void test_aroundBody24(ConnectorInstanceIcfImpl ajc$this, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult connectionResult = parentResult.createSubresult(ConnectorTestOperation.CONNECTOR_CONNECTION.getOperation());
        connectionResult.addContext("implementationClass", ConnectorInstance.class);
        connectionResult.addContext("connector", (Object)ajc$this.connectorType);
        try {
            ajc$this.icfConnectorFacade.test();
            connectionResult.recordSuccess();
        }
        catch (UnsupportedOperationException ex) {
            connectionResult.recordStatus(OperationResultStatus.NOT_APPLICABLE, "Operation not supported by the connector", (Throwable)ex);
        }
        catch (Exception ex) {
            IcfUtil.processIcfException(ex, connectionResult);
        }
    }

    static final /* synthetic */ void search_aroundBody26(ConnectorInstanceIcfImpl ajc$this, Class type, ObjectClassComplexTypeDefinition objectClassDefinition, QueryType query, final ResultHandler handler, OperationResult parentResult, JoinPoint joinPoint) {
        final OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorInstance.class.getName()) + ".search");
        result.addParam("objectClass", (Object)objectClassDefinition);
        result.addContext("connector", (Object)ajc$this.connectorType);
        if (objectClassDefinition == null) {
            result.recordFatalError("Object class not defined");
            throw new IllegalArgumentException("objectClass not defined");
        }
        ObjectClass icfObjectClass = ajc$this.objectClassToIcf(objectClassDefinition);
        if (icfObjectClass == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Unable to detemine object class from QName " + objectClassDefinition + " while attempting to search objects by " + ObjectTypeUtil.toShortString((ObjectType)ajc$this.connectorType));
            result.recordFatalError("Unable to detemine object class", (Throwable)ex);
            throw ex;
        }
        final PrismObjectDefinition objectDefinition = ajc$this.toShadowDefinition(objectClassDefinition);
        ResultsHandler icfHandler = new ResultsHandler(){

            public boolean handle(ConnectorObject connectorObject) {
                PrismObject resourceObject;
                try {
                    resourceObject = ConnectorInstanceIcfImpl.this.convertToResourceObject(connectorObject, objectDefinition, true);
                }
                catch (SchemaException e) {
                    throw new IntermediateException(e);
                }
                boolean cont = handler.handle(resourceObject);
                if (!cont) {
                    result.recordPartialError("Stopped on request from the handler");
                }
                return cont;
            }
        };
        OperationResult icfResult = result.createSubresult(String.valueOf(ConnectorFacade.class.getName()) + ".search");
        icfResult.addParam("objectClass", (Object)icfObjectClass);
        icfResult.addContext("connector", ajc$this.icfConnectorFacade.getClass());
        try {
            Element filter;
            Attribute connectorAttribute = null;
            if (query != null && QNameUtil.compareQName((QName)SchemaConstantsGenerated.Q_EQUAL, (Node)(filter = query.getFilter()))) {
                if (filter.getChildNodes().getLength() > 1) {
                    throw new UnsupportedOperationException("Support for only one attribute filter.");
                }
                Node node = filter.getFirstChild();
                if (QNameUtil.compareQName((QName)SchemaConstantsGenerated.Q_VALUE, (Node)node)) {
                    String icfAttrName = ajc$this.convertAttributeNameToIcf(QNameUtil.getNodeQName((Node)node.getFirstChild()), parentResult);
                    Object value = ajc$this.convertValueToIcf(node.getFirstChild().getTextContent(), QNameUtil.getNodeQName((Node)node.getFirstChild()));
                    connectorAttribute = AttributeBuilder.build((String)icfAttrName, (Object[])new Object[]{value});
                }
            }
            EqualsFilter equalsFilter = null;
            if (connectorAttribute != null) {
                equalsFilter = new EqualsFilter(connectorAttribute);
            }
            ajc$this.icfConnectorFacade.search(icfObjectClass, (Filter)equalsFilter, icfHandler, null);
            icfResult.recordSuccess();
        }
        catch (IntermediateException inex) {
            SchemaException ex = (SchemaException)inex.getCause();
            throw ex;
        }
        catch (Exception ex) {
            icfResult.recordFatalError((Throwable)ex);
            result.recordFatalError("ICF invocation failed");
            throw new GenericFrameworkException(ex);
        }
        if (result.isUnknown()) {
            result.recordSuccess();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConnectorInstanceIcfImpl.java", ConnectorInstanceIcfImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "configure", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.prism.PrismContainerValue:com.evolveum.midpoint.schema.result.OperationResult", "configuration:parentResult", "com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ConfigurationException", "void"), 132);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateConnectorSchema", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "", "", "", "com.evolveum.midpoint.prism.schema.PrismSchema"), 213);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "fetchCurrentToken", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition:com.evolveum.midpoint.schema.result.OperationResult", "objectClass:parentResult", "com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException", "com.evolveum.midpoint.prism.PrismProperty"), 1244);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "fetchChanges", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition:com.evolveum.midpoint.prism.PrismProperty:com.evolveum.midpoint.schema.result.OperationResult", "objectClass:lastToken:parentResult", "com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ConfigurationException", "java.util.List"), 1266);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "test", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.schema.result.OperationResult", "parentResult", "", "void"), 1343);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "search", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "java.lang.Class:com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.provisioning.ucf.api.ResultHandler:com.evolveum.midpoint.schema.result.OperationResult", "type:objectClassDefinition:query:handler:parentResult", "com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.SchemaException", "void"), 1364);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.schema.result.OperationResult", "parentResult", "com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.ConfigurationException", "void"), 332);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResourceSchema", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.schema.result.OperationResult", "parentResult", "com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.ConfigurationException", "com.evolveum.midpoint.schema.processor.ResourceSchema"), 393);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCapabilities", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.schema.result.OperationResult", "parentResult", "com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.ConfigurationException", "java.util.Set"), 596);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "fetchObject", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "java.lang.Class:com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition:java.util.Collection:boolean:java.util.Collection:com.evolveum.midpoint.schema.result.OperationResult", "type:objectClassDefinition:identifiers:returnDefaultAttributes:attributesToReturn:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.SchemaException", "com.evolveum.midpoint.prism.PrismObject"), 626);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addObject", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.prism.PrismObject:java.util.Set:com.evolveum.midpoint.schema.result.OperationResult", "object:additionalOperations:parentResult", "com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException", "java.util.Collection"), 754);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "modifyObject", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition:java.util.Collection:java.util.Set:com.evolveum.midpoint.schema.result.OperationResult", "objectClass:identifiers:changes:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException:com.evolveum.midpoint.util.exception.SchemaException", "java.util.Set"), 900);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteObject", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition:java.util.Set:java.util.Collection:com.evolveum.midpoint.schema.result.OperationResult", "objectClass:additionalOperations:identifiers:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException", "void"), 1188);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deserializeToken", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl", "java.lang.Object", "serializedToken", "", "com.evolveum.midpoint.prism.PrismProperty"), 1239);
    }
}

