/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.ucf.impl;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.common.crypto.EncryptionException;
import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.provisioning.ucf.api.ConnectorFactory;
import com.evolveum.midpoint.provisioning.ucf.api.ConnectorInstance;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorFactoryIcfImpl$AjcClosure1;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorFactoryIcfImpl$AjcClosure3;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorInstanceIcfImpl;
import com.evolveum.midpoint.provisioning.ucf.impl.IcfUtil;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.Configuration;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.AuthenticationApiOp;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.SchemaApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.api.operations.ValidateApiOp;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Element;

@Component
public class ConnectorFactoryIcfImpl
implements ConnectorFactory {
    public static final String ICF_FRAMEWORK_URI = "http://midpoint.evolveum.com/xml/ns/public/connector/icf-1";
    public static final String NS_ICF_CONFIGURATION = "http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/connector-schema-2";
    public static final String NS_ICF_SCHEMA = "http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/resource-schema-2";
    public static final String NS_ICF_SCHEMA_PREFIX = "icfs";
    public static final String NS_ICF_RESOURCE_INSTANCE_PREFIX = "ri";
    public static final QName ICFS_NAME;
    public static final QName ICFS_UID;
    public static final QName ICFS_ACCOUNT;
    public static final String ACCOUNT_OBJECT_CLASS_LOCAL_NAME = "AccountObjectClass";
    public static final String GROUP_OBJECT_CLASS_LOCAL_NAME = "GroupObjectClass";
    public static final String CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_ELEMENT_LOCAL_NAME = "configurationProperties";
    public static final QName CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_ELEMENT_QNAME;
    public static final String CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_TYPE_LOCAL_NAME = "ConfigurationPropertiesType";
    public static final QName CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_TYPE_QNAME;
    public static final String CONNECTOR_SCHEMA_CONFIGURATION_TYPE_LOCAL_NAME = "ConfigurationType";
    public static final String CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_XML_ELEMENT_NAME = "connectorPoolConfiguration";
    public static final QName CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_ELEMENT;
    public static final QName CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_TYPE;
    protected static final String CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_MIN_EVICTABLE_IDLE_TIME_MILLIS = "minEvictableIdleTimeMillis";
    public static final String CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_MIN_IDLE = "minIdle";
    public static final String CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_MAX_IDLE = "maxIdle";
    public static final String CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_MAX_OBJECTS = "maxObjects";
    public static final String CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_MAX_WAIT = "maxWait";
    public static final String CONNECTOR_SCHEMA_PRODUCER_BUFFER_SIZE_XML_ELEMENT_NAME = "producerBufferSize";
    public static final QName CONNECTOR_SCHEMA_PRODUCER_BUFFER_SIZE_ELEMENT;
    public static final QName CONNECTOR_SCHEMA_PRODUCER_BUFFER_SIZE_TYPE;
    public static final String CONNECTOR_SCHEMA_TIMEOUTS_XML_ELEMENT_NAME = "timeouts";
    public static final QName CONNECTOR_SCHEMA_TIMEOUTS_ELEMENT;
    public static final QName CONNECTOR_SCHEMA_TIMEOUTS_TYPE;
    static final Map<String, Class<? extends APIOperation>> apiOpMap;
    private static final String ICF_CONFIGURATION_NAMESPACE_PREFIX = "http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/bundle/";
    private static final String CONNECTOR_IDENTIFIER_SEPARATOR = "/";
    private static final Trace LOGGER;
    private ConnectorInfoManagerFactory connectorInfoManagerFactory;
    private ConnectorInfoManager localConnectorInfoManager;
    private Set<URL> bundleURLs;
    private Set<ConnectorType> localConnectorTypes = null;
    @Autowired(required=true)
    MidpointConfiguration midpointConfiguration;
    @Autowired(required=true)
    Protector protector;
    @Autowired(required=true)
    PrismContext prismContext;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ConnectorFactoryIcfImpl.ajc$preClinit();
        ICFS_NAME = new QName(NS_ICF_SCHEMA, "name");
        ICFS_UID = new QName(NS_ICF_SCHEMA, "uid");
        ICFS_ACCOUNT = new QName(NS_ICF_SCHEMA, "account");
        CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_ELEMENT_QNAME = new QName(NS_ICF_CONFIGURATION, CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_ELEMENT_LOCAL_NAME);
        CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_TYPE_QNAME = new QName(NS_ICF_CONFIGURATION, CONNECTOR_SCHEMA_CONFIGURATION_PROPERTIES_TYPE_LOCAL_NAME);
        CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_ELEMENT = new QName(NS_ICF_CONFIGURATION, CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_XML_ELEMENT_NAME);
        CONNECTOR_SCHEMA_CONNECTOR_POOL_CONFIGURATION_TYPE = new QName(NS_ICF_CONFIGURATION, "ConnectorPoolConfigurationType");
        CONNECTOR_SCHEMA_PRODUCER_BUFFER_SIZE_ELEMENT = new QName(NS_ICF_CONFIGURATION, CONNECTOR_SCHEMA_PRODUCER_BUFFER_SIZE_XML_ELEMENT_NAME);
        CONNECTOR_SCHEMA_PRODUCER_BUFFER_SIZE_TYPE = DOMUtil.XSD_INT;
        CONNECTOR_SCHEMA_TIMEOUTS_ELEMENT = new QName(NS_ICF_CONFIGURATION, CONNECTOR_SCHEMA_TIMEOUTS_XML_ELEMENT_NAME);
        CONNECTOR_SCHEMA_TIMEOUTS_TYPE = new QName(NS_ICF_CONFIGURATION, "TimeoutsType");
        apiOpMap = new HashMap<String, Class<? extends APIOperation>>();
        LOGGER = TraceManager.getTrace(ConnectorFactoryIcfImpl.class);
        apiOpMap.put("create", CreateApiOp.class);
        apiOpMap.put("get", GetApiOp.class);
        apiOpMap.put("update", UpdateApiOp.class);
        apiOpMap.put("delete", DeleteApiOp.class);
        apiOpMap.put("test", TestApiOp.class);
        apiOpMap.put("scriptOnConnector", ScriptOnConnectorApiOp.class);
        apiOpMap.put("scriptOnResource", ScriptOnResourceApiOp.class);
        apiOpMap.put("authentication", AuthenticationApiOp.class);
        apiOpMap.put("search", SearchApiOp.class);
        apiOpMap.put("validate", ValidateApiOp.class);
        apiOpMap.put("sync", SyncApiOp.class);
        apiOpMap.put("schema", SchemaApiOp.class);
    }

    @PostConstruct
    public void initialize() {
        this.bundleURLs = new HashSet<URL>();
        Configuration config = this.midpointConfiguration.getConfiguration("midpoint.icf");
        if (config.getBoolean("scanClasspath")) {
            this.bundleURLs.addAll(this.scanClassPathForBundles());
        }
        List dirs = config.getList("scanDirectory");
        for (String dir : dirs) {
            this.bundleURLs.addAll(this.scanDirectory(dir));
        }
        for (URL u : this.bundleURLs) {
            LOGGER.debug("ICF bundle URL : {}", (Object)u);
        }
        this.connectorInfoManagerFactory = ConnectorInfoManagerFactory.getInstance();
    }

    @Override
    public ConnectorInstance createConnectorInstance(ConnectorType connectorType, String namespace) throws ObjectNotFoundException, SchemaException {
        ConnectorType connectorType2 = connectorType;
        String string = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)connectorType2, (Object)string);
        Object[] objectArray = new Object[]{this, connectorType2, string, joinPoint};
        return (ConnectorInstance)MidpointAspect.aspectOf().processUcfNdc(new ConnectorFactoryIcfImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private PrismSchema getConnectorSchema(ConnectorType connectorType, String namespace) throws SchemaException {
        XmlSchemaType xmlSchema = connectorType.getSchema();
        if (xmlSchema == null) {
            return null;
        }
        Element xsdElement = ObjectTypeUtil.findXsdElement((XmlSchemaType)xmlSchema);
        if (xsdElement == null) {
            return null;
        }
        PrismSchema connectorSchema = PrismSchema.parse((Element)xsdElement, (String)connectorType.toString(), (PrismContext)this.prismContext);
        return connectorSchema;
    }

    @Override
    public Set<ConnectorType> listConnectors(ConnectorHostType host, OperationResult parentRestul) throws CommunicationException {
        ConnectorHostType connectorHostType = host;
        OperationResult operationResult = parentRestul;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)connectorHostType, (Object)operationResult);
        Object[] objectArray = new Object[]{this, connectorHostType, operationResult, joinPoint};
        return (Set)MidpointAspect.aspectOf().processUcfNdc(new ConnectorFactoryIcfImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Set<ConnectorType> listLocalConnectors() {
        if (this.localConnectorTypes == null) {
            this.localConnectorTypes = new HashSet<ConnectorType>();
            List connectorInfos = this.getLocalConnectorInfoManager().getConnectorInfos();
            for (ConnectorInfo connectorInfo : connectorInfos) {
                ConnectorType connectorType = this.convertToConnectorType(connectorInfo, null);
                this.localConnectorTypes.add(connectorType);
            }
        }
        return this.localConnectorTypes;
    }

    private Set<ConnectorType> listRemoteConnectors(ConnectorHostType host) {
        ConnectorInfoManager remoteConnectorInfoManager = this.getRemoteConnectorInfoManager(host);
        HashSet<ConnectorType> connectorTypes = new HashSet<ConnectorType>();
        List connectorInfos = remoteConnectorInfoManager.getConnectorInfos();
        for (ConnectorInfo connectorInfo : connectorInfos) {
            ConnectorType connectorType = this.convertToConnectorType(connectorInfo, host);
            connectorTypes.add(connectorType);
        }
        return connectorTypes;
    }

    private ConnectorType convertToConnectorType(ConnectorInfo cinfo, ConnectorHostType hostType) {
        ConnectorType connectorType = new ConnectorType();
        ConnectorKey key = cinfo.getConnectorKey();
        String stringID = this.keyToNamespaceSuffix(key);
        StringBuilder connectorName = new StringBuilder("ICF ");
        connectorName.append(key.getConnectorName());
        if (hostType != null) {
            connectorName.append(" @");
            connectorName.append(hostType.getName());
        }
        connectorType.setName(connectorName.toString());
        connectorType.setFramework(ICF_FRAMEWORK_URI);
        connectorType.setConnectorType(key.getConnectorName());
        connectorType.setNamespace(ICF_CONFIGURATION_NAMESPACE_PREFIX + stringID);
        connectorType.setConnectorVersion(key.getBundleVersion());
        connectorType.setConnectorBundle(key.getBundleName());
        if (hostType != null) {
            if (hostType.getOid() != null) {
                ObjectReferenceType ref = new ObjectReferenceType();
                ref.setOid(hostType.getOid());
                ref.setType(ObjectTypes.CONNECTOR_HOST.getTypeQName());
                connectorType.setConnectorHostRef(ref);
            } else {
                connectorType.setConnectorHost(hostType);
            }
        }
        return connectorType;
    }

    private String keyToNamespaceSuffix(ConnectorKey key) {
        StringBuilder sb = new StringBuilder();
        sb.append(key.getBundleName());
        sb.append(CONNECTOR_IDENTIFIER_SEPARATOR);
        sb.append(key.getConnectorName());
        return sb.toString();
    }

    private ConnectorInfoManager getLocalConnectorInfoManager() {
        if (this.localConnectorInfoManager == null) {
            this.localConnectorInfoManager = this.connectorInfoManagerFactory.getLocalManager(this.bundleURLs.toArray(new URL[0]));
        }
        return this.localConnectorInfoManager;
    }

    private ConnectorInfoManager getRemoteConnectorInfoManager(ConnectorHostType hostType) {
        GuardedString key;
        String hostname = hostType.getHostname();
        int port = Integer.parseInt(hostType.getPort());
        try {
            key = new GuardedString(this.protector.decryptString(hostType.getSharedSecret()).toCharArray());
        }
        catch (EncryptionException e) {
            throw new SystemException("Shared secret decryption error: " + e.getMessage(), (Throwable)e);
        }
        Integer timeout = hostType.getTimeout();
        boolean useSSL = false;
        if (hostType.isProtectConnection() != null) {
            useSSL = hostType.isProtectConnection();
        }
        List trustManagers = this.protector.getTrustManagers();
        RemoteFrameworkConnectionInfo remoteFramewrorkInfo = new RemoteFrameworkConnectionInfo(hostname, port, key, useSSL, trustManagers, timeout.intValue());
        return this.connectorInfoManagerFactory.getRemoteManager(remoteFramewrorkInfo);
    }

    private Set<URL> scanClassPathForBundles() {
        HashSet<URL> bundle = new HashSet<URL>();
        Enumeration<URL> en = null;
        try {
            en = ConnectorFactoryIcfImpl.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException iOException) {
            LOGGER.debug("Error during reding content from class path");
        }
        while (en.hasMoreElements()) {
            URL u = en.nextElement();
            Properties prop = new Properties();
            LOGGER.trace("Scan classloader resource: " + u.toString());
            try {
                InputStream is = u.openStream();
                if (is == null) continue;
                prop.load(is);
            }
            catch (IOException ex) {
                LOGGER.trace("Unable load: " + u + " [" + ex.getMessage() + "]");
            }
            if (prop.get("ConnectorBundle-Name") == null) continue;
            LOGGER.info("Discovered ICF bundle on CLASSPATH: " + prop.get("ConnectorBundle-Name") + " version: " + prop.get("ConnectorBundle-Version"));
            try {
                URL tmp = new URL(u.getPath().split("!")[0]);
                if (this.isThisBundleCompatible(tmp).booleanValue()) {
                    bundle.add(tmp);
                    continue;
                }
                LOGGER.info("Skip loading ICF bundle {} due error occured", (Object)tmp);
            }
            catch (MalformedURLException e) {
                LOGGER.error("This never happend we hope. URL:" + u.getPath(), (Throwable)e);
                throw new SystemException((Throwable)e);
            }
        }
        return bundle;
    }

    private Set<URL> scanDirectory(String path) {
        File[] dirEntries;
        HashSet<URL> bundle = new HashSet<URL>();
        File dir = new File(path);
        if (this.isThisJarFileBundle(dir).booleanValue()) {
            try {
                bundle.add(dir.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.error("This never happend we hope.", (Throwable)e);
                throw new SystemException((Throwable)e);
            }
            return bundle;
        }
        if (!dir.isDirectory()) {
            LOGGER.error("Provided Icf connector path {} is not a directory.", (Object)dir.getAbsolutePath());
        }
        if ((dirEntries = dir.listFiles()) == null) {
            LOGGER.warn("No bundles found in directory {}", (Object)dir.getAbsolutePath());
            return bundle;
        }
        int i = 0;
        while (i < dirEntries.length) {
            if (this.isThisJarFileBundle(dirEntries[i]).booleanValue()) {
                try {
                    if (this.isThisBundleCompatible(dirEntries[i].toURI().toURL()).booleanValue()) {
                        bundle.add(dirEntries[i].toURI().toURL());
                    } else {
                        LOGGER.info("Skip loading budle {} due error occured", (Object)dirEntries[i].toURI().toURL());
                    }
                }
                catch (MalformedURLException e) {
                    LOGGER.error("This never happend we hope.", (Throwable)e);
                    throw new SystemException((Throwable)e);
                }
            }
            ++i;
        }
        return bundle;
    }

    private Boolean isThisBundleCompatible(URL bundleUrl) {
        if (bundleUrl == null) {
            return false;
        }
        try {
            ConnectorInfoManagerFactory.getInstance().getLocalManager(new URL[]{bundleUrl});
        }
        catch (ConfigurationException ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            } else {
                LOGGER.error(ex.getMessage());
            }
            return false;
        }
        return true;
    }

    private Boolean isThisJarFileBundle(File file) {
        InputStream is;
        if (file == null) {
            throw new IllegalArgumentException("No file is providied for bundle test.");
        }
        if (!file.isFile()) {
            LOGGER.debug("This {} is not a file", (Object)file.getAbsolutePath());
            return false;
        }
        Properties prop = new Properties();
        JarFile jar = null;
        try {
            jar = new JarFile(file);
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to read jar file: " + file.getAbsolutePath() + " [" + ex.getMessage() + "]");
            return false;
        }
        try {
            JarEntry entry = new JarEntry("META-INF/MANIFEST.MF");
            is = jar.getInputStream(entry);
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to fine MANIFEST.MF in jar file: " + file.getAbsolutePath() + " [" + ex.getMessage() + "]");
            return false;
        }
        try {
            prop.load(is);
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to parse jar file: " + file.getAbsolutePath() + " [" + ex.getMessage() + "]");
            return false;
        }
        catch (NullPointerException ex) {
            LOGGER.debug("Unable to parse jar file: " + file.getAbsolutePath() + " [" + ex.getMessage() + "]");
            return false;
        }
        if (prop.get("ConnectorBundle-Name") != null) {
            LOGGER.info("Discovered ICF bundle in JAR: " + prop.get("ConnectorBundle-Name") + " version: " + prop.get("ConnectorBundle-Version"));
            return true;
        }
        LOGGER.debug("Provided file {} is not iCF bundle jar", (Object)file.getAbsolutePath());
        return false;
    }

    private ConnectorInfo getConnectorInfo(ConnectorType connectorType) throws ObjectNotFoundException {
        if (!ICF_FRAMEWORK_URI.equals(connectorType.getFramework())) {
            throw new ObjectNotFoundException("Requested connector for framework " + connectorType.getFramework() + " cannot be found in framework " + ICF_FRAMEWORK_URI);
        }
        ConnectorKey key = this.getConnectorKey(connectorType);
        if (connectorType.getConnectorHost() == null && connectorType.getConnectorHostRef() == null) {
            return this.getLocalConnectorInfoManager().findConnectorInfo(key);
        }
        ConnectorHostType host = connectorType.getConnectorHost();
        if (host == null) {
            throw new ObjectNotFoundException("Attempt to use remote connector without ConnectorHostType resolved (there is only ConnectorHostRef");
        }
        return this.getRemoteConnectorInfoManager(host).findConnectorInfo(key);
    }

    private ConnectorKey getConnectorKey(ConnectorType connectorType) {
        return new ConnectorKey(connectorType.getConnectorBundle(), connectorType.getConnectorVersion(), connectorType.getConnectorType());
    }

    static Class<? extends APIOperation> resolveApiOpClass(String opName) {
        return apiOpMap.get(opName);
    }

    static final /* synthetic */ ConnectorInstance createConnectorInstance_aroundBody0(ConnectorFactoryIcfImpl ajc$this, ConnectorType connectorType, String namespace, JoinPoint joinPoint) {
        ConnectorInfo cinfo = ajc$this.getConnectorInfo(connectorType);
        if (cinfo == null) {
            LOGGER.error("Failed to instantiate {}", (Object)ObjectTypeUtil.toShortString((ObjectType)connectorType));
            LOGGER.debug("Connector key: {}, host: {}", (Object)ajc$this.getConnectorKey(connectorType), (Object)ObjectTypeUtil.toShortString((ObjectType)connectorType));
            LOGGER.trace("Connector object: {}", (Object)ObjectTypeUtil.dump((ObjectType)connectorType));
            LOGGER.trace("Connector host object: {}", (Object)ObjectTypeUtil.dump((ObjectType)connectorType.getConnectorHost()));
            throw new ObjectNotFoundException("The classes (JAR) of " + ObjectTypeUtil.toShortString((ObjectType)connectorType) + " were not found by the ICF framework; connector type=" + connectorType.getConnectorType() + ", version=" + connectorType.getConnectorVersion());
        }
        PrismSchema connectorSchema = ajc$this.getConnectorSchema(connectorType, namespace);
        ConnectorInstanceIcfImpl connectorImpl = new ConnectorInstanceIcfImpl(cinfo, connectorType, namespace, connectorSchema, ajc$this.protector, ajc$this.prismContext);
        return connectorImpl;
    }

    static final /* synthetic */ Set listConnectors_aroundBody2(ConnectorFactoryIcfImpl ajc$this, ConnectorHostType host, OperationResult parentRestul, JoinPoint joinPoint) {
        OperationResult result = parentRestul.createSubresult(ConnectorFactory.OPERATION_LIST_CONNECTOR);
        result.addContext("implementationClass", ConnectorFactoryIcfImpl.class);
        result.addParam("host", (Object)host);
        try {
            if (host == null) {
                Set<ConnectorType> connectors = ajc$this.listLocalConnectors();
                result.recordSuccess();
                return connectors;
            }
            Set<ConnectorType> connectors = ajc$this.listRemoteConnectors(host);
            result.recordSuccess();
            return connectors;
        }
        catch (Exception icfException) {
            Exception ex = IcfUtil.processIcfException(icfException, result);
            result.recordFatalError(ex.getMessage(), (Throwable)ex);
            if (ex instanceof CommunicationException) {
                throw (CommunicationException)((Object)ex);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new SystemException("Unexpected ICF exception: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConnectorFactoryIcfImpl.java", ConnectorFactoryIcfImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createConnectorInstance", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorFactoryIcfImpl", "com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType:java.lang.String", "connectorType:namespace", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException", "com.evolveum.midpoint.provisioning.ucf.api.ConnectorInstance"), 213);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listConnectors", "com.evolveum.midpoint.provisioning.ucf.impl.ConnectorFactoryIcfImpl", "com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType:com.evolveum.midpoint.schema.result.OperationResult", "host:parentRestul", "com.evolveum.midpoint.util.exception.CommunicationException", "java.util.Set"), 257);
    }
}

