/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.ucf.api;

import com.evolveum.midpoint.provisioning.ucf.api.Operation;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;

public class PasswordChangeOperation
extends Operation {
    private ProtectedStringType newPassword;
    private ProtectedStringType oldPassword;

    public PasswordChangeOperation(ProtectedStringType newPassword) {
        this.newPassword = newPassword;
    }

    public PasswordChangeOperation(ProtectedStringType newPassword, ProtectedStringType oldPassword) {
        this.newPassword = newPassword;
        this.oldPassword = oldPassword;
    }

    public ProtectedStringType getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(ProtectedStringType newPassword) {
        this.newPassword = newPassword;
    }

    public ProtectedStringType getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(ProtectedStringType oldPassword) {
        this.oldPassword = oldPassword;
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append("Password change: new password ");
        this.appendPasswordDescription(sb, this.newPassword);
        sb.append("; old password ");
        this.appendPasswordDescription(sb, this.oldPassword);
        return sb.toString();
    }

    private void appendPasswordDescription(StringBuilder sb, ProtectedStringType passwd) {
        if (passwd != null) {
            sb.append("present");
            if (passwd.getClearValue() != null) {
                sb.append(" in clear");
                if (passwd.getClearValue().isEmpty()) {
                    sb.append(" and empty");
                }
            }
            if (passwd.getEncryptedData() != null) {
                sb.append(" encrypted");
            }
        } else {
            sb.append("null");
        }
    }
}

