/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.impl;

import com.evolveum.midpoint.common.ResourceObjectPattern;
import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ContainerDelta;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.provisioning.api.GenericConnectorException;
import com.evolveum.midpoint.provisioning.impl.ConnectorTypeManager;
import com.evolveum.midpoint.provisioning.impl.ResourceTypeManager;
import com.evolveum.midpoint.provisioning.ucf.api.Change;
import com.evolveum.midpoint.provisioning.ucf.api.ConnectorInstance;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.provisioning.ucf.api.Operation;
import com.evolveum.midpoint.provisioning.ucf.api.PropertyModificationOperation;
import com.evolveum.midpoint.provisioning.util.ShadowCacheUtil;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainer;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceSchema;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.MiscSchemaUtil;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.ActivationCapabilityType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShadowConverter {
    @Autowired
    private ConnectorTypeManager connectorTypeManager;
    @Autowired
    private ResourceTypeManager resourceTypeManager;
    @Autowired(required=true)
    private PrismContext prismContext;
    private static final Trace LOGGER = TraceManager.getTrace(ShadowConverter.class);

    public ConnectorTypeManager getConnectorTypeManager() {
        return this.connectorTypeManager;
    }

    public void setConnectorTypeManager(ConnectorTypeManager connectorTypeManager) {
        this.connectorTypeManager = connectorTypeManager;
    }

    public ResourceTypeManager getResourceTypeManager() {
        return this.resourceTypeManager;
    }

    public void setResourceTypeManager(ResourceTypeManager resourceTypeManager) {
        this.resourceTypeManager = resourceTypeManager;
    }

    public <T extends ResourceObjectShadowType> T getShadow(Class<T> type, ResourceType resource, T repoShadow, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        ConnectorInstance connector = this.getConnectorInstance(resource, parentResult);
        ResourceSchema schema = this.resourceTypeManager.getResourceSchema(resource, connector, parentResult);
        QName objectClass = repoShadow.getObjectClass();
        ObjectClassComplexTypeDefinition objectClassDefinition = schema.findObjectClassDefinition(objectClass);
        ResourceObjectShadowUtil.fixShadow((PrismObject)repoShadow.asPrismObject(), (ResourceSchema)schema);
        if (objectClassDefinition == null) {
            SchemaException ex = new SchemaException("Object class " + objectClass + " defined in the repository shadow is not known in schema of resource " + ObjectTypeUtil.toShortString((ObjectType)resource));
            parentResult.recordFatalError("Object class " + objectClass + " defined in the repository shadow is not known in resource schema", (Throwable)ex);
            throw ex;
        }
        Collection identifiers = ResourceObjectShadowUtil.getIdentifiers(repoShadow);
        if (identifiers == null || identifiers.isEmpty()) {
            if (repoShadow.getFailedOperationType() != null) {
                throw new CommunicationException("Error communicating with connector");
            }
            SchemaException ex = new SchemaException("No identifiers found in the respository shadow " + ObjectTypeUtil.toShortString(repoShadow) + " with respect to resource " + ObjectTypeUtil.toShortString((ObjectType)resource));
            parentResult.recordFatalError("No identifiers found in the respository shadow " + ObjectTypeUtil.toShortString(repoShadow), (Throwable)ex);
            throw ex;
        }
        Collection attributes = ResourceObjectShadowUtil.getAttributes(repoShadow);
        if (this.isProtectedShadow(resource, objectClassDefinition, attributes)) {
            LOGGER.error("Attempt to fetch protected resource object " + objectClassDefinition + ": " + identifiers + "; ignoring the request");
            throw new SecurityViolationException("Cannot get protected resource object " + objectClassDefinition + ": " + identifiers);
        }
        T resourceShadow = this.fetchResourceObject(type, objectClassDefinition, identifiers, connector, resource, parentResult);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Shadow from repository:\n{}", (Object)repoShadow.asPrismObject().dump());
            LOGGER.trace("Resource object fetched from resource:\n{}", (Object)resourceShadow.asPrismObject().dump());
        }
        T resultShadow = ShadowCacheUtil.completeShadow(resourceShadow, repoShadow, resource, parentResult);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Shadow when assembled:\n", (Object)ObjectTypeUtil.dump(resultShadow));
        }
        parentResult.recordSuccess();
        return resultShadow;
    }

    public ResourceType completeResource(ResourceType resource, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException {
        return this.resourceTypeManager.completeResource(resource, null, parentResult);
    }

    public ResourceObjectShadowType addShadow(ResourceType resource, ResourceObjectShadowType shadowType, Set<Operation> additionalOperations, boolean isReconciled, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ObjectAlreadyExistsException, ConfigurationException, SecurityViolationException {
        ConnectorInstance connector = this.getConnectorInstance(resource, parentResult);
        ResourceSchema resourceSchema = this.resourceTypeManager.getResourceSchema(resource, connector, parentResult);
        Collection<ResourceAttribute<?>> resourceAttributesAfterAdd = null;
        PrismObject shadow = shadowType.asPrismObject();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Shadow before conversion:\n{}", (Object)shadow.dump());
        }
        ResourceObjectShadowUtil.fixShadow((PrismObject)shadow, (ResourceSchema)resourceSchema);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Shadow after conversion:\n{}", (Object)shadow.dump());
        }
        if (this.isProtectedShadow(resource, shadow)) {
            LOGGER.error("Attempt to add protected shadow " + shadowType + "; ignoring the request");
            throw new SecurityViolationException("Cannot get protected shadow " + shadowType);
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connector for resource {}\n ADD object:\n{}\n additional operations:\n{}", new Object[]{resource.asPrismObject(), shadowType.asPrismObject().debugDump(), SchemaDebugUtil.debugDump(additionalOperations)});
            }
            resourceAttributesAfterAdd = connector.addObject((PrismObject<? extends ResourceObjectShadowType>)shadow, additionalOperations, parentResult);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connector ADD successful, returned attributes:\n{}", (Object)SchemaDebugUtil.prettyPrint(resourceAttributesAfterAdd));
            }
            this.applyAfterOperationAttributes(shadowType, resourceAttributesAfterAdd);
        }
        catch (CommunicationException ex) {
            parentResult.recordFatalError("Error communitacing with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
            throw new CommunicationException("Error communitacing with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
        }
        catch (GenericFrameworkException ex) {
            parentResult.recordFatalError("Generic error in connector: " + ex.getMessage(), (Throwable)ex);
            throw new GenericConnectorException("Generic error in connector: " + ex.getMessage(), (Throwable)ex);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Shadow being stored:\n{}", (Object)shadowType.asPrismObject().dump());
        }
        if (!isReconciled) {
            shadowType = ShadowCacheUtil.createRepositoryShadow(shadowType, resource);
        }
        parentResult.recordSuccess();
        return shadowType;
    }

    public void deleteShadow(ResourceType resource, ResourceObjectShadowType shadow, Set<Operation> additionalOperations, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        ConnectorInstance connector = this.getConnectorInstance(resource, parentResult);
        ResourceSchema schema = this.resourceTypeManager.getResourceSchema(resource, connector, parentResult);
        ObjectClassComplexTypeDefinition objectClassDefinition = schema.findObjectClassDefinition(shadow.getObjectClass());
        ResourceObjectShadowUtil.fixShadow((PrismObject)shadow.asPrismObject(), (ResourceSchema)schema);
        LOGGER.trace("Getting object identifiers");
        Collection identifiers = ResourceObjectShadowUtil.getIdentifiers((ResourceObjectShadowType)shadow);
        Collection attributes = ResourceObjectShadowUtil.getAttributes((ResourceObjectShadowType)shadow);
        if (this.isProtectedShadow(resource, objectClassDefinition, attributes)) {
            LOGGER.error("Attempt to delete protected resource object " + objectClassDefinition + ": " + identifiers + "; ignoring the request");
            throw new SecurityViolationException("Cannot delete protected resource object " + objectClassDefinition + ": " + identifiers);
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connector for resource {}\n DELETE object, object class {}, identified by:\n{}\n additional operations:\n{}", new Object[]{ObjectTypeUtil.toShortString((ObjectType)resource), shadow.getObjectClass(), SchemaDebugUtil.debugDump((Collection)identifiers), SchemaDebugUtil.debugDump(additionalOperations)});
            }
            connector.deleteObject(objectClassDefinition, additionalOperations, identifiers, parentResult);
            LOGGER.debug("Connector DELETE successful");
            parentResult.recordSuccess();
        }
        catch (ObjectNotFoundException ex) {
            parentResult.recordFatalError("Can't delete object " + ObjectTypeUtil.toShortString((ObjectType)shadow) + ". Reason: " + ex.getMessage(), (Throwable)ex);
            throw new ObjectNotFoundException("An error occured while deleting resource object " + shadow + "whith identifiers " + identifiers + ": " + ex.getMessage(), (Throwable)ex);
        }
        catch (CommunicationException ex) {
            parentResult.recordFatalError("Error communicating with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
            throw new CommunicationException("Error communitacing with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
        }
        catch (GenericFrameworkException ex) {
            parentResult.recordFatalError("Generic error in connector: " + ex.getMessage(), (Throwable)ex);
            throw new GenericConnectorException("Generic error in connector: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Set<PropertyModificationOperation> modifyShadow(ResourceType resource, ResourceObjectShadowType shadow, Set<Operation> operations, String oid, Collection<? extends ItemDelta> objectChanges, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        ConnectorInstance connector = this.getConnectorInstance(resource, parentResult);
        ResourceSchema schema = this.resourceTypeManager.getResourceSchema(resource, connector, parentResult);
        ObjectClassComplexTypeDefinition objectClassDefinition = schema.findObjectClassDefinition(shadow.getObjectClass());
        ResourceObjectShadowUtil.fixShadow((PrismObject)shadow.asPrismObject(), (ResourceSchema)schema);
        ResourceAttributeContainerDefinition resourceAttributeDefinition = ResourceObjectShadowUtil.getObjectClassDefinition((ResourceObjectShadowType)shadow);
        if (shadow instanceof AccountShadowType) {
            Operation activationOperation;
            Operation passwordChangeOp = this.determinePasswordChange(objectChanges, shadow);
            if (passwordChangeOp != null) {
                operations.add(passwordChangeOp);
            }
            if ((activationOperation = this.determineActivationChange(objectChanges, resource, resourceAttributeDefinition)) != null) {
                operations.add(activationOperation);
            }
        }
        Collection identifiers = ResourceObjectShadowUtil.getIdentifiers((ResourceObjectShadowType)shadow);
        Collection attributes = ResourceObjectShadowUtil.getAttributes((ResourceObjectShadowType)shadow);
        if (this.isProtectedShadow(resource, objectClassDefinition, attributes)) {
            LOGGER.error("Attempt to modify protected resource object " + objectClassDefinition + ": " + identifiers + "; ignoring the request");
            throw new SecurityViolationException("Cannot modify protected resource object " + objectClassDefinition + ": " + identifiers);
        }
        this.getAttributeChanges(objectChanges, operations, objectClassDefinition);
        Set<PropertyModificationOperation> sideEffectChanges = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connector for resource {}\n MODIFY object, object class {}, identified by:\n{}\n changes:\n{}", new Object[]{ObjectTypeUtil.toShortString((ObjectType)resource), shadow.getObjectClass(), SchemaDebugUtil.debugDump((Collection)identifiers), SchemaDebugUtil.debugDump(operations)});
            }
            if (identifiers.isEmpty() && shadow.getFailedOperationType() != null) {
                throw new CommunicationException("Error communicating with connector");
            }
            sideEffectChanges = connector.modifyObject(objectClassDefinition, identifiers, operations, parentResult);
            LOGGER.debug("Connector MODIFY successful, side-effect changes {}", (Object)SchemaDebugUtil.debugDump(sideEffectChanges));
        }
        catch (ObjectNotFoundException ex) {
            parentResult.recordFatalError("Object to modify not found. Reason: " + ex.getMessage(), (Throwable)ex);
            throw new ObjectNotFoundException("Object to modify not found. " + ex.getMessage(), (Throwable)ex);
        }
        catch (CommunicationException ex) {
            parentResult.recordFatalError("Error communicationg with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
            throw new CommunicationException("Error comminicationg with connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
        }
        catch (GenericFrameworkException ex) {
            parentResult.recordFatalError("Generic error in the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
            throw new CommunicationException("Error comminicationg with connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
        }
        parentResult.recordSuccess();
        return sideEffectChanges;
    }

    public PrismProperty fetchCurrentToken(ResourceType resourceType, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException {
        Validate.notNull((Object)resourceType, (String)"Resource must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        LOGGER.trace("Getting last token");
        ConnectorInstance connector = this.getConnectorInstance(resourceType, parentResult);
        ResourceSchema resourceSchema = RefinedResourceSchema.getResourceSchema((ResourceType)resourceType, (PrismContext)this.prismContext);
        ObjectClassComplexTypeDefinition objectClass = resourceSchema.findDefaultAccountDefinition();
        PrismProperty<?> lastToken = null;
        try {
            lastToken = connector.fetchCurrentToken(objectClass, parentResult);
        }
        catch (GenericFrameworkException e) {
            parentResult.recordFatalError("Generic error in the connector: " + e.getMessage(), (Throwable)e);
            throw new CommunicationException("Generic error in the connector: " + e.getMessage(), (Throwable)e);
        }
        catch (CommunicationException ex) {
            parentResult.recordFatalError("Error communicating with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
            throw new CommunicationException("Error communicating with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
        }
        LOGGER.trace("Got last token: {}", (Object)SchemaDebugUtil.prettyPrint(lastToken));
        parentResult.recordSuccess();
        return lastToken;
    }

    public List<Change> fetchChanges(ResourceType resource, PrismProperty lastToken, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException {
        Validate.notNull((Object)resource, (String)"Resource must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        Validate.notNull((Object)lastToken, (String)"Token property must not be null.");
        LOGGER.trace("Shadow converter, START fetch changes");
        ConnectorInstance connector = this.getConnectorInstance(resource, parentResult);
        ResourceSchema resourceSchema = RefinedResourceSchema.getResourceSchema((ResourceType)resource, (PrismContext)this.prismContext);
        ObjectClassComplexTypeDefinition objectClass = resourceSchema.findDefaultAccountDefinition();
        List<Change> changes = null;
        try {
            changes = connector.fetchChanges(objectClass, lastToken, parentResult);
        }
        catch (SchemaException ex) {
            parentResult.recordFatalError("Schema error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            parentResult.recordFatalError("Communication error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (GenericFrameworkException ex) {
            parentResult.recordFatalError("Generic error: " + ex.getMessage(), (Throwable)ex);
            throw new GenericConnectorException(ex.getMessage(), (Throwable)ex);
        }
        catch (ConfigurationException ex) {
            parentResult.recordFatalError("Configuration error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        Iterator<Change> iterator = changes.iterator();
        while (iterator.hasNext()) {
            Change change = iterator.next();
            if (!this.isProtectedShadowChange(resource, change)) continue;
            LOGGER.trace("Skipping change to a protected object: {}", (Object)change);
            iterator.remove();
        }
        parentResult.recordSuccess();
        LOGGER.trace("Shadow converter, END fetch changes");
        return changes;
    }

    public ResourceObjectShadowType createNewAccountFromChange(Change change, ResourceType resource, OperationResult parentResult) throws SchemaException, ObjectNotFoundException, CommunicationException, GenericFrameworkException, ConfigurationException, SecurityViolationException {
        ConnectorInstance connector = this.getConnectorInstance(resource, parentResult);
        ResourceSchema schema = this.resourceTypeManager.getResourceSchema(resource, connector, parentResult);
        ObjectClassComplexTypeDefinition rod = schema.findObjectClassDefinition(new QName(ResourceTypeUtil.getResourceNamespace((ResourceType)resource), "AccountObjectClass"));
        ResourceObjectShadowType shadow = null;
        try {
            shadow = this.fetchResourceObject(ResourceObjectShadowType.class, rod, change.getIdentifiers(), connector, resource, parentResult);
        }
        catch (ObjectNotFoundException ex) {
            parentResult.recordPartialError("Object detected in change log no longer exist on the resource. Skipping processing this object.");
            LOGGER.warn("Object detected in change log no longer exist on the resource. Skipping processing this object " + ex.getMessage());
            return null;
        }
        try {
            shadow = ShadowCacheUtil.completeShadow(shadow, null, resource, parentResult);
            shadow = ShadowCacheUtil.createRepositoryShadow(shadow, resource);
        }
        catch (SchemaException schemaException) {
            parentResult.recordFatalError("Can't create account shadow from identifiers: " + change.getIdentifiers());
            throw new SchemaException("Can't create account shadow from identifiers: " + change.getIdentifiers());
        }
        parentResult.recordSuccess();
        return shadow;
    }

    private <T extends ResourceObjectShadowType> T fetchResourceObject(Class<T> type, ObjectClassComplexTypeDefinition objectClassDefinition, Collection<? extends ResourceAttribute<?>> identifiers, ConnectorInstance connector, ResourceType resource, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, SecurityViolationException {
        if (this.isProtectedShadow(resource, objectClassDefinition, identifiers)) {
            LOGGER.error("Attempt to fetch protected resource object " + objectClassDefinition + ": " + identifiers + "; ignoring the request");
            throw new SecurityViolationException("Cannot get protected resource object " + objectClassDefinition + ": " + identifiers);
        }
        try {
            PrismObject<T> resourceObject = connector.fetchObject(type, objectClassDefinition, identifiers, true, null, parentResult);
            return (T)((ResourceObjectShadowType)resourceObject.asObjectable());
        }
        catch (ObjectNotFoundException e) {
            parentResult.recordFatalError("Object not found. Identifiers: " + identifiers + ". Reason: " + e.getMessage(), (Throwable)e);
            throw new ObjectNotFoundException("Object not found. Identifiers: " + identifiers + ". Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (CommunicationException e) {
            parentResult.recordFatalError("Error communication with the connector " + connector + ". Reason: " + e.getMessage(), (Throwable)e);
            throw new CommunicationException("Error communication with the connector " + connector + ". Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (GenericFrameworkException e) {
            parentResult.recordFatalError("Generic error in the connector " + connector + ". Reason: " + e.getMessage(), (Throwable)e);
            throw new GenericConnectorException("Generic error in the connector " + connector + ". Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (SchemaException ex) {
            parentResult.recordFatalError("Can't get resource schema. Reason: " + ex.getMessage(), (Throwable)ex);
            throw new SchemaException("Can't get resource schema. Reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void applyAfterOperationAttributes(ResourceObjectShadowType shadow, Collection<ResourceAttribute<?>> resourceAttributesAfterAdd) throws SchemaException {
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer((ResourceObjectShadowType)shadow);
        for (ResourceAttribute<?> attributeAfter : resourceAttributesAfterAdd) {
            ResourceAttribute attributeBefore = attributesContainer.findAttribute(attributeAfter.getName());
            if (attributeBefore != null) {
                attributesContainer.remove((Item)attributeBefore);
            }
            attributesContainer.add(attributeAfter);
        }
    }

    private ConnectorInstance getConnectorInstance(ResourceType resource, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException {
        return this.connectorTypeManager.getConfiguredConnectorInstance(resource, parentResult);
    }

    private Operation determineActivationChange(Collection<? extends ItemDelta> objectChange, ResourceType resource, ResourceAttributeContainerDefinition objectClassDefinition) throws SchemaException {
        PropertyDelta enabledPropertyDelta = PropertyDelta.findPropertyDelta(objectChange, (PropertyPath)new PropertyPath(new QName[]{ResourceObjectShadowType.F_ACTIVATION, ActivationType.F_ENABLED}));
        if (enabledPropertyDelta == null) {
            return null;
        }
        Boolean enabled = (Boolean)enabledPropertyDelta.getPropertyNew().getRealValue();
        LOGGER.trace("Find activation change to: {}", (Object)enabled);
        if (enabled != null) {
            LOGGER.trace("enabled not null.");
            if (!ResourceTypeUtil.hasResourceNativeActivationCapability((ResourceType)resource)) {
                PropertyModificationOperation activationAttribute = this.convertToActivationAttribute(resource, enabled, objectClassDefinition);
                return activationAttribute;
            }
            return new PropertyModificationOperation(enabledPropertyDelta);
        }
        return null;
    }

    private Operation determinePasswordChange(Collection<? extends ItemDelta> objectChange, ResourceObjectShadowType objectType) throws SchemaException {
        PropertyDelta passwordPropertyDelta = PropertyDelta.findPropertyDelta(objectChange, (PropertyPath)new PropertyPath(new QName[]{AccountShadowType.F_CREDENTIALS, CredentialsType.F_PASSWORD}));
        if (passwordPropertyDelta == null) {
            return null;
        }
        PasswordType newPasswordStructure = (PasswordType)passwordPropertyDelta.getPropertyNew().getRealValue();
        PropertyModificationOperation passwordChangeOp = null;
        if (newPasswordStructure != null) {
            ProtectedStringType newPasswordPS = newPasswordStructure.getProtectedString();
            if (MiscSchemaUtil.isNullOrEmpty((ProtectedStringType)newPasswordPS)) {
                throw new IllegalArgumentException("ProtectedString is empty in an attempt to change password of " + ObjectTypeUtil.toShortString((ObjectType)objectType));
            }
            passwordChangeOp = new PropertyModificationOperation(passwordPropertyDelta);
        }
        return passwordChangeOp;
    }

    private void getAttributeChanges(Collection<? extends ItemDelta> objectChange, Set<Operation> changes, ObjectClassComplexTypeDefinition rod) throws SchemaException {
        if (changes == null) {
            changes = new HashSet<Operation>();
        }
        for (ItemDelta itemDelta : objectChange) {
            if (itemDelta instanceof PropertyDelta) {
                if (itemDelta.getParentPath().equals((Object)new PropertyPath(new QName[]{ResourceObjectShadowType.F_ACTIVATION}))) continue;
                PropertyModificationOperation attributeModification = new PropertyModificationOperation((PropertyDelta)itemDelta);
                changes.add(attributeModification);
                continue;
            }
            if (itemDelta instanceof ContainerDelta) continue;
            throw new UnsupportedOperationException("Not supported delta: " + itemDelta);
        }
    }

    private PropertyModificationOperation convertToActivationAttribute(ResourceType resource, Boolean enabled, ResourceAttributeContainerDefinition objectClassDefinition) throws SchemaException {
        ActivationCapabilityType activationCapability = (ActivationCapabilityType)ResourceTypeUtil.getEffectiveCapability((ResourceType)resource, ActivationCapabilityType.class);
        if (activationCapability == null) {
            throw new SchemaException("Resource " + ObjectTypeUtil.toShortString((ObjectType)resource) + " does not have native or simulated activation capability");
        }
        ActivationCapabilityType.EnableDisable enableDisable = activationCapability.getEnableDisable();
        if (enableDisable == null) {
            throw new SchemaException("Resource " + ObjectTypeUtil.toShortString((ObjectType)resource) + " does not have native or simulated activation/enableDisable capability");
        }
        QName enableAttributeName = enableDisable.getAttribute();
        LOGGER.debug("Simulated attribute name: {}", (Object)enableAttributeName);
        if (enableAttributeName == null) {
            throw new SchemaException("Resource " + ObjectTypeUtil.toShortString((ObjectType)resource) + " does not have attribute specification for simulated activation/enableDisable capability");
        }
        ResourceAttributeDefinition enableAttributeDefinition = objectClassDefinition.findAttributeDefinition(enableAttributeName);
        if (enableAttributeDefinition == null) {
            throw new SchemaException("Resource " + ObjectTypeUtil.toShortString((ObjectType)resource) + "  attribute for simulated activation/enableDisable capability" + enableAttributeName + " in not present in the schema for objeclass " + objectClassDefinition);
        }
        PropertyDelta enableAttributeDelta = new PropertyDelta(new PropertyPath(new QName[]{ResourceObjectShadowType.F_ATTRIBUTES, enableAttributeName}), (PrismPropertyDefinition)enableAttributeDefinition);
        List enableValues = enableDisable.getEnableValue();
        Iterator i = enableValues.iterator();
        String enableValue = (String)i.next();
        if ("".equals(enableValue)) {
            enableValue = enableValues.size() < 2 ? "false" : (String)i.next();
        }
        String disableValue = (String)enableDisable.getDisableValue().iterator().next();
        if (enabled.booleanValue()) {
            LOGGER.trace("enable attribute delta: {}", (Object)enableValue);
            enableAttributeDelta.setValueToReplace((PrismValue)new PrismPropertyValue((Object)enableValue));
        } else {
            LOGGER.trace("enable attribute delta: {}", (Object)disableValue);
            enableAttributeDelta.setValueToReplace((PrismValue)new PrismPropertyValue((Object)disableValue));
        }
        PropertyModificationOperation attributeChange = new PropertyModificationOperation(enableAttributeDelta);
        return attributeChange;
    }

    public <T extends ResourceObjectShadowType> boolean isProtectedShadow(ResourceType resource, PrismObject<T> shadow) throws SchemaException {
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer(shadow);
        QName objectClass = ((ResourceObjectShadowType)shadow.asObjectable()).getObjectClass();
        Collection attributes = attributesContainer.getAttributes();
        return this.isProtectedShadow(resource, objectClass, attributes);
    }

    public boolean isProtectedShadow(ResourceType resource, ObjectClassComplexTypeDefinition objectClassDefinition, Collection<? extends ResourceAttribute<?>> attributes) throws SchemaException {
        return this.isProtectedShadow(resource, objectClassDefinition.getTypeName(), attributes);
    }

    private boolean isProtectedShadowChange(ResourceType resource, Change change) throws SchemaException {
        PrismObject<? extends ResourceObjectShadowType> currentShadow = change.getCurrentShadow();
        if (currentShadow != null) {
            return this.isProtectedShadow(resource, currentShadow);
        }
        Collection<ResourceAttribute<?>> identifiers = change.getIdentifiers();
        return this.isProtectedShadow(resource, change.getObjectClassDefinition().getTypeName(), identifiers);
    }

    private boolean isProtectedShadow(ResourceType resource, QName objectClass, Collection<? extends ResourceAttribute<?>> attributes) throws SchemaException {
        RefinedResourceSchema refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)resource, (PrismContext)this.prismContext);
        RefinedAccountDefinition refinedAccountDef = refinedSchema.findAccountDefinitionByObjectClass(objectClass);
        LOGGER.trace("isProtectedShadow: {} -> {}, {}", new Object[]{objectClass, refinedAccountDef, attributes});
        if (refinedAccountDef == null) {
            return false;
        }
        Collection protectedAccountPatterns = refinedAccountDef.getProtectedAccounts();
        if (protectedAccountPatterns == null) {
            return false;
        }
        return ResourceObjectPattern.matches(attributes, (Collection)protectedAccountPatterns);
    }
}

