/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.server.ConnectorServer;
import org.identityconnectors.framework.server.impl.CCLWatchThread;
import org.identityconnectors.framework.server.impl.CCLWatchThreadFactory;
import org.identityconnectors.framework.server.impl.ConnectionProcessor;

class ConnectionListener
extends CCLWatchThread {
    private static final int INTERNAL_QUEUE_SIZE = 2;
    private static final Log _log = Log.getLog(ConnectionListener.class);
    private final ConnectorServer _server;
    private final ServerSocket _socket;
    private final ExecutorService _threadPool;
    private boolean _stopped = false;

    public ConnectionListener(ConnectorServer server, ServerSocket socket) {
        super("ConnectionListener");
        this._server = server;
        this._socket = socket;
        this._threadPool = new ThreadPoolExecutor(server.getMinWorkers(), server.getMaxWorkers(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2, true), new CCLWatchThreadFactory());
    }

    public void run() {
        block8: while (!this.isStopped()) {
            try {
                Socket connection = this._socket.accept();
                ConnectionProcessor processor = new ConnectionProcessor(this._server, connection);
                while (true) {
                    try {
                        this._threadPool.execute(processor);
                        continue block8;
                    }
                    catch (RejectedExecutionException e) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e2) {}
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                if (!this.isStopped() || !(e instanceof SocketException)) {
                    _log.error(e, "Error processing request", new Object[0]);
                }
                if (this.isStopped()) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private synchronized void markStopped() {
        this._stopped = true;
    }

    private synchronized boolean isStopped() {
        return this._stopped;
    }

    public void shutdown() {
        if (Thread.currentThread() == this) {
            throw new IllegalArgumentException("Shutdown may not be called from this thread");
        }
        if (!this.isStopped()) {
            try {
                this.markStopped();
                this._socket.close();
                this.join();
                this._threadPool.shutdown();
            }
            catch (Exception e) {
                throw ConnectorException.wrap(e);
            }
        }
    }
}

