/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.binary;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.BinaryObjectDeserializer;
import org.identityconnectors.framework.impl.serializer.ObjectDecoder;
import org.identityconnectors.framework.impl.serializer.ObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectSerializerRegistry;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryObjectDecoder
implements ObjectDecoder,
BinaryObjectDeserializer {
    private InternalDecoder _internalDecoder;

    public BinaryObjectDecoder(InputStream in) {
        this._internalDecoder = new InternalDecoder(new DataInputStream(new BufferedInputStream(in, 4096)));
    }

    @Override
    public void close() {
        try {
            this._internalDecoder._rootInput.close();
        }
        catch (IOException e) {
            throw ConnectorException.wrap(e);
        }
    }

    @Override
    public Object readObject() {
        return this._internalDecoder.readObject(this);
    }

    @Override
    public boolean readBooleanContents() {
        this._internalDecoder.startAnonymousField(0);
        return this._internalDecoder.readBoolean();
    }

    @Override
    public boolean readBooleanField(String fieldName, boolean dflt) {
        if (this._internalDecoder.startField(fieldName)) {
            return this._internalDecoder.readBoolean();
        }
        return dflt;
    }

    @Override
    public byte[] readByteArrayContents() {
        this._internalDecoder.startAnonymousField(0);
        return this._internalDecoder.readByteArray();
    }

    @Override
    public Class<?> readClassContents() {
        this._internalDecoder.startAnonymousField(0);
        return this._internalDecoder.readClass();
    }

    @Override
    public Class<?> readClassField(String fieldName, Class<?> dflt) {
        if (this._internalDecoder.startField(fieldName)) {
            return this._internalDecoder.readClass();
        }
        return dflt;
    }

    @Override
    public double readDoubleContents() {
        this._internalDecoder.startAnonymousField(0);
        return this._internalDecoder.readDouble();
    }

    @Override
    public double readDoubleField(String fieldName, double dflt) {
        if (this._internalDecoder.startField(fieldName)) {
            return this._internalDecoder.readDouble();
        }
        return dflt;
    }

    @Override
    public float readFloatContents() {
        this._internalDecoder.startAnonymousField(0);
        return (float)this._internalDecoder.readDouble();
    }

    @Override
    public float readFloatField(String fieldName, float dflt) {
        if (this._internalDecoder.startField(fieldName)) {
            return (float)this._internalDecoder.readDouble();
        }
        return dflt;
    }

    @Override
    public int readIntContents() {
        this._internalDecoder.startAnonymousField(0);
        return this._internalDecoder.readInt();
    }

    @Override
    public int readIntField(String fieldName, int dflt) {
        if (this._internalDecoder.startField(fieldName)) {
            return this._internalDecoder.readInt();
        }
        return dflt;
    }

    @Override
    public long readLongContents() {
        this._internalDecoder.startAnonymousField(0);
        return this._internalDecoder.readLong();
    }

    @Override
    public long readLongField(String fieldName, long dflt) {
        if (this._internalDecoder.startField(fieldName)) {
            return this._internalDecoder.readLong();
        }
        return dflt;
    }

    @Override
    public int getNumSubObjects() {
        return this._internalDecoder.getNumAnonymousFields();
    }

    @Override
    public Object readObjectContents(int index) {
        this._internalDecoder.startAnonymousField(index);
        return this._internalDecoder.readObject(this);
    }

    @Override
    public Object readObjectField(String fieldName, Class<?> expected, Object dflt) {
        if (this._internalDecoder.startField(fieldName)) {
            return this.readObject();
        }
        return dflt;
    }

    @Override
    public String readStringContents() {
        this._internalDecoder.startAnonymousField(0);
        return this._internalDecoder.readString(false);
    }

    @Override
    public String readStringField(String fieldName, String dflt) {
        if (this._internalDecoder.startField(fieldName)) {
            return this._internalDecoder.readString(false);
        }
        return dflt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalDecoder {
        private boolean _firstObject = true;
        private final Map<Integer, String> _constantPool = new HashMap<Integer, String>();
        private final List<ReadState> _readStateStack = new ArrayList<ReadState>();
        private final DataInputStream _rootInput;

        public InternalDecoder(DataInputStream input) {
            this._rootInput = input;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object readObject(ObjectDecoder decoder) {
            Object rv;
            byte type;
            if (this._firstObject) {
                int magic = this.readInt();
                if (magic != 64251) {
                    throw new ConnectorException("Bad magic number: " + magic);
                }
                int version = this.readInt();
                if (version != 1) {
                    throw new ConnectorException("Unexpected version: " + version);
                }
                this._firstObject = false;
            }
            if (this._readStateStack.size() == 0) {
                int size = this.readInt();
                for (int i = 0; i < size; ++i) {
                    String constant = this.readString(false);
                    int code = this.readInt();
                    this._constantPool.put(code, constant);
                }
            }
            Class<?> clazz = this.readClass();
            ReadState state = new ReadState();
            while ((type = this.readByte()) != 72) {
                if (type == 70) {
                    byte[] bytes = this.readByteArray();
                    state.anonymousFields.add(bytes);
                    continue;
                }
                if (type != 71) throw new ConnectorException("Unknown type: " + type);
                String fieldName = this.readString(true);
                byte[] bytes = this.readByteArray();
                state.objectFields.put(fieldName, bytes);
            }
            this._readStateStack.add(state);
            if (clazz == null) {
                rv = null;
            } else {
                ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(clazz);
                if (handler == null) {
                    if (!clazz.isArray()) throw new ConnectorException("No deserializer for type: " + clazz);
                    int length = this.getNumAnonymousFields();
                    Object array = Array.newInstance(clazz.getComponentType(), length);
                    for (int i = 0; i < length; ++i) {
                        this.startAnonymousField(i);
                        Object element = this.readObject(decoder);
                        Array.set(array, i, element);
                    }
                    rv = array;
                } else {
                    rv = handler.deserialize(decoder);
                }
            }
            this._readStateStack.remove(this._readStateStack.size() - 1);
            return rv;
        }

        public Class<?> readClass() {
            byte type = this.readByte();
            if (type == 60) {
                return null;
            }
            if (type == 62) {
                Class<?> componentClass = this.readClass();
                return Array.newInstance(componentClass, 0).getClass();
            }
            if (type == 61) {
                String typeName = this.readString(true);
                ObjectTypeMapper mapper = ObjectSerializerRegistry.getMapperBySerialType(typeName);
                if (mapper == null) {
                    throw new ConnectorException("No deserializer for type: " + typeName);
                }
                return mapper.getHandledObjectType();
            }
            throw new ConnectorException("Bad type value: " + type);
        }

        public int getNumAnonymousFields() {
            ReadState readState = this._readStateStack.get(this._readStateStack.size() - 1);
            return readState.anonymousFields.size();
        }

        public void startAnonymousField(int index) {
            ReadState readState = this._readStateStack.get(this._readStateStack.size() - 1);
            readState.startAnonymousField(index);
        }

        public boolean startField(String name) {
            ReadState readState = this._readStateStack.get(this._readStateStack.size() - 1);
            return readState.startField(name);
        }

        public int readInt() {
            try {
                return this.getCurrentInput().readInt();
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public long readLong() {
            try {
                return this.getCurrentInput().readLong();
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public double readDouble() {
            try {
                return this.getCurrentInput().readDouble();
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public byte[] readByteArray() {
            try {
                int length = this.getCurrentInput().readInt();
                byte[] rv = new byte[length];
                this.getCurrentInput().readFully(rv);
                return rv;
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public byte readByte() {
            try {
                return this.getCurrentInput().readByte();
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public boolean readBoolean() {
            try {
                return this.getCurrentInput().readBoolean();
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public String readString(boolean interned) {
            if (interned) {
                int code = this.readInt();
                String name = this._constantPool.get(code);
                if (name == null) {
                    throw new ConnectorException("Undeclared code: " + code);
                }
                return name;
            }
            try {
                byte[] bytes = this.readByteArray();
                return new String(bytes, "UTF8");
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        private DataInputStream getCurrentInput() {
            if (this._readStateStack.size() > 0) {
                ReadState state = this._readStateStack.get(this._readStateStack.size() - 1);
                return state.currentInput;
            }
            return this._rootInput;
        }
    }

    private static class ReadState {
        public Map<String, byte[]> objectFields = new HashMap<String, byte[]>();
        public List<byte[]> anonymousFields = new ArrayList<byte[]>();
        public DataInputStream currentInput;

        public boolean startField(String name) {
            this.currentInput = null;
            byte[] content = this.objectFields.get(name);
            if (content == null) {
                return false;
            }
            this.currentInput = new DataInputStream(new ByteArrayInputStream(content));
            return true;
        }

        public void startAnonymousField(int index) {
            if (index >= this.anonymousFields.size()) {
                throw new ConnectorException("Anonymous content not found");
            }
            this.currentInput = new DataInputStream(new ByteArrayInputStream(this.anonymousFields.get(index)));
        }
    }
}

