/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.OperationTimeoutException;
import org.identityconnectors.framework.impl.api.ObjectStreamHandler;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;

public class BufferedResultsProxy
implements InvocationHandler {
    private static final Log _log = Log.getLog(BufferedResultsProxy.class);
    private final Object _target;
    private final int _bufferSize;
    private final long _timeoutMillis;

    public BufferedResultsProxy(Object target, int bufferSize, long timeoutMillis) {
        if (target == null) {
            String ERR = "Target argument must not be null!";
            throw new IllegalArgumentException("Target argument must not be null!");
        }
        this._target = target;
        this._timeoutMillis = timeoutMillis == -1L ? Long.MAX_VALUE : (timeoutMillis == 0L ? 60000L : timeoutMillis);
        this._bufferSize = bufferSize < 1 ? 100 : bufferSize;
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this._target, arguments);
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new UnsupportedOperationException("We only support operations that return void " + method);
        }
        BufferedResultsHandler bufHandler = new BufferedResultsHandler(method, this._target, arguments, this._bufferSize, this._timeoutMillis);
        ObjectStreamHandler handler = null;
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (!StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType)) continue;
            if (handler != null) {
                throw new UnsupportedOperationException("We only support operations that have a single stream handler " + method);
            }
            handler = StreamHandlerUtil.adaptToObjectStreamHandler(paramType, arguments[i]);
        }
        if (handler == null) {
            throw new UnsupportedOperationException("We only support operations that have a single stream handler " + method);
        }
        bufHandler.setDaemon(true);
        bufHandler.start();
        while (!bufHandler.isStopped()) {
            Object obj = bufHandler.getNextObject();
            if (obj == null) continue;
            try {
                boolean keepGoing = handler.handle(obj);
                if (keepGoing) continue;
                bufHandler.stop(true);
            }
            catch (RuntimeException e) {
                try {
                    bufHandler.stop(true);
                }
                catch (RuntimeException e2) {
                    _log.error(e2, null, new Object[0]);
                }
                throw e;
            }
        }
        return null;
    }

    private static class BufferedResultsHandler
    extends Thread
    implements ObjectStreamHandler {
        private static final Object DONE = new Object();
        private boolean _stopped = false;
        private final Method _method;
        private final Object _target;
        private final Object[] _arguments;
        private final long _timeoutMillis;
        private final ArrayBlockingQueue<Object> _buffer;

        public BufferedResultsHandler(Method method, Object target, Object[] arguments, int bufferSize, long timeoutMillis) {
            this._method = method;
            this._target = target;
            this._arguments = arguments;
            this._buffer = new ArrayBlockingQueue(bufferSize);
            this._timeoutMillis = timeoutMillis;
        }

        public boolean handle(Object obj) {
            Assertions.nullCheck(obj, "obj");
            try {
                this._buffer.put(obj);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ConnectorException.wrap(e);
            }
            return !this.isStopped();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(boolean wait) {
            if (wait && Thread.currentThread() == this) {
                throw new IllegalStateException("A thread cannot wait on itself");
            }
            BufferedResultsHandler bufferedResultsHandler = this;
            synchronized (bufferedResultsHandler) {
                this._stopped = true;
            }
            this._buffer.clear();
            if (wait) {
                try {
                    this.join(this._timeoutMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw ConnectorException.wrap(e);
                }
                if (this.isAlive()) {
                    throw new OperationTimeoutException();
                }
            }
        }

        public synchronized boolean isStopped() {
            return this._stopped;
        }

        private Object[] createActualArguments() {
            Object[] actualArguments = new Object[this._arguments.length];
            Class<?>[] paramTypes = this._method.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramType = paramTypes[i];
                actualArguments[i] = StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType) ? StreamHandlerUtil.adaptFromObjectStreamHandler(paramType, this) : this._arguments[i];
            }
            return actualArguments;
        }

        public void run() {
            try {
                try {
                    this._method.invoke(this._target, this.createActualArguments());
                    this._buffer.put(DONE);
                }
                catch (RuntimeException e) {
                    this._buffer.put(e);
                }
                catch (InvocationTargetException e) {
                    this._buffer.put(e.getTargetException());
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this._buffer.put(ConnectorException.wrap(e));
                }
            }
            catch (InterruptedException e) {
                _log.error(e, null, new Object[0]);
            }
        }

        public Object getNextObject() {
            Object obj;
            if (this.isStopped()) {
                return null;
            }
            try {
                obj = this._buffer.poll(this._timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ConnectorException.wrap(e);
            }
            if (obj == null) {
                this.stop(false);
                throw new OperationTimeoutException();
            }
            if (obj == DONE) {
                this.stop(true);
                return null;
            }
            if (obj instanceof RuntimeException) {
                this.stop(true);
                throw (RuntimeException)obj;
            }
            return obj;
        }
    }
}

