/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private ReflectionUtil() {
        throw new AssertionError();
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> target) {
        assert (target != null);
        HashSet ret = new HashSet();
        ReflectionUtil.getAllInteralInterfaces(target, ret);
        return ret;
    }

    private static void getAllInteralInterfaces(Class<?> target, Set<Class<?>> result) {
        if (target != null) {
            for (Class<?> inter : target.getInterfaces()) {
                result.add(inter);
            }
            ReflectionUtil.getAllInteralInterfaces(target.getSuperclass(), result);
        }
    }

    public static boolean containsInterface(Class<?> target, Class<?> clazz) {
        return clazz.isAssignableFrom(target);
    }

    public static <T> List<Class<? extends T>> getInterfaces(Class<?> target, Class<T> type) {
        ArrayList<Class<T>> ret = new ArrayList<Class<T>>();
        Set<Class<?>> interfs = ReflectionUtil.getAllInterfaces(target);
        for (Class clazz : interfs) {
            if (!ReflectionUtil.containsInterface(clazz, type)) continue;
            Class o = clazz;
            ret.add(o);
        }
        return ret;
    }

    public static boolean overridesEqualsAndHashcode(Class<?> clazz) {
        try {
            Method equals = clazz.getMethod("equals", Object.class);
            if (equals.getDeclaringClass() == Object.class) {
                return false;
            }
            Method hashCode = clazz.getMethod("hashCode", new Class[0]);
            return hashCode.getDeclaringClass() != Object.class;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPackage(Class<?> clazz) {
        String name = clazz.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    public static String getMethodName(int depth) {
        Throwable dummyException = new Throwable();
        StackTraceElement[] locations = dummyException.getStackTrace();
        String method = "unknown";
        if (locations != null && locations.length > depth) {
            StackTraceElement caller = locations[depth];
            method = caller.getMethodName();
        }
        return method;
    }
}

