/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl.execution;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.task.api.TaskExecutionStatus;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.TaskQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.TaskQuartzImplUtil;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public class TaskSynchronizer {
    private static final transient Trace LOGGER = TraceManager.getTrace(TaskSynchronizer.class);
    private TaskManagerQuartzImpl taskManager;

    public TaskSynchronizer(TaskManagerQuartzImpl taskManager) {
        this.taskManager = taskManager;
    }

    boolean synchronizeJobStores(OperationResult parentResult) {
        List tasks;
        OperationResult result = parentResult.createSubresult(String.valueOf(this.getClass().getName()) + ".synchronizeJobStores");
        Scheduler scheduler = this.taskManager.getExecutionManager().getQuartzScheduler();
        LOGGER.info("Synchronizing Quartz job store with midPoint repository.");
        PagingType paging = new PagingType();
        try {
            tasks = this.getRepositoryService().searchObjects(TaskType.class, QueryUtil.createAllObjectsQuery(), paging, result);
        }
        catch (Exception e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Synchronization cannot be done, because tasks cannot be listed from the repository.", (Throwable)e, (Object[])new Object[0]);
            return false;
        }
        LOGGER.trace("There are {} task(s) in repository", (Object)tasks.size());
        HashSet<String> oidsInRepo = new HashSet<String>();
        int processed = 0;
        int changed = 0;
        int errors = 0;
        for (PrismObject taskPrism : tasks) {
            oidsInRepo.add(taskPrism.getOid());
            TaskQuartzImpl task = null;
            try {
                task = (TaskQuartzImpl)this.taskManager.getTask(taskPrism.getOid(), result);
                if (this.synchronizeTask(task, result)) {
                    ++changed;
                }
            }
            catch (SchemaException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Task Manager cannot synchronize task {} due to schema exception.", (Throwable)e, (Object[])new Object[]{taskPrism.getOid()});
            }
            catch (ObjectNotFoundException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Task Manager cannot synchronize task {}", (Throwable)e, (Object[])new Object[]{task});
            }
            if (result.getLastSubresultStatus() == OperationResultStatus.SUCCESS) {
                ++processed;
                continue;
            }
            ++errors;
        }
        int removed = 0;
        HashSet jobs = null;
        try {
            jobs = new HashSet(scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"DEFAULT")));
        }
        catch (SchedulerException e) {
            String message = "Cannot list jobs from Quartz scheduler, skipping second part of synchronization procedure.";
            LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
            result.recordPartialError(message, (Throwable)e);
        }
        if (jobs != null) {
            LOGGER.trace("There are {} job(s) in Quartz job store", (Object)jobs.size());
            for (JobKey job : jobs) {
                if (oidsInRepo.contains(job.getName())) continue;
                LOGGER.info("Task " + job.getName() + " is not in repository, removing from Quartz job store.");
                try {
                    scheduler.deleteJob(job);
                    ++removed;
                }
                catch (SchedulerException e) {
                    String message = "Cannot remove job " + job.getName() + " from Quartz job store";
                    LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
                    result.createSubresult("deleteQuartzJob").recordPartialError(message, (Throwable)e);
                    ++errors;
                }
            }
        }
        String resultMessage = "Synchronization of midpoint and Quartz task store finished. " + processed + " task(s) existing in midPoint repository successfully processed, resulting in " + changed + " updated Quartz job(s). " + removed + " task(s) removed from Quartz job store. Processing of " + errors + " task(s) failed.";
        LOGGER.info(resultMessage);
        if (result.isUnknown()) {
            result.recordStatus(OperationResultStatus.SUCCESS, resultMessage);
        }
        return true;
    }

    public boolean synchronizeTask(TaskQuartzImpl task, OperationResult parentResult) {
        OperationResult result;
        String message;
        boolean changed;
        block13: {
            changed = false;
            message = "";
            result = parentResult.createSubresult(String.valueOf(TaskSynchronizer.class.getName()) + ".synchronizeTask");
            result.addParam("task", (Object)task);
            try {
                Trigger triggerToBe;
                boolean waitingOrClosed;
                LOGGER.trace("Synchronizing task {}", (Object)task);
                Scheduler scheduler = this.taskManager.getExecutionManager().getQuartzScheduler();
                String oid = task.getOid();
                JobKey jobKey = TaskQuartzImplUtil.createJobKeyForTask(task);
                TriggerKey triggerKey = TaskQuartzImplUtil.createTriggerKeyForTask(task);
                boolean bl = waitingOrClosed = task.getExecutionStatus() == TaskExecutionStatus.WAITING || task.getExecutionStatus() == TaskExecutionStatus.CLOSED;
                if (!scheduler.checkExists(jobKey) && !waitingOrClosed) {
                    String m1 = "Quartz job does not exist for a task, adding it. Task = " + task;
                    message = String.valueOf(message) + "[" + m1 + "] ";
                    LOGGER.trace(" - " + m1);
                    scheduler.addJob(TaskQuartzImplUtil.createJobDetailForTask(task), false);
                    changed = true;
                }
                boolean triggerExists = scheduler.checkExists(triggerKey);
                if (waitingOrClosed) {
                    if (triggerExists) {
                        String m1 = "Removing Quartz trigger for WAITING/CLOSED task " + task;
                        message = String.valueOf(message) + "[" + m1 + "] ";
                        LOGGER.trace(" - " + m1);
                        scheduler.unscheduleJob(TriggerKey.triggerKey((String)oid));
                        changed = true;
                    }
                    break block13;
                }
                if (task.getExecutionStatus() == TaskExecutionStatus.SUSPENDED || task.getExecutionStatus() != TaskExecutionStatus.RUNNABLE) break block13;
                try {
                    triggerToBe = TaskQuartzImplUtil.createTriggerForTask(task);
                }
                catch (ParseException e) {
                    String message2 = "Cannot create a trigger for a task " + this + " because of a cron expression parsing exception";
                    LoggingUtils.logException((Trace)LOGGER, (String)message2, (Throwable)e, (Object[])new Object[0]);
                    result.recordFatalError(message2, (Throwable)e);
                    throw new SystemException("Cannot a trigger for a task because of a cron expression parsing exception", (Throwable)e);
                }
                if (!triggerExists) {
                    String m1 = "Creating trigger for a RUNNABLE task " + task;
                    LOGGER.trace(" - " + m1);
                    message = String.valueOf(message) + "[" + m1 + "] ";
                    scheduler.scheduleJob(triggerToBe);
                    changed = true;
                } else {
                    Trigger triggerAsIs = scheduler.getTrigger(triggerKey);
                    if (TaskQuartzImplUtil.triggerDataMapsDiffer(triggerAsIs, triggerToBe)) {
                        String m1 = "Existing trigger has an incompatible parameters, recreating it; task = " + task;
                        LOGGER.trace(" - " + m1);
                        message = String.valueOf(message) + "[" + m1 + "] ";
                        scheduler.rescheduleJob(triggerKey, triggerToBe);
                        changed = true;
                    } else {
                        String m1 = "Existing trigger is OK, leaving it as is; task = " + task;
                        LOGGER.trace(" - " + m1);
                        message = String.valueOf(message) + "[" + m1 + "] ";
                        Trigger.TriggerState state = scheduler.getTriggerState(triggerKey);
                        if (state == Trigger.TriggerState.PAUSED) {
                            String m2 = "However, the trigger is paused, resuming it; task = " + task;
                            LOGGER.trace(" - " + m2);
                            message = String.valueOf(message) + "[" + m2 + "] ";
                            scheduler.resumeTrigger(triggerKey);
                            changed = true;
                        }
                    }
                }
            }
            catch (Exception e) {
                String message2 = "Cannot synchronize repository/Quartz Job Store information for task " + task;
                LoggingUtils.logException((Trace)LOGGER, (String)message2, (Throwable)e, (Object[])new Object[0]);
                result.recordFatalError(message2, (Throwable)e);
            }
        }
        if (result.isUnknown()) {
            result.computeStatus();
            result.recordStatus(result.getStatus(), message);
        }
        return changed;
    }

    private RepositoryService getRepositoryService() {
        return this.taskManager.getRepositoryService();
    }
}

