/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl.cluster;

import com.evolveum.midpoint.common.LoggingConfigurationManager;
import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Node;
import com.evolveum.midpoint.task.api.TaskManagerInitializationException;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.cluster.NodeRegistrar;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LoggingConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.NodeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemObjectsType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.List;

public class ClusterManager {
    private static final transient Trace LOGGER = TraceManager.getTrace(ClusterManager.class);
    private static final String CLASS_DOT = String.valueOf(ClusterManager.class.getName()) + ".";
    private static final String CHECK_SYSTEM_CONFIGURATION_CHANGED = String.valueOf(CLASS_DOT) + "checkSystemConfigurationChanged";
    private TaskManagerQuartzImpl taskManager;
    private NodeRegistrar nodeRegistrar;
    private ClusterManagerThread clusterManagerThread;

    public ClusterManager(TaskManagerQuartzImpl taskManager) {
        this.taskManager = taskManager;
        this.nodeRegistrar = new NodeRegistrar(taskManager, this);
    }

    public void checkClusterConfiguration(OperationResult result) {
        this.nodeRegistrar.verifyNodeObject(result);
        this.nodeRegistrar.checkNonClusteredNodes(result);
    }

    public boolean isClusterManagerThreadActive() {
        return this.clusterManagerThread != null && this.clusterManagerThread.isAlive();
    }

    public void recordNodeShutdown(OperationResult result) {
        this.nodeRegistrar.recordNodeShutdown(result);
    }

    public String getNodeId() {
        return this.nodeRegistrar.getNodeId();
    }

    public boolean isCurrentNode(PrismObject<NodeType> node) {
        return this.nodeRegistrar.isCurrentNode(node);
    }

    public boolean isCurrentNode(String node) {
        return this.nodeRegistrar.isCurrentNode(node);
    }

    public void deleteNode(String nodeIdentifier, OperationResult result) {
        this.nodeRegistrar.deleteNode(nodeIdentifier, result);
    }

    public void createNodeObject(OperationResult result) throws TaskManagerInitializationException {
        this.nodeRegistrar.createNodeObject(result);
    }

    public PrismObject<NodeType> getNodePrism() {
        return this.nodeRegistrar.getNodePrism();
    }

    public boolean isUp(NodeType nodeType) {
        return this.nodeRegistrar.isUp(nodeType);
    }

    public void stopClusterManagerThread(long waitTime, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ClusterManager.class.getName()) + ".stopClusterManagerThread");
        result.addParam("waitTime", (Object)waitTime);
        if (this.clusterManagerThread != null) {
            this.clusterManagerThread.signalShutdown();
            try {
                this.clusterManagerThread.join(waitTime);
            }
            catch (InterruptedException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Waiting for ClusterManagerThread shutdown was interrupted", (Throwable)e, (Object[])new Object[0]);
            }
            if (this.clusterManagerThread.isAlive()) {
                result.recordWarning("ClusterManagerThread shutdown requested but after " + waitTime + " ms it is still running.");
            } else {
                result.recordSuccess();
            }
        } else {
            result.recordSuccess();
        }
    }

    public void startClusterManagerThread() {
        this.clusterManagerThread = new ClusterManagerThread();
        this.clusterManagerThread.setName("ClusterManagerThread");
        this.clusterManagerThread.start();
    }

    private RepositoryService getRepositoryService() {
        return this.taskManager.getRepositoryService();
    }

    public String dumpNodeInfo(Node nodeInfo) {
        NodeType node = (NodeType)nodeInfo.getNodeType().asObjectable();
        return String.valueOf(node.getNodeIdentifier()) + " (" + node.getHostname() + ")";
    }

    private OperationResult createOperationResult(String methodName) {
        return new OperationResult(String.valueOf(ClusterManager.class.getName()) + "." + methodName);
    }

    public List<PrismObject<NodeType>> getAllNodes(OperationResult result) {
        try {
            return this.getRepositoryService().searchObjects(NodeType.class, QueryUtil.createAllObjectsQuery(), new PagingType(), result);
        }
        catch (SchemaException e) {
            throw new SystemException("Cannot get the list of nodes from the repository", (Throwable)e);
        }
    }

    public PrismObject<NodeType> getNodeById(String nodeIdentifier, OperationResult result) throws ObjectNotFoundException {
        try {
            QueryType q = QueryUtil.createNameQuery((String)nodeIdentifier);
            List nodes = this.taskManager.getRepositoryService().searchObjects(NodeType.class, q, new PagingType(), result);
            if (nodes.isEmpty()) {
                throw new ObjectNotFoundException("A node with identifier " + nodeIdentifier + " does not exist.");
            }
            if (nodes.size() > 1) {
                throw new SystemException("Multiple nodes with the same identifier '" + nodeIdentifier + "' in the repository.");
            }
            return (PrismObject)nodes.get(0);
        }
        catch (SchemaException e) {
            throw new SystemException("Cannot get the list of nodes from the repository", (Throwable)e);
        }
    }

    public void checkSystemConfigurationChanged(OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(CHECK_SYSTEM_CONFIGURATION_CHANGED);
        try {
            PrismObject config = this.getRepositoryService().getObject(SystemConfigurationType.class, SystemObjectsType.SYSTEM_CONFIGURATION.value(), result);
            String versionInRepo = config.getVersion();
            String versionApplied = LoggingConfigurationManager.getCurrentlyUsedVersion();
            if (!versionInRepo.equals(versionApplied)) {
                LoggingConfigurationManager.configure((LoggingConfigurationType)((SystemConfigurationType)config.asObjectable()).getLogging(), (String)versionInRepo, (OperationResult)result);
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("System configuration change check: version in repo = version currently applied = {}", (Object)versionApplied);
            }
            if (result.isUnknown()) {
                result.computeStatus();
            }
        }
        catch (ObjectNotFoundException e) {
            LoggingConfigurationManager.resetCurrentlyUsedVersion();
            String message = "No system configuration found, skipping application of system settings";
            LOGGER.error(String.valueOf(message) + ": " + e.getMessage(), (Throwable)e);
            result.recordWarning(message, (Throwable)e);
        }
        catch (SchemaException e) {
            String message = "Schema error in system configuration, skipping application of system settings";
            LOGGER.error(String.valueOf(message) + ": " + e.getMessage(), (Throwable)e);
            result.recordWarning(message, (Throwable)e);
        }
    }

    class ClusterManagerThread
    extends Thread {
        boolean canRun = true;

        ClusterManagerThread() {
        }

        @Override
        public void run() {
            LOGGER.info("ClusterManager thread starting.");
            OperationResult result = new OperationResult(ClusterManagerThread.class + ".run");
            long delay = (long)ClusterManager.this.taskManager.getConfiguration().getNodeRegistrationCycleTime() * 1000L;
            while (this.canRun) {
                try {
                    ClusterManager.this.checkSystemConfigurationChanged(result);
                    ClusterManager.this.checkClusterConfiguration(result);
                    ClusterManager.this.nodeRegistrar.updateNodeObject(result);
                }
                catch (Throwable t) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Unexpected exception in ClusterManager thread; continuing execution.", (Throwable)t, (Object[])new Object[0]);
                }
                LOGGER.trace("ClusterManager thread sleeping for " + delay + " msec");
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.trace("ClusterManager thread interrupted.");
                }
            }
            LOGGER.info("ClusterManager thread stopping.");
        }

        public void signalShutdown() {
            this.canRun = false;
            this.interrupt();
        }
    }
}

