/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.LightweightIdentifier;
import com.evolveum.midpoint.task.api.Node;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskBinding;
import com.evolveum.midpoint.task.api.TaskExecutionStatus;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskPersistenceStatus;
import com.evolveum.midpoint.task.api.TaskRecurrence;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ModelOperationStateType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultStatusType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScheduleType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskBindingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskExecutionStatusType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskRecurrenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ThreadStopActionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UriStack;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;

public class TaskQuartzImpl
implements Task {
    private TaskBinding DEFAULT_BINDING_TYPE = TaskBinding.TIGHT;
    private PrismObject<TaskType> taskPrism;
    private TaskPersistenceStatus persistenceStatus;
    private TaskManagerQuartzImpl taskManager;
    private RepositoryService repositoryService;
    private OperationResult taskResult;
    private volatile boolean canRun;
    private Node currentlyExecutesAt;
    private static final transient Trace LOGGER = TraceManager.getTrace(TaskQuartzImpl.class);
    private Collection<PropertyDelta<?>> pendingModifications = null;
    private static Set<QName> quartzRelatedProperties = new HashSet<QName>();

    static {
        quartzRelatedProperties.add(TaskType.F_BINDING);
        quartzRelatedProperties.add(TaskType.F_RECURRENCE);
        quartzRelatedProperties.add(TaskType.F_SCHEDULE);
    }

    TaskQuartzImpl(TaskManagerQuartzImpl taskManager, LightweightIdentifier taskIdentifier) {
        this.taskManager = taskManager;
        this.repositoryService = null;
        this.taskPrism = this.createPrism();
        this.canRun = true;
        this.setTaskIdentifier(taskIdentifier.toString());
        this.setExecutionStatusTransient(TaskExecutionStatus.RUNNABLE);
        this.setPersistenceStatusTransient(TaskPersistenceStatus.TRANSIENT);
        this.setRecurrenceStatusTransient(TaskRecurrence.SINGLE);
        this.setBindingTransient(this.DEFAULT_BINDING_TYPE);
        this.setProgressTransient(0L);
        this.setObjectTransient(null);
        this.setDefaults();
    }

    TaskQuartzImpl(TaskManagerQuartzImpl taskManager, PrismObject<TaskType> taskPrism, RepositoryService repositoryService) {
        this.taskManager = taskManager;
        this.repositoryService = repositoryService;
        this.taskPrism = taskPrism;
        this.canRun = true;
        this.setDefaults();
    }

    private PrismObject<TaskType> createPrism() {
        PrismObjectDefinition taskTypeDef = this.getPrismContext().getSchemaRegistry().findObjectDefinitionByCompileTimeClass(TaskType.class);
        PrismObject taskPrism = taskTypeDef.instantiate();
        return taskPrism;
    }

    private void setDefaults() {
        if (this.getBinding() == null) {
            this.setBindingTransient(this.DEFAULT_BINDING_TYPE);
        }
        this.persistenceStatus = StringUtils.isEmpty((String)this.getOid()) ? TaskPersistenceStatus.TRANSIENT : TaskPersistenceStatus.PERSISTENT;
        OperationResultType resultType = ((TaskType)this.taskPrism.asObjectable()).getResult();
        if (resultType == null) {
            resultType = new OperationResult(String.valueOf(Task.class.getName()) + ".run").createOperationResultType();
            ((TaskType)this.taskPrism.asObjectable()).setResult(resultType);
        }
        this.taskResult = OperationResult.createOperationResult((OperationResultType)resultType);
    }

    void initialize(OperationResult initResult) throws SchemaException {
        this.resolveOwnerRef(initResult);
    }

    public PrismObject<TaskType> getTaskPrismObject() {
        if (this.taskResult != null) {
            ((TaskType)this.taskPrism.asObjectable()).setResult(this.taskResult.createOperationResultType());
            ((TaskType)this.taskPrism.asObjectable()).setResultStatus(this.taskResult.getStatus().createStatusType());
        }
        return this.taskPrism;
    }

    RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean isAsynchronous() {
        return this.persistenceStatus == TaskPersistenceStatus.PERSISTENT;
    }

    public void addPendingModification(PropertyDelta<?> delta) {
        if (this.pendingModifications == null) {
            this.pendingModifications = new Vector();
        }
        this.pendingModifications.add(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePendingModifications(OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        if (this.pendingModifications != null) {
            Collection<PropertyDelta<?>> collection = this.pendingModifications;
            synchronized (collection) {
                if (!this.pendingModifications.isEmpty()) {
                    this.repositoryService.modifyObject(TaskType.class, this.getOid(), this.pendingModifications, parentResult);
                    this.synchronizeWithQuartzIfNeeded(this.pendingModifications, parentResult);
                    this.pendingModifications.clear();
                }
            }
        }
    }

    public void synchronizeWithQuartz(OperationResult parentResult) {
        this.taskManager.synchronizeTaskWithQuartz(this, parentResult);
    }

    private void synchronizeWithQuartzIfNeeded(Collection<PropertyDelta<?>> deltas, OperationResult parentResult) {
        for (PropertyDelta<?> delta : deltas) {
            if (!delta.getParentPath().isEmpty() || !quartzRelatedProperties.contains(delta.getName())) continue;
            this.synchronizeWithQuartz(parentResult);
            return;
        }
    }

    private void processModificationNow(PropertyDelta<?> delta, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        if (delta != null) {
            ArrayList deltas = new ArrayList(1);
            deltas.add(delta);
            this.repositoryService.modifyObject(TaskType.class, this.getOid(), deltas, parentResult);
            this.synchronizeWithQuartzIfNeeded(deltas, parentResult);
        }
    }

    private void processModificationBatched(PropertyDelta<?> delta) {
        if (delta != null) {
            this.addPendingModification(delta);
        }
    }

    public long getProgress() {
        Long value = (Long)this.taskPrism.getPropertyRealValue(TaskType.F_PROGRESS, Long.class);
        return value != null ? value : 0L;
    }

    public void setProgress(long value) {
        this.processModificationBatched(this.setProgressAndPrepareDelta(value));
    }

    public void setProgressImmediate(long value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setProgressAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setProgressTransient(long value) {
        try {
            this.taskPrism.setPropertyRealValue(TaskType.F_PROGRESS, (Object)value);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    private PropertyDelta<?> setProgressAndPrepareDelta(long value) {
        this.setProgressTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_PROGRESS, (Object[])new Object[]{value}) : null;
    }

    public OperationResult getResult() {
        return this.taskResult;
    }

    public void setResult(OperationResult result) {
        this.processModificationBatched(this.setResultAndPrepareDelta(result));
        this.setResultStatusType(result != null ? result.getStatus().createStatusType() : null);
    }

    public void setResultImmediate(OperationResult result, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setResultAndPrepareDelta(result), parentResult);
            this.setResultStatusTypeImmediate(result != null ? result.getStatus().createStatusType() : null, parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setResultTransient(OperationResult result) {
        this.taskResult = result;
        ((TaskType)this.taskPrism.asObjectable()).setResult(result.createOperationResultType());
        this.setResultStatusTypeTransient(result != null ? result.getStatus().createStatusType() : null);
    }

    private PropertyDelta<?> setResultAndPrepareDelta(OperationResult result) {
        this.setResultTransient(result);
        if (this.isPersistent()) {
            PropertyDelta d = PropertyDelta.createReplaceDeltaOrEmptyDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_RESULT, (Object)(result != null ? result.createOperationResultType() : null));
            LOGGER.trace("setResult delta = " + d.debugDump());
            return d;
        }
        return null;
    }

    public OperationResultStatusType getResultStatus() {
        return this.taskResult == null ? null : this.taskResult.getStatus().createStatusType();
    }

    public void setResultStatusType(OperationResultStatusType value) {
        this.processModificationBatched(this.setResultStatusTypeAndPrepareDelta(value));
    }

    public void setResultStatusTypeImmediate(OperationResultStatusType value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        this.processModificationNow(this.setResultStatusTypeAndPrepareDelta(value), parentResult);
    }

    public void setResultStatusTypeTransient(OperationResultStatusType value) {
        ((TaskType)this.taskPrism.asObjectable()).setResultStatus(value);
    }

    private PropertyDelta<?> setResultStatusTypeAndPrepareDelta(OperationResultStatusType value) {
        this.setResultStatusTypeTransient(value);
        if (this.isPersistent()) {
            PropertyDelta d = PropertyDelta.createReplaceDeltaOrEmptyDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_RESULT_STATUS, (Object)value);
            return d;
        }
        return null;
    }

    public String getHandlerUri() {
        return (String)this.taskPrism.getPropertyRealValue(TaskType.F_HANDLER_URI, String.class);
    }

    public void setHandlerUriTransient(String handlerUri) {
        try {
            this.taskPrism.setPropertyRealValue(TaskType.F_HANDLER_URI, (Object)handlerUri);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    public void setHandlerUriImmediate(String value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setHandlerUriAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setHandlerUri(String value) {
        this.processModificationBatched(this.setHandlerUriAndPrepareDelta(value));
    }

    private PropertyDelta<?> setHandlerUriAndPrepareDelta(String value) {
        this.setHandlerUriTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDeltaOrEmptyDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_HANDLER_URI, (Object)value) : null;
    }

    public UriStack getOtherHandlersUriStack() {
        this.checkHandlerUriConsistency();
        return ((TaskType)this.taskPrism.asObjectable()).getOtherHandlersUriStack();
    }

    public void setOtherHandlersUriStackTransient(UriStack value) {
        try {
            this.taskPrism.setPropertyRealValue(TaskType.F_OTHER_HANDLERS_URI_STACK, (Object)value);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        this.checkHandlerUriConsistency();
    }

    public void setOtherHandlersUriStackImmediate(UriStack value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setOtherHandlersUriStackAndPrepareDelta(value), parentResult);
            this.checkHandlerUriConsistency();
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setOtherHandlersUriStack(UriStack value) {
        this.processModificationBatched(this.setOtherHandlersUriStackAndPrepareDelta(value));
        this.checkHandlerUriConsistency();
    }

    private PropertyDelta<?> setOtherHandlersUriStackAndPrepareDelta(UriStack value) {
        this.setOtherHandlersUriStackTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_OTHER_HANDLERS_URI_STACK, (Object[])new Object[]{value}) : null;
    }

    private String popFromOtherHandlersUriStack() {
        this.checkHandlerUriConsistency();
        UriStack stack = (UriStack)this.taskPrism.getPropertyRealValue(TaskType.F_OTHER_HANDLERS_URI_STACK, UriStack.class);
        if (stack == null || stack.getUri().isEmpty()) {
            throw new IllegalStateException("Couldn't pop from OtherHandlersUriStack, becaus it is null or empty");
        }
        int last = stack.getUri().size() - 1;
        String retval = (String)stack.getUri().get(last);
        stack.getUri().remove(last);
        this.setOtherHandlersUriStack(stack);
        return retval;
    }

    public void pushHandlerUri(String uri) {
        this.checkHandlerUriConsistency();
        if (this.getHandlerUri() == null) {
            this.setHandlerUri(uri);
        } else {
            UriStack stack = (UriStack)this.taskPrism.getPropertyRealValue(TaskType.F_OTHER_HANDLERS_URI_STACK, UriStack.class);
            if (stack == null) {
                stack = new UriStack();
            }
            stack.getUri().add(this.getHandlerUri());
            this.setHandlerUri(uri);
            this.setOtherHandlersUriStack(stack);
        }
    }

    public void replaceCurrentHandlerUri(String newUri) {
        this.checkHandlerUriConsistency();
        this.setHandlerUri(newUri);
    }

    public void finishHandler(OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        UriStack otherHandlersUriStack = this.getOtherHandlersUriStack();
        if (otherHandlersUriStack != null && !otherHandlersUriStack.getUri().isEmpty()) {
            this.setHandlerUri(this.popFromOtherHandlersUriStack());
        } else {
            this.setHandlerUri(null);
            this.taskManager.closeTaskWithoutSavingState(this, parentResult);
        }
        try {
            this.savePendingModifications(parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
        LOGGER.trace("finishHandler: new current handler uri = {}, new number of handlers = {}", (Object)this.getHandlerUri(), (Object)this.getHandlersCount());
    }

    public int getHandlersCount() {
        this.checkHandlerUriConsistency();
        int main = this.getHandlerUri() != null ? 1 : 0;
        int others = this.getOtherHandlersUriStack() != null ? this.getOtherHandlersUriStack().getUri().size() : 0;
        return main + others;
    }

    private boolean isOtherHandlersUriStackEmpty() {
        UriStack stack = ((TaskType)this.taskPrism.asObjectable()).getOtherHandlersUriStack();
        return stack == null || stack.getUri().isEmpty();
    }

    private void checkHandlerUriConsistency() {
        if (this.getHandlerUri() == null && !this.isOtherHandlersUriStackEmpty()) {
            throw new IllegalStateException("Handler URI is null but there is at least one 'other' handler (otherHandlerUriStack size = " + this.getOtherHandlersUriStack().getUri().size() + ")");
        }
    }

    public TaskPersistenceStatus getPersistenceStatus() {
        return this.persistenceStatus;
    }

    public void setPersistenceStatusTransient(TaskPersistenceStatus persistenceStatus) {
        this.persistenceStatus = persistenceStatus;
    }

    public boolean isPersistent() {
        return this.persistenceStatus == TaskPersistenceStatus.PERSISTENT;
    }

    public boolean isTransient() {
        return this.persistenceStatus == TaskPersistenceStatus.TRANSIENT;
    }

    public String getOid() {
        return this.taskPrism.getOid();
    }

    public void setOid(String oid) {
        this.taskPrism.setOid(oid);
    }

    public String getTaskIdentifier() {
        return (String)this.taskPrism.getPropertyRealValue(TaskType.F_TASK_IDENTIFIER, String.class);
    }

    private void setTaskIdentifier(String value) {
        try {
            this.taskPrism.setPropertyRealValue(TaskType.F_TASK_IDENTIFIER, (Object)value);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    public TaskExecutionStatus getExecutionStatus() {
        TaskExecutionStatusType xmlValue = (TaskExecutionStatusType)this.taskPrism.getPropertyRealValue(TaskType.F_EXECUTION_STATUS, TaskExecutionStatusType.class);
        if (xmlValue == null) {
            return null;
        }
        return TaskExecutionStatus.fromTaskType((TaskExecutionStatusType)xmlValue);
    }

    public void setExecutionStatusTransient(TaskExecutionStatus executionStatus) {
        try {
            this.taskPrism.setPropertyRealValue(TaskType.F_EXECUTION_STATUS, (Object)executionStatus.toTaskType());
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    public void setInitialExecutionStatus(TaskExecutionStatus value) {
        if (this.isPersistent()) {
            throw new IllegalStateException("Initial execution state can be set only on transient tasks.");
        }
        ((TaskType)this.taskPrism.asObjectable()).setExecutionStatus(value.toTaskType());
    }

    public void setExecutionStatusImmediate(TaskExecutionStatus value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setExecutionStatusAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setExecutionStatus(TaskExecutionStatus value) {
        this.processModificationBatched(this.setExecutionStatusAndPrepareDelta(value));
    }

    private PropertyDelta<?> setExecutionStatusAndPrepareDelta(TaskExecutionStatus value) {
        this.setExecutionStatusTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_EXECUTION_STATUS, (Object[])new Object[]{value.toTaskType()}) : null;
    }

    public void makeRunnable() {
        if (!this.isTransient()) {
            throw new IllegalStateException("makeRunnable can be invoked only on transient tasks; task = " + this);
        }
        this.setExecutionStatus(TaskExecutionStatus.RUNNABLE);
    }

    public void makeWaiting() {
        if (!this.isTransient()) {
            throw new IllegalStateException("makeWaiting can be invoked only on transient tasks; task = " + this);
        }
        this.setExecutionStatus(TaskExecutionStatus.WAITING);
    }

    public TaskRecurrence getRecurrenceStatus() {
        TaskRecurrenceType xmlValue = (TaskRecurrenceType)this.taskPrism.getPropertyRealValue(TaskType.F_RECURRENCE, TaskRecurrenceType.class);
        if (xmlValue == null) {
            return null;
        }
        return TaskRecurrence.fromTaskType((TaskRecurrenceType)xmlValue);
    }

    public boolean isSingle() {
        return this.getRecurrenceStatus() == TaskRecurrence.SINGLE;
    }

    public boolean isCycle() {
        return this.getRecurrenceStatus() == TaskRecurrence.RECURRING;
    }

    public void setRecurrenceStatus(TaskRecurrence value) {
        this.processModificationBatched(this.setRecurrenceStatusAndPrepareDelta(value));
    }

    public void setRecurrenceStatusImmediate(TaskRecurrence value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setRecurrenceStatusAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setRecurrenceStatusTransient(TaskRecurrence value) {
        try {
            this.taskPrism.setPropertyRealValue(TaskType.F_RECURRENCE, (Object)value.toTaskType());
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    private PropertyDelta<?> setRecurrenceStatusAndPrepareDelta(TaskRecurrence value) {
        this.setRecurrenceStatusTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_RECURRENCE, (Object[])new Object[]{value.toTaskType()}) : null;
    }

    public void makeSingle() {
        this.setRecurrenceStatus(TaskRecurrence.SINGLE);
        this.setSchedule(new ScheduleType());
    }

    public void makeSingle(ScheduleType schedule) {
        this.setRecurrenceStatus(TaskRecurrence.SINGLE);
        this.setSchedule(schedule);
    }

    public void makeRecurrent(ScheduleType schedule) {
        this.setRecurrenceStatus(TaskRecurrence.RECURRING);
        this.setSchedule(schedule);
    }

    public void makeRecurrentSimple(int interval) {
        this.setRecurrenceStatus(TaskRecurrence.RECURRING);
        ScheduleType schedule = new ScheduleType();
        schedule.setInterval(Integer.valueOf(interval));
        this.setSchedule(schedule);
    }

    public void makeRecurrentCron(String cronLikeSpecification) {
        this.setRecurrenceStatus(TaskRecurrence.RECURRING);
        ScheduleType schedule = new ScheduleType();
        schedule.setCronLikePattern(cronLikeSpecification);
        this.setSchedule(schedule);
    }

    public ScheduleType getSchedule() {
        return ((TaskType)this.taskPrism.asObjectable()).getSchedule();
    }

    public void setSchedule(ScheduleType value) {
        this.processModificationBatched(this.setScheduleAndPrepareDelta(value));
    }

    public void setScheduleImmediate(ScheduleType value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setScheduleAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    private void setScheduleTransient(ScheduleType schedule) {
        ((TaskType)this.taskPrism.asObjectable()).setSchedule(schedule);
    }

    private PropertyDelta<?> setScheduleAndPrepareDelta(ScheduleType value) {
        this.setScheduleTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDeltaOrEmptyDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_SCHEDULE, (Object)value) : null;
    }

    public ThreadStopActionType getThreadStopAction() {
        return ((TaskType)this.taskPrism.asObjectable()).getThreadStopAction();
    }

    public void setThreadStopAction(ThreadStopActionType value) {
        this.processModificationBatched(this.setThreadStopActionAndPrepareDelta(value));
    }

    public void setThreadStopActionImmediate(ThreadStopActionType value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setThreadStopActionAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    private void setThreadStopActionTransient(ThreadStopActionType value) {
        ((TaskType)this.taskPrism.asObjectable()).setThreadStopAction(value);
    }

    private PropertyDelta<?> setThreadStopActionAndPrepareDelta(ThreadStopActionType value) {
        this.setThreadStopActionTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDeltaOrEmptyDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_THREAD_STOP_ACTION, (Object)value) : null;
    }

    public boolean isResilient() {
        ThreadStopActionType tsa = this.getThreadStopAction();
        return tsa == null || tsa == ThreadStopActionType.RESCHEDULE || tsa == ThreadStopActionType.RESTART;
    }

    public TaskBinding getBinding() {
        TaskBindingType xmlValue = (TaskBindingType)this.taskPrism.getPropertyRealValue(TaskType.F_BINDING, TaskBindingType.class);
        if (xmlValue == null) {
            return null;
        }
        return TaskBinding.fromTaskType((TaskBindingType)xmlValue);
    }

    public boolean isTightlyBound() {
        return this.getBinding() == TaskBinding.TIGHT;
    }

    public boolean isLooselyBound() {
        return this.getBinding() == TaskBinding.LOOSE;
    }

    public void setBinding(TaskBinding value) {
        this.processModificationBatched(this.setBindingAndPrepareDelta(value));
    }

    public void setBindingImmediate(TaskBinding value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setBindingAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setBindingTransient(TaskBinding value) {
        try {
            this.taskPrism.setPropertyRealValue(TaskType.F_BINDING, (Object)value.toTaskType());
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    private PropertyDelta<?> setBindingAndPrepareDelta(TaskBinding value) {
        this.setBindingTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_BINDING, (Object[])new Object[]{value.toTaskType()}) : null;
    }

    public PrismObject<UserType> getOwner() {
        PrismReference ownerRef = this.taskPrism.findReference(TaskType.F_OWNER_REF);
        if (ownerRef == null) {
            return null;
        }
        return ownerRef.getValue().getObject();
    }

    public void setOwner(PrismObject<UserType> owner) {
        PrismReference ownerRef;
        try {
            ownerRef = this.taskPrism.findOrCreateReference(TaskType.F_OWNER_REF);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        ownerRef.getValue().setObject(owner);
    }

    private PrismObject<UserType> resolveOwnerRef(OperationResult result) throws SchemaException {
        PrismReference ownerRef = this.taskPrism.findReference(TaskType.F_OWNER_REF);
        if (ownerRef == null) {
            throw new SchemaException("Task " + this.getOid() + " does not have an owner (missing ownerRef)");
        }
        try {
            return this.repositoryService.getObject(UserType.class, ownerRef.getOid(), result);
        }
        catch (ObjectNotFoundException e) {
            throw new SystemException("The owner of task " + this.getOid() + " cannot be found (owner OID: " + ownerRef.getOid() + ")", (Throwable)e);
        }
    }

    public ObjectReferenceType getObjectRef() {
        PrismReference objectRef = this.taskPrism.findReference(TaskType.F_OBJECT_REF);
        if (objectRef == null) {
            return null;
        }
        ObjectReferenceType objRefType = new ObjectReferenceType();
        objRefType.setOid(objectRef.getOid());
        objRefType.setType(objectRef.getValue().getTargetType());
        return objRefType;
    }

    public void setObjectRef(ObjectReferenceType objectRefType) {
        PrismReference objectRef;
        try {
            objectRef = this.taskPrism.findOrCreateReference(TaskType.F_OBJECT_REF);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
        objectRef.getValue().setOid(objectRefType.getOid());
        objectRef.getValue().setTargetType(objectRefType.getType());
    }

    public String getObjectOid() {
        PrismReference objectRef = this.taskPrism.findReference(TaskType.F_OBJECT_REF);
        if (objectRef == null) {
            return null;
        }
        return objectRef.getValue().getOid();
    }

    public <T extends ObjectType> PrismObject<T> getObject(Class<T> type, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        PrismReference objectRef = this.taskPrism.findReference(TaskType.F_OBJECT_REF);
        if (objectRef == null) {
            return null;
        }
        if (objectRef.getValue().getObject() != null) {
            PrismObject object = objectRef.getValue().getObject();
            if (object.canRepresent(type)) {
                return object;
            }
            throw new IllegalArgumentException("Requested object type " + type + ", but the type of object in the task is " + object.getClass());
        }
        OperationResult result = parentResult.createSubresult(String.valueOf(Task.class.getName()) + ".getObject");
        result.addContext("oid", (Object)this.getOid());
        result.addContext("implementationClass", TaskQuartzImpl.class);
        try {
            PrismObject object = this.repositoryService.getObject(type, objectRef.getOid(), result);
            objectRef.getValue().setObject(object);
            result.recordSuccess();
            return object;
        }
        catch (ObjectNotFoundException ex) {
            result.recordFatalError("Object not found", (Throwable)ex);
            throw ex;
        }
        catch (SchemaException ex) {
            result.recordFatalError("Schema error", (Throwable)ex);
            throw ex;
        }
    }

    private void setObjectTransient(PrismObject object) {
        if (object == null) {
            PrismReference objectRef = this.taskPrism.findReference(TaskType.F_OBJECT_REF);
            if (objectRef != null) {
                this.taskPrism.getValue().remove((Item)objectRef);
            }
        } else {
            PrismReference objectRef;
            try {
                objectRef = this.taskPrism.findOrCreateReference(TaskType.F_OBJECT_REF);
            }
            catch (SchemaException e) {
                throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
            }
            objectRef.getValue().setObject(object);
        }
    }

    public String getName() {
        return ((TaskType)this.taskPrism.asObjectable()).getName();
    }

    public void setName(String value) {
        this.processModificationBatched(this.setNameAndPrepareDelta(value));
    }

    public void setNameImmediate(String value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        this.processModificationNow(this.setNameAndPrepareDelta(value), parentResult);
    }

    public void setNameTransient(String name) {
        ((TaskType)this.taskPrism.asObjectable()).setName(name);
    }

    private PropertyDelta<?> setNameAndPrepareDelta(String value) {
        this.setNameTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_NAME, (Object[])new Object[]{value}) : null;
    }

    public String getDescription() {
        return ((TaskType)this.taskPrism.asObjectable()).getDescription();
    }

    public void setDescription(String value) {
        this.processModificationBatched(this.setDescriptionAndPrepareDelta(value));
    }

    public void setDescriptionImmediate(String value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setDescriptionAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setDescriptionTransient(String name) {
        ((TaskType)this.taskPrism.asObjectable()).setDescription(name);
    }

    private PropertyDelta<?> setDescriptionAndPrepareDelta(String value) {
        this.setDescriptionTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_DESCRIPTION, (Object[])new Object[]{value}) : null;
    }

    public PrismContainer<?> getExtension() {
        return this.taskPrism.getExtension();
    }

    public PrismProperty<?> getExtension(QName propertyName) {
        if (this.getExtension() != null) {
            return this.getExtension().findProperty(propertyName);
        }
        return null;
    }

    public void setExtensionProperty(PrismProperty<?> property) throws SchemaException {
        this.processModificationBatched(this.setExtensionPropertyAndPrepareDelta(property));
    }

    public void addExtensionProperty(PrismProperty<?> property) throws SchemaException {
        this.processModificationBatched(this.addExtensionPropertyAndPrepareDelta(property));
    }

    public void deleteExtensionProperty(PrismProperty<?> property) throws SchemaException {
        this.processModificationBatched(this.deleteExtensionPropertyAndPrepareDelta(property));
    }

    public void setExtensionPropertyImmediate(PrismProperty<?> property, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setExtensionPropertyAndPrepareDelta(property), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setExtensionPropertyTransient(PrismProperty<?> property) throws SchemaException {
        this.setExtensionPropertyAndPrepareDelta(property);
    }

    private PropertyDelta<?> setExtensionPropertyAndPrepareDelta(PrismProperty<?> property) throws SchemaException {
        PropertyDelta delta = new PropertyDelta(new PropertyPath(new QName[]{TaskType.F_EXTENSION, property.getName()}), property.getDefinition());
        delta.setValuesToReplace((Collection)property.getValues());
        ArrayList<PropertyDelta> modifications = new ArrayList<PropertyDelta>(1);
        modifications.add(delta);
        PropertyDelta.applyTo(modifications, this.taskPrism);
        return this.isPersistent() ? delta : null;
    }

    private PropertyDelta<?> addExtensionPropertyAndPrepareDelta(PrismProperty<?> property) throws SchemaException {
        PropertyDelta delta = new PropertyDelta(new PropertyPath(new QName[]{TaskType.F_EXTENSION, property.getName()}), property.getDefinition());
        delta.addValuesToAdd((Collection)property.getValues());
        ArrayList<PropertyDelta> modifications = new ArrayList<PropertyDelta>(1);
        modifications.add(delta);
        PropertyDelta.applyTo(modifications, this.taskPrism);
        return this.isPersistent() ? delta : null;
    }

    private PropertyDelta<?> deleteExtensionPropertyAndPrepareDelta(PrismProperty<?> property) throws SchemaException {
        PropertyDelta delta = new PropertyDelta(new PropertyPath(new QName[]{TaskType.F_EXTENSION, property.getName()}), property.getDefinition());
        delta.addValuesToDelete((Collection)property.getValues());
        ArrayList<PropertyDelta> modifications = new ArrayList<PropertyDelta>(1);
        modifications.add(delta);
        PropertyDelta.applyTo(modifications, this.taskPrism);
        return this.isPersistent() ? delta : null;
    }

    public String getNode() {
        return ((TaskType)this.taskPrism.asObjectable()).getNode();
    }

    public void setNode(String value) {
        this.processModificationBatched(this.setNodeAndPrepareDelta(value));
    }

    public void setNodeImmediate(String value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setNodeAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setNodeTransient(String value) {
        ((TaskType)this.taskPrism.asObjectable()).setNode(value);
    }

    private PropertyDelta<?> setNodeAndPrepareDelta(String value) {
        this.setNodeTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_NODE, (Object[])new Object[]{value}) : null;
    }

    public Long getLastRunStartTimestamp() {
        XMLGregorianCalendar gc = ((TaskType)this.taskPrism.asObjectable()).getLastRunStartTimestamp();
        return gc != null ? new Long(XmlTypeConverter.toMillis((XMLGregorianCalendar)gc)) : null;
    }

    public void setLastRunStartTimestamp(Long value) {
        this.processModificationBatched(this.setLastRunStartTimestampAndPrepareDelta(value));
    }

    public void setLastRunStartTimestampImmediate(Long value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setLastRunStartTimestampAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setLastRunStartTimestampTransient(Long value) {
        ((TaskType)this.taskPrism.asObjectable()).setLastRunStartTimestamp(XmlTypeConverter.createXMLGregorianCalendar((long)value));
    }

    private PropertyDelta<?> setLastRunStartTimestampAndPrepareDelta(Long value) {
        this.setLastRunStartTimestampTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDeltaOrEmptyDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_LAST_RUN_START_TIMESTAMP, (Object)((TaskType)this.taskPrism.asObjectable()).getLastRunStartTimestamp()) : null;
    }

    public Long getLastRunFinishTimestamp() {
        XMLGregorianCalendar gc = ((TaskType)this.taskPrism.asObjectable()).getLastRunFinishTimestamp();
        return gc != null ? new Long(XmlTypeConverter.toMillis((XMLGregorianCalendar)gc)) : null;
    }

    public void setLastRunFinishTimestamp(Long value) {
        this.processModificationBatched(this.setLastRunFinishTimestampAndPrepareDelta(value));
    }

    public void setLastRunFinishTimestampImmediate(Long value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setLastRunFinishTimestampAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setLastRunFinishTimestampTransient(Long value) {
        ((TaskType)this.taskPrism.asObjectable()).setLastRunFinishTimestamp(XmlTypeConverter.createXMLGregorianCalendar((long)value));
    }

    private PropertyDelta<?> setLastRunFinishTimestampAndPrepareDelta(Long value) {
        this.setLastRunFinishTimestampTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDeltaOrEmptyDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_LAST_RUN_FINISH_TIMESTAMP, (Object)((TaskType)this.taskPrism.asObjectable()).getLastRunFinishTimestamp()) : null;
    }

    public Long getNextRunStartTime(OperationResult parentResult) {
        return this.taskManager.getNextRunStartTime(this.getOid(), parentResult);
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("Task(");
        sb.append(TaskQuartzImpl.class.getName());
        sb.append(")\n");
        sb.append(this.taskPrism.debugDump(1));
        sb.append("\n  persistenceStatus: ");
        sb.append(this.persistenceStatus);
        sb.append("\n  result: ");
        if (this.taskResult == null) {
            sb.append("null");
        } else {
            sb.append(this.taskResult.dump());
        }
        return sb.toString();
    }

    public TaskHandler getHandler() {
        String handlerUri = ((TaskType)this.taskPrism.asObjectable()).getHandlerUri();
        return handlerUri != null ? this.taskManager.getHandler(handlerUri) : null;
    }

    public void setCategory(String value) {
        this.processModificationBatched(this.setCategoryAndPrepareDelta(value));
    }

    public void setCategoryImmediate(String value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setCategoryAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setCategoryTransient(String value) {
        try {
            this.taskPrism.setPropertyRealValue(TaskType.F_CATEGORY, (Object)value);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    private PropertyDelta<?> setCategoryAndPrepareDelta(String value) {
        this.setCategoryTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_CATEGORY, (Object[])new Object[]{value}) : null;
    }

    public String getCategory() {
        return ((TaskType)this.taskPrism.asObjectable()).getCategory();
    }

    public String getCategoryFromHandler() {
        TaskHandler h = this.getHandler();
        if (h != null) {
            return h.getCategoryName((Task)this);
        }
        return null;
    }

    public ModelOperationStateType getModelOperationState() {
        return ((TaskType)this.taskPrism.asObjectable()).getModelOperationState();
    }

    public void setModelOperationState(ModelOperationStateType value) {
        this.processModificationBatched(this.setModelOperationStateAndPrepareDelta(value));
    }

    public void setModelOperationStateImmediate(ModelOperationStateType value, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        try {
            this.processModificationNow(this.setModelOperationStateAndPrepareDelta(value), parentResult);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public void setModelOperationStateTransient(ModelOperationStateType value) {
        ((TaskType)this.taskPrism.asObjectable()).setModelOperationState(value);
    }

    private PropertyDelta<?> setModelOperationStateAndPrepareDelta(ModelOperationStateType value) {
        this.setModelOperationStateTransient(value);
        return this.isPersistent() ? PropertyDelta.createReplaceDelta(this.taskManager.getTaskObjectDefinition(), (QName)TaskType.F_MODEL_OPERATION_STATE, (Object[])new Object[]{value}) : null;
    }

    public void refresh(OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        OperationResult result = parentResult.createSubresult(String.valueOf(Task.class.getName()) + ".refresh");
        result.addContext("implementationClass", TaskQuartzImpl.class);
        result.addContext("oid", (Object)this.getOid());
        if (!this.isPersistent()) {
            result.recordSuccess();
            return;
        }
        PrismObject repoObj = null;
        try {
            repoObj = this.repositoryService.getObject(TaskType.class, this.getOid(), result);
        }
        catch (ObjectNotFoundException ex) {
            result.recordFatalError("Object not found", (Throwable)ex);
            throw ex;
        }
        catch (SchemaException ex) {
            result.recordFatalError("Schema error", (Throwable)ex);
            throw ex;
        }
        this.taskPrism = repoObj;
        this.initialize(result);
        result.recordSuccess();
    }

    public void signalShutdown() {
        LOGGER.trace("canRun set to false for task " + this + " (" + System.identityHashCode(this) + ")");
        this.canRun = false;
    }

    public boolean canRun() {
        return this.canRun;
    }

    public boolean stillCanStart() {
        if (this.getSchedule() != null && this.getSchedule().getLatestStartTime() != null) {
            long lst = this.getSchedule().getLatestStartTime().toGregorianCalendar().getTimeInMillis();
            return lst >= System.currentTimeMillis();
        }
        return true;
    }

    public String toString() {
        return "Task(id:" + this.getTaskIdentifier() + ", name:" + this.getName() + ", oid:" + this.getOid() + ")";
    }

    public int hashCode() {
        return this.taskPrism.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskQuartzImpl other = (TaskQuartzImpl)obj;
        if (this.persistenceStatus != other.persistenceStatus) {
            return false;
        }
        if (this.taskResult == null ? other.taskResult != null : !this.taskResult.equals(other.taskResult)) {
            return false;
        }
        return !(this.taskPrism == null ? other.taskPrism != null : !this.taskPrism.equals(other.taskPrism));
    }

    private PrismContext getPrismContext() {
        return this.taskManager.getPrismContext();
    }

    public Node currentlyExecutesAt() {
        return this.currentlyExecutesAt;
    }

    void setCurrentlyExecutesAt(Node node) {
        this.currentlyExecutesAt = node;
    }
}

