/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.util;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.JAXBUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.aspect.ObjectFormatter;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowAttributesType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UnknownJavaObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import com.evolveum.prism.xml.ns._public.types_2.ItemDeltaType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.PropertyUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SchemaDebugUtil
implements ObjectFormatter {
    private static int SHOW_LIST_MEMBERS = 3;

    static {
        SchemaDebugUtil f = new SchemaDebugUtil();
        MidpointAspect.registerFormatter((ObjectFormatter)f);
    }

    public static String dumpJaxbObject(Object jaxbObject, String elementLocalName, PrismContext prismContext) {
        QName elementQName = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", elementLocalName);
        try {
            return prismContext.getPrismJaxbProcessor().marshalElementToString(jaxbObject, elementQName);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Error marshalling JAXB object " + jaxbObject + ": " + e.getMessage(), e);
        }
    }

    public static String debugDump(Collection<? extends DebugDumpable> dumpables) {
        return SchemaDebugUtil.debugDump(dumpables, 0);
    }

    public static String debugDump(Collection<? extends DebugDumpable> dumpables, int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(SchemaDebugUtil.getCollectionOpeningSymbol(dumpables));
        sb.append("\n");
        for (DebugDumpable debugDumpable : dumpables) {
            sb.append(debugDumpable.debugDump(indent + 1));
        }
        sb.append("\n");
        sb.append(SchemaDebugUtil.getCollectionClosingSymbol(dumpables));
        return sb.toString();
    }

    public static String debugDumpXsdAnyProperties(Collection<?> xsdAnyCollection, int indent) {
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.indentDebugDump(sb, indent);
        sb.append(SchemaDebugUtil.getCollectionOpeningSymbol(xsdAnyCollection));
        for (Object element : xsdAnyCollection) {
            sb.append("\n");
            SchemaDebugUtil.indentDebugDump(sb, indent + 1);
            sb.append(SchemaDebugUtil.prettyPrintElementAsProperty(element));
        }
        sb.append("\n");
        SchemaDebugUtil.indentDebugDump(sb, indent);
        sb.append(SchemaDebugUtil.getCollectionClosingSymbol(xsdAnyCollection));
        return sb.toString();
    }

    private static String prettyPrintElementAsProperty(Object element) {
        if (element == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("<");
        QName elementName = JAXBUtil.getElementQName((Object)element);
        sb.append(SchemaDebugUtil.prettyPrint(elementName));
        sb.append(">");
        if (element instanceof Element) {
            Element domElement = (Element)element;
            sb.append(domElement.getTextContent());
        } else {
            sb.append(element.toString());
        }
        return sb.toString();
    }

    private static String getCollectionOpeningSymbol(Collection<?> col) {
        if (col instanceof List) {
            return "[";
        }
        if (col instanceof Set) {
            return "{";
        }
        return String.valueOf(col.getClass().getSimpleName()) + "(";
    }

    private static String getCollectionClosingSymbol(Collection<?> col) {
        if (col instanceof List) {
            return "]";
        }
        if (col instanceof Set) {
            return "}";
        }
        return ")";
    }

    public static void indentDebugDump(StringBuilder sb, int indent) {
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
    }

    public static <K, V extends DebugDumpable> String dumpMapMultiLine(Map<K, V> map) {
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.debugDumpMapMultiLine(sb, map, 0);
        return sb.toString();
    }

    public static <K, V extends DebugDumpable> void debugDumpMapMultiLine(StringBuilder sb, Map<K, V> map, int indent) {
        Iterator<Map.Entry<K, V>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, V> entry = i.next();
            SchemaDebugUtil.indentDebugDump(sb, indent);
            sb.append(SchemaDebugUtil.prettyPrint(entry.getKey()));
            sb.append(" => ");
            DebugDumpable value = (DebugDumpable)entry.getValue();
            if (value == null) {
                sb.append("null");
            } else {
                sb.append("\n");
                sb.append(value.debugDump(indent + 1));
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
    }

    public static <K, V> void debugDumpMapSingleLine(StringBuilder sb, Map<K, V> map, int indent) {
        Iterator<Map.Entry<K, V>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, V> entry = i.next();
            SchemaDebugUtil.indentDebugDump(sb, indent);
            sb.append(SchemaDebugUtil.prettyPrint(entry.getKey()));
            sb.append(" => ");
            V value = entry.getValue();
            if (value == null) {
                sb.append("null");
            } else {
                sb.append(value);
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
    }

    public static String debugDump(ObjectType objectType, int indent) {
        if (objectType instanceof AccountShadowType) {
            return SchemaDebugUtil.debugDump((AccountShadowType)objectType, indent);
        }
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.indentDebugDump(sb, indent);
        sb.append(SchemaDebugUtil.prettyPrint(objectType));
        return sb.toString();
    }

    public static String prettyPrint(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(SchemaDebugUtil.getCollectionOpeningSymbol(collection));
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            sb.append(SchemaDebugUtil.prettyPrint(iterator.next()));
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append(SchemaDebugUtil.getCollectionClosingSymbol(collection));
        return sb.toString();
    }

    public static String prettyPrint(QName qname) {
        if (qname == null) {
            return "null";
        }
        if (qname.getNamespaceURI() != null && qname.getNamespaceURI().startsWith("http://midpoint.evolveum.com/xml/ns/public/")) {
            return "{..." + qname.getNamespaceURI().substring("http://midpoint.evolveum.com/xml/ns/public/".length()) + "}" + qname.getLocalPart();
        }
        return qname.toString();
    }

    public static String prettyPrint(AssignmentType assignmentType) {
        if (assignmentType == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("AssignmentType(");
        if (assignmentType.getTarget() != null) {
            sb.append("target:");
            sb.append(SchemaDebugUtil.prettyPrint(assignmentType.getTarget()));
        }
        if (assignmentType.getTargetRef() != null) {
            sb.append("target:");
            sb.append(SchemaDebugUtil.prettyPrint(assignmentType.getTargetRef()));
        }
        if (assignmentType.getAccountConstruction() != null) {
            sb.append(SchemaDebugUtil.prettyPrint(assignmentType.getAccountConstruction()));
        }
        sb.append(", ");
        if (assignmentType.getActivation() != null) {
            sb.append(SchemaDebugUtil.prettyPrint(assignmentType.getActivation()));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String prettyPrint(AccountConstructionType act) {
        if (act == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("AccountConstructionType(");
        if (act.getResource() != null) {
            sb.append(SchemaDebugUtil.prettyPrint(act.getResource()));
        }
        if (act.getResourceRef() != null) {
            sb.append(SchemaDebugUtil.prettyPrint(act.getResourceRef()));
        }
        sb.append(", ");
        if (act.getType() != null) {
            sb.append("type=");
            sb.append(act.getType());
            sb.append(", ");
        }
        if (act.getAttribute() != null) {
            for (ValueConstructionType attrConstr : act.getAttribute()) {
                sb.append(SchemaDebugUtil.prettyPrint(attrConstr));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String prettyPrint(ValueConstructionType vc) {
        if (vc == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("ValueConstructionType(");
        if (vc.getRef() != null) {
            sb.append("ref=");
            sb.append(SchemaDebugUtil.prettyPrint(vc.getRef()));
            sb.append(",");
        }
        if (vc.getValueConstructor() != null) {
            SchemaDebugUtil.prettyPringValueConstructor(sb, vc.getValueConstructor());
            sb.append(",");
        }
        if (vc.getSequence() != null) {
            sb.append("[");
            for (JAXBElement<?> vconstr : vc.getSequence().getValueConstructor()) {
                SchemaDebugUtil.prettyPringValueConstructor(sb, vconstr);
                sb.append(",");
            }
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    private static void prettyPringValueConstructor(StringBuilder sb, JAXBElement vconstr) {
        sb.append("ValueConstructor(");
        sb.append(SchemaDebugUtil.prettyPrint(vconstr));
        sb.append(")");
    }

    public static String prettyPrint(ObjectReferenceType ref) {
        if (ref == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("ref(");
        sb.append(ref.getOid());
        sb.append(",");
        sb.append(SchemaDebugUtil.prettyPrint(ref.getType()));
        sb.append(")");
        return sb.toString();
    }

    public static String prettyPrint(PropertyReferenceListType reflist) {
        if (reflist == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        Iterator<Element> iterator = reflist.getProperty().iterator();
        while (iterator.hasNext()) {
            XPathHolder xpath = new XPathHolder(iterator.next());
            sb.append(xpath.toString());
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String prettyPrint(ObjectType object) {
        return SchemaDebugUtil.prettyPrint(object, false);
    }

    public static String prettyPrint(ObjectType object, boolean showContent) {
        if (object instanceof AccountShadowType) {
            return SchemaDebugUtil.prettyPrint((AccountShadowType)object, showContent);
        }
        if (object == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(object.getClass().getSimpleName());
        sb.append("(");
        sb.append(object.getOid());
        sb.append(",");
        sb.append(object.getName());
        if (showContent) {
            PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors((Object)object);
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor desc = propertyDescriptorArray[n2];
                if (!"oid".equals(desc.getName()) && !"name".equals(desc.getName())) {
                    try {
                        Object value = PropertyUtils.getProperty((Object)object, (String)desc.getName());
                        sb.append(desc.getName());
                        sb.append("=");
                        sb.append(value);
                        sb.append(",");
                    }
                    catch (IllegalAccessException ex) {
                        sb.append(desc.getName());
                        sb.append(":");
                        sb.append(ex.getClass().getSimpleName());
                        sb.append(",");
                    }
                    catch (InvocationTargetException ex) {
                        sb.append(desc.getName());
                        sb.append(":");
                        sb.append(ex.getClass().getSimpleName());
                        sb.append(",");
                    }
                    catch (NoSuchMethodException ex) {
                        sb.append(desc.getName());
                        sb.append(":");
                        sb.append(ex.getClass().getSimpleName());
                        sb.append(",");
                    }
                }
                ++n2;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String prettyPrint(ProtectedStringType protectedStringType) {
        if (protectedStringType == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("ProtectedStringType(");
        if (protectedStringType.getEncryptedData() != null) {
            sb.append("[encrypted data]");
        }
        if (protectedStringType.getClearValue() != null) {
            sb.append("\"");
            sb.append(protectedStringType.getClearValue());
            sb.append("\"");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String prettyPrint(OperationResultType resultType) {
        if (resultType == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("RT(");
        sb.append(resultType.getOperation());
        sb.append(",");
        sb.append((Object)resultType.getStatus());
        sb.append(",");
        sb.append(resultType.getMessage());
        sb.append(")");
        return sb.toString();
    }

    public static String prettyPrint(AccountShadowType object) {
        return SchemaDebugUtil.prettyPrint(object, false);
    }

    public static String prettyPrint(AccountShadowType object, boolean showContent) {
        if (object == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(object.getClass().getSimpleName());
        sb.append("(");
        sb.append(object.getOid());
        sb.append(",name=");
        sb.append(object.getName());
        sb.append(",");
        if (showContent) {
            if (object.getResource() != null) {
                sb.append("resource=(@");
                sb.append(object.getResource());
                sb.append("),");
            }
            if (object.getResourceRef() != null) {
                sb.append("resourceRef=(@");
                sb.append(object.getResourceRef());
                sb.append("),");
            }
            sb.append("objectClass=");
            sb.append(object.getObjectClass());
            sb.append(",attributes=(");
            sb.append(SchemaDebugUtil.prettyPrint(object.getAttributes()));
            sb.append("),...");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String debugDump(AccountShadowType object, int indent) {
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.indentDebugDump(sb, indent);
        if (object == null) {
            sb.append("null");
            return sb.toString();
        }
        sb.append(object.getClass().getSimpleName());
        sb.append("(");
        sb.append(object.getOid());
        sb.append(",name=");
        sb.append(object.getName());
        if (object.getResource() != null) {
            sb.append("\n");
            SchemaDebugUtil.indentDebugDump(sb, indent + 1);
            sb.append("resource: ");
            sb.append(ObjectTypeUtil.toShortString(object.getResource()));
        }
        if (object.getResourceRef() != null) {
            sb.append("\n");
            SchemaDebugUtil.indentDebugDump(sb, indent + 1);
            sb.append("resourceRef: ");
            sb.append(ObjectTypeUtil.toShortString(object.getResourceRef()));
        }
        sb.append("\n");
        SchemaDebugUtil.indentDebugDump(sb, indent + 1);
        sb.append("objectClass: ");
        sb.append(SchemaDebugUtil.prettyPrint(object.getObjectClass()));
        sb.append("\n");
        SchemaDebugUtil.indentDebugDump(sb, indent + 1);
        sb.append("attributes:");
        ResourceObjectShadowAttributesType attributes = object.getAttributes();
        if (attributes == null) {
            sb.append("null");
        } else {
            sb.append("\n");
            sb.append(SchemaDebugUtil.debugDumpXsdAnyProperties(attributes.getAny(), indent + 2));
        }
        sb.append("\n");
        SchemaDebugUtil.indentDebugDump(sb, indent + 1);
        sb.append("activation:");
        if (object.getActivation() == null) {
            sb.append("null");
        } else {
            sb.append("\n");
            sb.append(SchemaDebugUtil.debugDump(object.getActivation(), indent + 2));
        }
        return sb.toString();
    }

    private static String debugDump(ActivationType activation, int indent) {
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.indentDebugDump(sb, indent);
        sb.append("enabled: ");
        sb.append(activation.isEnabled());
        if (activation.getValidFrom() != null) {
            sb.append("\n");
            SchemaDebugUtil.indentDebugDump(sb, indent);
            sb.append("valid from: ");
            sb.append(activation.getValidFrom());
        }
        if (activation.getValidTo() != null) {
            sb.append("\n");
            SchemaDebugUtil.indentDebugDump(sb, indent);
            sb.append("valid to: ");
            sb.append(activation.getValidTo());
        }
        return sb.toString();
    }

    public static String prettyPrint(ObjectModificationType objectChange) {
        if (objectChange == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("ObjectModification(");
        sb.append(objectChange.getOid());
        sb.append(",");
        List<ItemDeltaType> changes = objectChange.getModification();
        sb.append("[");
        Iterator<ItemDeltaType> iterator = changes.iterator();
        while (iterator.hasNext()) {
            sb.append(SchemaDebugUtil.prettyPrint(iterator.next()));
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("])");
        return sb.toString();
    }

    public static String prettyPrint(ItemDeltaType change) {
        if (change == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("ProperyModification(");
        sb.append(change.getModificationType());
        sb.append(",");
        if (change.getPath() != null) {
            XPathHolder xpath = new XPathHolder(change.getPath());
            sb.append(xpath.toString());
        } else {
            sb.append("xpath=null");
        }
        sb.append(",");
        for (Object element : change.getValue().getAny()) {
            sb.append(SchemaDebugUtil.prettyPrint(element));
            sb.append(",");
        }
        return sb.toString();
    }

    public static String prettyPrint(List<Element> list) {
        if (list == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (list.size() > 0) {
            Element el0 = list.get(0);
            QName elQName = el0.getPrefix() != null ? new QName(el0.getNamespaceURI(), el0.getLocalName(), el0.getPrefix()) : new QName(el0.getNamespaceURI(), el0.getLocalName());
            sb.append(elQName);
            sb.append("[");
            Iterator<Element> iterator = list.iterator();
            while (iterator.hasNext()) {
                Element el = iterator.next();
                sb.append(SchemaDebugUtil.prettyPrint(el, false));
                if (iterator.hasNext()) {
                    sb.append(",");
                }
                sb.append("]");
            }
        } else {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static String prettyPrint(Node node) {
        if (node instanceof Element) {
            return SchemaDebugUtil.prettyPrint((Element)node);
        }
        return "Node:" + node.getNodeName();
    }

    public static String prettyPrint(Element element) {
        return SchemaDebugUtil.prettyPrint(element, true);
    }

    public static String prettyPrint(Element element, boolean displayTag) {
        if (element == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (displayTag) {
            sb.append("<");
            if (element.getLocalName() != null) {
                sb.append(new QName(element.getNamespaceURI(), element.getLocalName()));
            } else {
                sb.append("<null>");
            }
            sb.append(">");
        }
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attr = attributes.item(i);
            if (!("xmlns".equals(attr.getPrefix()) || (attr.getPrefix() == null || attr.getPrefix().isEmpty()) && "xmlns".equals(attr.getLocalName()))) {
                sb.append("@");
                sb.append(attr.getLocalName());
                sb.append("=");
                sb.append(attr.getTextContent());
                if (i < attributes.getLength() - 1) {
                    sb.append(",");
                }
            }
            ++i;
        }
        if (attributes.getLength() > 0) {
            sb.append(":");
        }
        StringBuilder content = new StringBuilder();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                content.append(((Text)child).getTextContent());
            } else if (child.getNodeType() != 8) {
                content = new StringBuilder("[complex content]");
                break;
            }
            child = child.getNextSibling();
        }
        sb.append((CharSequence)content);
        return sb.toString();
    }

    public static String prettyPrint(ObjectListType list) {
        if (list == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("ObjectList[");
        Iterator<ObjectType> iterator = list.getObject().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (i < SHOW_LIST_MEMBERS) {
                sb.append(SchemaDebugUtil.prettyPrint(iterator.next()));
                if (iterator.hasNext()) {
                    sb.append(",");
                }
            } else {
                sb.append("(and ");
                sb.append(list.getObject().size() - i);
                sb.append(" more)");
                break;
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String prettyPrint(QueryType query) {
        if (query == null) {
            return "null";
        }
        Element filter = query.getFilter();
        StringBuilder sb = new StringBuilder("Query(");
        SchemaDebugUtil.prettyPrintFilter(sb, filter);
        sb.append(")");
        return sb.toString();
    }

    private static void prettyPrintFilter(StringBuilder sb, Element filter) {
        if (filter == null) {
            sb.append("null");
            return;
        }
        String tag = filter.getLocalName();
        sb.append(tag);
        sb.append("(");
        if ("type".equals(tag)) {
            String uri = filter.getAttribute("uri");
            QName typeQname = QNameUtil.uriToQName((String)uri);
            sb.append(typeQname.getLocalPart());
            sb.append(")");
            return;
        }
        NodeList childNodes = filter.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 3) {
                sb.append("\"");
                sb.append(node.getTextContent());
                sb.append("\"");
            } else if (node.getNodeType() == 1) {
                SchemaDebugUtil.prettyPrintFilter(sb, (Element)node);
            } else {
                sb.append("!");
                sb.append(node.getNodeType());
            }
            sb.append(",");
            ++i;
        }
        sb.append(")");
    }

    public static String prettyPrint(PagingType paging) {
        if (paging == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("Paging(");
        if (paging.getOffset() != null) {
            sb.append(paging.getOffset()).append(",");
        } else {
            sb.append(",");
        }
        if (paging.getMaxSize() != null) {
            sb.append(paging.getMaxSize()).append(",");
        } else {
            sb.append(",");
        }
        if (paging.getOrderBy() != null) {
            sb.append(SchemaDebugUtil.prettyPrint(paging.getOrderBy())).append(",");
        } else {
            sb.append(",");
        }
        if (paging.getOrderDirection() != null) {
            sb.append((Object)paging.getOrderDirection());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String resourceFromShadow(ResourceObjectShadowType shadow) {
        if (shadow == null) {
            return null;
        }
        ResourceType resource = shadow.getResource();
        if (resource != null) {
            return resource.getName();
        }
        ObjectReferenceType resourceRef = shadow.getResourceRef();
        if (resourceRef != null) {
            return resourceRef.getOid();
        }
        return "ERROR:noResource";
    }

    public static String prettyPrint(JAXBElement<?> element) {
        return "JAXBElement(" + DebugUtil.prettyPrint((QName)element.getName()) + "): " + element.getValue();
    }

    public static String prettyPrint(UnknownJavaObjectType xml) {
        if (xml == null) {
            return "null";
        }
        return "Java(" + xml.getClazz() + "," + xml.getToString() + ")";
    }

    public static String prettyPrint(Object value) {
        Object elementValue;
        if (value == null) {
            return "null";
        }
        String out = null;
        if (value instanceof JAXBElement && (out = SchemaDebugUtil.tryPrettyPrint(elementValue = ((JAXBElement)value).getValue())) != null) {
            return "JAXBElement(" + ((JAXBElement)value).getName() + "," + out + ")";
        }
        out = SchemaDebugUtil.tryPrettyPrint(value);
        if (out == null) {
            out = value.toString();
        }
        return out;
    }

    private static String tryPrettyPrint(Object value) {
        if (value instanceof Class) {
            Class c = (Class)value;
            if (c.getPackage().getName().equals("com.evolveum.midpoint.xml.ns._public.common.common_2")) {
                return c.getSimpleName();
            }
            return c.getName();
        }
        if (value instanceof Collection) {
            return SchemaDebugUtil.prettyPrint((Collection)value);
        }
        if (value instanceof ObjectType) {
            return SchemaDebugUtil.prettyPrint((ObjectType)value);
        }
        if (value instanceof Node) {
            return SchemaDebugUtil.prettyPrint((Node)value);
        }
        Method[] methodArray = SchemaDebugUtil.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypes;
            Method method = methodArray[n2];
            if (method.getName().equals("prettyPrint") && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0].equals(value.getClass())) {
                try {
                    return (String)method.invoke(null, value);
                }
                catch (IllegalArgumentException e) {
                    return "###INTERNAL#ERROR### Illegal argument: " + e.getMessage();
                }
                catch (IllegalAccessException e) {
                    return "###INTERNAL#ERROR### Illegal access: " + e.getMessage();
                }
                catch (InvocationTargetException e) {
                    return "###INTERNAL#ERROR### Illegal target: " + e.getMessage();
                }
                catch (Throwable e) {
                    return "###INTERNAL#ERROR### " + e.getClass().getName() + ": " + e.getMessage();
                }
            }
            ++n2;
        }
        return null;
    }

    public String format(Object o) {
        try {
            return SchemaDebugUtil.prettyPrint(o);
        }
        catch (Throwable t) {
            return "###INTERNAL#ERROR### " + t.getClass().getName() + ": " + t.getMessage();
        }
    }
}

