/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.util;

import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class ConnectorTypeUtil {
    public static String getConnectorHostTypeOid(ConnectorType connectorType) {
        if (connectorType.getConnectorHostRef() != null) {
            return connectorType.getConnectorHostRef().getOid();
        }
        if (connectorType.getConnectorHost() != null) {
            return connectorType.getConnectorHost().getOid();
        }
        return null;
    }

    public static Element getConnectorXsdSchema(ConnectorType connector) {
        XmlSchemaType xmlSchemaType = connector.getSchema();
        if (xmlSchemaType == null) {
            return null;
        }
        return ObjectTypeUtil.findXsdElement(xmlSchemaType);
    }

    public static Element getConnectorXsdSchema(PrismObject<ConnectorType> connector) {
        PrismContainer xmlSchema = connector.findContainer(ConnectorType.F_SCHEMA);
        if (xmlSchema == null) {
            return null;
        }
        return ObjectTypeUtil.findXsdElement((PrismContainer<XmlSchemaType>)xmlSchema);
    }

    public static void setConnectorXsdSchema(ConnectorType connectorType, Element xsdElement) {
        PrismObject connector = connectorType.asPrismObject();
        ConnectorTypeUtil.setConnectorXsdSchema((PrismObject<ConnectorType>)connector, xsdElement);
    }

    public static void setConnectorXsdSchema(PrismObject<ConnectorType> connector, Element xsdElement) {
        try {
            PrismContainer schemaContainer = connector.findOrCreateContainer(ConnectorType.F_SCHEMA);
            PrismProperty definitionProperty = schemaContainer.findOrCreateProperty(XmlSchemaType.F_DEFINITION);
            ObjectTypeUtil.setXsdSchemaDefinition((PrismProperty<Element>)definitionProperty, xsdElement);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    public static PrismSchema getConnectorSchema(ConnectorType connectorType, PrismContext prismContext) throws SchemaException {
        Element connectorSchemaElement = ConnectorTypeUtil.getConnectorXsdSchema(connectorType);
        return PrismSchema.parse((Element)connectorSchemaElement, (String)("schema for " + connectorType), (PrismContext)prismContext);
    }

    public static PrismContainerDefinition<?> findConfigurationContainerDefintion(ConnectorType connectorType, PrismSchema connectorSchema) {
        QName configContainerQName = new QName(connectorType.getNamespace(), ResourceType.F_CONFIGURATION.getLocalPart());
        return connectorSchema.findContainerDefinitionByElementName(configContainerQName);
    }

    public static PrismContainerDefinition<?> findConfigurationContainerDefintion(ConnectorType connectorType, PrismContext prismContext) throws SchemaException {
        PrismSchema connectorSchema = ConnectorTypeUtil.getConnectorSchema(connectorType, prismContext);
        return ConnectorTypeUtil.findConfigurationContainerDefintion(connectorType, connectorSchema);
    }
}

