/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.result;

import com.evolveum.midpoint.xml.ns._public.common.common_2.EntryType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LocalizedMessageType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultStatusType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ParamsType;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public abstract class OperationResultFactory {
    private static long TOKEN_NUMBER = 0L;

    private static synchronized long getNextToken() {
        return ++TOKEN_NUMBER;
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status, String message, String localizedMessage) {
        return OperationResultFactory.createOperationResult(operation, status, null, message, null, localizedMessage, null);
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status, String message, String localizedMessage, Object[] localizedArguments) {
        return OperationResultFactory.createOperationResult(operation, status, null, message, null, localizedMessage, localizedArguments);
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status, String message, String messageCode, String localizedMessage) {
        return OperationResultFactory.createOperationResult(operation, status, null, message, messageCode, localizedMessage, null);
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status, String message, String messageCode, String localizedMessage, Object[] localizedArguments) {
        return OperationResultFactory.createOperationResult(operation, status, null, message, messageCode, localizedMessage, localizedArguments);
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status, Map<String, Element> params, String message, String messageCode, String localizedMessage, Object[] localizedArguments) {
        OperationResultType result = OperationResultFactory.createOperationResult(operation, status, params, message, messageCode);
        if (StringUtils.isEmpty((String)localizedMessage)) {
            return result;
        }
        ObjectFactory factory = new ObjectFactory();
        LocalizedMessageType localizedMessageType = factory.createLocalizedMessageType();
        result.setLocalizedMessage(localizedMessageType);
        localizedMessageType.setKey(localizedMessage);
        if (localizedArguments == null || localizedArguments.length == 0) {
            return result;
        }
        Object[] objectArray = localizedArguments;
        int n = localizedArguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            localizedMessageType.getArgument().add(object);
            ++n2;
        }
        return result;
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status, Map<String, Element> params, String message, String messageCode) {
        OperationResultType result = OperationResultFactory.createOperationResult(operation, status, params, message);
        result.setMessageCode(messageCode);
        return result;
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status, Map<String, Element> params, String message) {
        OperationResultType result = OperationResultFactory.createOperationResult(operation, status, params);
        result.setMessage(message);
        return result;
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status, Map<String, Element> params) {
        OperationResultType result = OperationResultFactory.createOperationResult(operation, status);
        if (params == null || params.isEmpty()) {
            return result;
        }
        ObjectFactory factory = new ObjectFactory();
        ParamsType paramsType = factory.createParamsType();
        result.setParams(paramsType);
        Set<Map.Entry<String, Element>> set = params.entrySet();
        for (Map.Entry<String, Element> entry : set) {
            EntryType entryType = factory.createEntryType();
            entryType.setKey(entry.getKey());
            entryType.setAny(entry.getValue());
            paramsType.getEntry().add(entryType);
        }
        return result;
    }

    public static OperationResultType createOperationResult(String operation, OperationResultStatusType status) {
        if (StringUtils.isEmpty((String)operation)) {
            throw new IllegalArgumentException("Operation name not defined.");
        }
        if (status == null) {
            throw new IllegalArgumentException("Operation status not defined.");
        }
        ObjectFactory factory = new ObjectFactory();
        OperationResultType result = factory.createOperationResultType();
        result.setToken(OperationResultFactory.getNextToken());
        result.setOperation(operation);
        result.setStatus(status);
        return result;
    }
}

