/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;

public final class ResourceAttributeContainer
extends PrismContainer {
    public ResourceAttributeContainer(QName name, ResourceAttributeContainerDefinition definition, PrismContext prismContext) {
        super(name, (PrismContainerDefinition)definition, prismContext);
    }

    public ResourceAttributeContainerDefinition getDefinition() {
        return (ResourceAttributeContainerDefinition)super.getDefinition();
    }

    public Collection<ResourceAttribute<?>> getAttributes() {
        return this.getValue().getProperties();
    }

    public void add(ResourceAttribute<?> attribute) throws SchemaException {
        super.add(attribute);
    }

    public PrismProperty<?> getIdentifier() {
        Collection<ResourceAttribute<?>> attrDefs = this.getIdentifiers();
        if (attrDefs.size() > 1) {
            throw new IllegalStateException("Resource object has more than one identifier.");
        }
        Iterator<ResourceAttribute<?>> iterator = attrDefs.iterator();
        if (iterator.hasNext()) {
            PrismProperty p = iterator.next();
            return p;
        }
        return null;
    }

    public Collection<ResourceAttribute<?>> getIdentifiers() {
        return this.extractAttributesByDefinitions(this.getDefinition().getIdentifiers());
    }

    public PrismProperty getSecondaryIdentifier() {
        Collection<ResourceAttribute<?>> secondaryIdentifiers = this.getSecondaryIdentifiers();
        if (secondaryIdentifiers.size() > 1) {
            throw new IllegalStateException("Resource object has more than one identifier.");
        }
        Iterator<ResourceAttribute<?>> iterator = secondaryIdentifiers.iterator();
        if (iterator.hasNext()) {
            PrismProperty p = iterator.next();
            return p;
        }
        return null;
    }

    public Collection<ResourceAttribute<?>> getSecondaryIdentifiers() {
        return this.extractAttributesByDefinitions(this.getDefinition().getSecondaryIdentifiers());
    }

    private Collection<ResourceAttribute<?>> extractAttributesByDefinitions(Collection<ResourceAttributeDefinition> definitions) {
        ArrayList attributes = new ArrayList(definitions.size());
        for (ResourceAttributeDefinition attrDef : definitions) {
            for (ResourceAttribute<?> property : this.getAttributes()) {
                if (!attrDef.getName().equals(property.getName())) continue;
                property.setDefinition(attrDef);
                attributes.add(property);
            }
        }
        return attributes;
    }

    public ResourceAttribute getDescriptionAttribute() {
        if (this.getDefinition() == null) {
            return null;
        }
        return this.findAttribute(this.getDefinition().getDisplayNameAttribute());
    }

    public ResourceAttribute<String> getNamingAttribute() {
        if (this.getDefinition() == null) {
            return null;
        }
        if (this.getDefinition().getNamingAttribute() == null) {
            return null;
        }
        return this.findAttribute(this.getDefinition().getNamingAttribute());
    }

    public ResourceAttribute getDisplayNameAttribute() {
        if (this.getDefinition() == null) {
            return null;
        }
        return this.findAttribute(this.getDefinition().getDisplayNameAttribute());
    }

    public String getNativeObjectClass() {
        return this.getDefinition() == null ? null : this.getDefinition().getNativeObjectClass();
    }

    public boolean isAccountType() {
        ResourceAttributeContainerDefinition definition = this.getDefinition();
        return definition != null ? Boolean.valueOf(definition.isAccountType()) : null;
    }

    public boolean isDefaultAccountType() {
        ResourceAttributeContainerDefinition definition = this.getDefinition();
        return definition != null ? Boolean.valueOf(definition.isDefaultAccountType()) : null;
    }

    public <X> ResourceAttribute<X> findAttribute(QName attributeQName) {
        return (ResourceAttribute)super.findProperty(attributeQName);
    }

    public <X> ResourceAttribute<X> findAttribute(ResourceAttributeDefinition attributeDefinition) {
        return (ResourceAttribute)this.getValue().findProperty((PrismPropertyDefinition)attributeDefinition);
    }

    public <X> ResourceAttribute<X> findOrCreateAttribute(ResourceAttributeDefinition attributeDefinition) throws SchemaException {
        return (ResourceAttribute)this.getValue().findOrCreateProperty((PrismPropertyDefinition)attributeDefinition);
    }

    public <X> ResourceAttribute<X> findOrCreateAttribute(QName attributeName) throws SchemaException {
        return (ResourceAttribute)this.getValue().findOrCreateProperty(attributeName);
    }

    public static ResourceAttributeContainer convertFromContainer(PrismContainer<?> container, ObjectClassComplexTypeDefinition objectClassDefinition) throws SchemaException {
        if (container == null) {
            return null;
        }
        QName elementName = container.getName();
        ResourceAttributeContainer attributesContainer = ResourceAttributeContainer.createEmptyContainer(elementName, objectClassDefinition);
        for (Item item : container.getValue().getItems()) {
            if (item instanceof PrismProperty) {
                PrismProperty property = (PrismProperty)item;
                QName attributeName = property.getName();
                ResourceAttributeDefinition attributeDefinition = objectClassDefinition.findAttributeDefinition(attributeName);
                if (attributeDefinition == null) {
                    throw new SchemaException("No definition for attribute " + attributeName + " in object class " + (Object)((Object)objectClassDefinition));
                }
                ResourceAttribute attribute = new ResourceAttribute(attributeName, attributeDefinition, property.getPrismContext());
                for (PrismPropertyValue pval : property.getValues()) {
                    attribute.add((PrismValue)pval.clone());
                }
                attributesContainer.add(attribute);
                continue;
            }
            throw new SchemaException("Cannot process item of type " + item.getClass().getSimpleName() + ", attributes can only be properties");
        }
        return attributesContainer;
    }

    public static ResourceAttributeContainer createEmptyContainer(QName elementName, ObjectClassComplexTypeDefinition objectClassDefinition) {
        ResourceAttributeContainerDefinition attributesContainerDefinition = new ResourceAttributeContainerDefinition(elementName, objectClassDefinition, objectClassDefinition.getPrismContext());
        return new ResourceAttributeContainer(elementName, attributesContainerDefinition, objectClassDefinition.getPrismContext());
    }

    public ResourceAttributeContainer clone() {
        ResourceAttributeContainer clone = new ResourceAttributeContainer(this.getName(), this.getDefinition(), this.getPrismContext());
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(ResourceAttributeContainer clone) {
        super.copyValues((PrismContainer)clone);
    }

    protected String getDebugDumpClassName() {
        return "RAC";
    }
}

