/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.valueconstruction;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.Visitable;
import com.evolveum.midpoint.prism.Visitor;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.util.DOMUtil;

public class ValueConstructorUtil {
    public static <V extends PrismValue> PrismValueDeltaSetTriple<V> toOutputTriple(PrismValueDeltaSetTriple<V> resultTriple, ItemDefinition outputDefinition, final PropertyPathSegment lastPathSegment, final PrismContext prismContext) {
        Class resultTripleValueClass = resultTriple.getRealValueClass();
        if (resultTripleValueClass == null) {
            return resultTriple;
        }
        PrismValueDeltaSetTriple clonedTriple = resultTriple.clone();
        if (resultTripleValueClass.equals(String.class) && outputDefinition.getTypeName().equals(PrismConstants.POLYSTRING_TYPE_QNAME)) {
            clonedTriple.accept(new Visitor(){

                public void visit(Visitable visitable) {
                    if (visitable instanceof PrismPropertyValue) {
                        PrismPropertyValue pval = (PrismPropertyValue)visitable;
                        String realVal = (String)pval.getValue();
                        PolyString polyStringVal = new PolyString(realVal);
                        polyStringVal.recompute(prismContext.getDefaultPolyStringNormalizer());
                        pval.setValue((Object)polyStringVal);
                    }
                }
            });
        }
        if (resultTripleValueClass.equals(PolyString.class) && outputDefinition.getTypeName().equals(DOMUtil.XSD_STRING)) {
            clonedTriple.accept(new Visitor(){

                public void visit(Visitable visitable) {
                    PrismPropertyValue pval;
                    PolyString realVal;
                    if (visitable instanceof PrismPropertyValue && (realVal = (PolyString)(pval = (PrismPropertyValue)visitable).getValue()) != null) {
                        if (lastPathSegment != null && lastPathSegment.getName().equals(PrismConstants.POLYSTRING_ELEMENT_NORM_QNAME)) {
                            pval.setValue((Object)realVal.getNorm());
                        } else {
                            pval.setValue((Object)realVal.getOrig());
                        }
                    }
                }
            });
        }
        return clonedTriple;
    }
}

