/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.valueconstruction;

import com.evolveum.midpoint.common.expression.Expression;
import com.evolveum.midpoint.common.expression.ExpressionFactory;
import com.evolveum.midpoint.common.valueconstruction.ObjectDeltaObject;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructor;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExpressionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.VariableDefinitionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class ValueConstruction<V extends PrismValue>
implements Dumpable,
DebugDumpable {
    private Map<QName, ValueConstructor> constructors;
    private ExpressionFactory expressionFactory;
    private Map<QName, Object> variables;
    private String shortDesc;
    private ValueConstructionType valueConstructionType;
    private ObjectResolver objectResolver;
    private Item<V> input;
    private ItemDelta<V> inputDelta;
    private PrismValueDeltaSetTriple<V> outputTriple;
    private ItemDefinition outputDefinition;
    private boolean conditionMaskOld = true;
    private boolean conditionMaskNew = true;
    private static final Trace LOGGER = TraceManager.getTrace(ValueConstruction.class);

    ValueConstruction(ValueConstructionType valueConstructionType, ItemDefinition outputDefinition, String shortDesc, Map<QName, ValueConstructor> constructors, ExpressionFactory expressionFactory) {
        this.shortDesc = shortDesc;
        this.valueConstructionType = valueConstructionType;
        this.constructors = constructors;
        this.expressionFactory = expressionFactory;
        this.variables = new HashMap<QName, Object>();
        this.input = null;
        this.outputTriple = null;
        this.outputDefinition = outputDefinition;
        this.objectResolver = null;
    }

    public ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public void setObjectResolver(ObjectResolver objectResolver) {
        this.objectResolver = objectResolver;
    }

    public void setInput(Item<V> input) {
        this.input = input;
    }

    public ItemDelta<V> getInputDelta() {
        return this.inputDelta;
    }

    public void setInputDelta(ItemDelta<V> inputDelta) {
        this.inputDelta = inputDelta;
    }

    public ItemDefinition getOutputDefinition() {
        return this.outputDefinition;
    }

    public void setOutputDefinition(ItemDefinition outputDefinition) {
        this.outputDefinition = outputDefinition;
    }

    public QName getItemName() {
        if (this.outputDefinition != null) {
            return this.outputDefinition.getName();
        }
        return null;
    }

    public void setRootNode(ObjectReferenceType objectRef) {
        this.addVariableDefinition(null, (Object)objectRef);
    }

    public void setRootNode(ObjectDeltaObject<?> odo) {
        this.addVariableDefinition(null, (Object)odo);
    }

    public void setRootNode(ObjectType objectType) {
        this.addVariableDefinition(null, (Object)objectType);
    }

    public void setRootNode(PrismObject<? extends ObjectType> mpObject) {
        this.addVariableDefinition(null, (Object)mpObject);
    }

    public void addVariableDefinition(VariableDefinitionType varDef) {
        if (varDef.getObjectRef() != null) {
            this.addVariableDefinition(varDef.getName(), varDef.getObjectRef());
        } else if (varDef.getValue() != null) {
            this.addVariableDefinition(varDef.getName(), varDef.getValue());
        } else {
            LOGGER.warn("Empty definition of variable {} in expression {}, ignoring it", (Object)varDef.getName(), (Object)this.shortDesc);
        }
    }

    public void addVariableDefinition(QName name, ObjectReferenceType objectRef) {
        this.addVariableDefinition(name, (Object)objectRef);
    }

    public void addVariableDefinition(QName name, ObjectType objectType) {
        this.addVariableDefinition(name, (Object)objectType);
    }

    public void addVariableDefinition(QName name, PrismObject<? extends ObjectType> midpointObject) {
        this.addVariableDefinition(name, (Object)midpointObject);
    }

    public void addVariableDefinition(QName name, String value) {
        this.addVariableDefinition(name, (Object)value);
    }

    public void addVariableDefinition(QName name, int value) {
        this.addVariableDefinition(name, (Object)value);
    }

    public void addVariableDefinition(QName name, Element value) {
        this.addVariableDefinition(name, (Object)value);
    }

    public void addVariableDefinition(QName name, PrismValue value) {
        this.addVariableDefinition(name, (Object)value);
    }

    public void addVariableDefinition(QName name, ObjectDeltaObject<?> value) {
        this.addVariableDefinition(name, (Object)value);
    }

    public void addVariableDefinitions(Map<QName, Object> extraVariables) {
        for (Map.Entry<QName, Object> entry : extraVariables.entrySet()) {
            this.variables.put(entry.getKey(), entry.getValue());
        }
    }

    private void addVariableDefinition(QName name, Object value) {
        if (this.variables.containsKey(name)) {
            LOGGER.warn("Duplicate definition of variable {} in expression {}, ignoring it", (Object)name, (Object)this.shortDesc);
            return;
        }
        this.variables.put(name, value);
    }

    public boolean hasVariableDefinition(QName varName) {
        return this.variables.containsKey(varName);
    }

    public boolean isInitial() {
        if (this.valueConstructionType == null) {
            return false;
        }
        Boolean value = this.valueConstructionType.isInitial();
        if (value == null) {
            value = false;
        }
        return value;
    }

    public boolean isAuthoritative() {
        if (this.valueConstructionType == null) {
            return false;
        }
        Boolean value = this.valueConstructionType.isAuthoritative();
        if (value == null) {
            value = false;
        }
        return value;
    }

    public boolean isExclusive() {
        if (this.valueConstructionType == null) {
            return false;
        }
        Boolean value = this.valueConstructionType.isExclusive();
        if (value == null) {
            value = false;
        }
        return value;
    }

    public boolean isConditionMaskOld() {
        return this.conditionMaskOld;
    }

    public void setConditionMaskOld(boolean conditionMaskOld) {
        this.conditionMaskOld = conditionMaskOld;
    }

    public boolean isConditionMaskNew() {
        return this.conditionMaskNew;
    }

    public void setConditionMaskNew(boolean conditionMaskNew) {
        this.conditionMaskNew = conditionMaskNew;
    }

    public void evaluate(OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        boolean conditionResultNew;
        if (this.outputDefinition == null) {
            throw new IllegalArgumentException("No output definition, cannot evaluate construction " + this.shortDesc);
        }
        boolean conditionResultOld = this.evaluateConditionOld(result) && this.conditionMaskOld;
        boolean bl = conditionResultNew = this.evaluateConditionNew(result) && this.conditionMaskNew;
        if (!conditionResultOld && !conditionResultNew) {
            return;
        }
        this.evaluateValueConstructors(result, conditionResultOld, conditionResultNew);
    }

    private boolean evaluateConditionOld(OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        if (this.valueConstructionType == null) {
            return true;
        }
        ExpressionType conditionExpressionType = this.valueConstructionType.getCondition();
        if (conditionExpressionType == null) {
            return true;
        }
        Expression conditionExpression = this.expressionFactory.createExpression(conditionExpressionType, "condition in " + this.shortDesc);
        conditionExpression.addVariableDefinitionsOld(this.variables);
        PrismPropertyValue<Boolean> conditionValue = conditionExpression.evaluateScalar(Boolean.class, result);
        if (conditionValue == null || conditionValue.getValue() == null) {
            return true;
        }
        return (Boolean)conditionValue.getValue();
    }

    private boolean evaluateConditionNew(OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        if (this.valueConstructionType == null) {
            return true;
        }
        ExpressionType conditionExpressionType = this.valueConstructionType.getCondition();
        if (conditionExpressionType == null) {
            return true;
        }
        Expression conditionExpression = this.expressionFactory.createExpression(conditionExpressionType, "condition in " + this.shortDesc);
        conditionExpression.addVariableDefinitionsNew(this.variables);
        PrismPropertyValue<Boolean> conditionValue = conditionExpression.evaluateScalar(Boolean.class, result);
        if (conditionValue == null || conditionValue.getValue() == null) {
            return true;
        }
        return (Boolean)conditionValue.getValue();
    }

    private void evaluateValueConstructors(OperationResult result, boolean conditionResultOld, boolean conditionResultNew) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        if (this.valueConstructionType == null) {
            ValueConstructor constructor = this.getDefaultConstructor();
            this.outputTriple = constructor.construct(null, this.outputDefinition, this.input, this.inputDelta, this.variables, conditionResultOld, conditionResultNew, this.shortDesc, result);
            return;
        }
        if (this.valueConstructionType.getValueConstructor() != null && this.valueConstructionType.getSequence() != null) {
            throw new SchemaException("Both constructor and sequence was specified, ambiguous situation in " + this.shortDesc);
        }
        if (this.valueConstructionType.getValueConstructor() == null && this.valueConstructionType.getSequence() == null) {
            throw new SchemaException("No constructor was specified in " + this.shortDesc);
        }
        if (this.valueConstructionType.getValueConstructor() != null) {
            ValueConstructor constructor = this.determineConstructor(this.valueConstructionType.getValueConstructor());
            this.outputTriple = constructor.construct(this.valueConstructionType.getValueConstructor(), this.outputDefinition, this.input, this.inputDelta, this.variables, conditionResultOld, conditionResultNew, this.shortDesc, result);
            return;
        }
        if (this.valueConstructionType.getSequence() != null) {
            for (JAXBElement valueConstructorElement : this.valueConstructionType.getSequence().getValueConstructor()) {
                ValueConstructor constructor = this.determineConstructor(valueConstructorElement);
                this.outputTriple = constructor.construct(valueConstructorElement, this.outputDefinition, this.input, this.inputDelta, this.variables, conditionResultOld, conditionResultNew, this.shortDesc, result);
                if (this.outputTriple != null) break;
            }
        }
    }

    private ValueConstructor getDefaultConstructor() {
        return this.constructors.get(null);
    }

    private ValueConstructor determineConstructor(JAXBElement<?> valueConstructorElement) throws SchemaException {
        if (!this.constructors.containsKey(valueConstructorElement.getName())) {
            throw new SchemaException("Unknown value constructor element " + valueConstructorElement.getName() + " in " + this.shortDesc);
        }
        return this.constructors.get(valueConstructorElement.getName());
    }

    public PrismValueDeltaSetTriple<V> getOutputTriple() {
        return this.outputTriple;
    }

    public Item<V> getOutput() throws SchemaException {
        if (this.outputTriple == null) {
            return null;
        }
        if (this.outputTriple.hasPlusSet() || this.outputTriple.hasMinusSet()) {
            throw new IllegalStateException("Cannot create output from " + this + " as it is not zero-only");
        }
        Item output = this.outputDefinition.instantiate();
        output.addAll(this.outputTriple.getZeroSet());
        return output;
    }

    public static List<Object> getStaticValueList(ValueConstructionType valueConstruction) throws SchemaException {
        JAXBElement valueConstructor = valueConstruction.getValueConstructor();
        if (valueConstructor == null) {
            return null;
        }
        if (!valueConstructor.getName().equals(SchemaConstants.C_VALUE)) {
            throw new IllegalArgumentException("Expected static value constructor but found " + valueConstructor.getName() + " in value construction");
        }
        Element element = (Element)valueConstructor.getValue();
        return XmlTypeConverter.convertValueElementAsList((Element)element);
    }

    public ValueConstruction<V> clone() {
        ValueConstruction<V> clone = new ValueConstruction<V>(this.valueConstructionType, this.outputDefinition, this.shortDesc, this.constructors, this.expressionFactory);
        clone.input = this.input;
        clone.objectResolver = this.objectResolver;
        clone.outputTriple = this.outputTriple.clone();
        clone.outputDefinition = this.outputDefinition;
        clone.variables = this.variables;
        return clone;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        result = 31 * result + (this.outputTriple == null ? 0 : this.outputTriple.hashCode());
        result = 31 * result + (this.outputDefinition == null ? 0 : this.outputDefinition.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueConstruction other = (ValueConstruction)obj;
        if (this.input == null ? other.input != null : !this.input.equals(other.input)) {
            return false;
        }
        if (this.outputTriple == null ? other.outputTriple != null : !this.outputTriple.equals(other.outputTriple)) {
            return false;
        }
        if (this.outputDefinition == null ? other.outputDefinition != null : !this.outputDefinition.equals((Object)other.outputDefinition)) {
            return false;
        }
        return !(this.variables == null ? other.variables != null : !this.variables.equals(other.variables));
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.toString());
        return sb.toString();
    }

    public String dump() {
        return this.debugDump();
    }

    public String toString() {
        return "VC(" + SchemaDebugUtil.prettyPrint((QName)this.outputDefinition.getName()) + " = " + this.outputTriple + ")";
    }
}

