/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.valueconstruction;

import com.evolveum.midpoint.common.valueconstruction.ObjectDeltaObject;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructor;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructorUtil;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class PathValueConstructor
implements ValueConstructor {
    private ObjectResolver objectResolver;
    private PrismContext prismContext;

    public PathValueConstructor(ObjectResolver objectResolver, PrismContext prismContext) {
        this.objectResolver = objectResolver;
        this.prismContext = prismContext;
    }

    @Override
    public <V extends PrismValue> PrismValueDeltaSetTriple<V> construct(JAXBElement<?> constructorElement, ItemDefinition outputDefinition, Item<V> input, ItemDelta<V> inputDelta, Map<QName, Object> variables, boolean conditionResultOld, boolean conditionResultNew, String contextDescription, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        PrismValueDeltaSetTriple outputTriple;
        ObjectType objectType;
        Object constructorTypeObject = constructorElement.getValue();
        if (!(constructorTypeObject instanceof Element)) {
            throw new IllegalArgumentException("Path value constructor cannot handle elements of type " + constructorTypeObject.getClass().getName());
        }
        XPathHolder xpath = new XPathHolder((Element)constructorTypeObject);
        PropertyPath path = xpath.toPropertyPath();
        if (path.isEmpty()) {
            PrismValueDeltaSetTriple outputTriple2 = ItemDelta.toDeltaSetTriple(input, inputDelta, (boolean)conditionResultOld, (boolean)conditionResultNew);
            if (outputTriple2 == null) {
                return null;
            }
            return outputTriple2.clone();
        }
        PropertyPathSegment first = path.first();
        QName varName = null;
        if (first.isVariable()) {
            varName = first.getName();
            path = path.rest();
        }
        if (!variables.containsKey(varName)) {
            throw new ExpressionEvaluationException("No variable with name " + varName);
        }
        PrismObject baseObject = variables.get(varName);
        ObjectDelta baseDelta = null;
        Item referedItem = null;
        ItemDelta referedItemDelta = null;
        if (baseObject instanceof ObjectReferenceType && (objectType = this.resolveReference((ObjectReferenceType)baseObject, this.objectResolver, varName, contextDescription, result)) != null) {
            baseObject = objectType.asPrismObject();
        }
        if (baseObject instanceof ObjectDeltaObject) {
            ObjectDeltaObject odo = (ObjectDeltaObject)baseObject;
            baseDelta = odo.getDelta();
            baseObject = odo.getOldObject();
        }
        if (baseObject instanceof PrismContainer) {
            baseObject = ((PrismContainer)baseObject).getValue();
        }
        if (baseObject instanceof PrismContainerValue) {
            PrismContainerValue containerValue = (PrismContainerValue)baseObject;
            referedItem = containerValue.findItem(path);
        }
        if (baseDelta != null) {
            referedItemDelta = baseDelta.findItemDelta(path);
        }
        if ((outputTriple = ItemDelta.toDeltaSetTriple((Item)referedItem, (ItemDelta)referedItemDelta, (boolean)conditionResultOld, (boolean)conditionResultNew)) == null) {
            return null;
        }
        return ValueConstructorUtil.toOutputTriple(outputTriple, outputDefinition, path.last(), this.prismContext);
    }

    private ObjectType resolveReference(ObjectReferenceType ref, ObjectResolver objectResolver, QName varName, String contextDescription, OperationResult result) throws SchemaException, ObjectNotFoundException {
        if (ref.getOid() == null) {
            throw new SchemaException("Null OID in reference in variable " + DebugUtil.prettyPrint((QName)varName) + " in " + contextDescription);
        }
        try {
            return objectResolver.resolve(ref, ObjectType.class, contextDescription, result);
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("Object not found during variable " + DebugUtil.prettyPrint((QName)varName) + " resolution in " + contextDescription + ": " + e.getMessage(), (Throwable)e, ref.getOid());
        }
        catch (SchemaException e) {
            throw new SchemaException("Schema error during variable " + DebugUtil.prettyPrint((QName)varName) + " resolution in " + contextDescription + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

