/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.string;

import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CharacterClassType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LimitationsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.StringPolicyType;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.apache.commons.lang.text.StrBuilder;

public class StringPolicyUtils {
    private static final transient Trace LOGGER = TraceManager.getTrace(StringPolicyUtils.class);
    private static final String ASCII7_CHARS = " !\"#$%&'()*+,-.01234567890:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

    public static StringPolicyType normalize(StringPolicyType sp) {
        if (sp == null) {
            throw new IllegalArgumentException("Providide string policy cannot be null");
        }
        if (sp.getLimitations() == null) {
            LimitationsType sl = new LimitationsType();
            sl.setCheckAgainstDictionary(Boolean.valueOf(false));
            sl.setCheckPattern("");
            sl.setMaxLength(Integer.valueOf(-1));
            sl.setMinLength(Integer.valueOf(0));
            sl.setMinUniqueChars(Integer.valueOf(0));
            sp.setLimitations(sl);
        }
        if (sp.getCharacterClass() == null) {
            CharacterClassType cct = new CharacterClassType();
            cct.setValue(ASCII7_CHARS);
            sp.setCharacterClass(cct);
        }
        return sp;
    }

    public static String collectCharacterClass(CharacterClassType cc, QName ref) {
        StrBuilder l = new StrBuilder();
        if (cc == null) {
            throw new IllegalArgumentException("Character class cannot be null");
        }
        if (cc.getValue() != null && (ref == null || ref.equals(cc.getName()))) {
            l.append(cc.getValue());
        } else if (cc.getCharacterClass() != null && !cc.getCharacterClass().isEmpty()) {
            for (CharacterClassType subClass : cc.getCharacterClass()) {
                if (ref == null || ref.equals(cc.getName())) {
                    l.append(StringPolicyUtils.collectCharacterClass(subClass, null));
                    continue;
                }
                l.append(StringPolicyUtils.collectCharacterClass(subClass, ref));
            }
        }
        HashSet<String> h = new HashSet<String>();
        String[] stringArray = l.toString().split("");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            h.add(s);
            ++n2;
        }
        return new StrBuilder().appendAll(h).toString();
    }

    public static ArrayList<String> stringTokenizer(String in) {
        ArrayList<String> l = new ArrayList<String>();
        String[] a = in.split("");
        int i = 1;
        while (i < a.length) {
            l.add(a[i]);
            ++i;
        }
        return l;
    }
}

