/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.password;

import com.evolveum.midpoint.common.string.StringPolicyUtils;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LimitationsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordLifeTimeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordPolicyType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.StringLimitType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.StringPolicyType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PasswordPolicyUtils {
    private static final transient Trace LOGGER = TraceManager.getTrace(PasswordPolicyUtils.class);

    public static void normalize(PasswordPolicyType pp) {
        if (pp == null) {
            throw new IllegalArgumentException("Password policy cannot be null");
        }
        if (pp.getStringPolicy() == null) {
            StringPolicyType sp = new StringPolicyType();
            pp.setStringPolicy(StringPolicyUtils.normalize(sp));
        } else {
            pp.setStringPolicy(StringPolicyUtils.normalize(pp.getStringPolicy()));
        }
        if (pp.getLifetime() == null) {
            PasswordLifeTimeType lt = new PasswordLifeTimeType();
            lt.setExpiration(Integer.valueOf(-1));
            lt.setWarnBeforeExpiration(Integer.valueOf(0));
            lt.setLockAfterExpiration(Integer.valueOf(0));
            lt.setMinPasswordAge(Integer.valueOf(0));
            lt.setPasswordHistoryLength(Integer.valueOf(0));
        }
    }

    public static boolean validatePassword(String password, List<PasswordPolicyType> policies, OperationResult result) {
        boolean ret = true;
        for (PasswordPolicyType pp : policies) {
            OperationResult op = PasswordPolicyUtils.validatePassword(password, pp);
            result.addSubresult(op);
            if (!ret || op.isSuccess()) continue;
            ret = false;
        }
        return ret;
    }

    public static boolean validatePassword(String password, PasswordPolicyType pp, OperationResult result) {
        OperationResult op = PasswordPolicyUtils.validatePassword(password, pp);
        result.addSubresult(op);
        return op.isSuccess();
    }

    public static OperationResult validatePassword(String password, PasswordPolicyType pp) {
        if (pp == null) {
            throw new IllegalArgumentException("No policy provided: NULL");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password for validaiton is null.");
        }
        OperationResult ret = new OperationResult("Password validation against password policy:" + pp.getName());
        PasswordPolicyUtils.normalize(pp);
        LimitationsType lims = pp.getStringPolicy().getLimitations();
        if (lims.getMinLength() > password.length()) {
            ret.addSubresult(new OperationResult("Check global minimal length", OperationResultStatus.FATAL_ERROR, "Required minimal size of password is not met." + lims.getMinLength() + ">" + password.length()));
        } else {
            ret.addSubresult(new OperationResult("Check global minimal length", OperationResultStatus.SUCCESS, "PASSED"));
        }
        if (lims.getMaxLength() < password.length()) {
            ret.addSubresult(new OperationResult("Check global maximal length", OperationResultStatus.FATAL_ERROR, "Required maximal size of password was exceeded." + lims.getMaxLength() + "<" + password.length()));
        } else {
            ret.addSubresult(new OperationResult("Check global maximal length", OperationResultStatus.SUCCESS, "PASSED"));
        }
        HashSet<String> tmp = new HashSet<String>(StringPolicyUtils.stringTokenizer(password));
        if (lims.getMinUniqueChars() > tmp.size()) {
            ret.addSubresult(new OperationResult("Check minimal unique chars", OperationResultStatus.FATAL_ERROR, "Required minimal count of unique characters of password are not met." + lims.getMinUniqueChars() + ">" + tmp.size()));
        } else {
            ret.addSubresult(new OperationResult("Check minimal unique chars", OperationResultStatus.SUCCESS, "PASSED"));
        }
        HashSet<String> allValidChars = new HashSet<String>(128);
        ArrayList<String> validChars = null;
        ArrayList<String> passwd = StringPolicyUtils.stringTokenizer(password);
        for (StringLimitType l : lims.getLimit()) {
            OperationResult limitResult = new OperationResult("Tested limitation: " + l.getDescription());
            validChars = l.getCharacterClass().getValue() != null ? StringPolicyUtils.stringTokenizer(l.getCharacterClass().getValue()) : StringPolicyUtils.stringTokenizer(StringPolicyUtils.collectCharacterClass(pp.getStringPolicy().getCharacterClass(), l.getCharacterClass().getRef()));
            allValidChars.addAll(validChars);
            int count = 0;
            for (String s : passwd) {
                if (!validChars.contains(s)) continue;
                ++count;
            }
            if (l.getMinOccurs() > count) {
                limitResult.addSubresult(new OperationResult("Check minimal occurence", OperationResultStatus.FATAL_ERROR, "Required minimal occurence of characters in password is not met." + l.getMinOccurs() + ">" + count));
            } else {
                limitResult.addSubresult(new OperationResult("Check minimal occurence", OperationResultStatus.SUCCESS, "PASSED"));
            }
            if (l.getMaxOccurs() < count) {
                limitResult.addSubresult(new OperationResult("Check maximal occurence", OperationResultStatus.FATAL_ERROR, "Required maximal occurence of characters in password was exceeded." + l.getMaxOccurs() + "<" + count));
            } else {
                limitResult.addSubresult(new OperationResult("Check maximal occurence", OperationResultStatus.SUCCESS, "PASSED"));
            }
            if (l.isMustBeFirst().booleanValue() && !validChars.contains(password.substring(0, 1))) {
                limitResult.addSubresult(new OperationResult("Check valid first char", OperationResultStatus.FATAL_ERROR, "First character is not from allowed set " + validChars.toString()));
            } else {
                limitResult.addSubresult(new OperationResult("Check valid first char", OperationResultStatus.SUCCESS, "PASSED"));
            }
            limitResult.computeStatus();
            ret.addSubresult(limitResult);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : passwd) {
            if (allValidChars.contains(s)) continue;
            sb.append(s);
        }
        if (sb.length() > 0) {
            ret.addSubresult(new OperationResult("Check if not contain invalid characters", OperationResultStatus.FATAL_ERROR, "Not allowed characters [ " + sb + " ] are in password"));
        } else {
            ret.addSubresult(new OperationResult("Check if not contain invalid characters", OperationResultStatus.SUCCESS, "PASSED"));
        }
        ret.computeStatus();
        return ret;
    }
}

