/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.password;

import com.evolveum.midpoint.common.password.PasswordPolicyUtils;
import com.evolveum.midpoint.common.string.StringPolicyUtils;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordPolicyType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.StringLimitType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang.text.StrBuilder;

public class PasswordGenerator {
    private static final transient Trace LOGGER = TraceManager.getTrace(PasswordGenerator.class);
    private static final Random rand = new Random(System.currentTimeMillis());

    public static String generate(PasswordPolicyType pp, OperationResult inputResult) {
        return PasswordGenerator.generate(pp, false, inputResult);
    }

    public static String generate(PasswordPolicyType pp, boolean generateMinimalSize, OperationResult inputResult) {
        ArrayList<String> validChars;
        HashMap<Integer, ArrayList<String>> chars;
        if (pp == null) {
            throw new IllegalArgumentException("Provided password policy can not be null.");
        }
        if (inputResult == null) {
            throw new IllegalArgumentException("Provided operation result cannot be null");
        }
        OperationResult generatorResult = new OperationResult("Password generator running policy :" + pp.getName());
        inputResult.addSubresult(generatorResult);
        PasswordPolicyUtils.normalize(pp);
        HashMap<StringLimitType, ArrayList<String>> lims = new HashMap<StringLimitType, ArrayList<String>>();
        for (StringLimitType l : pp.getStringPolicy().getLimitations().getLimit()) {
            if (l.getCharacterClass().getValue() != null) {
                lims.put(l, StringPolicyUtils.stringTokenizer(l.getCharacterClass().getValue()));
                continue;
            }
            lims.put(l, StringPolicyUtils.stringTokenizer(StringPolicyUtils.collectCharacterClass(pp.getStringPolicy().getCharacterClass(), l.getCharacterClass().getRef())));
        }
        int minLen = pp.getStringPolicy().getLimitations().getMinLength();
        int maxLen = pp.getStringPolicy().getLimitations().getMaxLength();
        int unique = pp.getStringPolicy().getLimitations().getMinUniqueChars();
        if (unique > minLen) {
            minLen = unique;
            OperationResult reportBug = new OperationResult("Global limitation check");
            reportBug.recordWarning("There is more required uniq characters then definied minimum. Raise minimum to number of required uniq chars.");
        }
        StringBuilder password = new StringBuilder();
        HashMap<StringLimitType, ArrayList<String>> mustBeFirst = new HashMap<StringLimitType, ArrayList<String>>();
        for (StringLimitType l : lims.keySet()) {
            if (!l.isMustBeFirst().booleanValue()) continue;
            mustBeFirst.put(l, (ArrayList)lims.get(l));
        }
        if (!mustBeFirst.isEmpty()) {
            int intersectionCardinality;
            HashMap<Integer, ArrayList<String>> posibleFirstChars = PasswordGenerator.cardinalityCounter(mustBeFirst, null, false, false, generatorResult);
            ArrayList<String> intersectionCharacters = posibleFirstChars.get(intersectionCardinality = mustBeFirst.keySet().size());
            if (intersectionCharacters == null || intersectionCharacters.size() == 0) {
                generatorResult.recordFatalError("No intersection for required first character sets in password policy:" + pp.getName());
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Unable to generate password: No intersection for required first character sets in password policy: [" + pp.getName() + "] following character limitation and sets are used:");
                    for (StringLimitType l : mustBeFirst.keySet()) {
                        StrBuilder tmp = new StrBuilder();
                        tmp.appendSeparator(", ");
                        tmp.appendAll((Collection)mustBeFirst.get(l));
                        LOGGER.error("L:" + l.getDescription() + " -> [" + tmp + "]");
                    }
                }
                return null;
            }
            if (LOGGER.isDebugEnabled()) {
                StrBuilder tmp = new StrBuilder();
                tmp.appendSeparator(", ");
                tmp.appendAll(intersectionCharacters);
                LOGGER.trace("Generate first character intersection items [" + tmp + "] into password.");
            }
            password.append(intersectionCharacters.get(rand.nextInt(intersectionCharacters.size())));
        }
        boolean uniquenessReached = false;
        int i = 0;
        while (i < minLen) {
            if (password.length() >= unique) {
                uniquenessReached = true;
            }
            if ((chars = PasswordGenerator.cardinalityCounter(lims, StringPolicyUtils.stringTokenizer(password.toString()), false, uniquenessReached, generatorResult)) == null) {
                return null;
            }
            if (chars.isEmpty()) {
                LOGGER.trace("Minimal criterias was met. No more characters");
                break;
            }
            int card = 1;
            while (card < lims.keySet().size()) {
                if (chars.containsKey(card)) {
                    validChars = chars.get(card);
                    password.append(validChars.get(rand.nextInt(validChars.size())));
                    LOGGER.trace(password.toString());
                    break;
                }
                ++card;
            }
            ++i;
        }
        if (password.length() > maxLen) {
            generatorResult.recordFatalError("Unable to meet minimal criterian and not exceed maximxal size of password.");
            return null;
        }
        i = 0;
        while (i < minLen) {
            if (password.length() == maxLen || password.length() >= minLen && generateMinimalSize) break;
            if (password.length() >= unique) {
                uniquenessReached = true;
            }
            if ((chars = PasswordGenerator.cardinalityCounter(lims, StringPolicyUtils.stringTokenizer(password.toString()), true, uniquenessReached, generatorResult)) == null) {
                generatorResult.recordFatalError("No valid characters to generate, but no all limitation are reached");
                return null;
            }
            if (chars.isEmpty()) break;
            int card = 1;
            while (card < lims.keySet().size()) {
                if (chars.containsKey(card)) {
                    validChars = chars.get(card);
                    password.append(validChars.get(rand.nextInt(validChars.size())));
                    LOGGER.trace(password.toString());
                    break;
                }
                ++card;
            }
            ++i;
        }
        if (password.length() < minLen) {
            generatorResult.recordFatalError("Unable generate password and meet minimal size of password." + password.length() + "<" + minLen);
            return null;
        }
        generatorResult.recordSuccess();
        StrBuilder sb = new StrBuilder(password.substring(0, 1));
        ArrayList<String> shuffleBuffer = StringPolicyUtils.stringTokenizer(password.substring(1));
        Collections.shuffle(shuffleBuffer);
        sb.appendAll(shuffleBuffer);
        return sb.toString();
    }

    private static HashMap<Integer, ArrayList<String>> cardinalityCounter(HashMap<StringLimitType, ArrayList<String>> lims, ArrayList<String> password, Boolean skipMatchedLims, boolean uniquenessReached, OperationResult op) {
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (StringLimitType l : lims.keySet()) {
            ArrayList<String> chars = lims.get(l);
            int i = 0;
            if (password != null) {
                i = PasswordGenerator.charIntersectionCounter(lims.get(l), password);
            }
            if (i > l.getMaxOccurs()) {
                OperationResult o = new OperationResult("Limitation check :" + l.getDescription());
                o.recordFatalError("Exceeded maximal value for this limitation. " + i + ">" + l.getMaxOccurs());
                op.addSubresult(o);
                return null;
            }
            if (i == l.getMaxOccurs() || i >= l.getMinOccurs() && !skipMatchedLims.booleanValue()) continue;
            for (String s : chars) {
                if (password != null && password.contains(s) && !uniquenessReached) continue;
                if (counter.get(s) == null) {
                    counter.put(s, 1);
                    continue;
                }
                counter.put(s, (Integer)counter.get(s) + 1);
            }
        }
        if (password != null) {
            for (StringLimitType l : lims.keySet()) {
                int i = PasswordGenerator.charIntersectionCounter(lims.get(l), password);
                if (i > l.getMaxOccurs()) {
                    OperationResult o = new OperationResult("Limitation check :" + l.getDescription());
                    o.recordFatalError("Exceeded maximal value for this limitation. " + i + ">" + l.getMaxOccurs());
                    op.addSubresult(o);
                    return null;
                }
                if (i != l.getMaxOccurs()) continue;
                LOGGER.trace("Skip " + l.getDescription());
                for (String charToRemove : lims.get(l)) {
                    counter.remove(charToRemove);
                }
            }
        }
        HashMap<Integer, ArrayList<String>> ret = new HashMap<Integer, ArrayList<String>>();
        for (String s : counter.keySet()) {
            if (ret.get(counter.get(s)) == null) {
                ret.put((Integer)counter.get(s), new ArrayList());
            }
            ret.get(counter.get(s)).add(s);
        }
        return ret;
    }

    private static int charIntersectionCounter(ArrayList<String> a, ArrayList<String> b) {
        int ret = 0;
        for (String s : b) {
            if (!a.contains(s)) continue;
            ++ret;
        }
        return ret;
    }
}

