/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.expression.xpath;

import com.evolveum.midpoint.common.expression.ExpressionEvaluator;
import com.evolveum.midpoint.common.expression.MidPointFunctions;
import com.evolveum.midpoint.common.expression.xpath.LazyXPathVariableResolver;
import com.evolveum.midpoint.common.expression.xpath.MidPointNamespaceContext;
import com.evolveum.midpoint.common.expression.xpath.ReflectionXPathFunctionResolver;
import com.evolveum.midpoint.common.expression.xpath.XPathExpressionCodeHolder;
import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ExceptionUtil;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathExpressionEvaluator
implements ExpressionEvaluator {
    public static String XPATH_LANGUAGE_URL = "http://www.w3.org/TR/xpath/";
    private XPathFactory factory = XPathFactory.newInstance();
    private PrismContext prismContext;

    public XPathExpressionEvaluator(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    @Override
    public <T> PrismPropertyValue<T> evaluateScalar(Class<T> type, Element code, Map<QName, Object> variables, ObjectResolver objectResolver, MidPointFunctions functionLibrary, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Object evaluatedExpression;
        QName returnType = this.determineRerturnType(type);
        PrismPropertyValue<T> propertyValue = this.convertScalar(type, returnType, evaluatedExpression = this.evaluate(returnType, code, variables, objectResolver, functionLibrary, contextDescription, result), contextDescription);
        Object value = propertyValue.getValue();
        if (value == null || value instanceof String && ((String)value).isEmpty()) {
            return null;
        }
        return propertyValue;
    }

    @Override
    public <T> List<PrismPropertyValue<T>> evaluateList(Class<T> type, Element code, Map<QName, Object> variables, ObjectResolver objectResolver, MidPointFunctions functionLibrary, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Object evaluatedExpression = this.evaluate(XPathConstants.NODESET, code, variables, objectResolver, functionLibrary, contextDescription, result);
        if (!(evaluatedExpression instanceof NodeList)) {
            throw new IllegalStateException("The expression " + contextDescription + " resulted in " + evaluatedExpression.getClass().getName() + " while exprecting NodeList");
        }
        return this.convertList(type, (NodeList)evaluatedExpression, contextDescription);
    }

    private Object evaluate(QName returnType, Element code, Map<QName, Object> variables, ObjectResolver objectResolver, MidPointFunctions functionLibrary, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Object evaluatedExpression;
        XPathExpression expr;
        XPathExpressionCodeHolder codeHolder = new XPathExpressionCodeHolder(code);
        XPath xpath = this.factory.newXPath();
        LazyXPathVariableResolver variableResolver = new LazyXPathVariableResolver(variables, objectResolver, contextDescription, result);
        xpath.setXPathVariableResolver(variableResolver);
        xpath.setNamespaceContext(new MidPointNamespaceContext(codeHolder.getNamespaceMap()));
        xpath.setXPathFunctionResolver(this.getFunctionResolver(functionLibrary));
        try {
            expr = xpath.compile(codeHolder.getExpressionAsString());
        }
        catch (Exception e) {
            Throwable originalException = ExceptionUtil.lookForTunneledException((Throwable)e);
            if (originalException != null && originalException instanceof ObjectNotFoundException) {
                throw (ObjectNotFoundException)originalException;
            }
            if (originalException != null && originalException instanceof SchemaException) {
                throw (SchemaException)originalException;
            }
            if (e instanceof XPathExpressionException) {
                throw this.createExpressionEvaluationException(e, contextDescription);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SystemException(e.getMessage(), (Throwable)e);
        }
        Object rootNode = this.determineRootNode(variableResolver);
        try {
            evaluatedExpression = expr.evaluate(rootNode, returnType);
        }
        catch (Exception e) {
            Throwable originalException = ExceptionUtil.lookForTunneledException((Throwable)e);
            if (originalException != null && originalException instanceof ObjectNotFoundException) {
                throw (ObjectNotFoundException)originalException;
            }
            if (originalException != null && originalException instanceof SchemaException) {
                throw (SchemaException)originalException;
            }
            if (e instanceof XPathExpressionException) {
                throw this.createExpressionEvaluationException(e, contextDescription);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SystemException(e.getMessage(), (Throwable)e);
        }
        if (evaluatedExpression == null) {
            return null;
        }
        return evaluatedExpression;
    }

    private ExpressionEvaluationException createExpressionEvaluationException(Exception e, String contextDescription) {
        return new ExpressionEvaluationException(String.valueOf(ExceptionUtil.lookForMessage((Throwable)e)) + " in " + contextDescription, (Throwable)e);
    }

    private Object determineRootNode(XPathVariableResolver variableResolver) throws SchemaException {
        Object rootNode = variableResolver.resolveVariable(null);
        if (rootNode == null) {
            return DOMUtil.getDocument();
        }
        return LazyXPathVariableResolver.convertToXml(rootNode, null);
    }

    private QName determineRerturnType(Class<?> type) throws ExpressionEvaluationException {
        if (type.equals(String.class)) {
            return XPathConstants.STRING;
        }
        if (type.equals(Double.class)) {
            return XPathConstants.NUMBER;
        }
        if (type.equals(Integer.class)) {
            return XPathConstants.NUMBER;
        }
        if (type.equals(Boolean.class)) {
            return XPathConstants.BOOLEAN;
        }
        if (type.equals(NodeList.class)) {
            return XPathConstants.NODESET;
        }
        if (type.equals(Node.class)) {
            return XPathConstants.NODE;
        }
        if (type.equals(PolyString.class)) {
            return XPathConstants.STRING;
        }
        throw new ExpressionEvaluationException("Unsupported return type " + type);
    }

    private <T> PrismPropertyValue<T> convertScalar(Class<T> type, QName returnType, Object value, String contextDescription) throws ExpressionEvaluationException {
        if (type.isAssignableFrom(value.getClass())) {
            return new PrismPropertyValue(value);
        }
        try {
            Object resultValue = null;
            if (value instanceof String) {
                resultValue = XmlTypeConverter.toJavaValue((String)((String)value), type);
            } else if (value instanceof Element) {
                resultValue = XmlTypeConverter.convertValueElementAsScalar((Element)((Element)value), type);
            } else {
                throw new ExpressionEvaluationException("Unexpected scalar return type " + value.getClass().getName());
            }
            if (returnType.equals(PrismConstants.POLYSTRING_TYPE_QNAME) && resultValue instanceof String) {
                resultValue = new PolyString((String)resultValue);
            }
            if (resultValue instanceof PolyString) {
                ((PolyString)resultValue).recompute(this.prismContext.getDefaultPolyStringNormalizer());
            }
            return new PrismPropertyValue(resultValue);
        }
        catch (SchemaException e) {
            throw new ExpressionEvaluationException("Error converting result of " + contextDescription + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ExpressionEvaluationException("Error converting result of " + contextDescription + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private <T> List<PrismPropertyValue<T>> convertList(Class<T> type, NodeList valueNodes, String contextDescription) throws ExpressionEvaluationException {
        ArrayList<PrismPropertyValue<T>> values = new ArrayList<PrismPropertyValue<T>>();
        if (valueNodes == null) {
            return values;
        }
        try {
            List list = XmlTypeConverter.convertValueElementAsList((NodeList)valueNodes, type);
            for (Object item : list) {
                if (item == null || item instanceof String && ((String)item).isEmpty()) continue;
                values.add(new PrismPropertyValue(item));
            }
            return values;
        }
        catch (SchemaException e) {
            throw new ExpressionEvaluationException("Error converting return value of " + contextDescription + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ExpressionEvaluationException("Error converting return value of " + contextDescription + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private XPathFunctionResolver getFunctionResolver(MidPointFunctions functionLibrary) {
        return new ReflectionXPathFunctionResolver(functionLibrary);
    }

    @Override
    public String getLanguageName() {
        return "XPath 2.0";
    }

    @Override
    public String getLanguageUrl() {
        return XPATH_LANGUAGE_URL;
    }
}

