/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.expression.xpath;

import com.evolveum.midpoint.schema.holder.TrivialXPathParser;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathExpressionCodeHolder {
    private Element dom;

    public XPathExpressionCodeHolder(Element domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException("Attempt to create " + XPathExpressionCodeHolder.class.getSimpleName() + " with null DOM element");
        }
        this.dom = domElement;
    }

    public NodeList getExpression() {
        return this.dom.getChildNodes();
    }

    public String getFullExpressionAsString() {
        NodeList childNodes = this.dom.getChildNodes();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 3 || childNode.getNodeType() == 4) {
                sb.append(childNode.getNodeValue());
            } else {
                childNode.getNodeType();
            }
            ++i;
        }
        return sb.toString();
    }

    public String getExpressionAsString() {
        String stringExpression = this.getFullExpressionAsString();
        TrivialXPathParser parser = TrivialXPathParser.parse((String)stringExpression);
        stringExpression = parser.getPureXPathString();
        return stringExpression;
    }

    public String lookupNamespaceUri(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this.dom.lookupNamespaceURI(null);
        }
        return this.dom.lookupNamespaceURI(prefix);
    }

    public Map<String, String> getNamespaceMap() {
        Map namespaceMap = null;
        String stringExpression = this.getFullExpressionAsString();
        TrivialXPathParser parser = TrivialXPathParser.parse((String)stringExpression);
        namespaceMap = parser.getNamespaceMap();
        Node node = this.dom;
        while (node != null) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    Node attribute = attributes.item(i);
                    if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                        String localName = attribute.getLocalName();
                        if (attribute.getPrefix() == null && localName.equals("xmlns")) {
                            if (namespaceMap.get("") == null) {
                                namespaceMap.put("", attribute.getNodeValue());
                            }
                        } else if (namespaceMap.get(localName) == null) {
                            namespaceMap.put(localName, attribute.getNodeValue());
                        }
                    }
                    ++i;
                }
            }
            node = node.getParentNode();
        }
        return namespaceMap;
    }
}

