/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.expression.xpath;

import com.evolveum.midpoint.common.expression.MidPointFunctions;
import com.evolveum.midpoint.schema.constants.MidPointConstants;
import com.evolveum.midpoint.util.MiscUtil;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;

public class ReflectionXPathFunctionResolver
implements XPathFunctionResolver {
    private MidPointFunctions functionLibrary;

    public ReflectionXPathFunctionResolver(MidPointFunctions functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    @Override
    public XPathFunction resolveFunction(QName functionQName, int arity) {
        String namespace = functionQName.getNamespaceURI();
        if (namespace != null && !namespace.equals(MidPointConstants.NS_FUNC)) {
            return null;
        }
        String functionName = functionQName.getLocalPart();
        Method method = MiscUtil.findMethod((Object)this.functionLibrary, (String)functionName, (int)arity);
        boolean isVarArg = false;
        if (method == null) {
            method = MiscUtil.findVarArgsMethod((Object)this.functionLibrary, (String)functionName);
            if (method == null) {
                return null;
            }
            isVarArg = true;
        }
        final Method finalMethod = method;
        final boolean finalIsVarArg = isVarArg;
        XPathFunction xPathFunction = new XPathFunction(){

            public Object evaluate(List argList) throws XPathFunctionException {
                Object[] args = argList.toArray();
                if (finalIsVarArg) {
                    Class<?> parameterTypeClass = finalMethod.getParameterTypes()[0];
                    Object[] varArgs = (Object[])Array.newInstance(parameterTypeClass.getComponentType(), args.length);
                    int i = 0;
                    while (i < args.length) {
                        varArgs[i] = args[i];
                        ++i;
                    }
                    args = new Object[]{varArgs};
                }
                try {
                    return finalMethod.invoke((Object)ReflectionXPathFunctionResolver.this.functionLibrary, args);
                }
                catch (IllegalArgumentException e) {
                    throw new XPathFunctionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new XPathFunctionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new XPathFunctionException(e);
                }
            }
        };
        return xPathFunction;
    }
}

