/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common;

import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class Utils {
    private static final Trace LOGGER = TraceManager.getTrace(Utils.class);

    public static String getPropertyName(String name) {
        if (name == null) {
            return "";
        }
        return StringUtils.lowerCase((String)name);
    }

    public static String getPropertySilent(Object object, String property) {
        String result = null;
        try {
            result = BeanUtils.getProperty((Object)object, (String)property);
        }
        catch (IllegalAccessException ex) {
            LOGGER.warn("Failed to get property for instances {}, {}. Error message was {}", new Object[]{object.getClass().getName(), property, ex.getMessage()});
        }
        catch (InvocationTargetException ex) {
            LOGGER.warn("Failed to get property for instances {}, {}. Error message was {}", new Object[]{object.getClass().getName(), property, ex.getMessage()});
        }
        catch (NoSuchMethodException ex) {
            LOGGER.warn("Failed to get property for instances {}, {}. Error message was {}", new Object[]{object.getClass().getName(), property, ex.getMessage()});
        }
        return result;
    }

    public static void copyPropertiesSilent(Object target, Object source) {
        try {
            BeanUtils.copyProperties((Object)target, (Object)source);
            Field[] fields = target.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                ParameterizedType type;
                if ("List".equals(fields[i].getType().getSimpleName()) && (type = (ParameterizedType)fields[i].getGenericType()) != null && type.getActualTypeArguments().length > 0 && "String".equals(((Class)type.getActualTypeArguments()[0]).getSimpleName())) {
                    boolean existsSetter = true;
                    try {
                        Method targetSetterMethod = target.getClass().getDeclaredMethod("set" + StringUtils.capitalize((String)fields[i].getName()), List.class);
                        if (targetSetterMethod == null) {
                            existsSetter = false;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        existsSetter = false;
                    }
                    if (!existsSetter) {
                        Method targetMethod = target.getClass().getDeclaredMethod("get" + StringUtils.capitalize((String)fields[i].getName()), new Class[0]);
                        Method sourceMethod = source.getClass().getDeclaredMethod("get" + StringUtils.capitalize((String)fields[i].getName()), new Class[0]);
                        if (targetMethod != null && sourceMethod != null) {
                            List targetList = (List)targetMethod.invoke(target, new Object[0]);
                            List sourceList = (List)sourceMethod.invoke(source, new Object[0]);
                            if (targetList != null) {
                                targetList.clear();
                                if (sourceList != null) {
                                    for (Object str : sourceList) {
                                        if (!(str instanceof String)) continue;
                                        targetList.add((String)str);
                                    }
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (NoSuchMethodException ex) {
            LOGGER.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{source, target, ex.getMessage()});
        }
        catch (SecurityException ex) {
            LOGGER.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{source, target, ex.getMessage()});
        }
        catch (IllegalAccessException ex) {
            LOGGER.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{source, target, ex.getMessage()});
        }
        catch (InvocationTargetException ex) {
            LOGGER.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{source, target, ex.getMessage()});
        }
    }

    public static void unresolveResource(ResourceObjectShadowType shadow) {
        if (shadow == null || shadow.getResource() == null) {
            return;
        }
        ObjectReferenceType reference = new ObjectReferenceType();
        reference.setOid(shadow.getResource().getOid());
        reference.setType(SchemaConstants.I_RESOURCE_TYPE);
        shadow.setResourceRef(reference);
        shadow.setResource(null);
    }

    public static void unresolveResourceForAccounts(List<? extends ResourceObjectShadowType> shadows) {
        for (ResourceObjectShadowType resourceObjectShadowType : shadows) {
            Utils.unresolveResource(resourceObjectShadowType);
        }
    }

    public static Element fillPropertyReference(String resolve) {
        XPathHolder xpath = new XPathHolder(Utils.getPropertyName(resolve));
        return xpath.toElement("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "property");
    }

    public static PropertyReferenceListType getResolveResourceList() {
        PropertyReferenceListType resolveListType = new PropertyReferenceListType();
        resolveListType.getProperty().add(Utils.fillPropertyReference("Account"));
        resolveListType.getProperty().add(Utils.fillPropertyReference("Resource"));
        return resolveListType;
    }

    public static String cleanupUtf(String bad) {
        StringBuilder sb = new StringBuilder(bad.length());
        int i = 0;
        while (i < bad.length()) {
            int cp = bad.codePointAt(i);
            if (Utils.isValidXmlCodepoint(cp)) {
                sb.append(Character.toChars(cp));
            }
            i += Character.charCount(cp);
        }
        return sb.toString();
    }

    public static boolean isValidXmlCodepoint(int cp) {
        return cp == 9 || cp == 10 || cp == 13 || cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF;
    }
}

