/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common;

import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class ResourceObjectPattern
implements Serializable {
    private Collection<ResourceAttribute<?>> identifiers;

    public Collection<ResourceAttribute<?>> getIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList();
        }
        return this.identifiers;
    }

    public void addIdentifier(ResourceAttribute<?> identifier) {
        this.getIdentifiers().add(identifier);
    }

    public static boolean matches(Collection<? extends ResourceAttribute<?>> attributesToMatch, Collection<ResourceObjectPattern> protectedAccountPatterns) {
        for (ResourceObjectPattern pattern : protectedAccountPatterns) {
            if (!pattern.matches(attributesToMatch)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(Collection<? extends ResourceAttribute<?>> attributesToMatch) {
        for (ResourceAttribute<?> identifier : this.identifiers) {
            if (ResourceObjectPattern.matches(identifier, attributesToMatch)) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(ResourceAttribute<?> identifier, Collection<? extends ResourceAttribute<?>> attributesToMatch) {
        for (ResourceAttribute<?> attributeToMatch : attributesToMatch) {
            if (!ResourceObjectPattern.matches(identifier, attributeToMatch)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(ResourceAttribute<?> identifier, ResourceAttribute<?> attributeToMatch) {
        return identifier.equalsRealValue(attributeToMatch);
    }
}

