/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.EnumSet;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.Tokenizer;

public enum Language {
    EN("English"),
    AB("Abkhaz"),
    AA("Afar"),
    AF("Afrikaans"),
    AK("Akan"),
    SQ("Albanian"),
    AM("Amharic"),
    AR("Arabic"),
    HY("Armenian"),
    AS("Assamese"),
    AV("Avaric"),
    AE("Avestan"),
    AY("Aymara"),
    AZ("Azerbaijani"),
    BM("Bambara"),
    BA("Bashkir"),
    EU("Basque"),
    BE("Belarusian"),
    BN("Bengali"),
    BH("Bihari"),
    BI("Bislama"),
    BS("Bosnian"),
    BR("Breton"),
    BG("Bulgarian"),
    MY("Burmese"),
    CA("Catalan"),
    CH("Chamorro"),
    CE("Chechen"),
    NY("Chichewa"),
    ZH("Chinese", false),
    CV("Chuvash"),
    KW("Cornish"),
    CO("Corsican"),
    CR("Cree"),
    HR("Croatian"),
    CS("Czech"),
    DA("Danish"),
    DV("Divehi"),
    NL("Dutch"),
    DZ("Dzongkha"),
    EO("Esperanto"),
    ET("Estonian"),
    EE("Ewe"),
    FO("Faroese"),
    FJ("Fijian"),
    FI("Finnish"),
    FR("French"),
    FF("Fula"),
    GD("Gaelic"),
    GL("Galician"),
    KA("Georgian"),
    DE("German"),
    EL("Greek"),
    GN("Guaran\u0000u0ed"),
    GU("Gujarati"),
    HT("Haitian"),
    HA("Hausa"),
    HE("Hebrew"),
    HZ("Herero"),
    HI("Hindi"),
    HO("Hiri Motu"),
    HU("Hungarian"),
    IS("Icelandic"),
    IO("Ido"),
    IG("Igbo"),
    ID("Indonesian"),
    IA("Interlingua"),
    IE("Interlingue"),
    IU("Inuktitut"),
    IK("Inupiaq"),
    GA("Irish"),
    IT("Italian"),
    JA("Japanese", false),
    JV("Javanese"),
    KL("Kalaallisut"),
    KN("Kannada"),
    KR("Kanuri"),
    KS("Kashmiri"),
    KK("Kazakh"),
    KM("Khmer"),
    KI("Kikuyu"),
    RW("Kinyarwanda"),
    KY("Kirghiz"),
    RN("Kirundi"),
    KV("Komi"),
    KG("Kongo"),
    KO("Korean", false),
    KU("Kurdish"),
    KJ("Kwanyama"),
    LO("Lao"),
    LA("Latin"),
    LV("Latvian"),
    LI("Limburgish"),
    LN("Lingala"),
    LT("Lithuanian"),
    LU("Luba Katanga"),
    LB("Luxembourgish"),
    MK("Macedonian"),
    MG("Malagasy"),
    MS("Malay"),
    ML("Malayalam"),
    MT("Maltese"),
    GV("Manx"),
    MI("Maori"),
    MR("Marathi"),
    MH("Marshallese"),
    MN("Mongolian"),
    NA("Nauru"),
    NV("Navajo"),
    NG("Ndonga"),
    NE("Nepali"),
    ND("North Ndebele"),
    SE("Northern Sami"),
    NO("Norwegian"),
    NB("Norwegian Bokm\u00e5l"),
    NN("Norwegian Nynorsk"),
    II("Nuosu"),
    OC("Occitan"),
    OJ("Ojibwe"),
    CU("Old Church Slavonic"),
    OR("Oriya"),
    OM("Oromo"),
    OS("Ossetian"),
    PI("Pali"),
    PA("Panjabi"),
    PS("Pashto"),
    FA("Persian"),
    PL("Polish"),
    PT("Portuguese"),
    QU("Quechua"),
    RO("Romanian"),
    RM("Romansh"),
    RU("Russian"),
    SM("Samoan"),
    SG("Sango"),
    SA("Sanskrit"),
    SC("Sardinian"),
    SR("Serbian"),
    SN("Shona"),
    SD("Sindhi"),
    SI("Sinhala"),
    SK("Slovak"),
    SL("Slovene"),
    ES("Spanish"),
    SO("Somali"),
    NR("South Ndebele"),
    ST("Southern Sotho"),
    SU("Sundanese"),
    SW("Swahili"),
    SS("Swati"),
    SV("Swedish"),
    SY("Syriac"),
    TL("Tagalog"),
    TY("Tahitian"),
    TG("Tajik"),
    TA("Tamil"),
    TT("Tatar"),
    TE("Telugu"),
    TH("Thai", false),
    BO("Tibetan"),
    TI("Tigrinya"),
    TO("Tonga"),
    TS("Tsonga"),
    TN("Tswana"),
    TR("Turkish"),
    TK("Turkmen"),
    TW("Twi"),
    UG("Uighur"),
    UK("Ukrainian"),
    UR("Urdu"),
    UZ("Uzbek"),
    VE("Venda"),
    VI("Vietnamese"),
    VO("Volap\u00fck"),
    WA("Walloon"),
    FY("Western Frisian"),
    WO("Wolof"),
    CY("Welsh"),
    XH("Xhosa"),
    YI("Yiddish"),
    YO("Yoruba"),
    ZA("Zhuang"),
    ZU("Zulu");

    public static final Language DEFAULT;
    public static final EnumSet<Language> WESTERN;
    private final boolean ws;
    private final String full;

    static {
        DEFAULT = EN;
        WESTERN = EnumSet.noneOf(Language.class);
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lt = languageArray[n2];
            if (lt.ws) {
                WESTERN.add(lt);
            }
            ++n2;
        }
    }

    private Language(String n2) {
        this(n2, true);
    }

    private Language(String f, boolean w) {
        this.full = f;
        this.ws = w;
    }

    public static Language get(String lang) {
        String ln = lang.replaceAll("-.*", "");
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lt = languageArray[n2];
            if (ln.equalsIgnoreCase(lt.full) || ln.equalsIgnoreCase(lt.name())) {
                return lt;
            }
            ++n2;
        }
        return null;
    }

    public static boolean supported(Language lang, boolean stem) {
        Language ln = lang != null ? lang : DEFAULT;
        boolean supp = false;
        for (Tokenizer t : Tokenizer.IMPL) {
            supp |= t.supports(ln);
        }
        if (!supp || !stem) {
            return supp;
        }
        for (Stemmer s : Stemmer.IMPL) {
            if (!s.supports(ln)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.full;
    }
}

