/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

public final class BitArray {
    private static final int WORD_POWER = 6;
    private static final int WORD_SIZE = 64;
    private static final long WORD_MASK = -1L;
    private long[] words;
    private long length;

    public BitArray() {
        this(64);
    }

    public BitArray(int n) {
        this.init(n);
    }

    public BitArray(long[] a, long l) {
        this.setWords(a, l);
    }

    public void init() {
        this.setWords(new long[1], 0L);
    }

    public void init(int n) {
        this.setWords(new long[(Math.max(0, n - 1) >>> 6) + 1], n);
    }

    public void setWords(long[] a, long l) {
        this.words = a;
        this.length = l;
    }

    public long[] toArray() {
        int i = this.words.length;
        while (--i >= 0 && this.words[i] == 0L) {
        }
        long[] result = new long[++i];
        System.arraycopy(this.words, 0, result, 0, i);
        return result;
    }

    public boolean get(int i) {
        if ((long)i >= this.length) {
            return false;
        }
        int wordIndex = i >>> 6;
        return (this.words[wordIndex] & 1L << i) != 0L;
    }

    public void set(int i) {
        int wordIndex = i >>> 6;
        if (wordIndex >= this.words.length) {
            this.expandTo(wordIndex + 1);
        }
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << i;
        if ((long)i >= this.length) {
            this.length = (long)i + 1L;
        }
    }

    public void clear(int i) {
        int wordIndex = i >>> 6;
        if (wordIndex >= this.words.length) {
            this.expandTo(wordIndex + 1);
        }
        int n = wordIndex;
        this.words[n] = this.words[n] & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * Unable to fully structure code
     */
    public int nextClearBit(int i) {
        wordIndex = i >>> 6;
        word = (this.words[wordIndex] ^ -1L) & -1L << i;
        if (word == 0L) ** GOTO lbl8
        return (wordIndex << 6) + Long.numberOfTrailingZeros(word);
lbl-1000:
        // 1 sources

        {
            word = this.words[wordIndex] ^ -1L;
            if (word == 0L) continue;
            return (wordIndex << 6) + Long.numberOfTrailingZeros(word);
lbl8:
            // 2 sources

            ** while (++wordIndex < this.words.length)
        }
lbl9:
        // 1 sources

        return wordIndex << 6;
    }

    private void expandTo(int s) {
        long[] newWords = new long[Math.max(this.words.length << 1, s)];
        System.arraycopy(this.words, 0, newWords, 0, this.words.length);
        this.words = newWords;
    }
}

