/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.util.format.Formatter;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

final class FormatterEN
extends Formatter {
    private static final byte[] ZERO = Token.token("Zero");
    private static final byte[][] WORDS = Token.tokens("", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen");
    private static final byte[][] WORDS10 = Token.tokens("", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety");
    private static final byte[][] WORDS100 = Token.tokens("Hundred", "Thousand", "Million", "Billion", "Trillion", "Quadrillion", "Quintillion");
    private static final long[] UNITS100 = new long[]{100L, 1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final byte[][] ORDINALS = Token.tokens("", "First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth");
    private static final byte[][] ORDINALS10 = Token.tokens("", "Tenth", "Twentieth", "Thirtieth", "Fortieth", "Fiftieth", "Sixtieth", "Seventieth", "Eightieth", "Ninetieth");
    private static final byte[][] DAYS = Token.tokens("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
    private static final byte[][] MONTHS = Token.tokens("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
    private static final byte[][] AMPM = Token.tokens("AM", "PM");
    private static final byte[] AND = Token.token("and");
    private static final byte[][] ORDSUFFIX = Token.tokens("st", "nd", "rd", "th");
    private static final byte[][] ERAS = Token.tokens("BC", "AD");

    FormatterEN() {
    }

    @Override
    public byte[] word(long n, byte[] ord) {
        TokenBuilder tb = new TokenBuilder();
        if (n == 0L) {
            tb.add(ZERO);
        } else {
            this.word(tb, n, ord);
        }
        return tb.finish();
    }

    @Override
    public byte[] ordinal(long n, byte[] ord) {
        if (ord == null) {
            return Token.EMPTY;
        }
        int f = (int)(n % 10L);
        return ORDSUFFIX[f > 0 && f < 4 && n % 100L / 10L != 1L ? f - 1 : 3];
    }

    @Override
    public byte[] month(int n, int min, int max) {
        TokenBuilder tb = new TokenBuilder(Token.substring(MONTHS[n], 0, max));
        while (tb.size() < min) {
            tb.add(32);
        }
        return tb.finish();
    }

    @Override
    public byte[] day(int n, int min, int max) {
        TokenBuilder tb = new TokenBuilder(Token.substring(DAYS[n], 0, max));
        while (tb.size() < min) {
            tb.add(32);
        }
        return tb.finish();
    }

    @Override
    public byte[] ampm(boolean am) {
        return AMPM[am ? 0 : 1];
    }

    @Override
    public byte[] calendar() {
        return ERAS[1];
    }

    @Override
    public byte[] era(int year) {
        return ERAS[year < 0 ? 0 : 1];
    }

    private void word(TokenBuilder tb, long n, byte[] ord) {
        if (n != 0L) {
            if (n < 20L) {
                tb.add((ord != null ? ORDINALS : WORDS)[(int)n]);
            } else if (n < 100L) {
                int r = (int)(n % 10L);
                if (r == 0) {
                    tb.add((ord != null ? ORDINALS10 : WORDS10)[(int)n / 10]);
                } else {
                    tb.add(WORDS10[(int)n / 10]).add(45);
                    tb.add((ord != null ? ORDINALS : WORDS)[r]);
                }
            } else {
                int w = WORDS100.length - 1;
                while (w >= 0) {
                    if (this.addWord(tb, n, UNITS100[w], WORDS100[w], ord)) break;
                    --w;
                }
            }
        }
    }

    private boolean addWord(TokenBuilder tb, long n, long f, byte[] unit, byte[] ord) {
        boolean ge;
        boolean bl = ge = n >= f;
        if (ge) {
            this.word(tb, n / f, null);
            long r = n % f;
            tb.add(32).add(unit);
            if (ord != null) {
                tb.add(ORDSUFFIX[3]);
            }
            if (r > 0L) {
                tb.add(32);
                if (r < 100L) {
                    tb.add(AND).add(32);
                }
            }
            this.word(tb, r, ord);
        }
        return ge;
    }
}

