/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.QNm;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class NSLocal {
    public final Atts ns = new Atts();
    private int def;

    public void add(QNm name, InputInfo ii) throws QueryException {
        byte[] uri;
        byte[] ln = name.ln();
        if (Token.eq(ln, Token.XML) || Token.eq(ln, Token.XMLNS)) {
            Err.NSDEF.thrw(ii, name);
        }
        if (Token.eq(QueryText.XMLURI, uri = name.uri().atom())) {
            Err.NOXMLNS.thrw(ii, Token.XML, name);
        }
        if (Token.eq(QueryText.XMLNSURI, uri)) {
            Err.NOXMLNS.thrw(ii, Token.XMLNS, name);
        }
        this.ns.add(ln, uri);
    }

    public void delete(QNm name) {
        byte[] ln = name.ln();
        int s = this.ns.size - 1;
        while (s >= 0) {
            if (Token.eq(ln, this.ns.key[s])) {
                this.ns.delete(s);
            }
            --s;
        }
    }

    public void uri(QNm qname) {
        byte[] pre = qname.pref();
        if (pre.length == 0) {
            return;
        }
        byte[] uri = this.find(pre);
        qname.uri(uri != null ? uri : NSGlobal.uri(pre));
    }

    public byte[] uri(byte[] pre, boolean dn, InputInfo ii) throws QueryException {
        byte[] uri = this.find(pre);
        if (uri == null) {
            uri = NSGlobal.uri(pre);
        }
        if (uri.length == 0 && pre.length != 0) {
            (dn ? Err.INVPREF : Err.PREFUNKNOWN).thrw(ii, new Object[]{pre});
        }
        return uri;
    }

    public byte[] find(byte[] pre) {
        int s = this.ns.size - 1;
        while (s >= 0) {
            if (Token.eq(this.ns.key[s], pre)) {
                return this.ns.val[s];
            }
            --s;
        }
        return null;
    }

    public byte[] prefix(byte[] uri) {
        int s = this.ns.size - 1;
        while (s >= 0) {
            if (Token.eq(this.ns.val[s], uri)) {
                return this.ns.key[s];
            }
            --s;
        }
        return NSGlobal.prefix(uri);
    }

    public void finish(byte[] elem) {
        if (elem.length != 0) {
            this.ns.add(Token.EMPTY, elem);
        }
        this.def = this.ns.size;
    }

    public NSLocal copy() {
        NSLocal local = new NSLocal();
        int i = 0;
        while (i < this.def) {
            local.ns.add(this.ns.key[i], this.ns.val[i]);
            ++i;
        }
        return local;
    }

    public int size() {
        return this.ns.size;
    }

    public void size(int s) {
        this.ns.size = s;
    }
}

