/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.item.Item;
import org.basex.util.InputInfo;

public final class ItemSet {
    private static final int CAP = 8;
    private int[] keys = new int[8];
    private int[] next = new int[8];
    private int[] bucket = new int[8];
    private Item[] values = new Item[8];
    private int size = 1;

    public boolean index(InputInfo ii, Item i) throws QueryException {
        if (this.size == this.next.length) {
            this.rehash();
        }
        int h = i.hash(ii);
        int p = h & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (this.values[id].equiv(ii, i)) {
                return false;
            }
            id = this.next[id];
        }
        this.next[this.size] = this.bucket[p];
        this.keys[this.size] = h;
        this.values[this.size] = i;
        ++this.size;
        return true;
    }

    private void rehash() {
        int s = this.size << 1;
        int[] b = new int[s];
        int l = this.bucket.length;
        int i = 0;
        while (i < l) {
            int id = this.bucket[i];
            while (id != 0) {
                int p = this.keys[id] & s - 1;
                int nx = this.next[id];
                this.next[id] = b[p];
                b[p] = id;
                id = nx;
            }
            ++i;
        }
        this.bucket = b;
        this.next = Arrays.copyOf(this.next, s);
        this.keys = Arrays.copyOf(this.keys, s);
        Item[] i2 = new Item[s];
        System.arraycopy(this.values, 0, i2, 0, this.size);
        this.values = i2;
    }
}

