/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.iter.AxisIter;
import org.basex.query.up.ContextModifier;
import org.basex.query.up.DatabaseModifier;
import org.basex.query.up.primitives.Put;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.util.Token;
import org.basex.util.hash.IntMap;
import org.basex.util.hash.TokenSet;

public final class Updates {
    public ContextModifier mod;
    private final IntMap<MemData> fragmentIDs = new IntMap();
    private final TokenSet putUris = new TokenSet();

    public void add(UpdatePrimitive up, QueryContext ctx) throws QueryException {
        Put put;
        if (this.mod == null) {
            this.mod = new DatabaseModifier();
        }
        if (up instanceof Put && this.putUris.add(Token.token((put = (Put)up).path(0))) < 0) {
            Err.UPURIDUP.thrw(put.input, put.path(0));
        }
        this.mod.add(up, ctx);
    }

    public DBNode determineDataRef(ANode target, QueryContext ctx) {
        ANode p;
        if (target instanceof DBNode) {
            return (DBNode)target;
        }
        ANode anc = target;
        AxisIter it = target.anc();
        while ((p = it.next()) != null) {
            anc = p;
        }
        int ancID = anc.id;
        MemData data = this.fragmentIDs.get(ancID);
        if (data == null) {
            data = new MemData(ctx.context.prop);
            new DataBuilder(data).context(ctx).build(anc);
            this.fragmentIDs.add(ancID, data);
        }
        int trgID = target.id;
        int pre = this.preSteps(anc, trgID);
        return new DBNode(data, pre);
    }

    private int preSteps(ANode node, int trgID) {
        ANode n;
        if (node.id == trgID) {
            return 0;
        }
        int s = 1;
        AxisIter it = node.attributes();
        while ((n = it.next()) != null) {
            int st = this.preSteps(n, trgID);
            if (st == 0) {
                return s;
            }
            s += st;
        }
        it = node.children();
        while ((n = it.next()) != null && n.id <= trgID) {
            s += this.preSteps(n, trgID);
        }
        return s;
    }

    public void applyUpdates(QueryContext ctx) throws QueryException {
        if (this.mod != null) {
            this.mod.applyUpdates(ctx);
        }
    }

    public int size() {
        return this.mod == null ? 0 : this.mod.size();
    }
}

