/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.iter;

import org.basex.query.QueryException;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.Seq;
import org.basex.query.item.Value;
import org.basex.util.Array;

public abstract class Iter {
    public abstract Item next() throws QueryException;

    public Item get(long i) throws QueryException {
        return null;
    }

    public long size() {
        return -1L;
    }

    public boolean reset() {
        return false;
    }

    public Value finish() throws QueryException {
        Item i = this.next();
        if (i == null) {
            return Empty.SEQ;
        }
        Item[] item = new Item[Math.max(1, (int)this.size())];
        int s = 0;
        do {
            if (s == item.length) {
                item = Iter.extend(item);
            }
            item[s++] = i;
        } while ((i = this.next()) != null);
        return Seq.get(item, s);
    }

    protected static Item[] extend(Item[] it) {
        int s = it.length;
        Item[] tmp = new Item[Array.newSize(s)];
        System.arraycopy(it, 0, tmp, 0, s);
        return tmp;
    }
}

